/* rygel-media-export-media-cache.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2013 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <mail@jensge.org>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-db.h>
#include <gee.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_media_cache_properties[RYGEL_MEDIA_EXPORT_MEDIA_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _rygel_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_database_cursor_iterator_unref (var), NULL)))
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
	gchar* content_type;
};

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelDatabaseDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CREATE_BLACKLIST_TABLE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CREATE_BLACKLIST_INDEX,
	RYGEL_MEDIA_EXPORT_SQL_STRING_ADD_TO_BLACKLIST,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHECK_BLACKLIST
} RygelMediaExportSQLString;

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DISC,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID
} RygelMediaExportDetailColumn;

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST;
RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_copy (const RygelMediaExportExistsCacheEntry* self,
                                                 RygelMediaExportExistsCacheEntry* dest);
void rygel_media_export_exists_cache_entry_destroy (RygelMediaExportExistsCacheEntry* self);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type,
                                                                      GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self,
                                             const gchar* name,
                                             GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_media_cache_ensure_exists (GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self,
                                                  const gchar* id,
                                                  GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self,
                                                  RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue * array,
                              gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self,
                                                   RygelMediaObject* object,
                                                   GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self,
                                                    RygelMediaContainer* container,
                                                    GError** error);
static void rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self,
                                                             RygelMediaContainer* container,
                                                             GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self,
                                                   RygelMediaObject* object,
                                                   gboolean override_guarded,
                                                   GError** error);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self,
                                               RygelMediaFileItem* item,
                                               gboolean override_guarded,
                                               GError** error);
static void rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self,
                                                        RygelMediaFileItem* item,
                                                        GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self,
                                                             const gchar* object_id,
                                                             GError** error);
static RygelDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self,
                                                                 RygelMediaExportSQLString id,
                                                                 GValue* values,
                                                                 int values_length1,
                                                                 GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self,
                                                                            RygelMediaContainer* parent,
                                                                            sqlite3_stmt* statement);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self,
                                                                   const gchar* container_id,
                                                                   GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self,
                                                     const gchar* container_id,
                                                     GError** error);
static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self,
                                                 RygelMediaExportSQLString id,
                                                 GValue* values,
                                                 int values_length1,
                                                 GError** error);
guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self,
                                                          const gchar* id,
                                                          guint32* object_update_id,
                                                          guint32* container_update_id,
                                                          guint32* total_deleted_child_count);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self,
                                                GFile* file,
                                                gint64* timestamp,
                                                gint64* size,
                                                gchar* * mime_type,
                                                GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self,
                                                                RygelMediaContainer* container,
                                                                const gchar* sort_criteria,
                                                                glong offset,
                                                                glong max_count,
                                                                GError** error);
static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria,
                                                               gchar* * extra_columns,
                                                               gint* column_count);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self,
                                                                                    RygelSearchExpression* expression,
                                                                                    const gchar* container_id,
                                                                                    const gchar* sort_criteria,
                                                                                    guint offset,
                                                                                    guint max_count,
                                                                                    guint* total_matches,
                                                                                    GError** error);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression,
                                                                   GValueArray* args,
                                                                   const gchar* prefix,
                                                                   GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self,
                                                   guint max_count);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self,
                                                                 const gchar* filter,
                                                                 GValueArray* args,
                                                                 const gchar* container_id,
                                                                 GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self,
                                                                         const gchar* filter,
                                                                         GValueArray* args,
                                                                         const gchar* container_id,
                                                                         const gchar* sort_criteria,
                                                                         glong offset,
                                                                         glong max_count,
                                                                         GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self,
                                                                            RygelSearchExpression* expression,
                                                                            const gchar* container_id,
                                                                            GError** error);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new_root (void);
RygelNullContainer* rygel_null_container_construct_root (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new (const gchar* id,
                                              RygelMediaContainer* parent,
                                              const gchar* title);
RygelNullContainer* rygel_null_container_construct (GType object_type,
                                                    const gchar* id,
                                                    RygelMediaContainer* parent,
                                                    const gchar* title);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self,
                                                            const gchar* container_id,
                                                            GError** error);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self,
                                                                        const gchar* column,
                                                                        const gchar* filter,
                                                                        GValueArray* args,
                                                                        glong offset,
                                                                        const gchar* sort_criteria,
                                                                        glong max_count,
                                                                        gboolean add_all_container,
                                                                        GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self,
                                                                                   const gchar* attribute,
                                                                                   RygelSearchExpression* expression,
                                                                                   const gchar* sort_criteria,
                                                                                   glong offset,
                                                                                   guint max_count,
                                                                                   gboolean add_all_container,
                                                                                   GError** error);
static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand,
                                                             gchar* * collate,
                                                             gboolean for_sort,
                                                             GError** error);
gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self,
                                                      const gchar* token);
void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self,
                                                         RygelMediaObject* object,
                                                         gboolean guarded);
gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self,
                                                        RygelMediaObject* object,
                                                        RygelMediaContainer* parent,
                                                        GError** error);
void rygel_media_export_media_cache_blacklist (RygelMediaExportMediaCache* self,
                                               GFile* file);
gboolean rygel_media_export_media_cache_is_blacklisted (RygelMediaExportMediaCache* self,
                                                        GFile* file);
static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self,
                                                           const gchar* id);
void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self,
                                                          GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "17"
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value,
                                                        gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value,
                                                         gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelDatabaseDatabase* database,
                                                                                 RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type,
                                                                                       RygelDatabaseDatabase* database,
                                                                                       RygelMediaExportSQLFactory* sql);
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self,
                                                                gint* current_version,
                                                                GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self,
                                                      gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self,
                                                         GError** error);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self,
                                                           RygelMediaObject* object,
                                                           GError** error);
static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self,
                                                          RygelMediaObject* object,
                                                          gboolean is_guarded,
                                                          GError** error);
RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self,
                                                                      const gchar* id,
                                                                      const gchar* title,
                                                                      guint child_count,
                                                                      const gchar* uri);
RygelMediaFileItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self,
                                                                RygelMediaContainer* parent,
                                                                const gchar* id,
                                                                const gchar* title,
                                                                const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self,
                                               sqlite3_stmt* statement,
                                               RygelMediaFileItem* item);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression,
                                                                GValueArray* args,
                                                                GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression,
                                                                 GValueArray* args,
                                                                 GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp,
                                                                    GValueArray* args,
                                                                    GError** error);
static void rygel_media_export_media_cache_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark
rygel_media_export_media_cache_error_quark (void)
{
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType
rygel_media_export_object_type_get_type (void)
{
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


void
rygel_media_export_exists_cache_entry_copy (const RygelMediaExportExistsCacheEntry* self,
                                            RygelMediaExportExistsCacheEntry* dest)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).mtime;
	(*dest).mtime = _tmp0_;
	_tmp1_ = (*self).size;
	(*dest).size = _tmp1_;
	_tmp2_ = (*self).content_type;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).content_type);
	(*dest).content_type = _tmp3_;
}


void
rygel_media_export_exists_cache_entry_destroy (RygelMediaExportExistsCacheEntry* self)
{
	_g_free0 ((*self).content_type);
}


RygelMediaExportExistsCacheEntry*
rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self)
{
	RygelMediaExportExistsCacheEntry* dup;
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
	rygel_media_export_exists_cache_entry_copy (self, dup);
	return dup;
}


void
rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self)
{
	rygel_media_export_exists_cache_entry_destroy (self);
	g_free (self);
}


GType
rygel_media_export_exists_cache_entry_get_type (void)
{
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__volatile)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__volatile, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__volatile;
}


static RygelMediaExportMediaCache*
rygel_media_export_media_cache_construct (GType object_type,
                                          GError** error)
{
	RygelMediaExportMediaCache * self = NULL;
	gchar* db_name = NULL;
	gchar* _tmp0_;
	RygelMediaExportSQLFactory* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaExportObjectFactory* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("media-export");
	db_name = _tmp0_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = rygel_meta_config_get_default ();
		config = _tmp1_;
		_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "use-temp-db", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch4_g_error;
		}
		if (_tmp2_) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (":memory:");
			_g_free0 (db_name);
			db_name = _tmp3_;
		}
		_g_object_unref0 (config);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (db_name);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp4_ = rygel_media_export_sql_factory_new ();
	_g_object_unref0 (self->priv->sql);
	self->priv->sql = _tmp4_;
	_tmp5_ = db_name;
	rygel_media_export_media_cache_open_db (self, _tmp5_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (db_name);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = rygel_media_export_object_factory_new ();
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp6_;
	_g_free0 (db_name);
	return self;
}


static RygelMediaExportMediaCache*
rygel_media_export_media_cache_new (GError** error)
{
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
}


gchar*
rygel_media_export_media_cache_get_id (GFile* file)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp1_, (gsize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


void
rygel_media_export_media_cache_ensure_exists (GError** error)
{
	RygelMediaExportMediaCache* _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_export_media_cache_instance;
	if (_tmp0_ == NULL) {
		RygelMediaExportMediaCache* _tmp1_ = NULL;
		RygelMediaExportMediaCache* _tmp2_;
		RygelMediaExportMediaCache* _tmp3_;
		_tmp2_ = rygel_media_export_media_cache_new (&_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (rygel_media_export_media_cache_instance);
		rygel_media_export_media_cache_instance = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


RygelMediaExportMediaCache*
rygel_media_export_media_cache_get_default (void)
{
	RygelMediaExportMediaCache* result = NULL;
	RygelMediaExportMediaCache* _tmp0_;
	RygelMediaExportMediaCache* _tmp1_;
	_tmp0_ = rygel_media_export_media_cache_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
_vala_GValue_array_free (GValue * array,
                         gint array_length)
{
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


void
rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self,
                                             const gchar* id,
                                             GError** error)
{
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue* _tmp1_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp2_;
	RygelMediaExportSQLFactory* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp2_ = self->priv->db;
	_tmp3_ = self->priv->sql;
	_tmp4_ = rygel_media_export_sql_factory_make (_tmp3_, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
	rygel_database_database_exec (_tmp2_, _tmp4_, values, values_length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


void
rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self,
                                              RygelMediaObject* object,
                                              GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = rygel_media_object_get_id (object);
	_tmp1_ = _tmp0_;
	rygel_media_export_media_cache_remove_by_id (self, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Add the container to the cache, in a database transcation,
     * rolling back the transaction if necessary.
     */
static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}


void
rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self,
                                               RygelMediaContainer* container,
                                               GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	{
		RygelDatabaseDatabase* _tmp0_;
		RygelDatabaseDatabase* _tmp1_;
		_tmp0_ = self->priv->db;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch5_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		rygel_media_export_media_cache_save_container_metadata (self, container, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch5_rygel_database_database_error;
			}
			goto __finally5;
		}
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) container, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch5_rygel_database_database_error;
			}
			goto __finally5;
		}
		_tmp1_ = self->priv->db;
		rygel_database_database_commit (_tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch5_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally5;
	__catch5_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = self->priv->db;
		rygel_database_database_rollback (_tmp2_);
		_tmp3_ = _error_;
		_tmp4_ = _g_error_copy0 (_tmp3_);
		_inner_error_ = _tmp4_;
		_g_error_free0 (_error_);
		goto __finally5;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Add the item to the cache.
     */
void
rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self,
                                          RygelMediaFileItem* item,
                                          gboolean override_guarded,
                                          GError** error)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	{
		RygelDatabaseDatabase* _tmp0_;
		RygelDatabaseDatabase* _tmp1_;
		_tmp0_ = self->priv->db;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch6_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		rygel_media_export_media_cache_save_item_metadata (self, item, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch6_rygel_database_database_error;
			}
			goto __finally6;
		}
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) item, override_guarded, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch6_rygel_database_database_error;
			}
			goto __finally6;
		}
		_tmp1_ = self->priv->db;
		rygel_database_database_commit (_tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch6_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally6;
	__catch6_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		RygelDatabaseDatabase* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) item);
		_tmp3_ = _tmp2_;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning (_ ("Failed to add item with ID %s: %s"), _tmp3_, _tmp5_);
		_tmp6_ = self->priv->db;
		rygel_database_database_rollback (_tmp6_);
		_tmp7_ = _error_;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_inner_error_ = _tmp8_;
		_g_error_free0 (_error_);
		goto __finally6;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Create a new container or item instance based on the ID.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     */
RygelMediaObject*
rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self,
                                           const gchar* object_id,
                                           GError** error)
{
	RygelMediaObject* result = NULL;
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue* _tmp1_;
	gint values_length1;
	gint _values_size_;
	RygelMediaObject* parent = NULL;
	RygelDatabaseCursor* cursor = NULL;
	GValue* _tmp2_;
	gint _tmp2__length1;
	RygelDatabaseCursor* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_id != NULL, NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, object_id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = values_length1;
	parent = NULL;
	_tmp2_ = values;
	_tmp2__length1 = values_length1;
	_tmp3_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT, _tmp2_, _tmp2__length1, &_inner_error_);
	cursor = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parent);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return NULL;
		} else {
			_g_object_unref0 (parent);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp4_;
		RygelDatabaseCursorIterator* _tmp5_;
		_tmp4_ = cursor;
		_tmp5_ = rygel_database_cursor_iterator (_tmp4_);
		_statement_it = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			RygelDatabaseCursorIterator* _tmp7_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp8_;
			sqlite3_stmt* _tmp9_;
			RygelMediaContainer* parent_container = NULL;
			RygelMediaObject* _tmp10_;
			RygelMediaContainer* _tmp11_;
			RygelMediaObject* object = NULL;
			RygelMediaContainer* _tmp12_;
			sqlite3_stmt* _tmp13_;
			RygelMediaObject* _tmp14_;
			RygelMediaObject* _tmp15_;
			RygelMediaContainer* _tmp16_;
			RygelMediaObject* _tmp17_;
			RygelMediaObject* _tmp18_;
			_tmp7_ = _statement_it;
			_tmp6_ = rygel_database_cursor_iterator_next (_tmp7_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					return NULL;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (!_tmp6_) {
				break;
			}
			_tmp8_ = _statement_it;
			_tmp9_ = rygel_database_cursor_iterator_get (_tmp8_, &_inner_error_);
			statement = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					return NULL;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp10_ = parent;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp10_) : NULL);
			parent_container = _tmp11_;
			_tmp12_ = parent_container;
			_tmp13_ = statement;
			_tmp14_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp12_, _tmp13_);
			object = _tmp14_;
			_tmp15_ = object;
			_tmp16_ = parent_container;
			rygel_media_object_set_parent_ref (_tmp15_, _tmp16_);
			_tmp17_ = object;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (parent);
			parent = _tmp18_;
			_g_object_unref0 (object);
			_g_object_unref0 (parent_container);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = parent;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


RygelMediaContainer*
rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self,
                                              const gchar* container_id,
                                              GError** error)
{
	RygelMediaContainer* result = NULL;
	RygelMediaObject* object = NULL;
	RygelMediaObject* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp5_;
	RygelMediaContainer* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = rygel_media_export_media_cache_get_object (self, container_id, &_inner_error_);
	object = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = object;
	if (_tmp2_ != NULL) {
		RygelMediaObject* _tmp3_;
		_tmp3_ = object;
		_tmp1_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_MEDIA_CONTAINER);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", container_id);
		_inner_error_ = _tmp4_;
		if ((_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			return NULL;
		} else {
			_g_object_unref0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = object;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp5_) : NULL);
	result = _tmp6_;
	_g_object_unref0 (object);
	return result;
}


gint
rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self,
                                                const gchar* container_id,
                                                GError** error)
{
	gint result = 0;
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue* _tmp1_;
	gint values_length1;
	gint _values_size_;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (container_id != NULL, 0);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, container_id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp2_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT, values, values_length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gint _tmp3_ = -1;
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return _tmp3_;
		} else {
			gint _tmp4_ = -1;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
	}
	result = _tmp2_;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


guint32
rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self)
{
	guint32 result = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	{
		gint _tmp0_ = 0;
		_tmp0_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		result = (guint32) _tmp0_;
		return result;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_debug ("rygel-media-export-media-cache.vala:190: Failed to query max update id" \
": %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		guint32 _tmp3_ = 0U;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp3_;
	}
	result = (guint32) 0;
	return result;
}


void
rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self,
                                                     const gchar* id,
                                                     guint32* object_update_id,
                                                     guint32* container_update_id,
                                                     guint32* total_deleted_child_count)
{
	guint32 _vala_object_update_id = 0U;
	guint32 _vala_container_update_id = 0U;
	guint32 _vala_total_deleted_child_count = 0U;
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue* _tmp1_;
	gint values_length1;
	gint _values_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_vala_object_update_id = (guint32) 0;
	_vala_container_update_id = (guint32) 0;
	_vala_total_deleted_child_count = (guint32) 0;
	{
		RygelDatabaseCursor* cursor = NULL;
		RygelDatabaseDatabase* _tmp2_;
		GValue* _tmp3_;
		gint _tmp3__length1;
		RygelDatabaseCursor* _tmp4_;
		sqlite3_stmt* statement = NULL;
		RygelDatabaseCursor* _tmp5_;
		sqlite3_stmt* _tmp6_;
		sqlite3_stmt* _tmp7_;
		sqlite3_stmt* _tmp8_;
		sqlite3_stmt* _tmp9_;
		_tmp2_ = self->priv->db;
		_tmp3_ = values;
		_tmp3__length1 = values_length1;
		_tmp4_ = rygel_database_database_exec_cursor (_tmp2_, "SELECT object_update_id, " "container_update_id, " "deleted_child_count " "FROM Object WHERE upnp_id = ?", _tmp3_, _tmp3__length1, &_inner_error_);
		cursor = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_tmp5_ = cursor;
		_tmp6_ = rygel_database_cursor_next (_tmp5_, &_inner_error_);
		statement = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (cursor);
			goto __catch8_g_error;
		}
		_tmp7_ = statement;
		_vala_object_update_id = (guint32) sqlite3_column_int64 (_tmp7_, 0);
		_tmp8_ = statement;
		_vala_container_update_id = (guint32) sqlite3_column_int64 (_tmp8_, 1);
		_tmp9_ = statement;
		_vala_total_deleted_child_count = (guint32) sqlite3_column_int64 (_tmp9_, 2);
		_g_object_unref0 (cursor);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning (_ ("Failed to get update IDs: %s"), _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	if (object_update_id) {
		*object_update_id = _vala_object_update_id;
	}
	if (container_update_id) {
		*container_update_id = _vala_container_update_id;
	}
	if (total_deleted_child_count) {
		*total_deleted_child_count = _vala_total_deleted_child_count;
	}
}


gboolean
rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self,
                                       GFile* file,
                                       gint64* timestamp,
                                       gint64* size,
                                       gchar* * mime_type,
                                       GError** error)
{
	gint64 _vala_timestamp = 0LL;
	gint64 _vala_size = 0LL;
	gchar* _vala_mime_type = NULL;
	gboolean result = FALSE;
	gchar* uri = NULL;
	gchar* _tmp0_;
	GValue* values = NULL;
	const gchar* _tmp1_;
	GValue _tmp2_ = {0};
	GValue* _tmp3_;
	gint values_length1;
	gint _values_size_;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	RygelDatabaseCursor* cursor = NULL;
	GValue* _tmp18_;
	gint _tmp18__length1;
	RygelDatabaseCursor* _tmp19_;
	sqlite3_stmt* statement = NULL;
	RygelDatabaseCursor* _tmp22_;
	sqlite3_stmt* _tmp23_;
	sqlite3_stmt* _tmp26_;
	gint64 _tmp27_;
	sqlite3_stmt* _tmp28_;
	sqlite3_stmt* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	_tmp1_ = uri;
	g_value_init (&_tmp2_, G_TYPE_STRING);
	g_value_set_string (&_tmp2_, _tmp1_);
	_tmp3_ = g_new0 (GValue, 1);
	_tmp3_[0] = _tmp2_;
	values = _tmp3_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_g_free0 (_vala_mime_type);
	_vala_mime_type = NULL;
	_tmp4_ = self->priv->exists_cache;
	_tmp5_ = uri;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, _tmp5_)) {
		RygelMediaExportExistsCacheEntry* entry = NULL;
		GeeHashMap* _tmp6_;
		const gchar* _tmp7_;
		gpointer _tmp8_;
		GeeHashMap* _tmp9_;
		const gchar* _tmp10_;
		RygelMediaExportExistsCacheEntry* _tmp11_;
		gint64 _tmp12_;
		RygelMediaExportExistsCacheEntry* _tmp13_;
		gint64 _tmp14_;
		RygelMediaExportExistsCacheEntry* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp6_ = self->priv->exists_cache;
		_tmp7_ = uri;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
		entry = (RygelMediaExportExistsCacheEntry*) _tmp8_;
		_tmp9_ = self->priv->exists_cache;
		_tmp10_ = uri;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
		_tmp11_ = entry;
		_tmp12_ = (*_tmp11_).mtime;
		_vala_timestamp = _tmp12_;
		_tmp13_ = entry;
		_tmp14_ = (*_tmp13_).size;
		_vala_size = _tmp14_;
		_tmp15_ = entry;
		_tmp16_ = (*_tmp15_).content_type;
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (_vala_mime_type);
		_vala_mime_type = _tmp17_;
		result = TRUE;
		_rygel_media_export_exists_cache_entry_free0 (entry);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (uri);
		if (timestamp) {
			*timestamp = _vala_timestamp;
		}
		if (size) {
			*size = _vala_size;
		}
		if (mime_type) {
			*mime_type = _vala_mime_type;
		} else {
			_g_free0 (_vala_mime_type);
		}
		return result;
	}
	_tmp18_ = values;
	_tmp18__length1 = values_length1;
	_tmp19_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS, _tmp18_, _tmp18__length1, &_inner_error_);
	cursor = _tmp19_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gboolean _tmp20_ = FALSE;
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			return _tmp20_;
		} else {
			gboolean _tmp21_ = FALSE;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp21_;
		}
	}
	_tmp22_ = cursor;
	_tmp23_ = rygel_database_cursor_next (_tmp22_, &_inner_error_);
	statement = _tmp23_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gboolean _tmp24_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (cursor);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			return _tmp24_;
		} else {
			gboolean _tmp25_ = FALSE;
			_g_object_unref0 (cursor);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp25_;
		}
	}
	_tmp26_ = statement;
	_vala_timestamp = sqlite3_column_int64 (_tmp26_, 1);
	_tmp27_ = _vala_timestamp;
	if (_tmp27_ == G_MAXINT64) {
		_vala_timestamp = (gint64) 0;
	}
	_tmp28_ = statement;
	_vala_size = sqlite3_column_int64 (_tmp28_, 2);
	_tmp29_ = statement;
	result = sqlite3_column_int (_tmp29_, 0) == 1;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (uri);
	if (timestamp) {
		*timestamp = _vala_timestamp;
	}
	if (size) {
		*size = _vala_size;
	}
	if (mime_type) {
		*mime_type = _vala_mime_type;
	} else {
		_g_free0 (_vala_mime_type);
	}
	return result;
}


RygelMediaObjects*
rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self,
                                             RygelMediaContainer* container,
                                             const gchar* sort_criteria,
                                             glong offset,
                                             glong max_count,
                                             GError** error)
{
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_;
	GValue* values = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp5_ = {0};
	GValue* _tmp6_;
	gint values_length1;
	gint _values_size_;
	gchar* sql = NULL;
	RygelMediaExportSQLFactory* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* sort_order = NULL;
	gchar* _tmp10_;
	RygelDatabaseCursor* cursor = NULL;
	RygelDatabaseDatabase* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GValue* _tmp16_;
	gint _tmp16__length1;
	RygelDatabaseCursor* _tmp17_;
	RygelDatabaseCursor* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) container);
	_tmp2_ = _tmp1_;
	g_value_init (&_tmp3_, G_TYPE_STRING);
	g_value_set_string (&_tmp3_, _tmp2_);
	g_value_init (&_tmp4_, G_TYPE_LONG);
	g_value_set_long (&_tmp4_, offset);
	g_value_init (&_tmp5_, G_TYPE_LONG);
	g_value_set_long (&_tmp5_, max_count);
	_tmp6_ = g_new0 (GValue, 3);
	_tmp6_[0] = _tmp3_;
	_tmp6_[1] = _tmp4_;
	_tmp6_[2] = _tmp5_;
	values = _tmp6_;
	values_length1 = 3;
	_values_size_ = values_length1;
	_tmp7_ = self->priv->sql;
	_tmp8_ = rygel_media_export_sql_factory_make (_tmp7_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN);
	_tmp9_ = g_strdup (_tmp8_);
	sql = _tmp9_;
	_tmp10_ = rygel_media_export_media_cache_translate_sort_criteria (sort_criteria, NULL, NULL);
	sort_order = _tmp10_;
	_tmp11_ = self->priv->db;
	_tmp12_ = sql;
	_tmp13_ = sort_order;
	_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = values;
	_tmp16__length1 = values_length1;
	_tmp17_ = rygel_database_database_exec_cursor (_tmp11_, _tmp15_, _tmp16_, _tmp16__length1, &_inner_error_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp15_);
	cursor = _tmp18_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sort_order);
		_g_free0 (sql);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_object_unref0 (children);
		return NULL;
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp19_;
		RygelDatabaseCursorIterator* _tmp20_;
		_tmp19_ = cursor;
		_tmp20_ = rygel_database_cursor_iterator (_tmp19_);
		_statement_it = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_ = FALSE;
			RygelDatabaseCursorIterator* _tmp22_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp23_;
			sqlite3_stmt* _tmp24_;
			RygelMediaObjects* _tmp25_;
			sqlite3_stmt* _tmp26_;
			RygelMediaObject* _tmp27_;
			RygelMediaObject* _tmp28_;
			RygelMediaObjects* _tmp29_;
			gpointer _tmp30_;
			RygelMediaObject* _tmp31_;
			_tmp22_ = _statement_it;
			_tmp21_ = rygel_database_cursor_iterator_next (_tmp22_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_free0 (sql);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (children);
				return NULL;
			}
			if (!_tmp21_) {
				break;
			}
			_tmp23_ = _statement_it;
			_tmp24_ = rygel_database_cursor_iterator_get (_tmp23_, &_inner_error_);
			statement = _tmp24_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_free0 (sql);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (children);
				return NULL;
			}
			_tmp25_ = children;
			_tmp26_ = statement;
			_tmp27_ = rygel_media_export_media_cache_get_object_from_statement (self, container, _tmp26_);
			_tmp28_ = _tmp27_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
			_g_object_unref0 (_tmp28_);
			_tmp29_ = children;
			_tmp30_ = gee_list_last ((GeeList*) _tmp29_);
			_tmp31_ = (RygelMediaObject*) _tmp30_;
			rygel_media_object_set_parent_ref (_tmp31_, container);
			_g_object_unref0 (_tmp31_);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	_g_free0 (sort_order);
	_g_free0 (sql);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


RygelMediaObjects*
rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self,
                                                                 RygelSearchExpression* expression,
                                                                 const gchar* container_id,
                                                                 const gchar* sort_criteria,
                                                                 guint offset,
                                                                 guint max_count,
                                                                 guint* total_matches,
                                                                 GError** error)
{
	guint _vala_total_matches = 0U;
	RygelMediaObjects* result = NULL;
	GValueArray* args = NULL;
	GValueArray* _tmp0_;
	gchar* filter = NULL;
	GValueArray* _tmp1_;
	gchar* _tmp2_;
	guint max_objects = 0U;
	glong _tmp6_ = 0L;
	const gchar* _tmp7_;
	GValueArray* _tmp8_;
	RygelMediaObjects* _tmp9_ = NULL;
	const gchar* _tmp10_;
	GValueArray* _tmp11_;
	guint _tmp12_;
	RygelMediaObjects* _tmp13_;
	RygelMediaObjects* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = args;
	_tmp2_ = rygel_media_export_media_cache_translate_search_expression (expression, _tmp1_, "WHERE", &_inner_error_);
	filter = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
	if (expression != NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = rygel_search_expression_to_string (expression);
		_tmp4_ = _tmp3_;
		g_debug ("rygel-media-export-media-cache.vala:288: Original search: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = filter;
		g_debug ("rygel-media-export-media-cache.vala:289: Parsed search expression: %s", _tmp5_);
	}
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
	_tmp7_ = filter;
	_tmp8_ = args;
	_tmp6_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp7_, _tmp8_, container_id, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_vala_total_matches = (guint) _tmp6_;
	_tmp10_ = filter;
	_tmp11_ = args;
	_tmp12_ = max_objects;
	_tmp13_ = rygel_media_export_media_cache_get_objects_by_filter (self, _tmp10_, _tmp11_, container_id, sort_criteria, (glong) offset, (glong) _tmp12_, &_inner_error_);
	_tmp9_ = _tmp13_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp14_ = _tmp9_;
	_tmp9_ = NULL;
	result = _tmp14_;
	_g_object_unref0 (_tmp9_);
	_g_free0 (filter);
	_g_value_array_free0 (args);
	if (total_matches) {
		*total_matches = _vala_total_matches;
	}
	return result;
}


static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}


static void
_vala_GValue_free (GValue* self)
{
	g_value_unset (self);
	g_free (self);
}


glong
rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self,
                                                                      RygelSearchExpression* expression,
                                                                      const gchar* container_id,
                                                                      GError** error)
{
	glong result = 0L;
	GValueArray* args = NULL;
	GValueArray* _tmp0_;
	gchar* filter = NULL;
	GValueArray* _tmp1_;
	gchar* _tmp2_;
	glong _tmp23_ = 0L;
	const gchar* _tmp24_;
	GValueArray* _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0L);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = args;
	_tmp2_ = rygel_media_export_media_cache_translate_search_expression (expression, _tmp1_, "WHERE", &_inner_error_);
	filter = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		glong _tmp3_ = -1L;
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return _tmp3_;
	}
	if (expression != NULL) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = rygel_search_expression_to_string (expression);
		_tmp5_ = _tmp4_;
		g_debug ("rygel-media-export-media-cache.vala:313: Original search: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = filter;
		g_debug ("rygel-media-export-media-cache.vala:314: Parsed search expression: %s", _tmp6_);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				GValueArray* _tmp10_;
				guint _tmp11_;
				GValue* arg = NULL;
				GValueArray* _tmp12_;
				gint _tmp13_;
				GValue* _tmp14_;
				gchar* _tmp15_ = NULL;
				GValue* _tmp16_;
				gint _tmp22_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = args;
				_tmp11_ = _tmp10_->n_values;
				if (!(((guint) _tmp9_) < _tmp11_)) {
					break;
				}
				_tmp12_ = args;
				_tmp13_ = i;
				_tmp14_ = __g_value_dup0 (g_value_array_get_nth (_tmp12_, (guint) _tmp13_));
				arg = _tmp14_;
				_tmp16_ = arg;
				if (G_VALUE_HOLDS (_tmp16_, G_TYPE_STRING)) {
					GValue* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = arg;
					_tmp18_ = g_value_get_string (_tmp17_);
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (_tmp15_);
					_tmp15_ = _tmp19_;
				} else {
					GValue* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = arg;
					_tmp21_ = g_strdup_value_contents (_tmp20_);
					_g_free0 (_tmp15_);
					_tmp15_ = _tmp21_;
				}
				_tmp22_ = i;
				g_debug ("rygel-media-export-media-cache.vala:319: Arg %d: %s", _tmp22_, _tmp15_);
				_g_free0 (_tmp15_);
				__vala_GValue_free0 (arg);
			}
		}
	}
	_tmp24_ = filter;
	_tmp25_ = args;
	_tmp23_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp24_, _tmp25_, container_id, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		glong _tmp26_ = -1L;
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return _tmp26_;
	}
	result = _tmp23_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}


glong
rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self,
                                                           const gchar* filter,
                                                           GValueArray* args,
                                                           const gchar* container_id,
                                                           GError** error)
{
	glong result = 0L;
	guint _tmp2_;
	const gchar* pattern = NULL;
	RygelMediaExportSQLString string_id = 0;
	RygelMediaExportSQLFactory* _tmp3_;
	RygelMediaExportSQLString _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	RygelDatabaseDatabase* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GValue* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (filter != NULL, 0L);
	g_return_val_if_fail (args != NULL, 0L);
	if (container_id != NULL) {
		GValue v = {0};
		GValue _tmp0_ = {0};
		GValue _tmp1_;
		g_value_init (&_tmp0_, G_TYPE_STRING);
		g_value_set_string (&_tmp0_, container_id);
		v = _tmp0_;
		_tmp1_ = v;
		g_value_array_prepend (args, &_tmp1_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	_tmp2_ = args->n_values;
	g_debug ("rygel-media-export-media-cache.vala:339: Parameters to bind: %u", _tmp2_);
	if (container_id != NULL) {
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR;
	} else {
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER;
	}
	_tmp3_ = self->priv->sql;
	_tmp4_ = string_id;
	_tmp5_ = rygel_media_export_sql_factory_make (_tmp3_, _tmp4_);
	pattern = _tmp5_;
	_tmp7_ = self->priv->db;
	_tmp8_ = g_strdup_printf (pattern, filter);
	_tmp9_ = _tmp8_;
	_tmp10_ = args->values;
	_tmp10__length1 = (gint) args->n_values;
	_tmp11_ = rygel_database_database_query_value (_tmp7_, _tmp9_, _tmp10_, _tmp10__length1, &_inner_error_);
	_g_free0 (_tmp9_);
	_tmp6_ = _tmp11_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		glong _tmp12_ = -1L;
		g_propagate_error (error, _inner_error_);
		return _tmp12_;
	}
	result = (glong) _tmp6_;
	return result;
}


RygelMediaObjects*
rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self,
                                                      const gchar* filter,
                                                      GValueArray* args,
                                                      const gchar* container_id,
                                                      const gchar* sort_criteria,
                                                      glong offset,
                                                      glong max_count,
                                                      GError** error)
{
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_;
	GValue v = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	RygelMediaContainer* parent = NULL;
	guint _tmp5_;
	const gchar* sql = NULL;
	gchar* sort_order = NULL;
	gchar* _tmp24_;
	RygelDatabaseCursor* cursor = NULL;
	RygelDatabaseDatabase* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GValue* _tmp30_;
	gint _tmp30__length1;
	RygelDatabaseCursor* _tmp31_;
	RygelDatabaseCursor* _tmp32_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_LONG);
	g_value_set_long (&_tmp1_, offset);
	v = _tmp1_;
	_tmp2_ = v;
	g_value_array_append (args, &_tmp2_);
	g_value_init (&_tmp3_, G_TYPE_LONG);
	g_value_set_long (&_tmp3_, max_count);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp3_;
	_tmp4_ = v;
	g_value_array_append (args, &_tmp4_);
	parent = NULL;
	_tmp5_ = args->n_values;
	g_debug ("rygel-media-export-media-cache.vala:366: Parameters to bind: %u", _tmp5_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				guint _tmp9_;
				GValue* arg = NULL;
				gint _tmp10_;
				GValue* _tmp11_;
				gchar* _tmp12_ = NULL;
				GValue* _tmp13_;
				gint _tmp19_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = args->n_values;
				if (!(((guint) _tmp8_) < _tmp9_)) {
					break;
				}
				_tmp10_ = i;
				_tmp11_ = __g_value_dup0 (g_value_array_get_nth (args, (guint) _tmp10_));
				arg = _tmp11_;
				_tmp13_ = arg;
				if (G_VALUE_HOLDS (_tmp13_, G_TYPE_STRING)) {
					GValue* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = arg;
					_tmp15_ = g_value_get_string (_tmp14_);
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (_tmp12_);
					_tmp12_ = _tmp16_;
				} else {
					GValue* _tmp17_;
					gchar* _tmp18_;
					_tmp17_ = arg;
					_tmp18_ = g_strdup_value_contents (_tmp17_);
					_g_free0 (_tmp12_);
					_tmp12_ = _tmp18_;
				}
				_tmp19_ = i;
				g_debug ("rygel-media-export-media-cache.vala:369: Arg %d: %s", _tmp19_, _tmp12_);
				_g_free0 (_tmp12_);
				__vala_GValue_free0 (arg);
			}
		}
	}
	if (container_id != NULL) {
		RygelMediaExportSQLFactory* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = self->priv->sql;
		_tmp21_ = rygel_media_export_sql_factory_make (_tmp20_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR);
		sql = _tmp21_;
	} else {
		RygelMediaExportSQLFactory* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = self->priv->sql;
		_tmp23_ = rygel_media_export_sql_factory_make (_tmp22_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
		sql = _tmp23_;
	}
	_tmp24_ = rygel_media_export_media_cache_translate_sort_criteria (sort_criteria, NULL, NULL);
	sort_order = _tmp24_;
	_tmp25_ = self->priv->db;
	_tmp26_ = sql;
	_tmp27_ = sort_order;
	_tmp28_ = g_strdup_printf (_tmp26_, filter, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = args->values;
	_tmp30__length1 = (gint) args->n_values;
	_tmp31_ = rygel_database_database_exec_cursor (_tmp25_, _tmp29_, _tmp30_, _tmp30__length1, &_inner_error_);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp29_);
	cursor = _tmp32_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sort_order);
		_g_object_unref0 (parent);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		_g_object_unref0 (children);
		return NULL;
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp33_;
		RygelDatabaseCursorIterator* _tmp34_;
		_tmp33_ = cursor;
		_tmp34_ = rygel_database_cursor_iterator (_tmp33_);
		_statement_it = _tmp34_;
		while (TRUE) {
			gboolean _tmp35_ = FALSE;
			RygelDatabaseCursorIterator* _tmp36_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp37_;
			sqlite3_stmt* _tmp38_;
			const gchar* parent_id = NULL;
			sqlite3_stmt* _tmp39_;
			const gchar* _tmp40_;
			gboolean _tmp41_ = FALSE;
			RygelMediaContainer* _tmp42_;
			RygelMediaContainer* _tmp51_;
			_tmp36_ = _statement_it;
			_tmp35_ = rygel_database_cursor_iterator_next (_tmp36_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_object_unref0 (parent);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				return NULL;
			}
			if (!_tmp35_) {
				break;
			}
			_tmp37_ = _statement_it;
			_tmp38_ = rygel_database_cursor_iterator_get (_tmp37_, &_inner_error_);
			statement = _tmp38_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_object_unref0 (parent);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				return NULL;
			}
			_tmp39_ = statement;
			_tmp40_ = sqlite3_column_text (_tmp39_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
			parent_id = _tmp40_;
			_tmp42_ = parent;
			if (_tmp42_ == NULL) {
				_tmp41_ = TRUE;
			} else {
				const gchar* _tmp43_;
				RygelMediaContainer* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				_tmp43_ = parent_id;
				_tmp44_ = parent;
				_tmp45_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp41_ = g_strcmp0 (_tmp43_, _tmp46_) != 0;
			}
			if (_tmp41_) {
				const gchar* _tmp47_;
				_tmp47_ = parent_id;
				if (_tmp47_ == NULL) {
					RygelNullContainer* _tmp48_;
					_tmp48_ = rygel_null_container_new_root ();
					_g_object_unref0 (parent);
					parent = (RygelMediaContainer*) _tmp48_;
				} else {
					const gchar* _tmp49_;
					RygelNullContainer* _tmp50_;
					_tmp49_ = parent_id;
					_tmp50_ = rygel_null_container_new (_tmp49_, NULL, "MediaExport");
					_g_object_unref0 (parent);
					parent = (RygelMediaContainer*) _tmp50_;
				}
			}
			_tmp51_ = parent;
			if (_tmp51_ != NULL) {
				RygelMediaObjects* _tmp52_;
				RygelMediaContainer* _tmp53_;
				sqlite3_stmt* _tmp54_;
				RygelMediaObject* _tmp55_;
				RygelMediaObject* _tmp56_;
				RygelMediaObjects* _tmp57_;
				gpointer _tmp58_;
				RygelMediaObject* _tmp59_;
				RygelMediaContainer* _tmp60_;
				_tmp52_ = children;
				_tmp53_ = parent;
				_tmp54_ = statement;
				_tmp55_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp53_, _tmp54_);
				_tmp56_ = _tmp55_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp56_);
				_g_object_unref0 (_tmp56_);
				_tmp57_ = children;
				_tmp58_ = gee_list_last ((GeeList*) _tmp57_);
				_tmp59_ = (RygelMediaObject*) _tmp58_;
				_tmp60_ = parent;
				rygel_media_object_set_parent_ref (_tmp59_, _tmp60_);
				_g_object_unref0 (_tmp59_);
			} else {
				sqlite3_stmt* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				_tmp61_ = statement;
				_tmp62_ = sqlite3_column_text (_tmp61_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
				_tmp63_ = parent_id;
				g_warning (_ ("Inconsistent database: item %s does not have parent %s"), _tmp62_, _tmp63_);
			}
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	_g_free0 (sort_order);
	_g_object_unref0 (parent);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


void
rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseCursor* cursor = NULL;
		RygelDatabaseCursor* _tmp0_;
		g_debug ("rygel-media-export-media-cache.vala:411: Database statistics:");
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS, NULL, 0, &_inner_error_);
		cursor = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		{
			RygelDatabaseCursorIterator* _statement_it = NULL;
			RygelDatabaseCursor* _tmp1_;
			RygelDatabaseCursorIterator* _tmp2_;
			_tmp1_ = cursor;
			_tmp2_ = rygel_database_cursor_iterator (_tmp1_);
			_statement_it = _tmp2_;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				RygelDatabaseCursorIterator* _tmp4_;
				sqlite3_stmt* statement = NULL;
				RygelDatabaseCursorIterator* _tmp5_;
				sqlite3_stmt* _tmp6_;
				sqlite3_stmt* _tmp7_;
				const gchar* _tmp8_;
				sqlite3_stmt* _tmp9_;
				_tmp4_ = _statement_it;
				_tmp3_ = rygel_database_cursor_iterator_next (_tmp4_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					goto __catch9_g_error;
				}
				if (!_tmp3_) {
					break;
				}
				_tmp5_ = _statement_it;
				_tmp6_ = rygel_database_cursor_iterator_get (_tmp5_, &_inner_error_);
				statement = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					goto __catch9_g_error;
				}
				_tmp7_ = statement;
				_tmp8_ = sqlite3_column_text (_tmp7_, 0);
				_tmp9_ = statement;
				g_debug ("rygel-media-export-media-cache.vala:414: %s: %d", _tmp8_, sqlite3_column_int (_tmp9_, 1));
			}
			_rygel_database_cursor_iterator_unref0 (_statement_it);
		}
		_g_object_unref0 (cursor);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_debug ("rygel-media-export-media-cache.vala:419: Failed to get database statis" \
"tics: %s", _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GeeArrayList*
rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self,
                                              const gchar* container_id,
                                              GError** error)
{
	GeeArrayList* result = NULL;
	GeeArrayList* children = NULL;
	GeeArrayList* _tmp0_;
	GValue* values = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseCursor* cursor = NULL;
	GValue* _tmp3_;
	gint _tmp3__length1;
	RygelDatabaseCursor* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	children = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, container_id);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp3_ = values;
	_tmp3__length1 = values_length1;
	_tmp4_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS, _tmp3_, _tmp3__length1, &_inner_error_);
	cursor = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_object_unref0 (children);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_object_unref0 (children);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp5_;
		RygelDatabaseCursorIterator* _tmp6_;
		_tmp5_ = cursor;
		_tmp6_ = rygel_database_cursor_iterator (_tmp5_);
		_statement_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			RygelDatabaseCursorIterator* _tmp8_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp9_;
			sqlite3_stmt* _tmp10_;
			GeeArrayList* _tmp11_;
			sqlite3_stmt* _tmp12_;
			const gchar* _tmp13_;
			_tmp8_ = _statement_it;
			_tmp7_ = rygel_database_cursor_iterator_next (_tmp8_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					return NULL;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (!_tmp7_) {
				break;
			}
			_tmp9_ = _statement_it;
			_tmp10_ = rygel_database_cursor_iterator_get (_tmp9_, &_inner_error_);
			statement = _tmp10_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					return NULL;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp11_ = children;
			_tmp12_ = statement;
			_tmp13_ = sqlite3_column_text (_tmp12_, 0);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp13_);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


GeeList*
rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self,
                                                               const gchar* column,
                                                               const gchar* filter,
                                                               GValueArray* args,
                                                               glong offset,
                                                               const gchar* sort_criteria,
                                                               glong max_count,
                                                               gboolean add_all_container,
                                                               GError** error)
{
	GeeList* result = NULL;
	GValue v = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue _tmp2_ = {0};
	GValue _tmp3_;
	gchar* extra_columns = NULL;
	gint column_count = 0;
	GString* builder = NULL;
	GString* _tmp4_;
	GeeArrayList* data = NULL;
	GeeArrayList* _tmp5_;
	gchar* sql_sort_order = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GString* _tmp20_;
	RygelMediaExportSQLFactory* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	RygelDatabaseCursor* cursor = NULL;
	RygelDatabaseDatabase* _tmp25_;
	GString* _tmp26_;
	const gchar* _tmp27_;
	GValue* _tmp28_;
	gint _tmp28__length1;
	RygelDatabaseCursor* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (column != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	g_value_init (&_tmp0_, G_TYPE_LONG);
	g_value_set_long (&_tmp0_, offset);
	v = _tmp0_;
	_tmp1_ = v;
	g_value_array_append (args, &_tmp1_);
	g_value_init (&_tmp2_, G_TYPE_LONG);
	g_value_set_long (&_tmp2_, max_count);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp2_;
	_tmp3_ = v;
	g_value_array_append (args, &_tmp3_);
	_tmp4_ = g_string_new ("");
	builder = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	data = _tmp5_;
	_tmp8_ = rygel_media_export_media_cache_translate_sort_criteria (sort_criteria, &_tmp6_, &_tmp7_);
	_g_free0 (extra_columns);
	extra_columns = _tmp6_;
	column_count = _tmp7_;
	sql_sort_order = _tmp8_;
	_tmp9_ = sql_sort_order;
	_tmp10_ = string_replace (_tmp9_, "o.title", "_column");
	_g_free0 (sql_sort_order);
	sql_sort_order = _tmp10_;
	_tmp11_ = extra_columns;
	_tmp12_ = string_replace (_tmp11_, "o.title", "1");
	_g_free0 (extra_columns);
	extra_columns = _tmp12_;
	if (add_all_container) {
		GString* _tmp13_;
		GString* _tmp19_;
		_tmp13_ = builder;
		g_string_append (_tmp13_, "SELECT 'all_place_holder' AS _column ");
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					gint _tmp16_;
					gint _tmp17_;
					GString* _tmp18_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = i;
					_tmp17_ = column_count;
					if (!(_tmp16_ < _tmp17_)) {
						break;
					}
					_tmp18_ = builder;
					g_string_append (_tmp18_, ", 1 ");
				}
			}
		}
		_tmp19_ = builder;
		g_string_append (_tmp19_, "UNION ");
	}
	_tmp20_ = builder;
	_tmp21_ = self->priv->sql;
	_tmp22_ = rygel_media_export_sql_factory_make (_tmp21_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
	_tmp23_ = extra_columns;
	_tmp24_ = sql_sort_order;
	g_string_append_printf (_tmp20_, _tmp22_, column, _tmp23_, filter, _tmp24_);
	_tmp25_ = self->priv->db;
	_tmp26_ = builder;
	_tmp27_ = _tmp26_->str;
	_tmp28_ = args->values;
	_tmp28__length1 = (gint) args->n_values;
	_tmp29_ = rygel_database_database_exec_cursor (_tmp25_, _tmp27_, _tmp28_, _tmp28__length1, &_inner_error_);
	cursor = _tmp29_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sql_sort_order);
		_g_object_unref0 (data);
		_g_string_free0 (builder);
		_g_free0 (extra_columns);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		return NULL;
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp30_;
		RygelDatabaseCursorIterator* _tmp31_;
		_tmp30_ = cursor;
		_tmp31_ = rygel_database_cursor_iterator (_tmp30_);
		_statement_it = _tmp31_;
		while (TRUE) {
			gboolean _tmp32_ = FALSE;
			RygelDatabaseCursorIterator* _tmp33_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp34_;
			sqlite3_stmt* _tmp35_;
			GeeArrayList* _tmp36_;
			sqlite3_stmt* _tmp37_;
			const gchar* _tmp38_;
			_tmp33_ = _statement_it;
			_tmp32_ = rygel_database_cursor_iterator_next (_tmp33_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sql_sort_order);
				_g_object_unref0 (data);
				_g_string_free0 (builder);
				_g_free0 (extra_columns);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return NULL;
			}
			if (!_tmp32_) {
				break;
			}
			_tmp34_ = _statement_it;
			_tmp35_ = rygel_database_cursor_iterator_get (_tmp34_, &_inner_error_);
			statement = _tmp35_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_rygel_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sql_sort_order);
				_g_object_unref0 (data);
				_g_string_free0 (builder);
				_g_free0 (extra_columns);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return NULL;
			}
			_tmp36_ = data;
			_tmp37_ = statement;
			_tmp38_ = sqlite3_column_text (_tmp37_, 0);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp38_);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	result = (GeeList*) data;
	_g_object_unref0 (cursor);
	_g_free0 (sql_sort_order);
	_g_string_free0 (builder);
	_g_free0 (extra_columns);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


/**
     * TODO
     */
GeeList*
rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self,
                                                                          const gchar* attribute,
                                                                          RygelSearchExpression* expression,
                                                                          const gchar* sort_criteria,
                                                                          glong offset,
                                                                          guint max_count,
                                                                          gboolean add_all_container,
                                                                          GError** error)
{
	GeeList* result = NULL;
	GValueArray* args = NULL;
	GValueArray* _tmp0_;
	gchar* filter = NULL;
	GValueArray* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* column = NULL;
	gchar* _tmp4_;
	guint max_objects = 0U;
	GeeList* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GValueArray* _tmp8_;
	guint _tmp9_;
	GeeList* _tmp10_;
	GeeList* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = args;
	_tmp2_ = rygel_media_export_media_cache_translate_search_expression (expression, _tmp1_, "AND", &_inner_error_);
	filter = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp3_ = filter;
	g_debug ("rygel-media-export-media-cache.vala:504: Parsed filter: %s", _tmp3_);
	_tmp4_ = rygel_media_export_media_cache_map_operand_to_column (attribute, NULL, FALSE, &_inner_error_);
	column = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	max_objects = rygel_media_export_media_cache_modify_limit (self, max_count);
	_tmp6_ = column;
	_tmp7_ = filter;
	_tmp8_ = args;
	_tmp9_ = max_objects;
	_tmp10_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, _tmp6_, _tmp7_, _tmp8_, offset, sort_criteria, (glong) _tmp9_, add_all_container, &_inner_error_);
	_tmp5_ = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (column);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp11_ = _tmp5_;
	_tmp5_ = NULL;
	result = _tmp11_;
	_g_object_unref0 (_tmp5_);
	_g_free0 (column);
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}


gchar*
rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		RygelDatabaseCursor* cursor = NULL;
		RygelDatabaseCursor* _tmp0_;
		sqlite3_stmt* statement = NULL;
		RygelDatabaseCursor* _tmp1_;
		sqlite3_stmt* _tmp2_;
		sqlite3_stmt* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN, NULL, 0, &_inner_error_);
		cursor = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch11_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp1_ = cursor;
		_tmp2_ = rygel_database_cursor_next (_tmp1_, &_inner_error_);
		statement = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (cursor);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch11_rygel_database_database_error;
			}
			_g_object_unref0 (cursor);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = statement;
		_tmp4_ = sqlite3_column_text (_tmp3_, 0);
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (cursor);
		return result;
	}
	goto __finally11;
	__catch11_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp6_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("rygel-media-export-media-cache.vala:525: %s", _ ("Failed to get reset token"));
		_tmp6_ = gupnp_get_uuid ();
		result = _tmp6_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally11:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void
rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self,
                                                 const gchar* token)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	{
		GValue* args = NULL;
		GValue _tmp0_ = {0};
		GValue* _tmp1_;
		gint args_length1;
		gint _args_size_;
		RygelDatabaseDatabase* _tmp2_;
		g_value_init (&_tmp0_, G_TYPE_STRING);
		g_value_set_string (&_tmp0_, token);
		_tmp1_ = g_new0 (GValue, 1);
		_tmp1_[0] = _tmp0_;
		args = _tmp1_;
		args_length1 = 1;
		_args_size_ = args_length1;
		_tmp2_ = self->priv->db;
		rygel_database_database_exec (_tmp2_, "UPDATE schema_info SET reset_token = ?", args, args_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch12_rygel_database_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	goto __finally12;
	__catch12_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning (_ ("Failed to persist ServiceResetToken: %s"), _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void
rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_;
		_tmp0_ = self->priv->db;
		rygel_database_database_exec (_tmp0_, "DELETE FROM object WHERE " "upnp_id LIKE 'virtual-parent:%'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch13_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally13;
	__catch13_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning (_ ("Failed to remove virtual folders: %s"), _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void
rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self,
                                                    RygelMediaObject* object,
                                                    gboolean guarded)
{
	gint _tmp0_ = 0;
	gint guarded_val = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	if (guarded) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	guarded_val = _tmp0_;
	{
		GValue* values = NULL;
		GValue _tmp1_ = {0};
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GValue _tmp4_ = {0};
		GValue* _tmp5_;
		gint values_length1;
		gint _values_size_;
		RygelDatabaseDatabase* _tmp6_;
		RygelMediaExportSQLFactory* _tmp7_;
		const gchar* _tmp8_;
		g_value_init (&_tmp1_, G_TYPE_INT);
		g_value_set_int (&_tmp1_, guarded_val);
		_tmp2_ = rygel_media_object_get_id (object);
		_tmp3_ = _tmp2_;
		g_value_init (&_tmp4_, G_TYPE_STRING);
		g_value_set_string (&_tmp4_, _tmp3_);
		_tmp5_ = g_new0 (GValue, 2);
		_tmp5_[0] = _tmp1_;
		_tmp5_[1] = _tmp4_;
		values = _tmp5_;
		values_length1 = 2;
		_values_size_ = values_length1;
		_tmp6_ = self->priv->db;
		_tmp7_ = self->priv->sql;
		_tmp8_ = rygel_media_export_sql_factory_make (_tmp7_, RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED);
		rygel_database_database_exec (_tmp6_, _tmp8_, values, values_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch14_rygel_database_database_error;
			}
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		values = (_vala_GValue_array_free (values, values_length1), NULL);
	}
	goto __finally14;
	__catch14_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = rygel_media_object_get_id (object);
		_tmp10_ = _tmp9_;
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		g_warning (_ ("Failed to mark item %s as guarded (%d): %s"), _tmp10_, guarded_val, _tmp12_);
		_g_error_free0 (_error_);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gchar*
rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self,
                                                 RygelMediaObject* object,
                                                 RygelMediaContainer* parent,
                                                 GError** error)
{
	gchar* result = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER)) {
		gchar* msg = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp0_ = g_strdup (_ ("Cannot create references to containers"));
		msg = _tmp0_;
		_tmp1_ = msg;
		_tmp2_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return NULL;
	}
	rygel_media_object_set_parent (object, parent);
	_tmp3_ = rygel_media_object_get_ref_id (object);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = rygel_media_object_get_id (object);
		_tmp6_ = _tmp5_;
		rygel_media_object_set_ref_id (object, _tmp6_);
	}
	_tmp7_ = gupnp_get_uuid ();
	_tmp8_ = _tmp7_;
	rygel_media_object_set_id (object, _tmp8_);
	_g_free0 (_tmp8_);
	rygel_media_export_media_cache_save_item (self, G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) object) : NULL, FALSE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp9_ = rygel_media_object_get_id (object);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	return result;
}


void
rygel_media_export_media_cache_blacklist (RygelMediaExportMediaCache* self,
                                          GFile* file)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GValue* values = NULL;
		gchar* _tmp0_;
		GValue _tmp1_ = {0};
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		GValue _tmp4_ = {0};
		GValue* _tmp5_;
		GValue* _tmp6_;
		gint _tmp6__length1;
		gint values_length1;
		gint _values_size_;
		RygelDatabaseDatabase* _tmp7_;
		RygelMediaExportSQLFactory* _tmp8_;
		const gchar* _tmp9_;
		_tmp0_ = g_file_get_uri (file);
		g_value_init (&_tmp1_, G_TYPE_STRING);
		g_value_take_string (&_tmp1_, _tmp0_);
		_tmp2_ = g_date_time_new_now_utc ();
		_tmp3_ = _tmp2_;
		g_value_init (&_tmp4_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp4_, g_date_time_to_unix (_tmp3_));
		_tmp5_ = g_new0 (GValue, 2);
		_tmp5_[0] = _tmp1_;
		_tmp5_[1] = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 2;
		_g_date_time_unref0 (_tmp3_);
		values = _tmp6_;
		values_length1 = _tmp6__length1;
		_values_size_ = values_length1;
		_tmp7_ = self->priv->db;
		_tmp8_ = self->priv->sql;
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_ADD_TO_BLACKLIST);
		rygel_database_database_exec (_tmp7_, _tmp9_, values, values_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch15_rygel_database_database_error;
			}
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		values = (_vala_GValue_array_free (values, values_length1), NULL);
	}
	goto __finally15;
	__catch15_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = g_file_get_uri (file);
		_tmp11_ = _tmp10_;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_warning (_ ("Failed to add %s to file blacklist: %s"), _tmp11_, _tmp13_);
		_g_free0 (_tmp11_);
		_g_error_free0 (_error_);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean
rygel_media_export_media_cache_is_blacklisted (RygelMediaExportMediaCache* self,
                                               GFile* file)
{
	gboolean result = FALSE;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GValue* values = NULL;
		gchar* _tmp0_;
		GValue _tmp1_ = {0};
		GValue* _tmp2_;
		gint values_length1;
		gint _values_size_;
		gint _tmp3_ = 0;
		_tmp0_ = g_file_get_uri (file);
		g_value_init (&_tmp1_, G_TYPE_STRING);
		g_value_take_string (&_tmp1_, _tmp0_);
		_tmp2_ = g_new0 (GValue, 1);
		_tmp2_[0] = _tmp1_;
		values = _tmp2_;
		values_length1 = 1;
		_values_size_ = values_length1;
		_tmp3_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHECK_BLACKLIST, values, values_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch16_rygel_database_database_error;
			}
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		result = _tmp3_ == 1;
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return result;
	}
	goto __finally16;
	__catch16_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = g_file_get_uri (file);
		_tmp6_ = _tmp5_;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning (_ ("Failed to get whether URI %s is blacklisted: %s"), _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally16:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp9_;
}


static gboolean
rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self,
                                                  const gchar* id)
{
	gboolean result = FALSE;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	{
		GValue* id_value = NULL;
		GValue _tmp0_ = {0};
		GValue* _tmp1_;
		gint id_value_length1;
		gint _id_value_size_;
		gint _tmp2_ = 0;
		g_value_init (&_tmp0_, G_TYPE_STRING);
		g_value_set_string (&_tmp0_, id);
		_tmp1_ = g_new0 (GValue, 1);
		_tmp1_[0] = _tmp0_;
		id_value = _tmp1_;
		id_value_length1 = 1;
		_id_value_size_ = id_value_length1;
		_tmp2_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED, id_value, id_value_length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch17_rygel_database_database_error;
			}
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
		result = _tmp2_ == 1;
		id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
		return result;
	}
	goto __finally17;
	__catch17_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning (_ ("Failed to get whether item %s is guarded: %s"), id, _tmp5_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally17:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp6_;
}


void
rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self,
                                                     GError** error)
{
	GeeHashMap* _tmp0_;
	RygelDatabaseCursor* cursor = NULL;
	RygelDatabaseCursor* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GDestroyNotify) rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->exists_cache);
	self->priv->exists_cache = _tmp0_;
	_tmp1_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE, NULL, 0, &_inner_error_);
	cursor = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		RygelDatabaseCursorIterator* _statement_it = NULL;
		RygelDatabaseCursor* _tmp2_;
		RygelDatabaseCursorIterator* _tmp3_;
		_tmp2_ = cursor;
		_tmp3_ = rygel_database_cursor_iterator (_tmp2_);
		_statement_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			RygelDatabaseCursorIterator* _tmp5_;
			sqlite3_stmt* statement = NULL;
			RygelDatabaseCursorIterator* _tmp6_;
			sqlite3_stmt* _tmp7_;
			RygelMediaExportExistsCacheEntry entry = {0};
			sqlite3_stmt* _tmp8_;
			sqlite3_stmt* _tmp9_;
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			GeeHashMap* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_;
			RygelMediaExportExistsCacheEntry _tmp16_;
			_tmp5_ = _statement_it;
			_tmp4_ = rygel_database_cursor_iterator_next (_tmp5_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					return;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (!_tmp4_) {
				break;
			}
			_tmp6_ = _statement_it;
			_tmp7_ = rygel_database_cursor_iterator_get (_tmp6_, &_inner_error_);
			statement = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					return;
				} else {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
			_tmp8_ = statement;
			entry.mtime = sqlite3_column_int64 (_tmp8_, 1);
			_tmp9_ = statement;
			entry.size = sqlite3_column_int64 (_tmp9_, 0);
			_tmp10_ = statement;
			_tmp11_ = sqlite3_column_text (_tmp10_, 2);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (entry.content_type);
			entry.content_type = _tmp12_;
			_tmp13_ = self->priv->exists_cache;
			_tmp14_ = statement;
			_tmp15_ = sqlite3_column_text (_tmp14_, 3);
			_tmp16_ = entry;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp15_, &_tmp16_);
			rygel_media_export_exists_cache_entry_destroy (&entry);
		}
		_rygel_database_cursor_iterator_unref0 (_statement_it);
	}
	_g_object_unref0 (cursor);
}


static guint
rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self,
                                             guint max_count)
{
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	if (max_count == ((guint) 0)) {
		result = (guint) -1;
		return result;
	} else {
		result = max_count;
		return result;
	}
}


static void
rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self,
                                        const gchar* name,
                                        GError** error)
{
	RygelDatabaseDatabase* _tmp0_ = NULL;
	RygelDatabaseDatabase* _tmp1_;
	RygelDatabaseDatabase* _tmp2_;
	gint old_version = 0;
	gint current_version = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = rygel_database_database_new (name, RYGEL_DATABASE_FLAVOR_CACHE, RYGEL_DATABASE_FLAGS_READ_WRITE, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp2_;
	old_version = -1;
	current_version = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	{
		RygelMediaExportMediaCacheUpgrader* upgrader = NULL;
		RygelDatabaseDatabase* _tmp3_;
		RygelMediaExportSQLFactory* _tmp4_;
		RygelMediaExportMediaCacheUpgrader* _tmp5_;
		gboolean _tmp6_ = FALSE;
		RygelMediaExportMediaCacheUpgrader* _tmp7_;
		gint _tmp8_ = 0;
		gboolean _tmp9_;
		RygelMediaExportMediaCacheUpgrader* _tmp18_;
		_tmp3_ = self->priv->db;
		_tmp4_ = self->priv->sql;
		_tmp5_ = rygel_media_export_media_cache_upgrader_new (_tmp3_, _tmp4_);
		upgrader = _tmp5_;
		_tmp7_ = upgrader;
		_tmp9_ = rygel_media_export_media_cache_upgrader_needs_upgrade (_tmp7_, &_tmp8_, &_inner_error_);
		old_version = _tmp8_;
		_tmp6_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch18_rygel_database_database_error;
			}
			goto __finally18;
		}
		if (_tmp6_) {
			RygelMediaExportMediaCacheUpgrader* _tmp10_;
			gint _tmp11_;
			_tmp10_ = upgrader;
			_tmp11_ = old_version;
			rygel_media_export_media_cache_upgrader_upgrade (_tmp10_, _tmp11_);
		} else {
			gint _tmp12_;
			gint _tmp13_;
			_tmp12_ = old_version;
			_tmp13_ = current_version;
			if (_tmp12_ == _tmp13_) {
				RygelMediaExportMediaCacheUpgrader* _tmp14_;
				_tmp14_ = upgrader;
				rygel_media_export_media_cache_upgrader_fix_schema (_tmp14_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch18_rygel_database_database_error;
					}
					goto __finally18;
				}
			} else {
				gint _tmp15_;
				gint _tmp16_;
				GError* _tmp17_;
				_tmp15_ = old_version;
				_tmp16_ = current_version;
				g_warning (_ ("The version “%d” of the detected database is newer than our supported " \
"version “%d”"), _tmp15_, _tmp16_);
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				_tmp17_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
				_inner_error_ = _tmp17_;
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch18_rygel_database_database_error;
				}
				goto __finally18;
			}
		}
		_tmp18_ = upgrader;
		rygel_media_export_media_cache_upgrader_ensure_indices (_tmp18_);
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
	}
	goto __finally18;
	__catch18_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("rygel-media-export-media-cache.vala:676: %s", "Could not find schema version;" " checking for empty database...");
		{
			gboolean _tmp19_ = FALSE;
			RygelDatabaseDatabase* _tmp20_;
			_tmp20_ = self->priv->db;
			_tmp19_ = rygel_database_database_is_empty (_tmp20_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch19_rygel_database_database_error;
				}
				_g_error_free0 (_error_);
				_g_object_unref0 (_tmp0_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (_tmp19_) {
				g_debug ("rygel-media-export-media-cache.vala:680: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
				if (!rygel_media_export_media_cache_create_schema (self)) {
					_g_object_unref0 (self->priv->db);
					self->priv->db = NULL;
					_g_error_free0 (_error_);
					_g_object_unref0 (_tmp0_);
					return;
				}
			} else {
				g_warning ("rygel-media-export-media-cache.vala:688: %s", _ ("Incompatible schema… cannot proceed"));
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				_g_error_free0 (_error_);
				_g_object_unref0 (_tmp0_);
				return;
			}
		}
		goto __finally19;
		__catch19_rygel_database_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp21_;
			const gchar* _tmp22_;
			GError* _tmp23_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = _error_;
			_tmp22_ = _tmp21_->message;
			g_warning (_ ("Invalid database, cannot query sqlite_master table: %s"), _tmp22_);
			_g_object_unref0 (self->priv->db);
			self->priv->db = NULL;
			_tmp23_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
			_inner_error_ = _tmp23_;
			_g_error_free0 (_error_);
			goto __finally19;
		}
		__finally19:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_error_free0 (_error_);
			goto __finally18;
		}
		_g_error_free0 (_error_);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_g_object_unref0 (_tmp0_);
}


static void
rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self,
                                                        RygelMediaContainer* container,
                                                        GError** error)
{
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue* _tmp24_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp25_;
	RygelMediaExportSQLFactory* _tmp26_;
	const gchar* _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_value_init (&_tmp0_, G_TYPE_INT);
	g_value_set_int (&_tmp0_, 0);
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, "inode/directory");
	g_value_init (&_tmp2_, G_TYPE_INT);
	g_value_set_int (&_tmp2_, -1);
	g_value_init (&_tmp3_, G_TYPE_INT);
	g_value_set_int (&_tmp3_, -1);
	_tmp4_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) container);
	_tmp5_ = _tmp4_;
	g_value_init (&_tmp6_, G_TYPE_STRING);
	g_value_set_string (&_tmp6_, _tmp5_);
	rygel_database_null (&_tmp7_);
	rygel_database_null (&_tmp8_);
	rygel_database_null (&_tmp9_);
	g_value_init (&_tmp10_, G_TYPE_INT);
	g_value_set_int (&_tmp10_, -1);
	g_value_init (&_tmp11_, G_TYPE_INT);
	g_value_set_int (&_tmp11_, -1);
	g_value_init (&_tmp12_, G_TYPE_INT);
	g_value_set_int (&_tmp12_, -1);
	g_value_init (&_tmp13_, G_TYPE_INT);
	g_value_set_int (&_tmp13_, -1);
	g_value_init (&_tmp14_, G_TYPE_INT);
	g_value_set_int (&_tmp14_, -1);
	g_value_init (&_tmp15_, G_TYPE_INT);
	g_value_set_int (&_tmp15_, -1);
	g_value_init (&_tmp16_, G_TYPE_INT);
	g_value_set_int (&_tmp16_, -1);
	_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) container);
	_tmp18_ = _tmp17_;
	g_value_init (&_tmp19_, G_TYPE_STRING);
	g_value_set_string (&_tmp19_, _tmp18_);
	rygel_database_null (&_tmp20_);
	rygel_database_null (&_tmp21_);
	g_value_init (&_tmp22_, G_TYPE_INT);
	g_value_set_int (&_tmp22_, -1);
	rygel_database_null (&_tmp23_);
	_tmp24_ = g_new0 (GValue, 20);
	_tmp24_[0] = _tmp0_;
	_tmp24_[1] = _tmp1_;
	_tmp24_[2] = _tmp2_;
	_tmp24_[3] = _tmp3_;
	_tmp24_[4] = _tmp6_;
	_tmp24_[5] = _tmp7_;
	_tmp24_[6] = _tmp8_;
	_tmp24_[7] = _tmp9_;
	_tmp24_[8] = _tmp10_;
	_tmp24_[9] = _tmp11_;
	_tmp24_[10] = _tmp12_;
	_tmp24_[11] = _tmp13_;
	_tmp24_[12] = _tmp14_;
	_tmp24_[13] = _tmp15_;
	_tmp24_[14] = _tmp16_;
	_tmp24_[15] = _tmp19_;
	_tmp24_[16] = _tmp20_;
	_tmp24_[17] = _tmp21_;
	_tmp24_[18] = _tmp22_;
	_tmp24_[19] = _tmp23_;
	values = _tmp24_;
	values_length1 = 20;
	_values_size_ = values_length1;
	_tmp25_ = self->priv->db;
	_tmp26_ = self->priv->sql;
	_tmp27_ = rygel_media_export_sql_factory_make (_tmp26_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
	rygel_database_database_exec (_tmp25_, _tmp27_, values, values_length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void
rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self,
                                                   RygelMediaFileItem* item,
                                                   GError** error)
{
	GValue* values = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	GValue _tmp2_ = {0};
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GValue _tmp5_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_ = {0};
	GValue _tmp18_ = {0};
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GValue _tmp25_ = {0};
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GValue _tmp28_ = {0};
	GValue _tmp29_ = {0};
	GValue _tmp30_ = {0};
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GValue _tmp33_ = {0};
	GValue* _tmp34_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp129_;
	RygelMediaExportSQLFactory* _tmp130_;
	const gchar* _tmp131_;
	GValue* _tmp132_;
	gint _tmp132__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = rygel_media_file_item_get_size (item);
	_tmp1_ = _tmp0_;
	g_value_init (&_tmp2_, G_TYPE_INT64);
	g_value_set_int64 (&_tmp2_, _tmp1_);
	_tmp3_ = rygel_media_file_item_get_mime_type (item);
	_tmp4_ = _tmp3_;
	g_value_init (&_tmp5_, G_TYPE_STRING);
	g_value_set_string (&_tmp5_, _tmp4_);
	g_value_init (&_tmp6_, G_TYPE_INT);
	g_value_set_int (&_tmp6_, -1);
	g_value_init (&_tmp7_, G_TYPE_INT);
	g_value_set_int (&_tmp7_, -1);
	_tmp8_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) item);
	_tmp9_ = _tmp8_;
	g_value_init (&_tmp10_, G_TYPE_STRING);
	g_value_set_string (&_tmp10_, _tmp9_);
	rygel_database_null (&_tmp11_);
	rygel_database_null (&_tmp12_);
	_tmp13_ = rygel_media_object_get_date ((RygelMediaObject*) item);
	_tmp14_ = _tmp13_;
	g_value_init (&_tmp15_, G_TYPE_STRING);
	g_value_set_string (&_tmp15_, _tmp14_);
	g_value_init (&_tmp16_, G_TYPE_INT);
	g_value_set_int (&_tmp16_, -1);
	g_value_init (&_tmp17_, G_TYPE_INT);
	g_value_set_int (&_tmp17_, -1);
	g_value_init (&_tmp18_, G_TYPE_INT);
	g_value_set_int (&_tmp18_, -1);
	g_value_init (&_tmp19_, G_TYPE_INT);
	g_value_set_int (&_tmp19_, -1);
	g_value_init (&_tmp20_, G_TYPE_INT);
	g_value_set_int (&_tmp20_, -1);
	g_value_init (&_tmp21_, G_TYPE_INT);
	g_value_set_int (&_tmp21_, -1);
	g_value_init (&_tmp22_, G_TYPE_INT);
	g_value_set_int (&_tmp22_, -1);
	_tmp23_ = rygel_media_object_get_id ((RygelMediaObject*) item);
	_tmp24_ = _tmp23_;
	g_value_init (&_tmp25_, G_TYPE_STRING);
	g_value_set_string (&_tmp25_, _tmp24_);
	_tmp26_ = rygel_media_file_item_get_dlna_profile (item);
	_tmp27_ = _tmp26_;
	g_value_init (&_tmp28_, G_TYPE_STRING);
	g_value_set_string (&_tmp28_, _tmp27_);
	rygel_database_null (&_tmp29_);
	g_value_init (&_tmp30_, G_TYPE_INT);
	g_value_set_int (&_tmp30_, -1);
	_tmp31_ = rygel_media_object_get_creator ((RygelMediaObject*) item);
	_tmp32_ = _tmp31_;
	g_value_init (&_tmp33_, G_TYPE_STRING);
	g_value_set_string (&_tmp33_, _tmp32_);
	_tmp34_ = g_new0 (GValue, 20);
	_tmp34_[0] = _tmp2_;
	_tmp34_[1] = _tmp5_;
	_tmp34_[2] = _tmp6_;
	_tmp34_[3] = _tmp7_;
	_tmp34_[4] = _tmp10_;
	_tmp34_[5] = _tmp11_;
	_tmp34_[6] = _tmp12_;
	_tmp34_[7] = _tmp15_;
	_tmp34_[8] = _tmp16_;
	_tmp34_[9] = _tmp17_;
	_tmp34_[10] = _tmp18_;
	_tmp34_[11] = _tmp19_;
	_tmp34_[12] = _tmp20_;
	_tmp34_[13] = _tmp21_;
	_tmp34_[14] = _tmp22_;
	_tmp34_[15] = _tmp25_;
	_tmp34_[16] = _tmp28_;
	_tmp34_[17] = _tmp29_;
	_tmp34_[18] = _tmp30_;
	_tmp34_[19] = _tmp33_;
	values = _tmp34_;
	values_length1 = 20;
	_values_size_ = values_length1;
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelAudioItem* _tmp35_;
		GValue* _tmp36_;
		gint _tmp36__length1;
		RygelAudioItem* _tmp37_;
		glong _tmp38_;
		glong _tmp39_;
		GValue _tmp40_ = {0};
		GValue _tmp41_;
		GValue* _tmp42_;
		gint _tmp42__length1;
		RygelAudioItem* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		GValue _tmp46_ = {0};
		GValue _tmp47_;
		GValue* _tmp48_;
		gint _tmp48__length1;
		RygelAudioItem* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		GValue _tmp52_ = {0};
		GValue _tmp53_;
		GValue* _tmp54_;
		gint _tmp54__length1;
		RygelAudioItem* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		GValue _tmp58_ = {0};
		GValue _tmp59_;
		GValue* _tmp60_;
		gint _tmp60__length1;
		RygelAudioItem* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		GValue _tmp64_ = {0};
		GValue _tmp65_;
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL);
		audio_item = _tmp35_;
		_tmp36_ = values;
		_tmp36__length1 = values_length1;
		_tmp37_ = audio_item;
		_tmp38_ = rygel_audio_item_get_duration (_tmp37_);
		_tmp39_ = _tmp38_;
		g_value_init (&_tmp40_, G_TYPE_LONG);
		g_value_set_long (&_tmp40_, _tmp39_);
		G_IS_VALUE (&_tmp36_[14]) ? (g_value_unset (&_tmp36_[14]), NULL) : NULL;
		_tmp36_[14] = _tmp40_;
		_tmp41_ = _tmp36_[14];
		_tmp42_ = values;
		_tmp42__length1 = values_length1;
		_tmp43_ = audio_item;
		_tmp44_ = rygel_audio_item_get_bitrate (_tmp43_);
		_tmp45_ = _tmp44_;
		g_value_init (&_tmp46_, G_TYPE_INT);
		g_value_set_int (&_tmp46_, _tmp45_);
		G_IS_VALUE (&_tmp42_[8]) ? (g_value_unset (&_tmp42_[8]), NULL) : NULL;
		_tmp42_[8] = _tmp46_;
		_tmp47_ = _tmp42_[8];
		_tmp48_ = values;
		_tmp48__length1 = values_length1;
		_tmp49_ = audio_item;
		_tmp50_ = rygel_audio_item_get_sample_freq (_tmp49_);
		_tmp51_ = _tmp50_;
		g_value_init (&_tmp52_, G_TYPE_INT);
		g_value_set_int (&_tmp52_, _tmp51_);
		G_IS_VALUE (&_tmp48_[9]) ? (g_value_unset (&_tmp48_[9]), NULL) : NULL;
		_tmp48_[9] = _tmp52_;
		_tmp53_ = _tmp48_[9];
		_tmp54_ = values;
		_tmp54__length1 = values_length1;
		_tmp55_ = audio_item;
		_tmp56_ = rygel_audio_item_get_bits_per_sample (_tmp55_);
		_tmp57_ = _tmp56_;
		g_value_init (&_tmp58_, G_TYPE_INT);
		g_value_set_int (&_tmp58_, _tmp57_);
		G_IS_VALUE (&_tmp54_[10]) ? (g_value_unset (&_tmp54_[10]), NULL) : NULL;
		_tmp54_[10] = _tmp58_;
		_tmp59_ = _tmp54_[10];
		_tmp60_ = values;
		_tmp60__length1 = values_length1;
		_tmp61_ = audio_item;
		_tmp62_ = rygel_audio_item_get_channels (_tmp61_);
		_tmp63_ = _tmp62_;
		g_value_init (&_tmp64_, G_TYPE_INT);
		g_value_set_int (&_tmp64_, _tmp63_);
		G_IS_VALUE (&_tmp60_[11]) ? (g_value_unset (&_tmp60_[11]), NULL) : NULL;
		_tmp60_[11] = _tmp64_;
		_tmp65_ = _tmp60_[11];
		if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaExportMusicItem* _tmp66_;
			GValue* _tmp67_;
			gint _tmp67__length1;
			RygelMediaExportMusicItem* _tmp68_;
			const gchar* _tmp69_;
			const gchar* _tmp70_;
			GValue _tmp71_ = {0};
			GValue _tmp72_;
			GValue* _tmp73_;
			gint _tmp73__length1;
			RygelMediaExportMusicItem* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			GValue _tmp77_ = {0};
			GValue _tmp78_;
			GValue* _tmp79_;
			gint _tmp79__length1;
			RygelMediaExportMusicItem* _tmp80_;
			const gchar* _tmp81_;
			const gchar* _tmp82_;
			GValue _tmp83_ = {0};
			GValue _tmp84_;
			GValue* _tmp85_;
			gint _tmp85__length1;
			RygelMediaExportMusicItem* _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
			GValue _tmp89_ = {0};
			GValue _tmp90_;
			GValue* _tmp91_;
			gint _tmp91__length1;
			RygelMediaExportMusicItem* _tmp92_;
			gint _tmp93_;
			GValue _tmp94_ = {0};
			GValue _tmp95_;
			_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) item) : NULL);
			music_item = _tmp66_;
			_tmp67_ = values;
			_tmp67__length1 = values_length1;
			_tmp68_ = music_item;
			_tmp69_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp68_);
			_tmp70_ = _tmp69_;
			g_value_init (&_tmp71_, G_TYPE_STRING);
			g_value_set_string (&_tmp71_, _tmp70_);
			G_IS_VALUE (&_tmp67_[5]) ? (g_value_unset (&_tmp67_[5]), NULL) : NULL;
			_tmp67_[5] = _tmp71_;
			_tmp72_ = _tmp67_[5];
			_tmp73_ = values;
			_tmp73__length1 = values_length1;
			_tmp74_ = music_item;
			_tmp75_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp74_);
			_tmp76_ = _tmp75_;
			g_value_init (&_tmp77_, G_TYPE_STRING);
			g_value_set_string (&_tmp77_, _tmp76_);
			G_IS_VALUE (&_tmp73_[6]) ? (g_value_unset (&_tmp73_[6]), NULL) : NULL;
			_tmp73_[6] = _tmp77_;
			_tmp78_ = _tmp73_[6];
			_tmp79_ = values;
			_tmp79__length1 = values_length1;
			_tmp80_ = music_item;
			_tmp81_ = rygel_media_object_get_genre ((RygelMediaObject*) _tmp80_);
			_tmp82_ = _tmp81_;
			g_value_init (&_tmp83_, G_TYPE_STRING);
			g_value_set_string (&_tmp83_, _tmp82_);
			G_IS_VALUE (&_tmp79_[17]) ? (g_value_unset (&_tmp79_[17]), NULL) : NULL;
			_tmp79_[17] = _tmp83_;
			_tmp84_ = _tmp79_[17];
			_tmp85_ = values;
			_tmp85__length1 = values_length1;
			_tmp86_ = music_item;
			_tmp87_ = rygel_music_item_get_track_number ((RygelMusicItem*) _tmp86_);
			_tmp88_ = _tmp87_;
			g_value_init (&_tmp89_, G_TYPE_INT);
			g_value_set_int (&_tmp89_, _tmp88_);
			G_IS_VALUE (&_tmp85_[12]) ? (g_value_unset (&_tmp85_[12]), NULL) : NULL;
			_tmp85_[12] = _tmp89_;
			_tmp90_ = _tmp85_[12];
			_tmp91_ = values;
			_tmp91__length1 = values_length1;
			_tmp92_ = music_item;
			_tmp93_ = _tmp92_->disc;
			g_value_init (&_tmp94_, G_TYPE_INT);
			g_value_set_int (&_tmp94_, _tmp93_);
			G_IS_VALUE (&_tmp91_[18]) ? (g_value_unset (&_tmp91_[18]), NULL) : NULL;
			_tmp91_[18] = _tmp94_;
			_tmp95_ = _tmp91_[18];
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelVisualItem* _tmp96_;
		GValue* _tmp97_;
		gint _tmp97__length1;
		RygelVisualItem* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		GValue _tmp101_ = {0};
		GValue _tmp102_;
		GValue* _tmp103_;
		gint _tmp103__length1;
		RygelVisualItem* _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
		GValue _tmp107_ = {0};
		GValue _tmp108_;
		GValue* _tmp109_;
		gint _tmp109__length1;
		RygelVisualItem* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		GValue _tmp113_ = {0};
		GValue _tmp114_;
		_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) item) : NULL);
		visual_item = _tmp96_;
		_tmp97_ = values;
		_tmp97__length1 = values_length1;
		_tmp98_ = visual_item;
		_tmp99_ = rygel_visual_item_get_width (_tmp98_);
		_tmp100_ = _tmp99_;
		g_value_init (&_tmp101_, G_TYPE_INT);
		g_value_set_int (&_tmp101_, _tmp100_);
		G_IS_VALUE (&_tmp97_[2]) ? (g_value_unset (&_tmp97_[2]), NULL) : NULL;
		_tmp97_[2] = _tmp101_;
		_tmp102_ = _tmp97_[2];
		_tmp103_ = values;
		_tmp103__length1 = values_length1;
		_tmp104_ = visual_item;
		_tmp105_ = rygel_visual_item_get_height (_tmp104_);
		_tmp106_ = _tmp105_;
		g_value_init (&_tmp107_, G_TYPE_INT);
		g_value_set_int (&_tmp107_, _tmp106_);
		G_IS_VALUE (&_tmp103_[3]) ? (g_value_unset (&_tmp103_[3]), NULL) : NULL;
		_tmp103_[3] = _tmp107_;
		_tmp108_ = _tmp103_[3];
		_tmp109_ = values;
		_tmp109__length1 = values_length1;
		_tmp110_ = visual_item;
		_tmp111_ = rygel_visual_item_get_color_depth (_tmp110_);
		_tmp112_ = _tmp111_;
		g_value_init (&_tmp113_, G_TYPE_INT);
		g_value_set_int (&_tmp113_, _tmp112_);
		G_IS_VALUE (&_tmp109_[13]) ? (g_value_unset (&_tmp109_[13]), NULL) : NULL;
		_tmp109_[13] = _tmp113_;
		_tmp114_ = _tmp109_[13];
		if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM)) {
			RygelMediaExportVideoItem* video_item = NULL;
			RygelMediaExportVideoItem* _tmp115_;
			GValue* _tmp116_;
			gint _tmp116__length1;
			RygelMediaExportVideoItem* _tmp117_;
			const gchar* _tmp118_;
			const gchar* _tmp119_;
			GValue _tmp120_ = {0};
			GValue _tmp121_;
			_tmp115_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) item) : NULL);
			video_item = _tmp115_;
			_tmp116_ = values;
			_tmp116__length1 = values_length1;
			_tmp117_ = video_item;
			_tmp118_ = rygel_video_item_get_author ((RygelVideoItem*) _tmp117_);
			_tmp119_ = _tmp118_;
			g_value_init (&_tmp120_, G_TYPE_STRING);
			g_value_set_string (&_tmp120_, _tmp119_);
			G_IS_VALUE (&_tmp116_[5]) ? (g_value_unset (&_tmp116_[5]), NULL) : NULL;
			_tmp116_[5] = _tmp120_;
			_tmp121_ = _tmp116_[5];
			_g_object_unref0 (video_item);
		}
		_g_object_unref0 (visual_item);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM)) {
		RygelMediaExportPlaylistItem* playlist_item = NULL;
		RygelMediaExportPlaylistItem* _tmp122_;
		GValue* _tmp123_;
		gint _tmp123__length1;
		RygelMediaExportPlaylistItem* _tmp124_;
		const gchar* _tmp125_;
		const gchar* _tmp126_;
		GValue _tmp127_ = {0};
		GValue _tmp128_;
		_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM) ? ((RygelMediaExportPlaylistItem*) item) : NULL);
		playlist_item = _tmp122_;
		_tmp123_ = values;
		_tmp123__length1 = values_length1;
		_tmp124_ = playlist_item;
		_tmp125_ = rygel_media_object_get_creator ((RygelMediaObject*) _tmp124_);
		_tmp126_ = _tmp125_;
		g_value_init (&_tmp127_, G_TYPE_STRING);
		g_value_set_string (&_tmp127_, _tmp126_);
		G_IS_VALUE (&_tmp123_[5]) ? (g_value_unset (&_tmp123_[5]), NULL) : NULL;
		_tmp123_[5] = _tmp127_;
		_tmp128_ = _tmp123_[5];
		_g_object_unref0 (playlist_item);
	}
	_tmp129_ = self->priv->db;
	_tmp130_ = self->priv->sql;
	_tmp131_ = rygel_media_export_sql_factory_make (_tmp130_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
	_tmp132_ = values;
	_tmp132__length1 = values_length1;
	rygel_database_database_exec (_tmp129_, _tmp131_, _tmp132_, _tmp132__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void
rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self,
                                                      RygelMediaObject* object,
                                                      GError** error)
{
	gint type = 0;
	GValue parent = {0};
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	GValue* values = NULL;
	gint _tmp8_;
	GValue _tmp9_ = {0};
	GValue _tmp10_;
	GValue _tmp11_ = {0};
	guint64 _tmp12_;
	guint64 _tmp13_;
	GValue _tmp14_ = {0};
	gchar* _tmp15_;
	GValue _tmp16_ = {0};
	guint _tmp17_;
	guint _tmp18_;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GValue _tmp24_ = {0};
	GValue* _tmp25_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp37_;
	RygelMediaExportSQLFactory* _tmp38_;
	const gchar* _tmp39_;
	GValue* _tmp40_;
	gint _tmp40__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	_tmp0_ = rygel_media_object_get_parent (object);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		GValue _tmp2_ = {0};
		rygel_database_null (&_tmp2_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp2_;
	} else {
		RygelMediaContainer* _tmp3_;
		RygelMediaContainer* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GValue _tmp7_ = {0};
		_tmp3_ = rygel_media_object_get_parent (object);
		_tmp4_ = _tmp3_;
		_tmp5_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_value_init (&_tmp7_, G_TYPE_STRING);
		g_value_set_string (&_tmp7_, _tmp6_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp7_;
	}
	_tmp8_ = type;
	g_value_init (&_tmp9_, G_TYPE_INT);
	g_value_set_int (&_tmp9_, _tmp8_);
	_tmp10_ = parent;
	if (G_IS_VALUE (&_tmp10_)) {
		g_value_init (&_tmp11_, G_VALUE_TYPE (&_tmp10_));
		g_value_copy (&_tmp10_, &_tmp11_);
	} else {
		_tmp11_ = _tmp10_;
	}
	_tmp12_ = rygel_media_object_get_modified (object);
	_tmp13_ = _tmp12_;
	g_value_init (&_tmp14_, G_TYPE_UINT64);
	g_value_set_uint64 (&_tmp14_, _tmp13_);
	_tmp15_ = rygel_media_object_get_primary_uri (object);
	g_value_init (&_tmp16_, G_TYPE_STRING);
	g_value_take_string (&_tmp16_, _tmp15_);
	_tmp17_ = rygel_media_object_get_object_update_id (object);
	_tmp18_ = _tmp17_;
	g_value_init (&_tmp19_, G_TYPE_UINT);
	g_value_set_uint (&_tmp19_, _tmp18_);
	g_value_init (&_tmp20_, G_TYPE_INT);
	g_value_set_int (&_tmp20_, -1);
	g_value_init (&_tmp21_, G_TYPE_INT);
	g_value_set_int (&_tmp21_, -1);
	_tmp22_ = rygel_media_object_get_id (object);
	_tmp23_ = _tmp22_;
	g_value_init (&_tmp24_, G_TYPE_STRING);
	g_value_set_string (&_tmp24_, _tmp23_);
	_tmp25_ = g_new0 (GValue, 8);
	_tmp25_[0] = _tmp9_;
	_tmp25_[1] = _tmp11_;
	_tmp25_[2] = _tmp14_;
	_tmp25_[3] = _tmp16_;
	_tmp25_[4] = _tmp19_;
	_tmp25_[5] = _tmp20_;
	_tmp25_[6] = _tmp21_;
	_tmp25_[7] = _tmp24_;
	values = _tmp25_;
	values_length1 = 8;
	_values_size_ = values_length1;
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaContainer* container = NULL;
		RygelMediaContainer* _tmp26_;
		GValue* _tmp27_;
		gint _tmp27__length1;
		RygelMediaContainer* _tmp28_;
		gint64 _tmp29_;
		GValue _tmp30_ = {0};
		GValue _tmp31_;
		GValue* _tmp32_;
		gint _tmp32__length1;
		RygelMediaContainer* _tmp33_;
		guint32 _tmp34_;
		GValue _tmp35_ = {0};
		GValue _tmp36_;
		_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) object) : NULL);
		container = _tmp26_;
		_tmp27_ = values;
		_tmp27__length1 = values_length1;
		_tmp28_ = container;
		_tmp29_ = _tmp28_->total_deleted_child_count;
		g_value_init (&_tmp30_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp30_, _tmp29_);
		G_IS_VALUE (&_tmp27_[6]) ? (g_value_unset (&_tmp27_[6]), NULL) : NULL;
		_tmp27_[6] = _tmp30_;
		_tmp31_ = _tmp27_[6];
		_tmp32_ = values;
		_tmp32__length1 = values_length1;
		_tmp33_ = container;
		_tmp34_ = _tmp33_->update_id;
		g_value_init (&_tmp35_, G_TYPE_UINT);
		g_value_set_uint (&_tmp35_, _tmp34_);
		G_IS_VALUE (&_tmp32_[7]) ? (g_value_unset (&_tmp32_[7]), NULL) : NULL;
		_tmp32_[7] = _tmp35_;
		_tmp36_ = _tmp32_[7];
		_g_object_unref0 (container);
	}
	_tmp37_ = self->priv->db;
	_tmp38_ = self->priv->sql;
	_tmp39_ = rygel_media_export_sql_factory_make (_tmp38_, RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT);
	_tmp40_ = values;
	_tmp40__length1 = values_length1;
	rygel_database_database_exec (_tmp37_, _tmp39_, _tmp40_, _tmp40__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}


static void
rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self,
                                                     RygelMediaObject* object,
                                                     gboolean is_guarded,
                                                     GError** error)
{
	gint type = 0;
	GValue parent = {0};
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	gint _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GValue* values = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GValue _tmp14_ = {0};
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GValue _tmp17_ = {0};
	gint _tmp18_;
	GValue _tmp19_ = {0};
	GValue _tmp20_;
	GValue _tmp21_ = {0};
	guint64 _tmp22_;
	guint64 _tmp23_;
	GValue _tmp24_ = {0};
	gchar* _tmp25_;
	GValue _tmp26_ = {0};
	guint _tmp27_;
	guint _tmp28_;
	GValue _tmp29_ = {0};
	GValue _tmp30_ = {0};
	GValue _tmp31_ = {0};
	GValue _tmp32_ = {0};
	GValue _tmp33_ = {0};
	GValue* _tmp34_;
	gint values_length1;
	gint _values_size_;
	RygelDatabaseDatabase* _tmp46_;
	RygelMediaExportSQLFactory* _tmp47_;
	const gchar* _tmp48_;
	GValue* _tmp49_;
	gint _tmp49__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	_tmp0_ = rygel_media_object_get_parent (object);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		GValue _tmp2_ = {0};
		rygel_database_null (&_tmp2_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp2_;
	} else {
		RygelMediaContainer* _tmp3_;
		RygelMediaContainer* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GValue _tmp7_ = {0};
		_tmp3_ = rygel_media_object_get_parent (object);
		_tmp4_ = _tmp3_;
		_tmp5_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_value_init (&_tmp7_, G_TYPE_STRING);
		g_value_set_string (&_tmp7_, _tmp6_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp7_;
	}
	if (is_guarded) {
		_tmp8_ = 1;
	} else {
		_tmp8_ = 0;
	}
	_tmp10_ = rygel_media_object_get_ref_id (object);
	_tmp11_ = _tmp10_;
	_tmp9_ = _tmp11_;
	if (_tmp9_ == NULL) {
		_tmp9_ = NULL;
	}
	_tmp12_ = rygel_media_object_get_id (object);
	_tmp13_ = _tmp12_;
	g_value_init (&_tmp14_, G_TYPE_STRING);
	g_value_set_string (&_tmp14_, _tmp13_);
	_tmp15_ = rygel_media_object_get_title (object);
	_tmp16_ = _tmp15_;
	g_value_init (&_tmp17_, G_TYPE_STRING);
	g_value_set_string (&_tmp17_, _tmp16_);
	_tmp18_ = type;
	g_value_init (&_tmp19_, G_TYPE_INT);
	g_value_set_int (&_tmp19_, _tmp18_);
	_tmp20_ = parent;
	if (G_IS_VALUE (&_tmp20_)) {
		g_value_init (&_tmp21_, G_VALUE_TYPE (&_tmp20_));
		g_value_copy (&_tmp20_, &_tmp21_);
	} else {
		_tmp21_ = _tmp20_;
	}
	_tmp22_ = rygel_media_object_get_modified (object);
	_tmp23_ = _tmp22_;
	g_value_init (&_tmp24_, G_TYPE_UINT64);
	g_value_set_uint64 (&_tmp24_, _tmp23_);
	_tmp25_ = rygel_media_object_get_primary_uri (object);
	g_value_init (&_tmp26_, G_TYPE_STRING);
	g_value_take_string (&_tmp26_, _tmp25_);
	_tmp27_ = rygel_media_object_get_object_update_id (object);
	_tmp28_ = _tmp27_;
	g_value_init (&_tmp29_, G_TYPE_UINT);
	g_value_set_uint (&_tmp29_, _tmp28_);
	g_value_init (&_tmp30_, G_TYPE_INT);
	g_value_set_int (&_tmp30_, -1);
	g_value_init (&_tmp31_, G_TYPE_INT);
	g_value_set_int (&_tmp31_, -1);
	g_value_init (&_tmp32_, G_TYPE_INT);
	g_value_set_int (&_tmp32_, _tmp8_);
	g_value_init (&_tmp33_, G_TYPE_STRING);
	g_value_set_string (&_tmp33_, _tmp9_);
	_tmp34_ = g_new0 (GValue, 11);
	_tmp34_[0] = _tmp14_;
	_tmp34_[1] = _tmp17_;
	_tmp34_[2] = _tmp19_;
	_tmp34_[3] = _tmp21_;
	_tmp34_[4] = _tmp24_;
	_tmp34_[5] = _tmp26_;
	_tmp34_[6] = _tmp29_;
	_tmp34_[7] = _tmp30_;
	_tmp34_[8] = _tmp31_;
	_tmp34_[9] = _tmp32_;
	_tmp34_[10] = _tmp33_;
	values = _tmp34_;
	values_length1 = 11;
	_values_size_ = values_length1;
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaContainer* container = NULL;
		RygelMediaContainer* _tmp35_;
		GValue* _tmp36_;
		gint _tmp36__length1;
		RygelMediaContainer* _tmp37_;
		gint64 _tmp38_;
		GValue _tmp39_ = {0};
		GValue _tmp40_;
		GValue* _tmp41_;
		gint _tmp41__length1;
		RygelMediaContainer* _tmp42_;
		guint32 _tmp43_;
		GValue _tmp44_ = {0};
		GValue _tmp45_;
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) object) : NULL);
		container = _tmp35_;
		_tmp36_ = values;
		_tmp36__length1 = values_length1;
		_tmp37_ = container;
		_tmp38_ = _tmp37_->total_deleted_child_count;
		g_value_init (&_tmp39_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp39_, _tmp38_);
		G_IS_VALUE (&_tmp36_[7]) ? (g_value_unset (&_tmp36_[7]), NULL) : NULL;
		_tmp36_[7] = _tmp39_;
		_tmp40_ = _tmp36_[7];
		_tmp41_ = values;
		_tmp41__length1 = values_length1;
		_tmp42_ = container;
		_tmp43_ = _tmp42_->update_id;
		g_value_init (&_tmp44_, G_TYPE_UINT);
		g_value_set_uint (&_tmp44_, _tmp43_);
		G_IS_VALUE (&_tmp41_[8]) ? (g_value_unset (&_tmp41_[8]), NULL) : NULL;
		_tmp41_[8] = _tmp44_;
		_tmp45_ = _tmp41_[8];
		_g_object_unref0 (container);
	}
	_tmp46_ = self->priv->db;
	_tmp47_ = self->priv->sql;
	_tmp48_ = rygel_media_export_sql_factory_make (_tmp47_, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
	_tmp49_ = values;
	_tmp49__length1 = values_length1;
	rygel_database_database_exec (_tmp46_, _tmp48_, _tmp49_, _tmp49__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}


/**
     * Add the container or item to the cache.
     */
static void
rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self,
                                              RygelMediaObject* object,
                                              gboolean override_guarded,
                                              GError** error)
{
	gboolean is_guarded = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = rygel_media_object_get_id (object);
	_tmp1_ = _tmp0_;
	is_guarded = rygel_media_export_media_cache_is_object_guarded (self, _tmp1_);
	if (!override_guarded) {
		gboolean _tmp3_;
		_tmp3_ = is_guarded;
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		rygel_media_export_media_cache_update_guarded_object (self, object, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		_tmp5_ = is_guarded;
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = override_guarded;
		}
		rygel_media_export_media_cache_create_normal_object (self, object, _tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean
rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		RygelDatabaseDatabase* _tmp0_;
		RygelDatabaseDatabase* _tmp1_;
		RygelMediaExportSQLFactory* _tmp2_;
		const gchar* _tmp3_;
		RygelDatabaseDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		const gchar* _tmp6_;
		RygelDatabaseDatabase* _tmp7_;
		RygelMediaExportSQLFactory* _tmp8_;
		const gchar* _tmp9_;
		RygelDatabaseDatabase* _tmp10_;
		RygelMediaExportSQLFactory* _tmp11_;
		const gchar* _tmp12_;
		RygelDatabaseDatabase* _tmp13_;
		RygelMediaExportSQLFactory* _tmp14_;
		const gchar* _tmp15_;
		RygelDatabaseDatabase* _tmp16_;
		RygelMediaExportSQLFactory* _tmp17_;
		const gchar* _tmp18_;
		RygelDatabaseDatabase* _tmp19_;
		RygelDatabaseDatabase* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp0_ = self->priv->db;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp1_ = self->priv->db;
		_tmp2_ = self->priv->sql;
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
		rygel_database_database_exec (_tmp1_, _tmp3_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp4_ = self->priv->db;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_database_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp7_ = self->priv->db;
		_tmp8_ = self->priv->sql;
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_database_database_exec (_tmp7_, _tmp9_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp10_ = self->priv->db;
		_tmp11_ = self->priv->sql;
		_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_database_database_exec (_tmp10_, _tmp12_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp13_ = self->priv->db;
		_tmp14_ = self->priv->sql;
		_tmp15_ = rygel_media_export_sql_factory_make (_tmp14_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_database_database_exec (_tmp13_, _tmp15_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp16_ = self->priv->db;
		_tmp17_ = self->priv->sql;
		_tmp18_ = rygel_media_export_sql_factory_make (_tmp17_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE);
		rygel_database_database_exec (_tmp16_, _tmp18_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp19_ = self->priv->db;
		rygel_database_database_commit (_tmp19_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_tmp20_ = self->priv->db;
		rygel_database_database_analyze (_tmp20_);
		_tmp21_ = gupnp_get_uuid ();
		_tmp22_ = _tmp21_;
		rygel_media_export_media_cache_save_reset_token (self, _tmp22_);
		_g_free0 (_tmp22_);
		result = TRUE;
		return result;
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* err = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		RygelDatabaseDatabase* _tmp25_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		g_warning (_ ("Failed to create database schema: %s"), _tmp24_);
		_tmp25_ = self->priv->db;
		rygel_database_database_rollback (_tmp25_);
		_g_error_free0 (err);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp26_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp26_;
	}
	result = FALSE;
	return result;
}


/**
     * Create a new container or item based on a SQL result.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     *
     * @param parent The object's parent container.
     * @param statement a SQLite result indicating the container's details.
     */
static RygelMediaObject*
rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self,
                                                          RygelMediaContainer* parent,
                                                          sqlite3_stmt* statement)
{
	RygelMediaObject* result = NULL;
	RygelMediaObject* object = NULL;
	const gchar* title = NULL;
	const gchar* _tmp0_;
	const gchar* object_id = NULL;
	const gchar* _tmp1_;
	const gchar* uri = NULL;
	const gchar* _tmp2_;
	RygelMediaObject* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	object = NULL;
	_tmp0_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
	title = _tmp0_;
	_tmp1_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
	object_id = _tmp1_;
	_tmp2_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
	uri = _tmp2_;
	switch (sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE)) {
		case 0:
		{
			RygelMediaExportObjectFactory* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			RygelMediaContainer* _tmp7_;
			RygelMediaContainer* container = NULL;
			RygelMediaObject* _tmp8_;
			RygelMediaContainer* _tmp9_;
			const gchar* _tmp10_;
			RygelMediaContainer* _tmp13_;
			RygelMediaContainer* _tmp14_;
			_tmp3_ = self->priv->factory;
			_tmp4_ = object_id;
			_tmp5_ = title;
			_tmp6_ = uri;
			_tmp7_ = rygel_media_export_object_factory_get_container (_tmp3_, _tmp4_, _tmp5_, (guint) 0, _tmp6_);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp8_) : NULL);
			container = _tmp9_;
			_tmp10_ = uri;
			if (_tmp10_ != NULL) {
				RygelMediaContainer* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = container;
				_tmp12_ = uri;
				rygel_media_object_add_uri ((RygelMediaObject*) _tmp11_, _tmp12_);
			}
			_tmp13_ = container;
			_tmp13_->total_deleted_child_count = (gint64) ((guint32) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT));
			_tmp14_ = container;
			_tmp14_->update_id = (guint32) ((guint) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID));
			_g_object_unref0 (container);
			break;
		}
		case 1:
		{
			const gchar* upnp_class = NULL;
			const gchar* _tmp15_;
			RygelMediaExportObjectFactory* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			RygelMediaFileItem* _tmp20_;
			RygelMediaFileItem* item = NULL;
			RygelMediaObject* _tmp21_;
			RygelMediaFileItem* _tmp22_;
			RygelMediaFileItem* _tmp23_;
			const gchar* _tmp24_;
			RygelMediaFileItem* _tmp27_;
			_tmp15_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
			upnp_class = _tmp15_;
			_tmp16_ = self->priv->factory;
			_tmp17_ = object_id;
			_tmp18_ = title;
			_tmp19_ = upnp_class;
			_tmp20_ = rygel_media_export_object_factory_get_item (_tmp16_, parent, _tmp17_, _tmp18_, _tmp19_);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp20_;
			_tmp21_ = object;
			_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp21_) : NULL);
			item = _tmp22_;
			_tmp23_ = item;
			rygel_media_export_media_cache_fill_item (self, statement, _tmp23_);
			_tmp24_ = uri;
			if (_tmp24_ != NULL) {
				RygelMediaFileItem* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = item;
				_tmp26_ = uri;
				rygel_media_object_add_uri ((RygelMediaObject*) _tmp25_, _tmp26_);
			}
			_tmp27_ = item;
			rygel_media_file_item_add_engine_resources (_tmp27_, NULL, NULL);
			_g_object_unref0 (item);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp28_ = object;
	if (_tmp28_ != NULL) {
		RygelMediaObject* _tmp29_;
		gboolean _tmp30_ = FALSE;
		RygelMediaObject* _tmp31_;
		guint64 _tmp32_;
		guint64 _tmp33_;
		RygelMediaObject* _tmp37_;
		RygelMediaObject* _tmp38_;
		const gchar* _tmp39_;
		_tmp29_ = object;
		rygel_media_object_set_modified (_tmp29_, (guint64) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP));
		_tmp31_ = object;
		_tmp32_ = rygel_media_object_get_modified (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp33_ == ((guint64) G_MAXINT64)) {
			RygelMediaObject* _tmp34_;
			_tmp34_ = object;
			_tmp30_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_TYPE_MEDIA_FILE_ITEM);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			RygelMediaObject* _tmp35_;
			RygelMediaObject* _tmp36_;
			_tmp35_ = object;
			rygel_media_object_set_modified (_tmp35_, (guint64) 0);
			_tmp36_ = object;
			rygel_media_file_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp36_) : NULL, TRUE);
		}
		_tmp37_ = object;
		rygel_media_object_set_object_update_id (_tmp37_, (guint) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID));
		_tmp38_ = object;
		_tmp39_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID);
		rygel_media_object_set_ref_id (_tmp38_, _tmp39_);
	}
	result = object;
	return result;
}


static void
rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self,
                                          sqlite3_stmt* statement,
                                          RygelMediaFileItem* item)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
	rygel_media_object_set_date ((RygelMediaObject*) item, _tmp0_);
	_tmp1_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
	rygel_media_file_item_set_mime_type (item, _tmp1_);
	_tmp2_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
	rygel_media_file_item_set_dlna_profile (item, _tmp2_);
	rygel_media_file_item_set_size (item, sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE));
	_tmp3_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR);
	rygel_media_object_set_creator ((RygelMediaObject*) item, _tmp3_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelAudioItem* _tmp4_;
		RygelAudioItem* _tmp5_;
		RygelAudioItem* _tmp6_;
		RygelAudioItem* _tmp7_;
		RygelAudioItem* _tmp8_;
		RygelAudioItem* _tmp9_;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL);
		audio_item = _tmp4_;
		_tmp5_ = audio_item;
		rygel_audio_item_set_duration (_tmp5_, (glong) sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION));
		_tmp6_ = audio_item;
		rygel_audio_item_set_bitrate (_tmp6_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE));
		_tmp7_ = audio_item;
		rygel_audio_item_set_sample_freq (_tmp7_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ));
		_tmp8_ = audio_item;
		rygel_audio_item_set_bits_per_sample (_tmp8_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE));
		_tmp9_ = audio_item;
		rygel_audio_item_set_channels (_tmp9_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS));
		if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaExportMusicItem* _tmp10_;
			RygelMediaExportMusicItem* _tmp11_;
			const gchar* _tmp12_;
			RygelMediaExportMusicItem* _tmp13_;
			const gchar* _tmp14_;
			RygelMediaExportMusicItem* _tmp15_;
			const gchar* _tmp16_;
			RygelMediaExportMusicItem* _tmp17_;
			RygelMediaExportMusicItem* _tmp18_;
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) item) : NULL);
			music_item = _tmp10_;
			_tmp11_ = music_item;
			_tmp12_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
			rygel_media_object_set_artist ((RygelMediaObject*) _tmp11_, _tmp12_);
			_tmp13_ = music_item;
			_tmp14_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
			rygel_audio_item_set_album ((RygelAudioItem*) _tmp13_, _tmp14_);
			_tmp15_ = music_item;
			_tmp16_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
			rygel_media_object_set_genre ((RygelMediaObject*) _tmp15_, _tmp16_);
			_tmp17_ = music_item;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp17_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK));
			_tmp18_ = music_item;
			rygel_music_item_lookup_album_art ((RygelMusicItem*) _tmp18_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelVisualItem* _tmp19_;
		RygelVisualItem* _tmp20_;
		RygelVisualItem* _tmp21_;
		RygelVisualItem* _tmp22_;
		_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) item) : NULL);
		visual_item = _tmp19_;
		_tmp20_ = visual_item;
		rygel_visual_item_set_width (_tmp20_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH));
		_tmp21_ = visual_item;
		rygel_visual_item_set_height (_tmp21_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT));
		_tmp22_ = visual_item;
		rygel_visual_item_set_color_depth (_tmp22_, sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH));
		_g_object_unref0 (visual_item);
	}
}


static gchar*
rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression,
                                                            GValueArray* args,
                                                            const gchar* prefix,
                                                            GError** error)
{
	gchar* result = NULL;
	gchar* filter = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	if (expression == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = rygel_media_export_media_cache_search_expression_to_sql (expression, args, &_inner_error_);
	filter = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = filter;
	_tmp3_ = g_strdup_printf (" %s %s", prefix, _tmp2_);
	result = _tmp3_;
	_g_free0 (filter);
	return result;
}


static gchar*
rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression,
                                                         GValueArray* args,
                                                         GError** error)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	if (expression == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = rygel_media_export_media_cache_logical_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) expression) : NULL, args, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp1_);
		return result;
	} else {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = rygel_media_export_media_cache_relational_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (expression, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) expression) : NULL, args, &_inner_error_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		result = _tmp6_;
		_g_free0 (_tmp4_);
		return result;
	}
}


static gchar*
rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression,
                                                          GValueArray* args,
                                                          GError** error)
{
	gchar* result = NULL;
	gchar* left_sql_string = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_;
	gchar* right_sql_string = NULL;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	const gchar* operator_sql_string = NULL;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = ((RygelSearchExpression*) expression)->operand1;
	_tmp1_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp0_, args, &_inner_error_);
	left_sql_string = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = ((RygelSearchExpression*) expression)->operand2;
	_tmp3_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp2_, args, &_inner_error_);
	right_sql_string = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (left_sql_string);
		return NULL;
	}
	operator_sql_string = "OR";
	_tmp4_ = ((RygelSearchExpression*) expression)->op;
	if (((RygelLogicalOperator) ((gintptr) _tmp4_)) == RYGEL_LOGICAL_OPERATOR_AND) {
		operator_sql_string = "AND";
	}
	_tmp5_ = left_sql_string;
	_tmp6_ = operator_sql_string;
	_tmp7_ = right_sql_string;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp5_, _tmp6_, _tmp7_);
	result = _tmp8_;
	_g_free0 (right_sql_string);
	_g_free0 (left_sql_string);
	return result;
}


static gchar*
rygel_media_export_media_cache_map_operand_to_column (const gchar* operand,
                                                      gchar* * collate,
                                                      gboolean for_sort,
                                                      GError** error)
{
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column = NULL;
	gboolean use_collation = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	gboolean _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (operand != NULL, NULL);
	column = NULL;
	use_collation = FALSE;
	_tmp0_ = operand;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("res")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("o.uri");
				_g_free0 (column);
				column = _tmp3_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("res@duration")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("m.duration");
				_g_free0 (column);
				column = _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("o.upnp_id");
				_g_free0 (column);
				column = _tmp5_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("o.parent");
				_g_free0 (column);
				column = _tmp6_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("m.class");
				_g_free0 (column);
				column = _tmp7_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("o.title");
				_g_free0 (column);
				column = _tmp8_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("upnp:artist")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("upnp:author"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("m.author");
				_g_free0 (column);
				column = _tmp9_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("m.creator");
				_g_free0 (column);
				column = _tmp10_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				if (for_sort) {
					gchar* _tmp11_;
					_tmp11_ = g_strdup ("m.date");
					_g_free0 (column);
					column = _tmp11_;
				} else {
					gchar* _tmp12_;
					_tmp12_ = g_strdup ("strftime(\"%Y\", m.date)");
					_g_free0 (column);
					column = _tmp12_;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				_tmp13_ = g_strdup ("m.album");
				_g_free0 (column);
				column = _tmp13_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("upnp:genre")))) || (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("dc:genre"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("m.genre");
				_g_free0 (column);
				column = _tmp14_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				_tmp15_ = g_strdup ("m.track");
				_g_free0 (column);
				column = _tmp15_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("rygel:originalVolumeNumber")))) {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				_tmp16_ = g_strdup ("m.disc");
				_g_free0 (column);
				column = _tmp16_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_;
				_tmp17_ = g_strdup ("o.object_update_id");
				_g_free0 (column);
				column = _tmp17_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp18_;
				_tmp18_ = g_strdup ("o.container_update_id");
				_g_free0 (column);
				column = _tmp18_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* message = NULL;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				GError* _tmp21_;
				_tmp19_ = g_strdup_printf ("Unsupported column %s", operand);
				message = _tmp19_;
				_tmp20_ = message;
				_tmp21_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, _tmp20_);
				_inner_error_ = _tmp21_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	_tmp22_ = use_collation;
	if (_tmp22_) {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("COLLATE CASEFOLD");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp23_;
	} else {
		gchar* _tmp24_;
		_tmp24_ = g_strdup ("");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp24_;
	}
	result = column;
	if (collate) {
		*collate = _vala_collate;
	} else {
		_g_free0 (_vala_collate);
	}
	return result;
}


static gchar*
rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp,
                                                             GValueArray* args,
                                                             GError** error)
{
	gchar* result = NULL;
	GValue* v = NULL;
	gchar* collate = NULL;
	gchar* column = NULL;
	gconstpointer _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	RygelDatabaseSqlOperator* operator = NULL;
	gconstpointer _tmp3_;
	GValue* _tmp31_;
	RygelDatabaseSqlOperator* _tmp34_;
	gchar* _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	v = NULL;
	collate = NULL;
	_tmp0_ = ((RygelSearchExpression*) exp)->operand1;
	_tmp2_ = rygel_media_export_media_cache_map_operand_to_column ((const gchar*) _tmp0_, &_tmp1_, FALSE, &_inner_error_);
	_g_free0 (collate);
	collate = _tmp1_;
	column = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (collate);
		__vala_GValue_free0 (v);
		return NULL;
	}
	_tmp3_ = ((RygelSearchExpression*) exp)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp3_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gchar* sql_function = NULL;
			gconstpointer _tmp4_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp4_ = ((RygelSearchExpression*) exp)->operand2;
			if (g_strcmp0 ((const gchar*) _tmp4_, "true") == 0) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("%s IS NOT NULL AND %s != ''");
				_g_free0 (sql_function);
				sql_function = _tmp5_;
			} else {
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("%s IS NULL OR %s = ''");
				_g_free0 (sql_function);
				sql_function = _tmp6_;
			}
			_tmp7_ = sql_function;
			_tmp8_ = column;
			_tmp9_ = column;
			_tmp10_ = g_strdup_printf (_tmp7_, _tmp8_, _tmp9_);
			result = _tmp10_;
			_g_free0 (sql_function);
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			gconstpointer _tmp11_;
			GValue* _tmp12_ = NULL;
			gconstpointer _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			RygelDatabaseSqlOperator* _tmp16_;
			_tmp11_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp12_ = g_new0 (GValue, 1);
			g_value_init (_tmp12_, G_TYPE_STRING);
			g_value_set_string (_tmp12_, (const gchar*) _tmp11_);
			__vala_GValue_free0 (v);
			v = _tmp12_;
			_tmp13_ = ((RygelSearchExpression*) exp)->op;
			_tmp14_ = column;
			_tmp15_ = collate;
			_tmp16_ = rygel_database_sql_operator_new_from_search_criteria_op ((GUPnPSearchCriteriaOp) ((gintptr) _tmp13_), _tmp14_, _tmp15_);
			_g_object_unref0 (operator);
			operator = _tmp16_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp17_;
			RygelDatabaseSqlFunction* _tmp18_;
			gconstpointer _tmp19_;
			GValue* _tmp20_ = NULL;
			_tmp17_ = column;
			_tmp18_ = rygel_database_sql_function_new ("contains", _tmp17_);
			_g_object_unref0 (operator);
			operator = (RygelDatabaseSqlOperator*) _tmp18_;
			_tmp19_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp20_ = g_new0 (GValue, 1);
			g_value_init (_tmp20_, G_TYPE_STRING);
			g_value_set_string (_tmp20_, (const gchar*) _tmp19_);
			__vala_GValue_free0 (v);
			v = _tmp20_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			const gchar* _tmp21_;
			RygelDatabaseSqlFunction* _tmp22_;
			gconstpointer _tmp23_;
			GValue* _tmp24_ = NULL;
			_tmp21_ = column;
			_tmp22_ = rygel_database_sql_function_new ("NOT contains", _tmp21_);
			_g_object_unref0 (operator);
			operator = (RygelDatabaseSqlOperator*) _tmp22_;
			_tmp23_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp24_ = g_new0 (GValue, 1);
			g_value_init (_tmp24_, G_TYPE_STRING);
			g_value_set_string (_tmp24_, (const gchar*) _tmp23_);
			__vala_GValue_free0 (v);
			v = _tmp24_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			const gchar* _tmp25_;
			RygelDatabaseSqlOperator* _tmp26_;
			gconstpointer _tmp27_;
			gchar* _tmp28_;
			GValue* _tmp29_ = NULL;
			_tmp25_ = column;
			_tmp26_ = rygel_database_sql_operator_new ("LIKE", _tmp25_, "");
			_g_object_unref0 (operator);
			operator = _tmp26_;
			_tmp27_ = ((RygelSearchExpression*) exp)->operand2;
			_tmp28_ = g_strdup_printf ("%s%%", (const gchar*) _tmp27_);
			_tmp29_ = g_new0 (GValue, 1);
			g_value_init (_tmp29_, G_TYPE_STRING);
			g_value_take_string (_tmp29_, _tmp28_);
			__vala_GValue_free0 (v);
			v = _tmp29_;
			break;
		}
		default:
		{
			gconstpointer _tmp30_;
			_tmp30_ = ((RygelSearchExpression*) exp)->op;
			g_debug ("rygel-media-export-media-cache.vala:1182: Unsupported search criteria " \
"op %d", (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp30_)));
			result = NULL;
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
	}
	_tmp31_ = v;
	if (_tmp31_ != NULL) {
		GValue* _tmp32_;
		GValue _tmp33_;
		_tmp32_ = v;
		_tmp33_ = *_tmp32_;
		g_value_array_append (args, &_tmp33_);
	}
	_tmp34_ = operator;
	_tmp35_ = rygel_database_sql_operator_to_string (_tmp34_);
	result = _tmp35_;
	_g_object_unref0 (operator);
	_g_free0 (column);
	_g_free0 (collate);
	__vala_GValue_free0 (v);
	return result;
}


static RygelDatabaseCursor*
rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self,
                                            RygelMediaExportSQLString id,
                                            GValue* values,
                                            int values_length1,
                                            GError** error)
{
	RygelDatabaseCursor* result = NULL;
	RygelDatabaseCursor* _tmp0_ = NULL;
	RygelDatabaseDatabase* _tmp1_;
	RygelMediaExportSQLFactory* _tmp2_;
	const gchar* _tmp3_;
	RygelDatabaseCursor* _tmp4_;
	RygelDatabaseCursor* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->db;
	_tmp2_ = self->priv->sql;
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, id);
	_tmp4_ = rygel_database_database_exec_cursor (_tmp1_, _tmp3_, values, values_length1, &_inner_error_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}


static gint
rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self,
                                            RygelMediaExportSQLString id,
                                            GValue* values,
                                            int values_length1,
                                            GError** error)
{
	gint result = 0;
	gint _tmp0_ = 0;
	RygelDatabaseDatabase* _tmp1_;
	RygelMediaExportSQLFactory* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->db;
	_tmp2_ = self->priv->sql;
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, id);
	_tmp0_ = rygel_database_database_query_value (_tmp1_, _tmp3_, values, values_length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gint _tmp4_ = -1;
			g_propagate_error (error, _inner_error_);
			return _tmp4_;
		} else {
			gint _tmp5_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp5_;
		}
	}
	result = _tmp0_;
	return result;
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gchar*
rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria,
                                                        gchar* * extra_columns,
                                                        gint* column_count)
{
	gchar* _vala_extra_columns = NULL;
	gint _vala_column_count = 0;
	gchar* result = NULL;
	gchar* collate = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* column_builder = NULL;
	GString* _tmp1_;
	gchar** fields = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint fields_length1;
	gint _fields_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_string_new ("ORDER BY ");
	builder = _tmp0_;
	_tmp1_ = g_string_new ("");
	column_builder = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (sort_criteria, ",", 0);
	fields = _tmp3_;
	fields_length1 = _vala_array_length (_tmp2_);
	_fields_size_ = fields_length1;
	_tmp4_ = fields;
	_tmp4__length1 = fields_length1;
	_vala_column_count = _tmp4__length1;
	_tmp5_ = fields;
	_tmp5__length1 = fields_length1;
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = _tmp5_;
		field_collection_length1 = _tmp5__length1;
		for (field_it = 0; field_it < _tmp5__length1; field_it = field_it + 1) {
			const gchar* field = NULL;
			field = field_collection[field_it];
			{
				{
					gchar* column = NULL;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar** _tmp16_;
					gint _tmp16__length1;
					const gchar* _tmp17_;
					GString* _tmp19_;
					const gchar* _tmp20_ = NULL;
					const gchar* _tmp21_;
					GString* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					GString* _tmp25_;
					const gchar* _tmp26_;
					_tmp6_ = field;
					_tmp7_ = field;
					_tmp8_ = strlen (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = string_slice (_tmp6_, (glong) 1, (glong) _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp13_ = rygel_media_export_media_cache_map_operand_to_column (_tmp11_, &_tmp12_, TRUE, &_inner_error_);
					_g_free0 (collate);
					collate = _tmp12_;
					_tmp14_ = _tmp13_;
					_g_free0 (_tmp11_);
					column = _tmp14_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch21_g_error;
					}
					_tmp15_ = field;
					_tmp16_ = fields;
					_tmp16__length1 = fields_length1;
					_tmp17_ = _tmp16_[0];
					if (g_strcmp0 (_tmp15_, _tmp17_) != 0) {
						GString* _tmp18_;
						_tmp18_ = builder;
						g_string_append (_tmp18_, ",");
					}
					_tmp19_ = column_builder;
					g_string_append (_tmp19_, ",");
					_tmp21_ = field;
					if (string_get (_tmp21_, (glong) 0) == '-') {
						_tmp20_ = "DESC";
					} else {
						_tmp20_ = "ASC";
					}
					_tmp22_ = builder;
					_tmp23_ = column;
					_tmp24_ = collate;
					g_string_append_printf (_tmp22_, "%s %s %s ", _tmp23_, _tmp24_, _tmp20_);
					_tmp25_ = column_builder;
					_tmp26_ = column;
					g_string_append (_tmp25_, _tmp26_);
					_g_free0 (column);
				}
				goto __finally21;
				__catch21_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp27_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_tmp27_ = field;
					g_warning (_ ("Skipping unsupported sort field: %s"), _tmp27_);
					_g_error_free0 (_error_);
				}
				__finally21:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
					_g_string_free0 (column_builder);
					_g_string_free0 (builder);
					_g_free0 (collate);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp28_ = column_builder;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	_g_free0 (_vala_extra_columns);
	_vala_extra_columns = _tmp30_;
	_tmp31_ = builder;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (column_builder);
	_g_string_free0 (builder);
	_g_free0 (collate);
	if (extra_columns) {
		*extra_columns = _vala_extra_columns;
	} else {
		_g_free0 (_vala_extra_columns);
	}
	if (column_count) {
		*column_count = _vala_column_count;
	}
	return result;
}


static void
rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass)
{
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
}


static void
rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self)
{
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
}


static void
rygel_media_export_media_cache_finalize (GObject * obj)
{
	RygelMediaExportMediaCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->sql);
	_g_object_unref0 (self->priv->exists_cache);
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
}


/**
 * Persistent storage of media objects.
 *
 * MediaExportDB is a sqlite3 backed persistent storage of media objects.
 */
GType
rygel_media_export_media_cache_get_type (void)
{
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



