/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef NUVIE_SOUND_SFX_H
#define NUVIE_SOUND_SFX_H

namespace Ultima {
namespace Nuvie {

typedef uint16 SfxIdType;

#define NUVIE_SFX_NONE 65535

#define NUVIE_SFX_BLOCKED 0
#define NUVIE_SFX_HIT 1
#define NUVIE_SFX_FOUNTAIN 2
#define NUVIE_SFX_DEATH 3
#define NUVIE_SFX_RUBBER_DUCK 4
#define NUVIE_SFX_BROKEN_GLASS 5
#define NUVIE_SFX_BELL 6
#define NUVIE_SFX_FIRE 7
#define NUVIE_SFX_CLOCK 8
#define NUVIE_SFX_PROTECTION_FIELD 9
#define NUVIE_SFX_WATER_WHEEL 10
#define NUVIE_SFX_MISSLE 11
#define NUVIE_SFX_EXPLOSION 12
#define NUVIE_SFX_ATTACK_SWING 13
#define NUVIE_SFX_SUCCESS 14
#define NUVIE_SFX_FAILURE 15
#define NUVIE_SFX_CORPSER_DRAGGED_UNDER 16
#define NUVIE_SFX_CORPSER_REGURGITATE 17
#define NUVIE_SFX_CASTING_MAGIC_P1 18
#define NUVIE_SFX_CASTING_MAGIC_P1_2 19
#define NUVIE_SFX_CASTING_MAGIC_P1_3 20
#define NUVIE_SFX_CASTING_MAGIC_P1_4 21
#define NUVIE_SFX_CASTING_MAGIC_P1_5 22
#define NUVIE_SFX_CASTING_MAGIC_P1_6 23
#define NUVIE_SFX_CASTING_MAGIC_P1_7 24
#define NUVIE_SFX_CASTING_MAGIC_P1_8 25

#define NUVIE_SFX_CASTING_MAGIC_P2 26
#define NUVIE_SFX_CASTING_MAGIC_P2_2 27
#define NUVIE_SFX_CASTING_MAGIC_P2_3 28
#define NUVIE_SFX_CASTING_MAGIC_P2_4 29
#define NUVIE_SFX_CASTING_MAGIC_P2_5 30
#define NUVIE_SFX_CASTING_MAGIC_P2_6 31
#define NUVIE_SFX_CASTING_MAGIC_P2_7 32
#define NUVIE_SFX_CASTING_MAGIC_P2_8 33

#define NUVIE_SFX_AVATAR_DEATH 34
#define NUVIE_SFX_KAL_LOR 35
#define NUVIE_SFX_SLUG_DISSOLVE 36
#define NUVIE_SFX_HAIL_STONE 37

#define NUVIE_SFX_SE_TICK 38

#define NUVIE_SFX_EARTH_QUAKE 39

} // End of namespace Nuvie
} // End of namespace Ultima

#endif
