-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.Walk_Expression_P)
procedure Wf_Attribute (E_Stack : in out Exp_Stack.Exp_Stack_Type) is
   Result : Sem.Exp_Record;
begin
   Exp_Stack.Pop (Item  => Result,
                  Stack => E_Stack); -- this is type of entire attribute expression
   if Result.Sort /= Sem.Type_Result then
      Result := Sem.Unknown_Type_Record;
   end if;
   Exp_Stack.Push (X     => Result,
                   Stack => E_Stack);
end Wf_Attribute;
