/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _ASSERTIONTRAIT_QVARIANT_H
#define _ASSERTIONTRAIT_QVARIANT_H

// sc
#include "util/uuid.h"
#include "util/String.h"

// qt
#include <QtCore/QVariant>


/** This adds QVariant support to CPPUNIT_ASSERT_EQUALS. */
template<> struct CPPUNIT_NS::assertion_traits<QVariant>
{
  static bool equal( const QVariant& x, const QVariant& y )
  {
    return x == y;
  }

  static std::string toString( const QVariant& x )
  {
    OStringStream ost;
    ost << "\"";
    if(x.isValid()){
      ost << (const char*)x.toString().toAscii();
    }
    else {
      ost << "<invalid>";
    }
    ost << "\"";
    return ost.str();
  }
};


#endif // _ASSERTIONTRAIT_QVARIANT_H
