/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _SWAC_DB_HH
#define _SWAC_DB_HH


#include "db.hh"
#include <list>


typedef std::list<std::string> tconsts;
typedef std::list<tconsts::iterator> tgroups;

struct Tswac_db {
private:
	bool db_init_sounds();
	bool db_init_languages();

protected:
	tsqlite db;
	bool check_field(char const *str);

public:
 	bool db_open(char const *path);
 	bool db_close();
	void db_clear();
	bool db_init();
};

#endif

