
//
// gSWF.h
//
// This file is generated by codegen/header.xsl
// DO NOT MODIFY
//


#ifndef SWF_H
#define SWF_H

#include <cinttypes>
#include <cstdint>
#include <SWFReader.h>
#include <SWFTag.h>
#include <SWFAction.h>
#include <SWFFilter.h>
#include <SWFTrait.h>
#include <SWFList.h>
#include <SWFShapeItem.h>
#include <SWFGlyphList.h>
#include <SWFIdItems.h>
#include <SWFOpCode.h>

namespace SWF {

struct Context {
	public:
		Context();
	
		int swfVersion;
		bool transientPropsToXML;
		bool debugTrace;
		bool exportAssets;
		bool quiet;
		
		bool isLast;
		char tagVersion;
		bool alpha;
		bool many_shapes;

		bool convertEncoding;
		const char *swf_encoding;
		
		std::int32_t fillBits;
		std::int32_t lineBits;
		std::uint8_t glyphBits;
		std::uint8_t advanceBits;
		bool wideGlyphOffsets;
		bool wideMap;
		std::uint16_t glyphCount;
		
};


class Rectangle : public Item {
	public:
		Rectangle();
		virtual ~Rectangle();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Rectangle* get( Reader *r, int end, Context *ctx );
		static Rectangle* getByName( const char *name );

		std::int32_t getbits();
			void setbits( std::int32_t );
	std::int32_t getleft();
			void setleft( std::int32_t );
	std::int32_t getright();
			void setright( std::int32_t );
	std::int32_t gettop();
			void settop( std::int32_t );
	std::int32_t getbottom();
			void setbottom( std::int32_t );
	

	protected:
		std::int32_t bits; // integer
std::int32_t left; // integer
std::int32_t right; // integer
std::int32_t top; // integer
std::int32_t bottom; // integer

};

class Color : public Item {
	public:
		Color();
		virtual ~Color();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Color* get( Reader *r, int end, Context *ctx );
		static Color* getByName( const char *name );

		std::uint8_t getred();
			void setred( std::uint8_t );
	std::uint8_t getgreen();
			void setgreen( std::uint8_t );
	std::uint8_t getblue();
			void setblue( std::uint8_t );
	std::uint8_t getalpha();
			void setalpha( std::uint8_t );
	

	protected:
		std::uint8_t red; // byte
std::uint8_t green; // byte
std::uint8_t blue; // byte
std::uint8_t alpha; // byte

};

class String : public Item {
	public:
		String();
		virtual ~String();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static String* get( Reader *r, int end, Context *ctx );
		static String* getByName( const char *name );

		char * getvalue();
			void setvalue( char * );
	

	protected:
		char * value; // string

};

class String2 : public Item {
	public:
		String2();
		virtual ~String2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static String2* get( Reader *r, int end, Context *ctx );
		static String2* getByName( const char *name );

		char * getvalue();
			void setvalue( char * );
	

	protected:
		char * value; // string

};

class Transform : public Item {
	public:
		Transform();
		virtual ~Transform();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Transform* get( Reader *r, int end, Context *ctx );
		static Transform* getByName( const char *name );

		bool getscaled();
			void setscaled( bool );
	std::int32_t getbitsScale();
			void setbitsScale( std::int32_t );
	float getscaleX();
			void setscaleX( float );
	float getscaleY();
			void setscaleY( float );
	bool getskewed();
			void setskewed( bool );
	std::int32_t getbitsSkew();
			void setbitsSkew( std::int32_t );
	float getskewX();
			void setskewX( float );
	float getskewY();
			void setskewY( float );
	std::int32_t getbitsTranslate();
			void setbitsTranslate( std::int32_t );
	std::int32_t gettransX();
			void settransX( std::int32_t );
	std::int32_t gettransY();
			void settransY( std::int32_t );
	

	protected:
		bool scaled; // bit
std::int32_t bitsScale; // integer
float scaleX; // fixedpoint
float scaleY; // fixedpoint
bool skewed; // bit
std::int32_t bitsSkew; // integer
float skewX; // fixedpoint
float skewY; // fixedpoint
std::int32_t bitsTranslate; // integer
std::int32_t transX; // integer
std::int32_t transY; // integer

};

class ColorTransform2 : public Item {
	public:
		ColorTransform2();
		virtual ~ColorTransform2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ColorTransform2* get( Reader *r, int end, Context *ctx );
		static ColorTransform2* getByName( const char *name );

		bool gethasOffset();
			void sethasOffset( bool );
	bool gethasFactor();
			void sethasFactor( bool );
	std::int32_t getbits();
			void setbits( std::int32_t );
	std::int32_t getfactorRed();
			void setfactorRed( std::int32_t );
	std::int32_t getfactorGreen();
			void setfactorGreen( std::int32_t );
	std::int32_t getfactorBlue();
			void setfactorBlue( std::int32_t );
	std::int32_t getfactorAlpha();
			void setfactorAlpha( std::int32_t );
	std::int32_t getoffsetRed();
			void setoffsetRed( std::int32_t );
	std::int32_t getoffsetGreen();
			void setoffsetGreen( std::int32_t );
	std::int32_t getoffsetBlue();
			void setoffsetBlue( std::int32_t );
	std::int32_t getoffsetAlpha();
			void setoffsetAlpha( std::int32_t );
	

	protected:
		bool hasOffset; // bit
bool hasFactor; // bit
std::int32_t bits; // integer
std::int32_t factorRed; // integer
std::int32_t factorGreen; // integer
std::int32_t factorBlue; // integer
std::int32_t factorAlpha; // integer
std::int32_t offsetRed; // integer
std::int32_t offsetGreen; // integer
std::int32_t offsetBlue; // integer
std::int32_t offsetAlpha; // integer

};

class Header : public Item {
	public:
		Header();
		virtual ~Header();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Header* get( Reader *r, int end, Context *ctx );
		static Header* getByName( const char *name );

		Rectangle *getsize();
	std::int32_t getframerate();
			void setframerate( std::int32_t );
	std::uint16_t getframes();
			void setframes( std::uint16_t );
	List<Tag> *gettags();
	

	protected:
		Rectangle size; // object
std::int32_t framerate; // integer
std::uint16_t frames; // word
List<Tag> tags; // list

};

class LineStyle : public Item {
	public:
		LineStyle();
		virtual ~LineStyle();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LineStyle* get( Reader *r, int end, Context *ctx );
		static LineStyle* getByName( const char *name );

		std::uint16_t getwidth();
			void setwidth( std::uint16_t );
	Color *getcolor();
	std::int32_t getstartCapStyle();
			void setstartCapStyle( std::int32_t );
	std::int32_t getjointStyle();
			void setjointStyle( std::int32_t );
	bool gethasFill();
			void sethasFill( bool );
	bool getnoHScale();
			void setnoHScale( bool );
	bool getnoVScale();
			void setnoVScale( bool );
	bool getpixelHinting();
			void setpixelHinting( bool );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getnoClose();
			void setnoClose( bool );
	std::int32_t getendCapStyle();
			void setendCapStyle( std::int32_t );
	float getmiterLimitFactor();
			void setmiterLimitFactor( float );
	List<Style> *getfillStyles();
	Color *getfillColor();
	

	protected:
		std::uint16_t width; // word
Color color; // object
std::int32_t startCapStyle; // integer
std::int32_t jointStyle; // integer
bool hasFill; // bit
bool noHScale; // bit
bool noVScale; // bit
bool pixelHinting; // bit
std::int32_t reserved; // integer
bool noClose; // bit
std::int32_t endCapStyle; // integer
float miterLimitFactor; // fixedpoint2
List<Style> fillStyles; // list
Color fillColor; // object

};

class StyleList : public Item {
	public:
		StyleList();
		virtual ~StyleList();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StyleList* get( Reader *r, int end, Context *ctx );
		static StyleList* getByName( const char *name );

		std::uint16_t getn_fillStyles();
			void setn_fillStyles( std::uint16_t );
	List<Style> *getfillStyles();
	std::uint16_t getn_lineStyles();
			void setn_lineStyles( std::uint16_t );
	List<LineStyle> *getlineStyles();
	std::int32_t getfillBits();
			void setfillBits( std::int32_t );
	std::int32_t getlineBits();
			void setlineBits( std::int32_t );
	

	protected:
		std::uint16_t n_fillStyles; // byteOrWord
List<Style> fillStyles; // list
std::uint16_t n_lineStyles; // byteOrWord
List<LineStyle> lineStyles; // list
std::int32_t fillBits; // integer
std::int32_t lineBits; // integer

};

class ShapeSetup : public ShapeItem {
	public:
		ShapeSetup();
		virtual ~ShapeSetup();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShapeSetup* get( Reader *r, int end, Context *ctx );
		static ShapeSetup* getByName( const char *name );

		bool gethasNewStyles();
			void sethasNewStyles( bool );
	bool gethasLineStyle();
			void sethasLineStyle( bool );
	bool gethasFillStyle1();
			void sethasFillStyle1( bool );
	bool gethasFillStyle0();
			void sethasFillStyle0( bool );
	bool gethasMoveTo();
			void sethasMoveTo( bool );
	std::int32_t getxybits();
			void setxybits( std::int32_t );
	std::int32_t getx();
			void setx( std::int32_t );
	std::int32_t gety();
			void sety( std::int32_t );
	std::int32_t getfillStyle0();
			void setfillStyle0( std::int32_t );
	std::int32_t getfillStyle1();
			void setfillStyle1( std::int32_t );
	std::int32_t getlineStyle();
			void setlineStyle( std::int32_t );
	StyleList *getstyles();
	

	protected:
		bool hasNewStyles; // bit
bool hasLineStyle; // bit
bool hasFillStyle1; // bit
bool hasFillStyle0; // bit
bool hasMoveTo; // bit
std::int32_t xybits; // integer
std::int32_t x; // integer
std::int32_t y; // integer
std::int32_t fillStyle0; // integer
std::int32_t fillStyle1; // integer
std::int32_t lineStyle; // integer
StyleList styles; // object

};

class CurveTo : public ShapeItem {
	public:
		CurveTo();
		virtual ~CurveTo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CurveTo* get( Reader *r, int end, Context *ctx );
		static CurveTo* getByName( const char *name );

		std::int32_t getbits();
			void setbits( std::int32_t );
	std::int32_t getx1();
			void setx1( std::int32_t );
	std::int32_t gety1();
			void sety1( std::int32_t );
	std::int32_t getx2();
			void setx2( std::int32_t );
	std::int32_t gety2();
			void sety2( std::int32_t );
	

	protected:
		std::int32_t bits; // integer
std::int32_t x1; // integer
std::int32_t y1; // integer
std::int32_t x2; // integer
std::int32_t y2; // integer

};

class Shape : public Item {
	public:
		Shape();
		virtual ~Shape();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Shape* get( Reader *r, int end, Context *ctx );
		static Shape* getByName( const char *name );

		List<ShapeItem> *getedges();
	

	protected:
		List<ShapeItem> edges; // list

};

class GlyphShape : public Item {
	public:
		GlyphShape();
		virtual ~GlyphShape();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GlyphShape* get( Reader *r, int end, Context *ctx );
		static GlyphShape* getByName( const char *name );

		std::int32_t getfillBits();
			void setfillBits( std::int32_t );
	std::int32_t getlineBits();
			void setlineBits( std::int32_t );
	List<ShapeItem> *getedges();
	

	protected:
		std::int32_t fillBits; // integer
std::int32_t lineBits; // integer
List<ShapeItem> edges; // list

};

class GradientItem : public Item {
	public:
		GradientItem();
		virtual ~GradientItem();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GradientItem* get( Reader *r, int end, Context *ctx );
		static GradientItem* getByName( const char *name );

		std::uint8_t getposition();
			void setposition( std::uint8_t );
	Color *getcolor();
	

	protected:
		std::uint8_t position; // byte
Color color; // object

};

class Symbol : public Item {
	public:
		Symbol();
		virtual ~Symbol();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Symbol* get( Reader *r, int end, Context *ctx );
		static Symbol* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	char * getname();
			void setname( char * );
	

	protected:
		std::uint16_t objectID; // word
char * name; // string

};

class Frame : public Item {
	public:
		Frame();
		virtual ~Frame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Frame* get( Reader *r, int end, Context *ctx );
		static Frame* getByName( const char *name );

		std::uint32_t getnumber();
			void setnumber( std::uint32_t );
	char * getlabel();
			void setlabel( char * );
	

	protected:
		std::uint32_t number; // encodedu32
char * label; // string

};

class Scene : public Item {
	public:
		Scene();
		virtual ~Scene();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Scene* get( Reader *r, int end, Context *ctx );
		static Scene* getByName( const char *name );

		std::uint32_t getoffset();
			void setoffset( std::uint32_t );
	char * getname();
			void setname( char * );
	

	protected:
		std::uint32_t offset; // encodedu32
char * name; // string

};

class Parameter : public Item {
	public:
		Parameter();
		virtual ~Parameter();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Parameter* get( Reader *r, int end, Context *ctx );
		static Parameter* getByName( const char *name );

		std::uint8_t getreg();
			void setreg( std::uint8_t );
	char * getname();
			void setname( char * );
	

	protected:
		std::uint8_t reg; // byte
char * name; // string

};

class UChar : public Item {
	public:
		UChar();
		virtual ~UChar();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UChar* get( Reader *r, int end, Context *ctx );
		static UChar* getByName( const char *name );

		std::uint8_t getvalue();
			void setvalue( std::uint8_t );
	

	protected:
		std::uint8_t value; // byte

};

class UShort : public Item {
	public:
		UShort();
		virtual ~UShort();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UShort* get( Reader *r, int end, Context *ctx );
		static UShort* getByName( const char *name );

		std::uint16_t getvalue();
			void setvalue( std::uint16_t );
	

	protected:
		std::uint16_t value; // word

};

class ULong : public Item {
	public:
		ULong();
		virtual ~ULong();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ULong* get( Reader *r, int end, Context *ctx );
		static ULong* getByName( const char *name );

		std::int32_t getvalue();
			void setvalue( std::int32_t );
	

	protected:
		std::int32_t value; // integer

};

class Short : public Item {
	public:
		Short();
		virtual ~Short();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Short* get( Reader *r, int end, Context *ctx );
		static Short* getByName( const char *name );

		std::uint16_t getvalue();
			void setvalue( std::uint16_t );
	

	protected:
		std::uint16_t value; // word

};

class Float : public Item {
	public:
		Float();
		virtual ~Float();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Float* get( Reader *r, int end, Context *ctx );
		static Float* getByName( const char *name );

		float getvalue();
			void setvalue( float );
	

	protected:
		float value; // float

};

class Double : public Item {
	public:
		Double();
		virtual ~Double();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Double* get( Reader *r, int end, Context *ctx );
		static Double* getByName( const char *name );

		double getvalue();
			void setvalue( double );
	

	protected:
		double value; // double

};

class Kerning : public Item {
	public:
		Kerning();
		virtual ~Kerning();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Kerning* get( Reader *r, int end, Context *ctx );
		static Kerning* getByName( const char *name );

		std::uint8_t geta();
			void seta( std::uint8_t );
	std::uint8_t getb();
			void setb( std::uint8_t );
	std::int32_t getadjustment();
			void setadjustment( std::int32_t );
	

	protected:
		std::uint8_t a; // byte
std::uint8_t b; // byte
std::int32_t adjustment; // integer

};

class WideKerning : public Item {
	public:
		WideKerning();
		virtual ~WideKerning();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static WideKerning* get( Reader *r, int end, Context *ctx );
		static WideKerning* getByName( const char *name );

		std::uint16_t geta();
			void seta( std::uint16_t );
	std::uint16_t getb();
			void setb( std::uint16_t );
	std::uint16_t getadjustment();
			void setadjustment( std::uint16_t );
	

	protected:
		std::uint16_t a; // word
std::uint16_t b; // word
std::uint16_t adjustment; // word

};

class TextEntry : public Item {
	public:
		TextEntry();
		virtual ~TextEntry();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextEntry* get( Reader *r, int end, Context *ctx );
		static TextEntry* getByName( const char *name );

		std::int32_t getglyph();
			void setglyph( std::int32_t );
	std::int32_t getadvance();
			void setadvance( std::int32_t );
	

	protected:
		std::int32_t glyph; // integer
std::int32_t advance; // integer

};

class TextEntry2 : public Item {
	public:
		TextEntry2();
		virtual ~TextEntry2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextEntry2* get( Reader *r, int end, Context *ctx );
		static TextEntry2* getByName( const char *name );

		std::int32_t getglyph();
			void setglyph( std::int32_t );
	std::int32_t getadvance();
			void setadvance( std::int32_t );
	

	protected:
		std::int32_t glyph; // integer
std::int32_t advance; // integer

};

class TextRecord6 : public Item {
	public:
		TextRecord6();
		virtual ~TextRecord6();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord6* get( Reader *r, int end, Context *ctx );
		static TextRecord6* getByName( const char *name );

		bool getisSetup();
			void setisSetup( bool );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool gethasFont();
			void sethasFont( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMoveY();
			void sethasMoveY( bool );
	bool gethasMoveX();
			void sethasMoveX( bool );
	std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Color *getcolor();
	std::uint16_t getx();
			void setx( std::uint16_t );
	std::uint16_t gety();
			void sety( std::uint16_t );
	std::uint16_t getfontHeight();
			void setfontHeight( std::uint16_t );
	std::int32_t getnGlyphs();
			void setnGlyphs( std::int32_t );
	List<TextEntry> *getglyphs();
	

	protected:
		bool isSetup; // bit
std::int32_t reserved; // integer
bool hasFont; // bit
bool hasColor; // bit
bool hasMoveY; // bit
bool hasMoveX; // bit
std::uint16_t objectID; // word
Color color; // object
std::uint16_t x; // word
std::uint16_t y; // word
std::uint16_t fontHeight; // word
std::int32_t nGlyphs; // integer
List<TextEntry> glyphs; // list

};

class TextRecord62 : public Item {
	public:
		TextRecord62();
		virtual ~TextRecord62();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord62* get( Reader *r, int end, Context *ctx );
		static TextRecord62* getByName( const char *name );

		bool getisSetup();
			void setisSetup( bool );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool gethasFont();
			void sethasFont( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMoveY();
			void sethasMoveY( bool );
	bool gethasMoveX();
			void sethasMoveX( bool );
	std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Color *getcolor();
	std::uint16_t getx();
			void setx( std::uint16_t );
	std::uint16_t gety();
			void sety( std::uint16_t );
	std::uint16_t getfontHeight();
			void setfontHeight( std::uint16_t );
	std::int32_t getnGlyphs();
			void setnGlyphs( std::int32_t );
	List<TextEntry2> *getglyphs();
	

	protected:
		bool isSetup; // bit
std::int32_t reserved; // integer
bool hasFont; // bit
bool hasColor; // bit
bool hasMoveY; // bit
bool hasMoveX; // bit
std::uint16_t objectID; // word
Color color; // object
std::uint16_t x; // word
std::uint16_t y; // word
std::uint16_t fontHeight; // word
std::int32_t nGlyphs; // integer
List<TextEntry2> glyphs; // list

};

class TextRecord7 : public Item {
	public:
		TextRecord7();
		virtual ~TextRecord7();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord7* get( Reader *r, int end, Context *ctx );
		static TextRecord7* getByName( const char *name );

		bool getisSetup();
			void setisSetup( bool );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool gethasFont();
			void sethasFont( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMoveY();
			void sethasMoveY( bool );
	bool gethasMoveX();
			void sethasMoveX( bool );
	std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Color *getcolor();
	std::uint16_t getx();
			void setx( std::uint16_t );
	std::uint16_t gety();
			void sety( std::uint16_t );
	std::uint16_t getfontHeight();
			void setfontHeight( std::uint16_t );
	std::uint8_t getnGlyphs();
			void setnGlyphs( std::uint8_t );
	List<TextEntry> *getglyphs();
	

	protected:
		bool isSetup; // bit
std::int32_t reserved; // integer
bool hasFont; // bit
bool hasColor; // bit
bool hasMoveY; // bit
bool hasMoveX; // bit
std::uint16_t objectID; // word
Color color; // object
std::uint16_t x; // word
std::uint16_t y; // word
std::uint16_t fontHeight; // word
std::uint8_t nGlyphs; // byte
List<TextEntry> glyphs; // list

};

class TextRecord72 : public Item {
	public:
		TextRecord72();
		virtual ~TextRecord72();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord72* get( Reader *r, int end, Context *ctx );
		static TextRecord72* getByName( const char *name );

		bool getisSetup();
			void setisSetup( bool );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool gethasFont();
			void sethasFont( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMoveY();
			void sethasMoveY( bool );
	bool gethasMoveX();
			void sethasMoveX( bool );
	std::uint16_t getfontRef();
			void setfontRef( std::uint16_t );
	Color *getcolor();
	std::uint16_t getx();
			void setx( std::uint16_t );
	std::uint16_t gety();
			void sety( std::uint16_t );
	std::uint16_t getfontHeight();
			void setfontHeight( std::uint16_t );
	std::uint8_t getnGlyphs();
			void setnGlyphs( std::uint8_t );
	List<TextEntry2> *getglyphs();
	

	protected:
		bool isSetup; // bit
std::int32_t reserved; // integer
bool hasFont; // bit
bool hasColor; // bit
bool hasMoveY; // bit
bool hasMoveX; // bit
std::uint16_t fontRef; // word
Color color; // object
std::uint16_t x; // word
std::uint16_t y; // word
std::uint16_t fontHeight; // word
std::uint8_t nGlyphs; // byte
List<TextEntry2> glyphs; // list

};

class TextRecord : public Item {
	public:
		TextRecord();
		virtual ~TextRecord();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord* get( Reader *r, int end, Context *ctx );
		static TextRecord* getByName( const char *name );

		List<TextRecord6> *getrecords();
	TextRecord7 *getstring();
	

	protected:
		List<TextRecord6> records; // list
TextRecord7 string; // object

};

class TextRecord2 : public Item {
	public:
		TextRecord2();
		virtual ~TextRecord2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord2* get( Reader *r, int end, Context *ctx );
		static TextRecord2* getByName( const char *name );

		List<TextRecord62> *getrecords();
	TextRecord72 *gettextString();
	

	protected:
		List<TextRecord62> records; // list
TextRecord72 textString; // object

};

class Button : public Item {
	public:
		Button();
		virtual ~Button();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Button* get( Reader *r, int end, Context *ctx );
		static Button* getByName( const char *name );

		std::int32_t getreserved1();
			void setreserved1( std::int32_t );
	std::int32_t getreserved2();
			void setreserved2( std::int32_t );
	bool gethasBlendMode();
			void sethasBlendMode( bool );
	bool gethasFilterList();
			void sethasFilterList( bool );
	bool gethitTest();
			void sethitTest( bool );
	bool getdown();
			void setdown( bool );
	bool getover();
			void setover( bool );
	bool getup();
			void setup( bool );
	std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint16_t getdepth();
			void setdepth( std::uint16_t );
	Transform *gettransform();
	ColorTransform2 *getcolorTransform();
	std::uint8_t getnumFilters();
			void setnumFilters( std::uint8_t );
	List<Filter> *getfilters();
	std::uint8_t getblendMode();
			void setblendMode( std::uint8_t );
	

	protected:
		std::int32_t reserved1; // integer
std::int32_t reserved2; // integer
bool hasBlendMode; // bit
bool hasFilterList; // bit
bool hitTest; // bit
bool down; // bit
bool over; // bit
bool up; // bit
std::uint16_t objectID; // word
std::uint16_t depth; // word
Transform transform; // object
ColorTransform2 colorTransform; // object
std::uint8_t numFilters; // byte
List<Filter> filters; // list
std::uint8_t blendMode; // byte

};

class Event : public Item {
	public:
		Event();
		virtual ~Event();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Event* get( Reader *r, int end, Context *ctx );
		static Event* getByName( const char *name );

		std::uint16_t getflags1();
			void setflags1( std::uint16_t );
	std::uint16_t getflags2();
			void setflags2( std::uint16_t );
	std::uint32_t getactionLength();
			void setactionLength( std::uint32_t );
	List<Action> *getactions();
	

	protected:
		std::uint16_t flags1; // word
std::uint16_t flags2; // word
std::uint32_t actionLength; // uint32
List<Action> actions; // list

};

class Condition : public Item {
	public:
		Condition();
		virtual ~Condition();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Condition* get( Reader *r, int end, Context *ctx );
		static Condition* getByName( const char *name );

		std::uint16_t getnext();
			void setnext( std::uint16_t );
	bool getmenuEnter();
			void setmenuEnter( bool );
	bool getpointerReleaseOutside();
			void setpointerReleaseOutside( bool );
	bool getpointerDragEnter();
			void setpointerDragEnter( bool );
	bool getpointerDragLeave();
			void setpointerDragLeave( bool );
	bool getpointerReleaseInside();
			void setpointerReleaseInside( bool );
	bool getpointerPush();
			void setpointerPush( bool );
	bool getpointerLeave();
			void setpointerLeave( bool );
	bool getpointerEnter();
			void setpointerEnter( bool );
	std::int32_t getkey();
			void setkey( std::int32_t );
	bool getmenuLeave();
			void setmenuLeave( bool );
	List<Action> *getactions();
	

	protected:
		std::uint16_t next; // word
bool menuEnter; // bit
bool pointerReleaseOutside; // bit
bool pointerDragEnter; // bit
bool pointerDragLeave; // bit
bool pointerReleaseInside; // bit
bool pointerPush; // bit
bool pointerLeave; // bit
bool pointerEnter; // bit
std::int32_t key; // integer
bool menuLeave; // bit
List<Action> actions; // list

};

class U30 : public Item {
	public:
		U30();
		virtual ~U30();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static U30* get( Reader *r, int end, Context *ctx );
		static U30* getByName( const char *name );

		std::uint32_t getvalue();
			void setvalue( std::uint32_t );
	

	protected:
		std::uint32_t value; // u30

};

class S24 : public Item {
	public:
		S24();
		virtual ~S24();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static S24* get( Reader *r, int end, Context *ctx );
		static S24* getByName( const char *name );

		std::int32_t getvalue();
			void setvalue( std::int32_t );
	

	protected:
		std::int32_t value; // s24

};

class ValueKind : public Item {
	public:
		ValueKind();
		virtual ~ValueKind();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ValueKind* get( Reader *r, int end, Context *ctx );
		static ValueKind* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	std::uint8_t getkind();
			void setkind( std::uint8_t );
	

	protected:
		std::uint32_t index; // u30
std::uint8_t kind; // byte

};

class MethodInfo : public Item {
	public:
		MethodInfo();
		virtual ~MethodInfo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MethodInfo* get( Reader *r, int end, Context *ctx );
		static MethodInfo* getByName( const char *name );

		std::uint32_t getparamCount();
			void setparamCount( std::uint32_t );
	std::uint32_t getretType();
			void setretType( std::uint32_t );
	List<U30> *getparamTypes();
	std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	bool gethasParamNames();
			void sethasParamNames( bool );
	bool getsetSDXNs();
			void setsetSDXNs( bool );
	bool getisExplicit();
			void setisExplicit( bool );
	bool getignoreRest();
			void setignoreRest( bool );
	bool gethasOptional();
			void sethasOptional( bool );
	bool getneedRest();
			void setneedRest( bool );
	bool getneedActivation();
			void setneedActivation( bool );
	bool getneedArguments();
			void setneedArguments( bool );
	std::uint32_t getoptionalCount();
			void setoptionalCount( std::uint32_t );
	List<ValueKind> *getoptional();
	List<U30> *getparamNames();
	

	protected:
		std::uint32_t paramCount; // u30
std::uint32_t retType; // u30
List<U30> paramTypes; // list
std::uint32_t nameIndex; // u30
bool hasParamNames; // bit
bool setSDXNs; // bit
bool isExplicit; // bit
bool ignoreRest; // bit
bool hasOptional; // bit
bool needRest; // bit
bool needActivation; // bit
bool needArguments; // bit
std::uint32_t optionalCount; // u30
List<ValueKind> optional; // list
List<U30> paramNames; // list

};

class MetadataInfo : public Item {
	public:
		MetadataInfo();
		virtual ~MetadataInfo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MetadataInfo* get( Reader *r, int end, Context *ctx );
		static MetadataInfo* getByName( const char *name );

		std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	std::uint32_t getvaluesCount();
			void setvaluesCount( std::uint32_t );
	List<U30> *getkeys();
	List<U30> *getvalues();
	

	protected:
		std::uint32_t nameIndex; // u30
std::uint32_t valuesCount; // u30
List<U30> keys; // list
List<U30> values; // list

};

class NamespaceSet : public Item {
	public:
		NamespaceSet();
		virtual ~NamespaceSet();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static NamespaceSet* get( Reader *r, int end, Context *ctx );
		static NamespaceSet* getByName( const char *name );

		std::uint32_t getcount();
			void setcount( std::uint32_t );
	List<U30> *getnamespaces();
	

	protected:
		std::uint32_t count; // u30
List<U30> namespaces; // list

};

class TraitInfo : public Item {
	public:
		TraitInfo();
		virtual ~TraitInfo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TraitInfo* get( Reader *r, int end, Context *ctx );
		static TraitInfo* getByName( const char *name );

		std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	bool getreserved();
			void setreserved( bool );
	bool gethasMetadata();
			void sethasMetadata( bool );
	bool getoverride();
			void setoverride( bool );
	bool getfinal();
			void setfinal( bool );
	List<Trait> *gettrait();
	std::uint32_t getmetadataCount();
			void setmetadataCount( std::uint32_t );
	List<U30> *getmetadata();
	

	protected:
		std::uint32_t nameIndex; // u30
bool reserved; // bit
bool hasMetadata; // bit
bool override; // bit
bool final; // bit
List<Trait> trait; // list
std::uint32_t metadataCount; // u30
List<U30> metadata; // list

};

class InstanceInfo : public Item {
	public:
		InstanceInfo();
		virtual ~InstanceInfo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static InstanceInfo* get( Reader *r, int end, Context *ctx );
		static InstanceInfo* getByName( const char *name );

		std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	std::uint32_t getsuperIndex();
			void setsuperIndex( std::uint32_t );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool gethasProtectedNS();
			void sethasProtectedNS( bool );
	bool getinterface();
			void setinterface( bool );
	bool getfinal();
			void setfinal( bool );
	bool getsealed();
			void setsealed( bool );
	std::uint32_t getprotectedNS();
			void setprotectedNS( std::uint32_t );
	std::uint32_t getinterfaceCount();
			void setinterfaceCount( std::uint32_t );
	List<U30> *getinterfaces();
	std::uint32_t getiInitIndex();
			void setiInitIndex( std::uint32_t );
	std::uint32_t gettraitCount();
			void settraitCount( std::uint32_t );
	List<TraitInfo> *gettraits();
	

	protected:
		std::uint32_t nameIndex; // u30
std::uint32_t superIndex; // u30
std::int32_t reserved; // integer
bool hasProtectedNS; // bit
bool interface; // bit
bool final; // bit
bool sealed; // bit
std::uint32_t protectedNS; // u30
std::uint32_t interfaceCount; // u30
List<U30> interfaces; // list
std::uint32_t iInitIndex; // u30
std::uint32_t traitCount; // u30
List<TraitInfo> traits; // list

};

class ClassInfo : public Item {
	public:
		ClassInfo();
		virtual ~ClassInfo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ClassInfo* get( Reader *r, int end, Context *ctx );
		static ClassInfo* getByName( const char *name );

		std::uint32_t getcInitIndex();
			void setcInitIndex( std::uint32_t );
	std::uint32_t gettraitCount();
			void settraitCount( std::uint32_t );
	List<TraitInfo> *gettraits();
	

	protected:
		std::uint32_t cInitIndex; // u30
std::uint32_t traitCount; // u30
List<TraitInfo> traits; // list

};

class ScriptInfo : public Item {
	public:
		ScriptInfo();
		virtual ~ScriptInfo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ScriptInfo* get( Reader *r, int end, Context *ctx );
		static ScriptInfo* getByName( const char *name );

		std::uint32_t getinitIndex();
			void setinitIndex( std::uint32_t );
	std::uint32_t gettraitCount();
			void settraitCount( std::uint32_t );
	List<TraitInfo> *gettraits();
	

	protected:
		std::uint32_t initIndex; // u30
std::uint32_t traitCount; // u30
List<TraitInfo> traits; // list

};

class Exception : public Item {
	public:
		Exception();
		virtual ~Exception();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Exception* get( Reader *r, int end, Context *ctx );
		static Exception* getByName( const char *name );

		std::uint32_t gettryStart();
			void settryStart( std::uint32_t );
	std::uint32_t gettryEnd();
			void settryEnd( std::uint32_t );
	std::uint32_t gettarget();
			void settarget( std::uint32_t );
	std::uint32_t gettype();
			void settype( std::uint32_t );
	std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t tryStart; // u30
std::uint32_t tryEnd; // u30
std::uint32_t target; // u30
std::uint32_t type; // u30
std::uint32_t name; // u30

};

class MethodBody : public Item {
	public:
		MethodBody();
		virtual ~MethodBody();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MethodBody* get( Reader *r, int end, Context *ctx );
		static MethodBody* getByName( const char *name );

		std::uint32_t getmethodInfo();
			void setmethodInfo( std::uint32_t );
	std::uint32_t getmaxStack();
			void setmaxStack( std::uint32_t );
	std::uint32_t getmaxRegs();
			void setmaxRegs( std::uint32_t );
	std::uint32_t getscopeDepth();
			void setscopeDepth( std::uint32_t );
	std::uint32_t getmaxScope();
			void setmaxScope( std::uint32_t );
	std::uint32_t getcodeLength();
			void setcodeLength( std::uint32_t );
	List<OpCode> *getcode();
	std::uint32_t getexceptionCount();
			void setexceptionCount( std::uint32_t );
	List<Exception> *getexceptions();
	std::uint32_t gettraitCount();
			void settraitCount( std::uint32_t );
	List<TraitInfo> *gettraits();
	

	protected:
		std::uint32_t methodInfo; // u30
std::uint32_t maxStack; // u30
std::uint32_t maxRegs; // u30
std::uint32_t scopeDepth; // u30
std::uint32_t maxScope; // u30
std::uint32_t codeLength; // u30
List<OpCode> code; // list
std::uint32_t exceptionCount; // u30
List<Exception> exceptions; // list
std::uint32_t traitCount; // u30
List<TraitInfo> traits; // list

};

class Constants : public Item {
	public:
		Constants();
		virtual ~Constants();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Constants* get( Reader *r, int end, Context *ctx );
		static Constants* getByName( const char *name );

		std::uint32_t getintCount();
			void setintCount( std::uint32_t );
	List<U30> *getints();
	std::uint32_t getuintCount();
			void setuintCount( std::uint32_t );
	List<U30> *getuints();
	std::uint32_t getdoubleCount();
			void setdoubleCount( std::uint32_t );
	List<Double> *getdoubles();
	std::uint32_t getstringCount();
			void setstringCount( std::uint32_t );
	List<String2> *getstrings();
	std::uint32_t getnamespaceConstantCount();
			void setnamespaceConstantCount( std::uint32_t );
	List<NamespaceConstant> *getnamespaces();
	std::uint32_t getnamespaceSetCount();
			void setnamespaceSetCount( std::uint32_t );
	List<NamespaceSet> *getnamespaceSets();
	std::uint32_t getmultinameConstantCount();
			void setmultinameConstantCount( std::uint32_t );
	List<MultinameConstant> *getmultinames();
	

	protected:
		std::uint32_t intCount; // u30
List<U30> ints; // list
std::uint32_t uintCount; // u30
List<U30> uints; // list
std::uint32_t doubleCount; // u30
List<Double> doubles; // list
std::uint32_t stringCount; // u30
List<String2> strings; // list
std::uint32_t namespaceConstantCount; // u30
List<NamespaceConstant> namespaces; // list
std::uint32_t namespaceSetCount; // u30
List<NamespaceSet> namespaceSets; // list
std::uint32_t multinameConstantCount; // u30
List<MultinameConstant> multinames; // list

};

class Action3 : public Item {
	public:
		Action3();
		virtual ~Action3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Action3* get( Reader *r, int end, Context *ctx );
		static Action3* getByName( const char *name );

		std::uint16_t getminorVersion();
			void setminorVersion( std::uint16_t );
	std::uint16_t getmajorVersion();
			void setmajorVersion( std::uint16_t );
	Constants *getconstants();
	std::uint32_t getmethodInfoCount();
			void setmethodInfoCount( std::uint32_t );
	List<MethodInfo> *getmethods();
	std::uint32_t getmetadataInfoCount();
			void setmetadataInfoCount( std::uint32_t );
	List<MetadataInfo> *getmetadata();
	std::uint32_t getclassCount();
			void setclassCount( std::uint32_t );
	List<InstanceInfo> *getinstances();
	List<ClassInfo> *getclasses();
	std::uint32_t getscriptCount();
			void setscriptCount( std::uint32_t );
	List<ScriptInfo> *getscripts();
	std::uint32_t getmethodBodyCount();
			void setmethodBodyCount( std::uint32_t );
	List<MethodBody> *getmethodBodies();
	

	protected:
		std::uint16_t minorVersion; // word
std::uint16_t majorVersion; // word
Constants constants; // object
std::uint32_t methodInfoCount; // u30
List<MethodInfo> methods; // list
std::uint32_t metadataInfoCount; // u30
List<MetadataInfo> metadata; // list
std::uint32_t classCount; // u30
List<InstanceInfo> instances; // list
List<ClassInfo> classes; // list
std::uint32_t scriptCount; // u30
List<ScriptInfo> scripts; // list
std::uint32_t methodBodyCount; // u30
List<MethodBody> methodBodies; // list

};

class ZoneData : public Item {
	public:
		ZoneData();
		virtual ~ZoneData();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ZoneData* get( Reader *r, int end, Context *ctx );
		static ZoneData* getByName( const char *name );

		float getposition();
			void setposition( float );
	float getsize();
			void setsize( float );
	

	protected:
		float position; // half
float size; // half

};

class ZoneArray : public Item {
	public:
		ZoneArray();
		virtual ~ZoneArray();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ZoneArray* get( Reader *r, int end, Context *ctx );
		static ZoneArray* getByName( const char *name );

		std::uint8_t getcount();
			void setcount( std::uint8_t );
	List<ZoneData> *getzones();
	std::int32_t getzoneX();
			void setzoneX( std::int32_t );
	std::int32_t getzoneY();
			void setzoneY( std::int32_t );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	

	protected:
		std::uint8_t count; // byte
List<ZoneData> zones; // list
std::int32_t zoneX; // integer
std::int32_t zoneY; // integer
std::int32_t reserved; // integer

};

class UnknownFilter : public Filter {
	public:
		UnknownFilter();
		virtual ~UnknownFilter();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UnknownFilter* get( Reader *r, int end, Context *ctx );
		static UnknownFilter* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class DropShadow : public Filter {
	public:
		DropShadow();
		virtual ~DropShadow();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DropShadow* get( Reader *r, int end, Context *ctx );
		static DropShadow* getByName( const char *name );

		Color *getcolor();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getangle();
			void setangle( float );
	float getdistance();
			void setdistance( float );
	float getstrength();
			void setstrength( float );
	bool getinnerShadow();
			void setinnerShadow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	std::int32_t getpasses();
			void setpasses( std::int32_t );
	

	protected:
		Color color; // object
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float angle; // fixedpoint2
float distance; // fixedpoint2
float strength; // fixedpoint2
bool innerShadow; // bit
bool knockout; // bit
bool compositeSource; // bit
std::int32_t passes; // integer

			static int id;
		
};

class Blur : public Filter {
	public:
		Blur();
		virtual ~Blur();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Blur* get( Reader *r, int end, Context *ctx );
		static Blur* getByName( const char *name );

		float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	std::int32_t getpasses();
			void setpasses( std::int32_t );
	std::int32_t getreserved1();
			void setreserved1( std::int32_t );
	

	protected:
		float blurX; // fixedpoint2
float blurY; // fixedpoint2
std::int32_t passes; // integer
std::int32_t reserved1; // integer

			static int id;
		
};

class Glow : public Filter {
	public:
		Glow();
		virtual ~Glow();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Glow* get( Reader *r, int end, Context *ctx );
		static Glow* getByName( const char *name );

		Color *getcolor();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getstrength();
			void setstrength( float );
	bool getinnerGlow();
			void setinnerGlow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	std::int32_t getpasses();
			void setpasses( std::int32_t );
	

	protected:
		Color color; // object
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float strength; // fixedpoint2
bool innerGlow; // bit
bool knockout; // bit
bool compositeSource; // bit
std::int32_t passes; // integer

			static int id;
		
};

class Bevel : public Filter {
	public:
		Bevel();
		virtual ~Bevel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Bevel* get( Reader *r, int end, Context *ctx );
		static Bevel* getByName( const char *name );

		Color *getshadowColor();
	Color *gethighlightColor();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getangle();
			void setangle( float );
	float getdistance();
			void setdistance( float );
	float getstrength();
			void setstrength( float );
	bool getinnerShadow();
			void setinnerShadow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	bool getonTop();
			void setonTop( bool );
	std::int32_t getpasses();
			void setpasses( std::int32_t );
	

	protected:
		Color shadowColor; // object
Color highlightColor; // object
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float angle; // fixedpoint2
float distance; // fixedpoint2
float strength; // fixedpoint2
bool innerShadow; // bit
bool knockout; // bit
bool compositeSource; // bit
bool onTop; // bit
std::int32_t passes; // integer

			static int id;
		
};

class GradientGlow : public Filter {
	public:
		GradientGlow();
		virtual ~GradientGlow();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GradientGlow* get( Reader *r, int end, Context *ctx );
		static GradientGlow* getByName( const char *name );

		std::uint8_t getnumColors();
			void setnumColors( std::uint8_t );
	List<Color> *getcolors();
	List<UChar> *getratio();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getangle();
			void setangle( float );
	float getdistance();
			void setdistance( float );
	float getstrength();
			void setstrength( float );
	bool getinnerGlow();
			void setinnerGlow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	bool getonTop();
			void setonTop( bool );
	std::int32_t getpasses();
			void setpasses( std::int32_t );
	

	protected:
		std::uint8_t numColors; // byte
List<Color> colors; // list
List<UChar> ratio; // list
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float angle; // fixedpoint2
float distance; // fixedpoint2
float strength; // fixedpoint2
bool innerGlow; // bit
bool knockout; // bit
bool compositeSource; // bit
bool onTop; // bit
std::int32_t passes; // integer

			static int id;
		
};

class Convolution : public Filter {
	public:
		Convolution();
		virtual ~Convolution();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Convolution* get( Reader *r, int end, Context *ctx );
		static Convolution* getByName( const char *name );

		std::uint8_t getmatrixX();
			void setmatrixX( std::uint8_t );
	std::uint8_t getmatrixY();
			void setmatrixY( std::uint8_t );
	float getdivizor();
			void setdivizor( float );
	float getbias();
			void setbias( float );
	List<Float> *getmatrix();
	Color *getdefaultColor();
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getclamp();
			void setclamp( bool );
	bool getpreserveAlpha();
			void setpreserveAlpha( bool );
	

	protected:
		std::uint8_t matrixX; // byte
std::uint8_t matrixY; // byte
float divizor; // float
float bias; // float
List<Float> matrix; // list
Color defaultColor; // object
std::int32_t reserved; // integer
bool clamp; // bit
bool preserveAlpha; // bit

			static int id;
		
};

class ColorMatrix : public Filter {
	public:
		ColorMatrix();
		virtual ~ColorMatrix();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ColorMatrix* get( Reader *r, int end, Context *ctx );
		static ColorMatrix* getByName( const char *name );

		List<Float> *getmatrix();
	

	protected:
		List<Float> matrix; // list

			static int id;
		
};

class GradientBevel : public Filter {
	public:
		GradientBevel();
		virtual ~GradientBevel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GradientBevel* get( Reader *r, int end, Context *ctx );
		static GradientBevel* getByName( const char *name );

		std::uint8_t getnumColors();
			void setnumColors( std::uint8_t );
	List<Color> *getcolors();
	List<UChar> *getratio();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getangle();
			void setangle( float );
	float getdistance();
			void setdistance( float );
	float getstrength();
			void setstrength( float );
	bool getinnerGlow();
			void setinnerGlow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	bool getonTop();
			void setonTop( bool );
	std::int32_t getpasses();
			void setpasses( std::int32_t );
	

	protected:
		std::uint8_t numColors; // byte
List<Color> colors; // list
List<UChar> ratio; // list
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float angle; // fixedpoint2
float distance; // fixedpoint2
float strength; // fixedpoint2
bool innerGlow; // bit
bool knockout; // bit
bool compositeSource; // bit
bool onTop; // bit
std::int32_t passes; // integer

			static int id;
		
};

class Solid : public Style {
	public:
		Solid();
		virtual ~Solid();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Solid* get( Reader *r, int end, Context *ctx );
		static Solid* getByName( const char *name );

		Color *getcolor();
	

	protected:
		Color color; // object

			static int id;
		
};

class LinearGradient : public Style {
	public:
		LinearGradient();
		virtual ~LinearGradient();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LinearGradient* get( Reader *r, int end, Context *ctx );
		static LinearGradient* getByName( const char *name );

		Transform *getmatrix();
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	std::int32_t getspreadMode();
			void setspreadMode( std::int32_t );
	std::int32_t getinterpolationMode();
			void setinterpolationMode( std::int32_t );
	std::int32_t getcount();
			void setcount( std::int32_t );
	List<GradientItem> *getgradientColors();
	

	protected:
		Transform matrix; // object
std::int32_t reserved; // integer
std::int32_t spreadMode; // integer
std::int32_t interpolationMode; // integer
std::int32_t count; // integer
List<GradientItem> gradientColors; // list

			static int id;
		
};

class RadialGradient : public Style {
	public:
		RadialGradient();
		virtual ~RadialGradient();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RadialGradient* get( Reader *r, int end, Context *ctx );
		static RadialGradient* getByName( const char *name );

		Transform *getmatrix();
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	std::int32_t getspreadMode();
			void setspreadMode( std::int32_t );
	std::int32_t getinterpolationMode();
			void setinterpolationMode( std::int32_t );
	std::int32_t getcount();
			void setcount( std::int32_t );
	List<GradientItem> *getgradientColors();
	

	protected:
		Transform matrix; // object
std::int32_t reserved; // integer
std::int32_t spreadMode; // integer
std::int32_t interpolationMode; // integer
std::int32_t count; // integer
List<GradientItem> gradientColors; // list

			static int id;
		
};

class ShiftedRadialGradient : public Style {
	public:
		ShiftedRadialGradient();
		virtual ~ShiftedRadialGradient();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShiftedRadialGradient* get( Reader *r, int end, Context *ctx );
		static ShiftedRadialGradient* getByName( const char *name );

		Transform *getmatrix();
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	std::int32_t getspreadMode();
			void setspreadMode( std::int32_t );
	std::int32_t getinterpolationMode();
			void setinterpolationMode( std::int32_t );
	std::int32_t getcount();
			void setcount( std::int32_t );
	List<GradientItem> *getgradientColors();
	float getshift();
			void setshift( float );
	

	protected:
		Transform matrix; // object
std::int32_t reserved; // integer
std::int32_t spreadMode; // integer
std::int32_t interpolationMode; // integer
std::int32_t count; // integer
List<GradientItem> gradientColors; // list
float shift; // fixedpoint2

			static int id;
		
};

class TiledBitmap : public Style {
	public:
		TiledBitmap();
		virtual ~TiledBitmap();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TiledBitmap* get( Reader *r, int end, Context *ctx );
		static TiledBitmap* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Transform *getmatrix();
	

	protected:
		std::uint16_t objectID; // word
Transform matrix; // object

			static int id;
		
};

class ClippedBitmap : public Style {
	public:
		ClippedBitmap();
		virtual ~ClippedBitmap();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ClippedBitmap* get( Reader *r, int end, Context *ctx );
		static ClippedBitmap* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Transform *getmatrix();
	

	protected:
		std::uint16_t objectID; // word
Transform matrix; // object

			static int id;
		
};

class TiledBitmap2 : public Style {
	public:
		TiledBitmap2();
		virtual ~TiledBitmap2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TiledBitmap2* get( Reader *r, int end, Context *ctx );
		static TiledBitmap2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Transform *getmatrix();
	

	protected:
		std::uint16_t objectID; // word
Transform matrix; // object

			static int id;
		
};

class ClippedBitmap2 : public Style {
	public:
		ClippedBitmap2();
		virtual ~ClippedBitmap2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ClippedBitmap2* get( Reader *r, int end, Context *ctx );
		static ClippedBitmap2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Transform *getmatrix();
	

	protected:
		std::uint16_t objectID; // word
Transform matrix; // object

			static int id;
		
};

class UnknownTag : public Tag {
	public:
		UnknownTag();
		virtual ~UnknownTag();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UnknownTag* get( Reader *r, int end, Context *ctx );
		static UnknownTag* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class End : public Tag {
	public:
		End();
		virtual ~End();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static End* get( Reader *r, int end, Context *ctx );
		static End* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ShowFrame : public Tag {
	public:
		ShowFrame();
		virtual ~ShowFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShowFrame* get( Reader *r, int end, Context *ctx );
		static ShowFrame* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DefineShape : public Tag {
	public:
		DefineShape();
		virtual ~DefineShape();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape* get( Reader *r, int end, Context *ctx );
		static DefineShape* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rectangle *getbounds();
	StyleList *getstyles();
	Shape *getshapes();
	

	protected:
		std::uint16_t objectID; // word
Rectangle bounds; // object
StyleList styles; // object
Shape shapes; // object

			static int id;
		
};

class RemoveObject : public Tag {
	public:
		RemoveObject();
		virtual ~RemoveObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RemoveObject* get( Reader *r, int end, Context *ctx );
		static RemoveObject* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint16_t getdepth();
			void setdepth( std::uint16_t );
	

	protected:
		std::uint16_t objectID; // word
std::uint16_t depth; // word

			static int id;
		
};

class DefineBits : public Tag {
	public:
		DefineBits();
		virtual ~DefineBits();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBits* get( Reader *r, int end, Context *ctx );
		static DefineBits* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
Rest data; // object

			static int id;
		
};

class SetBackgroundColor : public Tag {
	public:
		SetBackgroundColor();
		virtual ~SetBackgroundColor();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetBackgroundColor* get( Reader *r, int end, Context *ctx );
		static SetBackgroundColor* getByName( const char *name );

		Color *getcolor();
	

	protected:
		Color color; // object

			static int id;
		
};

class DefineText : public Tag {
	public:
		DefineText();
		virtual ~DefineText();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineText* get( Reader *r, int end, Context *ctx );
		static DefineText* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rectangle *getbounds();
	Transform *gettransform();
	std::uint8_t getglyphBits();
			void setglyphBits( std::uint8_t );
	std::uint8_t getadvanceBits();
			void setadvanceBits( std::uint8_t );
	List<TextRecord> *getrecords();
	

	protected:
		std::uint16_t objectID; // word
Rectangle bounds; // object
Transform transform; // object
std::uint8_t glyphBits; // byte
std::uint8_t advanceBits; // byte
List<TextRecord> records; // list

			static int id;
		
};

class DefineText2 : public Tag {
	public:
		DefineText2();
		virtual ~DefineText2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineText2* get( Reader *r, int end, Context *ctx );
		static DefineText2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rectangle *getbounds();
	Transform *gettransform();
	std::uint8_t getglyphBits();
			void setglyphBits( std::uint8_t );
	std::uint8_t getadvanceBits();
			void setadvanceBits( std::uint8_t );
	List<TextRecord2> *getrecords();
	

	protected:
		std::uint16_t objectID; // word
Rectangle bounds; // object
Transform transform; // object
std::uint8_t glyphBits; // byte
std::uint8_t advanceBits; // byte
List<TextRecord2> records; // list

			static int id;
		
};

class DoAction : public Tag {
	public:
		DoAction();
		virtual ~DoAction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DoAction* get( Reader *r, int end, Context *ctx );
		static DoAction* getByName( const char *name );

		List<Action> *getactions();
	

	protected:
		List<Action> actions; // list

			static int id;
		
};

class DefineFontInfo : public Tag {
	public:
		DefineFontInfo();
		virtual ~DefineFontInfo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFontInfo* get( Reader *r, int end, Context *ctx );
		static DefineFontInfo* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint8_t getnameLength();
			void setnameLength( std::uint8_t );
	
			void getnameData( unsigned char **dst, int *size );
			void setnameData( const unsigned char *src, int size );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getsmallTextOrUnicode();
			void setsmallTextOrUnicode( bool );
	bool getisShiftJIS();
			void setisShiftJIS( bool );
	bool getisANSII();
			void setisANSII( bool );
	bool getisItalic();
			void setisItalic( bool );
	bool getisBold();
			void setisBold( bool );
	bool getisWide();
			void setisWide( bool );
	std::uint8_t getlanguage();
			void setlanguage( std::uint8_t );
	Rest *getmap();
	

	protected:
		std::uint16_t objectID; // word
std::uint8_t nameLength; // byte
unsigned char * nameData; // data
std::int32_t reserved; // integer
bool smallTextOrUnicode; // bit
bool isShiftJIS; // bit
bool isANSII; // bit
bool isItalic; // bit
bool isBold; // bit
bool isWide; // bit
std::uint8_t language; // byte
Rest map; // object

			static int id;
		
};

class DefineSound : public Tag {
	public:
		DefineSound();
		virtual ~DefineSound();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineSound* get( Reader *r, int end, Context *ctx );
		static DefineSound* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::int32_t getformat();
			void setformat( std::int32_t );
	std::int32_t getrate();
			void setrate( std::int32_t );
	bool getis16bit();
			void setis16bit( bool );
	bool getstereo();
			void setstereo( bool );
	std::uint32_t getsamples();
			void setsamples( std::uint32_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
std::int32_t format; // integer
std::int32_t rate; // integer
bool is16bit; // bit
bool stereo; // bit
std::uint32_t samples; // uint32
Rest data; // object

			static int id;
		
};

class StartSound : public Tag {
	public:
		StartSound();
		virtual ~StartSound();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StartSound* get( Reader *r, int end, Context *ctx );
		static StartSound* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getstopPlayback();
			void setstopPlayback( bool );
	bool getnoMultiple();
			void setnoMultiple( bool );
	bool gethasEnvelope();
			void sethasEnvelope( bool );
	bool gethasLoop();
			void sethasLoop( bool );
	bool gethasOutPoint();
			void sethasOutPoint( bool );
	bool gethasInPoint();
			void sethasInPoint( bool );
	std::uint32_t getinPoint();
			void setinPoint( std::uint32_t );
	std::uint32_t getoutPoint();
			void setoutPoint( std::uint32_t );
	std::uint16_t getloop();
			void setloop( std::uint16_t );
	std::uint8_t getenvelopeCount();
			void setenvelopeCount( std::uint8_t );
	Rest *getenvelopeData();
	

	protected:
		std::uint16_t objectID; // word
std::int32_t reserved; // integer
bool stopPlayback; // bit
bool noMultiple; // bit
bool hasEnvelope; // bit
bool hasLoop; // bit
bool hasOutPoint; // bit
bool hasInPoint; // bit
std::uint32_t inPoint; // uint32
std::uint32_t outPoint; // uint32
std::uint16_t loop; // word
std::uint8_t envelopeCount; // byte
Rest envelopeData; // object

			static int id;
		
};

class DefineShape2 : public Tag {
	public:
		DefineShape2();
		virtual ~DefineShape2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape2* get( Reader *r, int end, Context *ctx );
		static DefineShape2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rectangle *getbounds();
	StyleList *getstyles();
	Shape *getshapes();
	

	protected:
		std::uint16_t objectID; // word
Rectangle bounds; // object
StyleList styles; // object
Shape shapes; // object

			static int id;
		
};

class DefineShape3 : public Tag {
	public:
		DefineShape3();
		virtual ~DefineShape3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape3* get( Reader *r, int end, Context *ctx );
		static DefineShape3* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rectangle *getbounds();
	StyleList *getstyles();
	Shape *getshapes();
	

	protected:
		std::uint16_t objectID; // word
Rectangle bounds; // object
StyleList styles; // object
Shape shapes; // object

			static int id;
		
};

class DefineShape4 : public Tag {
	public:
		DefineShape4();
		virtual ~DefineShape4();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape4* get( Reader *r, int end, Context *ctx );
		static DefineShape4* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
Rest data; // object

			static int id;
		
};

class DefineShape5 : public Tag {
	public:
		DefineShape5();
		virtual ~DefineShape5();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape5* get( Reader *r, int end, Context *ctx );
		static DefineShape5* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rectangle *getbounds();
	Rectangle *getstrokeBounds();
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getnonScalingStrokes();
			void setnonScalingStrokes( bool );
	bool getscalingStrokes();
			void setscalingStrokes( bool );
	StyleList *getstyles();
	Shape *getshapes();
	

	protected:
		std::uint16_t objectID; // word
Rectangle bounds; // object
Rectangle strokeBounds; // object
std::int32_t reserved; // integer
bool nonScalingStrokes; // bit
bool scalingStrokes; // bit
StyleList styles; // object
Shape shapes; // object

			static int id;
		
};

class DefineMorphShape : public Tag {
	public:
		DefineMorphShape();
		virtual ~DefineMorphShape();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineMorphShape* get( Reader *r, int end, Context *ctx );
		static DefineMorphShape* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
Rest data; // object

			static int id;
		
};

class DefineFontInfo2 : public Tag {
	public:
		DefineFontInfo2();
		virtual ~DefineFontInfo2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFontInfo2* get( Reader *r, int end, Context *ctx );
		static DefineFontInfo2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint8_t getnameLength();
			void setnameLength( std::uint8_t );
	
			void getnameData( unsigned char **dst, int *size );
			void setnameData( const unsigned char *src, int size );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getsmallTextOrUnicode();
			void setsmallTextOrUnicode( bool );
	bool getisShiftJIS();
			void setisShiftJIS( bool );
	bool getisANSII();
			void setisANSII( bool );
	bool getisItalic();
			void setisItalic( bool );
	bool getisBold();
			void setisBold( bool );
	bool getisWide();
			void setisWide( bool );
	std::uint8_t getlanguage();
			void setlanguage( std::uint8_t );
	Rest *getmap();
	

	protected:
		std::uint16_t objectID; // word
std::uint8_t nameLength; // byte
unsigned char * nameData; // data
std::int32_t reserved; // integer
bool smallTextOrUnicode; // bit
bool isShiftJIS; // bit
bool isANSII; // bit
bool isItalic; // bit
bool isBold; // bit
bool isWide; // bit
std::uint8_t language; // byte
Rest map; // object

			static int id;
		
};

class SoundStreamHead : public Tag {
	public:
		SoundStreamHead();
		virtual ~SoundStreamHead();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SoundStreamHead* get( Reader *r, int end, Context *ctx );
		static SoundStreamHead* getByName( const char *name );

		std::int32_t getreserved();
			void setreserved( std::int32_t );
	std::int32_t getplaybackRate();
			void setplaybackRate( std::int32_t );
	bool getplaybackSize();
			void setplaybackSize( bool );
	bool getplaybackStereo();
			void setplaybackStereo( bool );
	std::int32_t getcompression();
			void setcompression( std::int32_t );
	std::int32_t getsoundRate();
			void setsoundRate( std::int32_t );
	bool getsoundSize();
			void setsoundSize( bool );
	bool getsoundStereo();
			void setsoundStereo( bool );
	std::uint16_t getsampleSize();
			void setsampleSize( std::uint16_t );
	Rest *getlatencySeek();
	

	protected:
		std::int32_t reserved; // integer
std::int32_t playbackRate; // integer
bool playbackSize; // bit
bool playbackStereo; // bit
std::int32_t compression; // integer
std::int32_t soundRate; // integer
bool soundSize; // bit
bool soundStereo; // bit
std::uint16_t sampleSize; // word
Rest latencySeek; // object

			static int id;
		
};

class DefineBitsLossless : public Tag {
	public:
		DefineBitsLossless();
		virtual ~DefineBitsLossless();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBitsLossless* get( Reader *r, int end, Context *ctx );
		static DefineBitsLossless* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint8_t getformat();
			void setformat( std::uint8_t );
	std::uint16_t getwidth();
			void setwidth( std::uint16_t );
	std::uint16_t getheight();
			void setheight( std::uint16_t );
	std::uint8_t getn_colormap();
			void setn_colormap( std::uint8_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
std::uint8_t format; // byte
std::uint16_t width; // word
std::uint16_t height; // word
std::uint8_t n_colormap; // byte
Rest data; // object

			static int id;
		
};

class DefineBitsJPEG2 : public Tag {
	public:
		DefineBitsJPEG2();
		virtual ~DefineBitsJPEG2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBitsJPEG2* get( Reader *r, int end, Context *ctx );
		static DefineBitsJPEG2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
Rest data; // object

			static int id;
		
};

class DefineBitsJPEG3 : public Tag {
	public:
		DefineBitsJPEG3();
		virtual ~DefineBitsJPEG3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBitsJPEG3* get( Reader *r, int end, Context *ctx );
		static DefineBitsJPEG3* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint32_t getoffset_to_alpha();
			void setoffset_to_alpha( std::uint32_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
std::uint32_t offset_to_alpha; // uint32
Rest data; // object

			static int id;
		
};

class DefineBitsLossless2 : public Tag {
	public:
		DefineBitsLossless2();
		virtual ~DefineBitsLossless2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBitsLossless2* get( Reader *r, int end, Context *ctx );
		static DefineBitsLossless2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint8_t getformat();
			void setformat( std::uint8_t );
	std::uint16_t getwidth();
			void setwidth( std::uint16_t );
	std::uint16_t getheight();
			void setheight( std::uint16_t );
	std::uint8_t getn_colormap();
			void setn_colormap( std::uint8_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
std::uint8_t format; // byte
std::uint16_t width; // word
std::uint16_t height; // word
std::uint8_t n_colormap; // byte
Rest data; // object

			static int id;
		
};

class PlaceObject2 : public Tag {
	public:
		PlaceObject2();
		virtual ~PlaceObject2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PlaceObject2* get( Reader *r, int end, Context *ctx );
		static PlaceObject2* getByName( const char *name );

		bool gethasEventHandler();
			void sethasEventHandler( bool );
	bool gethasClipDepth();
			void sethasClipDepth( bool );
	bool gethasName();
			void sethasName( bool );
	bool gethasMorph();
			void sethasMorph( bool );
	bool gethasColorTransform();
			void sethasColorTransform( bool );
	bool gethasTransform();
			void sethasTransform( bool );
	bool gethasID();
			void sethasID( bool );
	bool getreplace();
			void setreplace( bool );
	std::uint16_t getdepth();
			void setdepth( std::uint16_t );
	std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Transform *gettransform();
	ColorTransform2 *getcolorTransform();
	std::uint16_t getmorph();
			void setmorph( std::uint16_t );
	char * getname();
			void setname( char * );
	std::uint16_t getclipDepth();
			void setclipDepth( std::uint16_t );
	std::uint16_t getreserved();
			void setreserved( std::uint16_t );
	std::uint16_t getallflags1();
			void setallflags1( std::uint16_t );
	std::uint16_t getallflags2();
			void setallflags2( std::uint16_t );
	List<Event> *getevents();
	

	protected:
		bool hasEventHandler; // bit
bool hasClipDepth; // bit
bool hasName; // bit
bool hasMorph; // bit
bool hasColorTransform; // bit
bool hasTransform; // bit
bool hasID; // bit
bool replace; // bit
std::uint16_t depth; // word
std::uint16_t objectID; // word
Transform transform; // object
ColorTransform2 colorTransform; // object
std::uint16_t morph; // word
char * name; // string
std::uint16_t clipDepth; // word
std::uint16_t reserved; // word
std::uint16_t allflags1; // word
std::uint16_t allflags2; // word
List<Event> events; // list

			static int id;
		
};

class RemoveObject2 : public Tag {
	public:
		RemoveObject2();
		virtual ~RemoveObject2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RemoveObject2* get( Reader *r, int end, Context *ctx );
		static RemoveObject2* getByName( const char *name );

		std::uint16_t getdepth();
			void setdepth( std::uint16_t );
	

	protected:
		std::uint16_t depth; // word

			static int id;
		
};

class DefineEditText : public Tag {
	public:
		DefineEditText();
		virtual ~DefineEditText();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineEditText* get( Reader *r, int end, Context *ctx );
		static DefineEditText* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rectangle *getsize();
	bool gethasText();
			void sethasText( bool );
	bool getwordWrap();
			void setwordWrap( bool );
	bool getmultiLine();
			void setmultiLine( bool );
	bool getpassword();
			void setpassword( bool );
	bool getreadOnly();
			void setreadOnly( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMaxLength();
			void sethasMaxLength( bool );
	bool gethasFont();
			void sethasFont( bool );
	bool getreserved();
			void setreserved( bool );
	bool getautoSize();
			void setautoSize( bool );
	bool gethasLayout();
			void sethasLayout( bool );
	bool getnotSelectable();
			void setnotSelectable( bool );
	bool gethasBorder();
			void sethasBorder( bool );
	bool getreserved2();
			void setreserved2( bool );
	bool getisHTML();
			void setisHTML( bool );
	bool getuseOutlines();
			void setuseOutlines( bool );
	std::uint16_t getfontRef();
			void setfontRef( std::uint16_t );
	std::uint16_t getfontHeight();
			void setfontHeight( std::uint16_t );
	Color *getcolor();
	std::uint16_t getmaxLength();
			void setmaxLength( std::uint16_t );
	std::uint8_t getalign();
			void setalign( std::uint8_t );
	std::uint16_t getleftMargin();
			void setleftMargin( std::uint16_t );
	std::uint16_t getrightMargin();
			void setrightMargin( std::uint16_t );
	std::uint16_t getindent();
			void setindent( std::uint16_t );
	std::uint16_t getleading();
			void setleading( std::uint16_t );
	char * getvariableName();
			void setvariableName( char * );
	char * getinitialText();
			void setinitialText( char * );
	

	protected:
		std::uint16_t objectID; // word
Rectangle size; // object
bool hasText; // bit
bool wordWrap; // bit
bool multiLine; // bit
bool password; // bit
bool readOnly; // bit
bool hasColor; // bit
bool hasMaxLength; // bit
bool hasFont; // bit
bool reserved; // bit
bool autoSize; // bit
bool hasLayout; // bit
bool notSelectable; // bit
bool hasBorder; // bit
bool reserved2; // bit
bool isHTML; // bit
bool useOutlines; // bit
std::uint16_t fontRef; // word
std::uint16_t fontHeight; // word
Color color; // object
std::uint16_t maxLength; // word
std::uint8_t align; // byte
std::uint16_t leftMargin; // word
std::uint16_t rightMargin; // word
std::uint16_t indent; // word
std::uint16_t leading; // word
char * variableName; // string
char * initialText; // string

			static int id;
		
};

class DefineSprite : public Tag {
	public:
		DefineSprite();
		virtual ~DefineSprite();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineSprite* get( Reader *r, int end, Context *ctx );
		static DefineSprite* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint16_t getframes();
			void setframes( std::uint16_t );
	List<Tag> *gettags();
	

	protected:
		std::uint16_t objectID; // word
std::uint16_t frames; // word
List<Tag> tags; // list

			static int id;
		
};

class FrameLabel : public Tag {
	public:
		FrameLabel();
		virtual ~FrameLabel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static FrameLabel* get( Reader *r, int end, Context *ctx );
		static FrameLabel* getByName( const char *name );

		char * getlabel();
			void setlabel( char * );
	Rest *getflags();
	

	protected:
		char * label; // string
Rest flags; // object

			static int id;
		
};

class SoundStreamHead2 : public Tag {
	public:
		SoundStreamHead2();
		virtual ~SoundStreamHead2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SoundStreamHead2* get( Reader *r, int end, Context *ctx );
		static SoundStreamHead2* getByName( const char *name );

		std::int32_t getreserved();
			void setreserved( std::int32_t );
	std::int32_t getplaybackRate();
			void setplaybackRate( std::int32_t );
	bool getplaybackSize();
			void setplaybackSize( bool );
	bool getplaybackStereo();
			void setplaybackStereo( bool );
	std::int32_t getcompression();
			void setcompression( std::int32_t );
	std::int32_t getsoundRate();
			void setsoundRate( std::int32_t );
	bool getsoundSize();
			void setsoundSize( bool );
	bool getsoundStereo();
			void setsoundStereo( bool );
	std::uint16_t getsampleSize();
			void setsampleSize( std::uint16_t );
	Rest *getlatencySeek();
	

	protected:
		std::int32_t reserved; // integer
std::int32_t playbackRate; // integer
bool playbackSize; // bit
bool playbackStereo; // bit
std::int32_t compression; // integer
std::int32_t soundRate; // integer
bool soundSize; // bit
bool soundStereo; // bit
std::uint16_t sampleSize; // word
Rest latencySeek; // object

			static int id;
		
};

class DefineFont : public Tag {
	public:
		DefineFont();
		virtual ~DefineFont();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFont* get( Reader *r, int end, Context *ctx );
		static DefineFont* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
Rest data; // object

			static int id;
		
};

class DefineFont2 : public Tag {
	public:
		DefineFont2();
		virtual ~DefineFont2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFont2* get( Reader *r, int end, Context *ctx );
		static DefineFont2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	bool gethasLayout();
			void sethasLayout( bool );
	bool getisShiftJIS();
			void setisShiftJIS( bool );
	bool getisUnicode();
			void setisUnicode( bool );
	bool getisANSII();
			void setisANSII( bool );
	bool getwideGlyphOffsets();
			void setwideGlyphOffsets( bool );
	bool getwideMap();
			void setwideMap( bool );
	bool getitalic();
			void setitalic( bool );
	bool getbold();
			void setbold( bool );
	std::uint8_t getlanguage();
			void setlanguage( std::uint8_t );
	char * getname();
			void setname( char * );
	std::uint16_t getglyphCount();
			void setglyphCount( std::uint16_t );
	GlyphList *getglyphs();
	std::uint16_t getascent();
			void setascent( std::uint16_t );
	std::uint16_t getdescent();
			void setdescent( std::uint16_t );
	std::uint16_t getleading();
			void setleading( std::uint16_t );
	List<Short> *getadvance();
	List<Rectangle> *getbounds();
	std::uint16_t getkerningCount();
			void setkerningCount( std::uint16_t );
	List<WideKerning> *getwideKerning();
	List<Kerning> *getkerning();
	

	protected:
		std::uint16_t objectID; // word
bool hasLayout; // bit
bool isShiftJIS; // bit
bool isUnicode; // bit
bool isANSII; // bit
bool wideGlyphOffsets; // bit
bool wideMap; // bit
bool italic; // bit
bool bold; // bit
std::uint8_t language; // byte
char * name; // string
std::uint16_t glyphCount; // word
GlyphList glyphs; // object
std::uint16_t ascent; // word
std::uint16_t descent; // word
std::uint16_t leading; // word
List<Short> advance; // list
List<Rectangle> bounds; // list
std::uint16_t kerningCount; // word
List<WideKerning> wideKerning; // list
List<Kerning> kerning; // list

			static int id;
		
};

class DefineFont3 : public Tag {
	public:
		DefineFont3();
		virtual ~DefineFont3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFont3* get( Reader *r, int end, Context *ctx );
		static DefineFont3* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	bool gethasLayout();
			void sethasLayout( bool );
	bool getisShiftJIS();
			void setisShiftJIS( bool );
	bool getisUnicode();
			void setisUnicode( bool );
	bool getisANSII();
			void setisANSII( bool );
	bool getwideGlyphOffsets();
			void setwideGlyphOffsets( bool );
	bool getwideMap();
			void setwideMap( bool );
	bool getitalic();
			void setitalic( bool );
	bool getbold();
			void setbold( bool );
	std::uint8_t getlanguage();
			void setlanguage( std::uint8_t );
	char * getname();
			void setname( char * );
	std::uint16_t getglyphCount();
			void setglyphCount( std::uint16_t );
	GlyphList *getglyphs();
	std::uint16_t getascent();
			void setascent( std::uint16_t );
	std::uint16_t getdescent();
			void setdescent( std::uint16_t );
	std::uint16_t getleading();
			void setleading( std::uint16_t );
	List<Short> *getadvance();
	List<Rectangle> *getbounds();
	std::uint16_t getkerningCount();
			void setkerningCount( std::uint16_t );
	List<WideKerning> *getwideKerning();
	List<Kerning> *getkerning();
	

	protected:
		std::uint16_t objectID; // word
bool hasLayout; // bit
bool isShiftJIS; // bit
bool isUnicode; // bit
bool isANSII; // bit
bool wideGlyphOffsets; // bit
bool wideMap; // bit
bool italic; // bit
bool bold; // bit
std::uint8_t language; // byte
char * name; // string
std::uint16_t glyphCount; // word
GlyphList glyphs; // object
std::uint16_t ascent; // word
std::uint16_t descent; // word
std::uint16_t leading; // word
List<Short> advance; // list
List<Rectangle> bounds; // list
std::uint16_t kerningCount; // word
List<WideKerning> wideKerning; // list
List<Kerning> kerning; // list

			static int id;
		
};

class DefineButton : public Tag {
	public:
		DefineButton();
		virtual ~DefineButton();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineButton* get( Reader *r, int end, Context *ctx );
		static DefineButton* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	List<Button> *getbuttons();
	List<Action> *getactions();
	

	protected:
		std::uint16_t objectID; // word
List<Button> buttons; // list
List<Action> actions; // list

			static int id;
		
};

class DefineButton2 : public Tag {
	public:
		DefineButton2();
		virtual ~DefineButton2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineButton2* get( Reader *r, int end, Context *ctx );
		static DefineButton2* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getmenu();
			void setmenu( bool );
	std::uint16_t getbuttonsSize();
			void setbuttonsSize( std::uint16_t );
	List<Button> *getbuttons();
	List<Condition> *getconditions();
	

	protected:
		std::uint16_t objectID; // word
std::int32_t reserved; // integer
bool menu; // bit
std::uint16_t buttonsSize; // word
List<Button> buttons; // list
List<Condition> conditions; // list

			static int id;
		
};

class Export : public Tag {
	public:
		Export();
		virtual ~Export();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Export* get( Reader *r, int end, Context *ctx );
		static Export* getByName( const char *name );

		std::uint16_t getcount();
			void setcount( std::uint16_t );
	List<Symbol> *getsymbols();
	

	protected:
		std::uint16_t count; // word
List<Symbol> symbols; // list

			static int id;
		
};

class Import : public Tag {
	public:
		Import();
		virtual ~Import();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Import* get( Reader *r, int end, Context *ctx );
		static Import* getByName( const char *name );

		char * geturl();
			void seturl( char * );
	std::uint16_t getcount();
			void setcount( std::uint16_t );
	List<Symbol> *getsymbols();
	

	protected:
		char * url; // string
std::uint16_t count; // word
List<Symbol> symbols; // list

			static int id;
		
};

class DoInitAction : public Tag {
	public:
		DoInitAction();
		virtual ~DoInitAction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DoInitAction* get( Reader *r, int end, Context *ctx );
		static DoInitAction* getByName( const char *name );

		std::uint16_t getsprite();
			void setsprite( std::uint16_t );
	List<Action> *getactions();
	

	protected:
		std::uint16_t sprite; // word
List<Action> actions; // list

			static int id;
		
};

class SoundStreamBlock : public Tag {
	public:
		SoundStreamBlock();
		virtual ~SoundStreamBlock();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SoundStreamBlock* get( Reader *r, int end, Context *ctx );
		static SoundStreamBlock* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class DefineVideoStream : public Tag {
	public:
		DefineVideoStream();
		virtual ~DefineVideoStream();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineVideoStream* get( Reader *r, int end, Context *ctx );
		static DefineVideoStream* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint16_t getframes();
			void setframes( std::uint16_t );
	std::uint16_t getwidth();
			void setwidth( std::uint16_t );
	std::uint16_t getheight();
			void setheight( std::uint16_t );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	std::int32_t getdeblocking();
			void setdeblocking( std::int32_t );
	bool getsmoothing();
			void setsmoothing( bool );
	std::uint8_t getcodec();
			void setcodec( std::uint8_t );
	

	protected:
		std::uint16_t objectID; // word
std::uint16_t frames; // word
std::uint16_t width; // word
std::uint16_t height; // word
std::int32_t reserved; // integer
std::int32_t deblocking; // integer
bool smoothing; // bit
std::uint8_t codec; // byte

			static int id;
		
};

class VideoFrame : public Tag {
	public:
		VideoFrame();
		virtual ~VideoFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static VideoFrame* get( Reader *r, int end, Context *ctx );
		static VideoFrame* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint16_t getframe();
			void setframe( std::uint16_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
std::uint16_t frame; // word
Rest data; // object

			static int id;
		
};

class ScriptLimits : public Tag {
	public:
		ScriptLimits();
		virtual ~ScriptLimits();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ScriptLimits* get( Reader *r, int end, Context *ctx );
		static ScriptLimits* getByName( const char *name );

		std::uint16_t getmaxRecursionDepth();
			void setmaxRecursionDepth( std::uint16_t );
	std::uint16_t gettimeout();
			void settimeout( std::uint16_t );
	

	protected:
		std::uint16_t maxRecursionDepth; // word
std::uint16_t timeout; // word

			static int id;
		
};

class SetTabIndex : public Tag {
	public:
		SetTabIndex();
		virtual ~SetTabIndex();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetTabIndex* get( Reader *r, int end, Context *ctx );
		static SetTabIndex* getByName( const char *name );

		std::uint16_t getdepth();
			void setdepth( std::uint16_t );
	std::uint16_t gettabIndex();
			void settabIndex( std::uint16_t );
	

	protected:
		std::uint16_t depth; // word
std::uint16_t tabIndex; // word

			static int id;
		
};

class PlaceObject3 : public Tag {
	public:
		PlaceObject3();
		virtual ~PlaceObject3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PlaceObject3* get( Reader *r, int end, Context *ctx );
		static PlaceObject3* getByName( const char *name );

		bool gethasEventHandler();
			void sethasEventHandler( bool );
	bool gethasClipDepth();
			void sethasClipDepth( bool );
	bool gethasName();
			void sethasName( bool );
	bool gethasMorph();
			void sethasMorph( bool );
	bool gethasColorTransform();
			void sethasColorTransform( bool );
	bool gethasTransform();
			void sethasTransform( bool );
	bool gethasID();
			void sethasID( bool );
	bool getreplace();
			void setreplace( bool );
	std::int32_t getreserved1();
			void setreserved1( std::int32_t );
	bool gethasCacheAsBitmap();
			void sethasCacheAsBitmap( bool );
	bool gethasBlendMode();
			void sethasBlendMode( bool );
	bool gethasFilterList();
			void sethasFilterList( bool );
	std::uint16_t getdepth();
			void setdepth( std::uint16_t );
	std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Transform *gettransform();
	ColorTransform2 *getcolorTransform();
	std::uint16_t getmorph();
			void setmorph( std::uint16_t );
	char * getname();
			void setname( char * );
	std::uint16_t getclipDepth();
			void setclipDepth( std::uint16_t );
	std::uint8_t getnumFilters();
			void setnumFilters( std::uint8_t );
	List<Filter> *getfilters();
	std::uint8_t getblendMode();
			void setblendMode( std::uint8_t );
	std::uint8_t getbitmapCaching();
			void setbitmapCaching( std::uint8_t );
	std::uint16_t getreserved();
			void setreserved( std::uint16_t );
	std::uint16_t getallflags1();
			void setallflags1( std::uint16_t );
	std::uint16_t getallflags2();
			void setallflags2( std::uint16_t );
	List<Event> *getevents();
	

	protected:
		bool hasEventHandler; // bit
bool hasClipDepth; // bit
bool hasName; // bit
bool hasMorph; // bit
bool hasColorTransform; // bit
bool hasTransform; // bit
bool hasID; // bit
bool replace; // bit
std::int32_t reserved1; // integer
bool hasCacheAsBitmap; // bit
bool hasBlendMode; // bit
bool hasFilterList; // bit
std::uint16_t depth; // word
std::uint16_t objectID; // word
Transform transform; // object
ColorTransform2 colorTransform; // object
std::uint16_t morph; // word
char * name; // string
std::uint16_t clipDepth; // word
std::uint8_t numFilters; // byte
List<Filter> filters; // list
std::uint8_t blendMode; // byte
std::uint8_t bitmapCaching; // byte
std::uint16_t reserved; // word
std::uint16_t allflags1; // word
std::uint16_t allflags2; // word
List<Event> events; // list

			static int id;
		
};

class ImportAssets2 : public Tag {
	public:
		ImportAssets2();
		virtual ~ImportAssets2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ImportAssets2* get( Reader *r, int end, Context *ctx );
		static ImportAssets2* getByName( const char *name );

		char * geturl();
			void seturl( char * );
	std::uint8_t getreserved1();
			void setreserved1( std::uint8_t );
	std::uint8_t getreserved2();
			void setreserved2( std::uint8_t );
	std::uint16_t getcount();
			void setcount( std::uint16_t );
	List<Symbol> *getsymbols();
	

	protected:
		char * url; // string
std::uint8_t reserved1; // byte
std::uint8_t reserved2; // byte
std::uint16_t count; // word
List<Symbol> symbols; // list

			static int id;
		
};

class FileAttributes : public Tag {
	public:
		FileAttributes();
		virtual ~FileAttributes();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static FileAttributes* get( Reader *r, int end, Context *ctx );
		static FileAttributes* getByName( const char *name );

		std::int32_t getreserved1();
			void setreserved1( std::int32_t );
	bool gethasMetaData();
			void sethasMetaData( bool );
	std::int32_t getreserved2();
			void setreserved2( std::int32_t );
	bool getallowABC();
			void setallowABC( bool );
	bool getsuppressCrossDomainCaching();
			void setsuppressCrossDomainCaching( bool );
	bool getswfRelativeURLs();
			void setswfRelativeURLs( bool );
	bool getuseNetwork();
			void setuseNetwork( bool );
	std::int32_t getreserved3();
			void setreserved3( std::int32_t );
	

	protected:
		std::int32_t reserved1; // integer
bool hasMetaData; // bit
std::int32_t reserved2; // integer
bool allowABC; // bit
bool suppressCrossDomainCaching; // bit
bool swfRelativeURLs; // bit
bool useNetwork; // bit
std::int32_t reserved3; // integer

			static int id;
		
};

class DefineFontAlignZones : public Tag {
	public:
		DefineFontAlignZones();
		virtual ~DefineFontAlignZones();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFontAlignZones* get( Reader *r, int end, Context *ctx );
		static DefineFontAlignZones* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::int32_t getcsmTableHint();
			void setcsmTableHint( std::int32_t );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	List<ZoneArray> *getzoneArrays();
	

	protected:
		std::uint16_t objectID; // word
std::int32_t csmTableHint; // integer
std::int32_t reserved; // integer
List<ZoneArray> zoneArrays; // list

			static int id;
		
};

class CSMTextSettings : public Tag {
	public:
		CSMTextSettings();
		virtual ~CSMTextSettings();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CSMTextSettings* get( Reader *r, int end, Context *ctx );
		static CSMTextSettings* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::int32_t getuseFlashType();
			void setuseFlashType( std::int32_t );
	std::int32_t getgridFit();
			void setgridFit( std::int32_t );
	std::int32_t getreserved1();
			void setreserved1( std::int32_t );
	float getthickness();
			void setthickness( float );
	float getsharpness();
			void setsharpness( float );
	std::uint8_t getreserved2();
			void setreserved2( std::uint8_t );
	

	protected:
		std::uint16_t objectID; // word
std::int32_t useFlashType; // integer
std::int32_t gridFit; // integer
std::int32_t reserved1; // integer
float thickness; // float
float sharpness; // float
std::uint8_t reserved2; // byte

			static int id;
		
};

class Metadata : public Tag {
	public:
		Metadata();
		virtual ~Metadata();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Metadata* get( Reader *r, int end, Context *ctx );
		static Metadata* getByName( const char *name );

		char * getRDF();
			void setRDF( char * );
	

	protected:
		char * RDF; // xml

			static int id;
		
};

class DefineScalingGrid : public Tag {
	public:
		DefineScalingGrid();
		virtual ~DefineScalingGrid();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineScalingGrid* get( Reader *r, int end, Context *ctx );
		static DefineScalingGrid* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	Rectangle *getsplitter();
	

	protected:
		std::uint16_t objectID; // word
Rectangle splitter; // object

			static int id;
		
};

class DoABC : public Tag {
	public:
		DoABC();
		virtual ~DoABC();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DoABC* get( Reader *r, int end, Context *ctx );
		static DoABC* getByName( const char *name );

		Action3 *getactions();
	

	protected:
		Action3 actions; // object

			static int id;
		
};

class DoABCDefine : public Tag {
	public:
		DoABCDefine();
		virtual ~DoABCDefine();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DoABCDefine* get( Reader *r, int end, Context *ctx );
		static DoABCDefine* getByName( const char *name );

		std::uint32_t getflags();
			void setflags( std::uint32_t );
	char * getname();
			void setname( char * );
	Action3 *getactions();
	

	protected:
		std::uint32_t flags; // uint32
char * name; // string
Action3 actions; // object

			static int id;
		
};

class SymbolClass : public Tag {
	public:
		SymbolClass();
		virtual ~SymbolClass();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SymbolClass* get( Reader *r, int end, Context *ctx );
		static SymbolClass* getByName( const char *name );

		std::uint16_t getcount();
			void setcount( std::uint16_t );
	List<Symbol> *getsymbols();
	

	protected:
		std::uint16_t count; // word
List<Symbol> symbols; // list

			static int id;
		
};

class DefineSceneAndFrameLabelData : public Tag {
	public:
		DefineSceneAndFrameLabelData();
		virtual ~DefineSceneAndFrameLabelData();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineSceneAndFrameLabelData* get( Reader *r, int end, Context *ctx );
		static DefineSceneAndFrameLabelData* getByName( const char *name );

		std::uint32_t getsceneCount();
			void setsceneCount( std::uint32_t );
	List<Scene> *getscenes();
	std::uint32_t getframeCount();
			void setframeCount( std::uint32_t );
	List<Frame> *getframes();
	

	protected:
		std::uint32_t sceneCount; // encodedu32
List<Scene> scenes; // list
std::uint32_t frameCount; // encodedu32
List<Frame> frames; // list

			static int id;
		
};

class DefineBinaryData : public Tag {
	public:
		DefineBinaryData();
		virtual ~DefineBinaryData();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBinaryData* get( Reader *r, int end, Context *ctx );
		static DefineBinaryData* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	std::uint32_t getreserved();
			void setreserved( std::uint32_t );
	Rest *getdata();
	

	protected:
		std::uint16_t objectID; // word
std::uint32_t reserved; // uint32
Rest data; // object

			static int id;
		
};

class DefineFontName : public Tag {
	public:
		DefineFontName();
		virtual ~DefineFontName();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFontName* get( Reader *r, int end, Context *ctx );
		static DefineFontName* getByName( const char *name );

		std::uint16_t getobjectID();
			void setobjectID( std::uint16_t );
	char * getname();
			void setname( char * );
	char * getcopyright();
			void setcopyright( char * );
	

	protected:
		std::uint16_t objectID; // word
char * name; // string
char * copyright; // string

			static int id;
		
};

class EnableDebugger : public Tag {
	public:
		EnableDebugger();
		virtual ~EnableDebugger();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EnableDebugger* get( Reader *r, int end, Context *ctx );
		static EnableDebugger* getByName( const char *name );

		char * getpassword();
			void setpassword( char * );
	

	protected:
		char * password; // string

			static int id;
		
};

class EnableDebugger2 : public Tag {
	public:
		EnableDebugger2();
		virtual ~EnableDebugger2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EnableDebugger2* get( Reader *r, int end, Context *ctx );
		static EnableDebugger2* getByName( const char *name );

		std::uint16_t getreserved();
			void setreserved( std::uint16_t );
	char * getpassword();
			void setpassword( char * );
	

	protected:
		std::uint16_t reserved; // word
char * password; // string

			static int id;
		
};

class StackString : public StackItem {
	public:
		StackString();
		virtual ~StackString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackString* get( Reader *r, int end, Context *ctx );
		static StackString* getByName( const char *name );

		char * getvalue();
			void setvalue( char * );
	

	protected:
		char * value; // string

			static int id;
		
};

class StackFloat : public StackItem {
	public:
		StackFloat();
		virtual ~StackFloat();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackFloat* get( Reader *r, int end, Context *ctx );
		static StackFloat* getByName( const char *name );

		float getvalue();
			void setvalue( float );
	

	protected:
		float value; // float

			static int id;
		
};

class StackNull : public StackItem {
	public:
		StackNull();
		virtual ~StackNull();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackNull* get( Reader *r, int end, Context *ctx );
		static StackNull* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StackUndefined : public StackItem {
	public:
		StackUndefined();
		virtual ~StackUndefined();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackUndefined* get( Reader *r, int end, Context *ctx );
		static StackUndefined* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StackRegister : public StackItem {
	public:
		StackRegister();
		virtual ~StackRegister();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackRegister* get( Reader *r, int end, Context *ctx );
		static StackRegister* getByName( const char *name );

		std::uint8_t getreg();
			void setreg( std::uint8_t );
	

	protected:
		std::uint8_t reg; // byte

			static int id;
		
};

class StackBoolean : public StackItem {
	public:
		StackBoolean();
		virtual ~StackBoolean();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackBoolean* get( Reader *r, int end, Context *ctx );
		static StackBoolean* getByName( const char *name );

		std::uint8_t getvalue();
			void setvalue( std::uint8_t );
	

	protected:
		std::uint8_t value; // byte

			static int id;
		
};

class StackDouble : public StackItem {
	public:
		StackDouble();
		virtual ~StackDouble();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackDouble* get( Reader *r, int end, Context *ctx );
		static StackDouble* getByName( const char *name );

		double getvalue();
			void setvalue( double );
	

	protected:
		double value; // double

			static int id;
		
};

class StackInteger : public StackItem {
	public:
		StackInteger();
		virtual ~StackInteger();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackInteger* get( Reader *r, int end, Context *ctx );
		static StackInteger* getByName( const char *name );

		std::uint32_t getvalue();
			void setvalue( std::uint32_t );
	

	protected:
		std::uint32_t value; // uint32

			static int id;
		
};

class StackDictionaryLookup : public StackItem {
	public:
		StackDictionaryLookup();
		virtual ~StackDictionaryLookup();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackDictionaryLookup* get( Reader *r, int end, Context *ctx );
		static StackDictionaryLookup* getByName( const char *name );

		std::uint8_t getindex();
			void setindex( std::uint8_t );
	

	protected:
		std::uint8_t index; // byte

			static int id;
		
};

class StackLargeDictionaryLookup : public StackItem {
	public:
		StackLargeDictionaryLookup();
		virtual ~StackLargeDictionaryLookup();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackLargeDictionaryLookup* get( Reader *r, int end, Context *ctx );
		static StackLargeDictionaryLookup* getByName( const char *name );

		std::uint16_t getindex();
			void setindex( std::uint16_t );
	

	protected:
		std::uint16_t index; // word

			static int id;
		
};

class UnknownAction : public Action {
	public:
		UnknownAction();
		virtual ~UnknownAction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UnknownAction* get( Reader *r, int end, Context *ctx );
		static UnknownAction* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class EndAction : public Action {
	public:
		EndAction();
		virtual ~EndAction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EndAction* get( Reader *r, int end, Context *ctx );
		static EndAction* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class NextFrame : public Action {
	public:
		NextFrame();
		virtual ~NextFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static NextFrame* get( Reader *r, int end, Context *ctx );
		static NextFrame* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class PreviousFrame : public Action {
	public:
		PreviousFrame();
		virtual ~PreviousFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PreviousFrame* get( Reader *r, int end, Context *ctx );
		static PreviousFrame* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Play : public Action {
	public:
		Play();
		virtual ~Play();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Play* get( Reader *r, int end, Context *ctx );
		static Play* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Stop : public Action {
	public:
		Stop();
		virtual ~Stop();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Stop* get( Reader *r, int end, Context *ctx );
		static Stop* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ToggleQuality : public Action {
	public:
		ToggleQuality();
		virtual ~ToggleQuality();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ToggleQuality* get( Reader *r, int end, Context *ctx );
		static ToggleQuality* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StopSound : public Action {
	public:
		StopSound();
		virtual ~StopSound();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StopSound* get( Reader *r, int end, Context *ctx );
		static StopSound* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class AddCast : public Action {
	public:
		AddCast();
		virtual ~AddCast();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static AddCast* get( Reader *r, int end, Context *ctx );
		static AddCast* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Substract : public Action {
	public:
		Substract();
		virtual ~Substract();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Substract* get( Reader *r, int end, Context *ctx );
		static Substract* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Mulitply : public Action {
	public:
		Mulitply();
		virtual ~Mulitply();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Mulitply* get( Reader *r, int end, Context *ctx );
		static Mulitply* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Divide : public Action {
	public:
		Divide();
		virtual ~Divide();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Divide* get( Reader *r, int end, Context *ctx );
		static Divide* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class EqualCast : public Action {
	public:
		EqualCast();
		virtual ~EqualCast();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EqualCast* get( Reader *r, int end, Context *ctx );
		static EqualCast* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LessThanCast : public Action {
	public:
		LessThanCast();
		virtual ~LessThanCast();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LessThanCast* get( Reader *r, int end, Context *ctx );
		static LessThanCast* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LogicalAND : public Action {
	public:
		LogicalAND();
		virtual ~LogicalAND();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LogicalAND* get( Reader *r, int end, Context *ctx );
		static LogicalAND* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LogicalOR : public Action {
	public:
		LogicalOR();
		virtual ~LogicalOR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LogicalOR* get( Reader *r, int end, Context *ctx );
		static LogicalOR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LogicalNOT : public Action {
	public:
		LogicalNOT();
		virtual ~LogicalNOT();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LogicalNOT* get( Reader *r, int end, Context *ctx );
		static LogicalNOT* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StringEqual : public Action {
	public:
		StringEqual();
		virtual ~StringEqual();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StringEqual* get( Reader *r, int end, Context *ctx );
		static StringEqual* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StringLength : public Action {
	public:
		StringLength();
		virtual ~StringLength();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StringLength* get( Reader *r, int end, Context *ctx );
		static StringLength* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SubString : public Action {
	public:
		SubString();
		virtual ~SubString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SubString* get( Reader *r, int end, Context *ctx );
		static SubString* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Pop : public Action {
	public:
		Pop();
		virtual ~Pop();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Pop* get( Reader *r, int end, Context *ctx );
		static Pop* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class IntegralPart : public Action {
	public:
		IntegralPart();
		virtual ~IntegralPart();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static IntegralPart* get( Reader *r, int end, Context *ctx );
		static IntegralPart* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetVariable : public Action {
	public:
		GetVariable();
		virtual ~GetVariable();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetVariable* get( Reader *r, int end, Context *ctx );
		static GetVariable* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetVariable : public Action {
	public:
		SetVariable();
		virtual ~SetVariable();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetVariable* get( Reader *r, int end, Context *ctx );
		static SetVariable* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetTargetDynamic : public Action {
	public:
		SetTargetDynamic();
		virtual ~SetTargetDynamic();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetTargetDynamic* get( Reader *r, int end, Context *ctx );
		static SetTargetDynamic* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ConcatenateString : public Action {
	public:
		ConcatenateString();
		virtual ~ConcatenateString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ConcatenateString* get( Reader *r, int end, Context *ctx );
		static ConcatenateString* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetProperty : public Action {
	public:
		GetProperty();
		virtual ~GetProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetProperty* get( Reader *r, int end, Context *ctx );
		static GetProperty* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetProperty : public Action {
	public:
		SetProperty();
		virtual ~SetProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetProperty* get( Reader *r, int end, Context *ctx );
		static SetProperty* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DuplicateSprite : public Action {
	public:
		DuplicateSprite();
		virtual ~DuplicateSprite();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DuplicateSprite* get( Reader *r, int end, Context *ctx );
		static DuplicateSprite* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class RemoveSprite : public Action {
	public:
		RemoveSprite();
		virtual ~RemoveSprite();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RemoveSprite* get( Reader *r, int end, Context *ctx );
		static RemoveSprite* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Trace : public Action {
	public:
		Trace();
		virtual ~Trace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Trace* get( Reader *r, int end, Context *ctx );
		static Trace* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StartDrag : public Action {
	public:
		StartDrag();
		virtual ~StartDrag();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StartDrag* get( Reader *r, int end, Context *ctx );
		static StartDrag* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StopDrag : public Action {
	public:
		StopDrag();
		virtual ~StopDrag();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StopDrag* get( Reader *r, int end, Context *ctx );
		static StopDrag* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StringLessThan : public Action {
	public:
		StringLessThan();
		virtual ~StringLessThan();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StringLessThan* get( Reader *r, int end, Context *ctx );
		static StringLessThan* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Throw : public Action {
	public:
		Throw();
		virtual ~Throw();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Throw* get( Reader *r, int end, Context *ctx );
		static Throw* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class CastObject : public Action {
	public:
		CastObject();
		virtual ~CastObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CastObject* get( Reader *r, int end, Context *ctx );
		static CastObject* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Implements : public Action {
	public:
		Implements();
		virtual ~Implements();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Implements* get( Reader *r, int end, Context *ctx );
		static Implements* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Random : public Action {
	public:
		Random();
		virtual ~Random();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Random* get( Reader *r, int end, Context *ctx );
		static Random* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class MultibyteStringLength : public Action {
	public:
		MultibyteStringLength();
		virtual ~MultibyteStringLength();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultibyteStringLength* get( Reader *r, int end, Context *ctx );
		static MultibyteStringLength* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ORD : public Action {
	public:
		ORD();
		virtual ~ORD();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ORD* get( Reader *r, int end, Context *ctx );
		static ORD* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class CHR : public Action {
	public:
		CHR();
		virtual ~CHR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CHR* get( Reader *r, int end, Context *ctx );
		static CHR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetTimer : public Action {
	public:
		GetTimer();
		virtual ~GetTimer();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetTimer* get( Reader *r, int end, Context *ctx );
		static GetTimer* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class MultibyteSubString : public Action {
	public:
		MultibyteSubString();
		virtual ~MultibyteSubString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultibyteSubString* get( Reader *r, int end, Context *ctx );
		static MultibyteSubString* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class MultibyteORD : public Action {
	public:
		MultibyteORD();
		virtual ~MultibyteORD();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultibyteORD* get( Reader *r, int end, Context *ctx );
		static MultibyteORD* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class MultibyteCHR : public Action {
	public:
		MultibyteCHR();
		virtual ~MultibyteCHR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultibyteCHR* get( Reader *r, int end, Context *ctx );
		static MultibyteCHR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Delete : public Action {
	public:
		Delete();
		virtual ~Delete();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Delete* get( Reader *r, int end, Context *ctx );
		static Delete* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DeleteAll : public Action {
	public:
		DeleteAll();
		virtual ~DeleteAll();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeleteAll* get( Reader *r, int end, Context *ctx );
		static DeleteAll* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetLocalVariable : public Action {
	public:
		SetLocalVariable();
		virtual ~SetLocalVariable();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetLocalVariable* get( Reader *r, int end, Context *ctx );
		static SetLocalVariable* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class CallFunction : public Action {
	public:
		CallFunction();
		virtual ~CallFunction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CallFunction* get( Reader *r, int end, Context *ctx );
		static CallFunction* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Return : public Action {
	public:
		Return();
		virtual ~Return();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Return* get( Reader *r, int end, Context *ctx );
		static Return* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Modulo : public Action {
	public:
		Modulo();
		virtual ~Modulo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Modulo* get( Reader *r, int end, Context *ctx );
		static Modulo* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class New : public Action {
	public:
		New();
		virtual ~New();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static New* get( Reader *r, int end, Context *ctx );
		static New* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DeclareLocalVariable : public Action {
	public:
		DeclareLocalVariable();
		virtual ~DeclareLocalVariable();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareLocalVariable* get( Reader *r, int end, Context *ctx );
		static DeclareLocalVariable* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DeclareArray : public Action {
	public:
		DeclareArray();
		virtual ~DeclareArray();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareArray* get( Reader *r, int end, Context *ctx );
		static DeclareArray* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DeclareObject : public Action {
	public:
		DeclareObject();
		virtual ~DeclareObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareObject* get( Reader *r, int end, Context *ctx );
		static DeclareObject* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class TypeOf : public Action {
	public:
		TypeOf();
		virtual ~TypeOf();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TypeOf* get( Reader *r, int end, Context *ctx );
		static TypeOf* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetTarget : public Action {
	public:
		GetTarget();
		virtual ~GetTarget();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetTarget* get( Reader *r, int end, Context *ctx );
		static GetTarget* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Enumerate : public Action {
	public:
		Enumerate();
		virtual ~Enumerate();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Enumerate* get( Reader *r, int end, Context *ctx );
		static Enumerate* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class AddTyped : public Action {
	public:
		AddTyped();
		virtual ~AddTyped();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static AddTyped* get( Reader *r, int end, Context *ctx );
		static AddTyped* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LessThanTyped : public Action {
	public:
		LessThanTyped();
		virtual ~LessThanTyped();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LessThanTyped* get( Reader *r, int end, Context *ctx );
		static LessThanTyped* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class EqualTyped : public Action {
	public:
		EqualTyped();
		virtual ~EqualTyped();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EqualTyped* get( Reader *r, int end, Context *ctx );
		static EqualTyped* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DefineNumber : public Action {
	public:
		DefineNumber();
		virtual ~DefineNumber();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineNumber* get( Reader *r, int end, Context *ctx );
		static DefineNumber* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DefineString : public Action {
	public:
		DefineString();
		virtual ~DefineString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineString* get( Reader *r, int end, Context *ctx );
		static DefineString* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Duplicate : public Action {
	public:
		Duplicate();
		virtual ~Duplicate();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Duplicate* get( Reader *r, int end, Context *ctx );
		static Duplicate* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Swap : public Action {
	public:
		Swap();
		virtual ~Swap();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Swap* get( Reader *r, int end, Context *ctx );
		static Swap* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetMember : public Action {
	public:
		GetMember();
		virtual ~GetMember();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetMember* get( Reader *r, int end, Context *ctx );
		static GetMember* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetMember : public Action {
	public:
		SetMember();
		virtual ~SetMember();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetMember* get( Reader *r, int end, Context *ctx );
		static SetMember* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Increment : public Action {
	public:
		Increment();
		virtual ~Increment();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Increment* get( Reader *r, int end, Context *ctx );
		static Increment* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Decrement : public Action {
	public:
		Decrement();
		virtual ~Decrement();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Decrement* get( Reader *r, int end, Context *ctx );
		static Decrement* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class CallMethod : public Action {
	public:
		CallMethod();
		virtual ~CallMethod();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CallMethod* get( Reader *r, int end, Context *ctx );
		static CallMethod* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class NewMethod : public Action {
	public:
		NewMethod();
		virtual ~NewMethod();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static NewMethod* get( Reader *r, int end, Context *ctx );
		static NewMethod* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class InstanceOf : public Action {
	public:
		InstanceOf();
		virtual ~InstanceOf();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static InstanceOf* get( Reader *r, int end, Context *ctx );
		static InstanceOf* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class EnumerateObject : public Action {
	public:
		EnumerateObject();
		virtual ~EnumerateObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EnumerateObject* get( Reader *r, int end, Context *ctx );
		static EnumerateObject* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class AND : public Action {
	public:
		AND();
		virtual ~AND();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static AND* get( Reader *r, int end, Context *ctx );
		static AND* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OR : public Action {
	public:
		OR();
		virtual ~OR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OR* get( Reader *r, int end, Context *ctx );
		static OR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class XOR : public Action {
	public:
		XOR();
		virtual ~XOR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static XOR* get( Reader *r, int end, Context *ctx );
		static XOR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ShiftLeft : public Action {
	public:
		ShiftLeft();
		virtual ~ShiftLeft();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShiftLeft* get( Reader *r, int end, Context *ctx );
		static ShiftLeft* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ShiftRight : public Action {
	public:
		ShiftRight();
		virtual ~ShiftRight();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShiftRight* get( Reader *r, int end, Context *ctx );
		static ShiftRight* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ShiftRightUnsigned : public Action {
	public:
		ShiftRightUnsigned();
		virtual ~ShiftRightUnsigned();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShiftRightUnsigned* get( Reader *r, int end, Context *ctx );
		static ShiftRightUnsigned* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StrictEqual : public Action {
	public:
		StrictEqual();
		virtual ~StrictEqual();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StrictEqual* get( Reader *r, int end, Context *ctx );
		static StrictEqual* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GreaterThanTyped : public Action {
	public:
		GreaterThanTyped();
		virtual ~GreaterThanTyped();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GreaterThanTyped* get( Reader *r, int end, Context *ctx );
		static GreaterThanTyped* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StringGreaterThan : public Action {
	public:
		StringGreaterThan();
		virtual ~StringGreaterThan();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StringGreaterThan* get( Reader *r, int end, Context *ctx );
		static StringGreaterThan* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Extends : public Action {
	public:
		Extends();
		virtual ~Extends();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Extends* get( Reader *r, int end, Context *ctx );
		static Extends* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GotoFrame : public Action {
	public:
		GotoFrame();
		virtual ~GotoFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GotoFrame* get( Reader *r, int end, Context *ctx );
		static GotoFrame* getByName( const char *name );

		std::uint16_t getframe();
			void setframe( std::uint16_t );
	

	protected:
		std::uint16_t frame; // word

			static int id;
		
};

class GetURL : public Action {
	public:
		GetURL();
		virtual ~GetURL();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetURL* get( Reader *r, int end, Context *ctx );
		static GetURL* getByName( const char *name );

		char * geturl();
			void seturl( char * );
	char * gettarget();
			void settarget( char * );
	

	protected:
		char * url; // string
char * target; // string

			static int id;
		
};

class StoreRegister : public Action {
	public:
		StoreRegister();
		virtual ~StoreRegister();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StoreRegister* get( Reader *r, int end, Context *ctx );
		static StoreRegister* getByName( const char *name );

		std::uint8_t getreg();
			void setreg( std::uint8_t );
	

	protected:
		std::uint8_t reg; // byte

			static int id;
		
};

class Dictionary : public Action {
	public:
		Dictionary();
		virtual ~Dictionary();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Dictionary* get( Reader *r, int end, Context *ctx );
		static Dictionary* getByName( const char *name );

		std::uint16_t getlength();
			void setlength( std::uint16_t );
	List<String> *getstrings();
	

	protected:
		std::uint16_t length; // word
List<String> strings; // list

			static int id;
		
};

class WaitForFrame : public Action {
	public:
		WaitForFrame();
		virtual ~WaitForFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static WaitForFrame* get( Reader *r, int end, Context *ctx );
		static WaitForFrame* getByName( const char *name );

		std::uint16_t getframe();
			void setframe( std::uint16_t );
	std::uint8_t getskip();
			void setskip( std::uint8_t );
	

	protected:
		std::uint16_t frame; // word
std::uint8_t skip; // byte

			static int id;
		
};

class SetTarget : public Action {
	public:
		SetTarget();
		virtual ~SetTarget();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetTarget* get( Reader *r, int end, Context *ctx );
		static SetTarget* getByName( const char *name );

		char * getlabel();
			void setlabel( char * );
	

	protected:
		char * label; // string

			static int id;
		
};

class GotoLabel : public Action {
	public:
		GotoLabel();
		virtual ~GotoLabel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GotoLabel* get( Reader *r, int end, Context *ctx );
		static GotoLabel* getByName( const char *name );

		char * getlabel();
			void setlabel( char * );
	

	protected:
		char * label; // string

			static int id;
		
};

class WaitForFrameDynamic : public Action {
	public:
		WaitForFrameDynamic();
		virtual ~WaitForFrameDynamic();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static WaitForFrameDynamic* get( Reader *r, int end, Context *ctx );
		static WaitForFrameDynamic* getByName( const char *name );

		std::uint16_t getframe();
			void setframe( std::uint16_t );
	std::uint8_t getskip();
			void setskip( std::uint8_t );
	

	protected:
		std::uint16_t frame; // word
std::uint8_t skip; // byte

			static int id;
		
};

class DeclareFunction2 : public Action {
	public:
		DeclareFunction2();
		virtual ~DeclareFunction2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareFunction2* get( Reader *r, int end, Context *ctx );
		static DeclareFunction2* getByName( const char *name );

		char * getname();
			void setname( char * );
	std::uint16_t getargc();
			void setargc( std::uint16_t );
	std::uint8_t getregc();
			void setregc( std::uint8_t );
	bool getpreloadParent();
			void setpreloadParent( bool );
	bool getpreloadRoot();
			void setpreloadRoot( bool );
	bool getsuppressSuper();
			void setsuppressSuper( bool );
	bool getpreloadSuper();
			void setpreloadSuper( bool );
	bool getsuppressArguments();
			void setsuppressArguments( bool );
	bool getpreloadArguments();
			void setpreloadArguments( bool );
	bool getsuppressThis();
			void setsuppressThis( bool );
	bool getpreloadThis();
			void setpreloadThis( bool );
	std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getpreloadGlobal();
			void setpreloadGlobal( bool );
	List<Parameter> *getargs();
	std::uint16_t getlength();
			void setlength( std::uint16_t );
	List<Action> *getactions();
	

	protected:
		char * name; // string
std::uint16_t argc; // word
std::uint8_t regc; // byte
bool preloadParent; // bit
bool preloadRoot; // bit
bool suppressSuper; // bit
bool preloadSuper; // bit
bool suppressArguments; // bit
bool preloadArguments; // bit
bool suppressThis; // bit
bool preloadThis; // bit
std::int32_t reserved; // integer
bool preloadGlobal; // bit
List<Parameter> args; // list
std::uint16_t length; // word
List<Action> actions; // list

			static int id;
		
};

class Try : public Action {
	public:
		Try();
		virtual ~Try();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Try* get( Reader *r, int end, Context *ctx );
		static Try* getByName( const char *name );

		std::int32_t getreserved();
			void setreserved( std::int32_t );
	bool getcatchInRegister();
			void setcatchInRegister( bool );
	bool getdoFinally();
			void setdoFinally( bool );
	bool getdoCatch();
			void setdoCatch( bool );
	std::uint16_t gettrySize();
			void settrySize( std::uint16_t );
	std::uint16_t getcatchSize();
			void setcatchSize( std::uint16_t );
	std::uint16_t getfinallySize();
			void setfinallySize( std::uint16_t );
	std::uint8_t getreg();
			void setreg( std::uint8_t );
	

	protected:
		std::int32_t reserved; // integer
bool catchInRegister; // bit
bool doFinally; // bit
bool doCatch; // bit
std::uint16_t trySize; // word
std::uint16_t catchSize; // word
std::uint16_t finallySize; // word
std::uint8_t reg; // byte

			static int id;
		
};

class With : public Action {
	public:
		With();
		virtual ~With();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static With* get( Reader *r, int end, Context *ctx );
		static With* getByName( const char *name );

		std::uint16_t getsize();
			void setsize( std::uint16_t );
	

	protected:
		std::uint16_t size; // word

			static int id;
		
};

class PushData : public Action {
	public:
		PushData();
		virtual ~PushData();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PushData* get( Reader *r, int end, Context *ctx );
		static PushData* getByName( const char *name );

		List<StackItem> *getitems();
	

	protected:
		List<StackItem> items; // list

			static int id;
		
};

class GetURL2 : public Action {
	public:
		GetURL2();
		virtual ~GetURL2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetURL2* get( Reader *r, int end, Context *ctx );
		static GetURL2* getByName( const char *name );

		std::uint8_t getmethod();
			void setmethod( std::uint8_t );
	

	protected:
		std::uint8_t method; // byte

			static int id;
		
};

class DeclareFunction : public Action {
	public:
		DeclareFunction();
		virtual ~DeclareFunction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareFunction* get( Reader *r, int end, Context *ctx );
		static DeclareFunction* getByName( const char *name );

		char * getname();
			void setname( char * );
	std::uint16_t getargc();
			void setargc( std::uint16_t );
	List<String> *getargs();
	std::uint16_t getlength();
			void setlength( std::uint16_t );
	

	protected:
		char * name; // string
std::uint16_t argc; // word
List<String> args; // list
std::uint16_t length; // word

			static int id;
		
};

class BranchAlways : public Action {
	public:
		BranchAlways();
		virtual ~BranchAlways();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static BranchAlways* get( Reader *r, int end, Context *ctx );
		static BranchAlways* getByName( const char *name );

		std::uint16_t getbyteOffset();
			void setbyteOffset( std::uint16_t );
	

	protected:
		std::uint16_t byteOffset; // word

			static int id;
		
};

class BranchIfTrue : public Action {
	public:
		BranchIfTrue();
		virtual ~BranchIfTrue();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static BranchIfTrue* get( Reader *r, int end, Context *ctx );
		static BranchIfTrue* getByName( const char *name );

		std::uint16_t getbyteOffset();
			void setbyteOffset( std::uint16_t );
	

	protected:
		std::uint16_t byteOffset; // word

			static int id;
		
};

class CallFrame : public Action {
	public:
		CallFrame();
		virtual ~CallFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CallFrame* get( Reader *r, int end, Context *ctx );
		static CallFrame* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GotoExpression : public Action {
	public:
		GotoExpression();
		virtual ~GotoExpression();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GotoExpression* get( Reader *r, int end, Context *ctx );
		static GotoExpression* getByName( const char *name );

		std::uint8_t getplay();
			void setplay( std::uint8_t );
	

	protected:
		std::uint8_t play; // byte

			static int id;
		
};

class PrivateNamespace : public NamespaceConstant {
	public:
		PrivateNamespace();
		virtual ~PrivateNamespace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PrivateNamespace* get( Reader *r, int end, Context *ctx );
		static PrivateNamespace* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class Namespace : public NamespaceConstant {
	public:
		Namespace();
		virtual ~Namespace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Namespace* get( Reader *r, int end, Context *ctx );
		static Namespace* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class PackageNamespace : public NamespaceConstant {
	public:
		PackageNamespace();
		virtual ~PackageNamespace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PackageNamespace* get( Reader *r, int end, Context *ctx );
		static PackageNamespace* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class PackageInternalNamespace : public NamespaceConstant {
	public:
		PackageInternalNamespace();
		virtual ~PackageInternalNamespace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PackageInternalNamespace* get( Reader *r, int end, Context *ctx );
		static PackageInternalNamespace* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class ProtectedNamespace : public NamespaceConstant {
	public:
		ProtectedNamespace();
		virtual ~ProtectedNamespace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ProtectedNamespace* get( Reader *r, int end, Context *ctx );
		static ProtectedNamespace* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class ExplicitNamespace : public NamespaceConstant {
	public:
		ExplicitNamespace();
		virtual ~ExplicitNamespace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ExplicitNamespace* get( Reader *r, int end, Context *ctx );
		static ExplicitNamespace* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class MultinameLNamespace : public NamespaceConstant {
	public:
		MultinameLNamespace();
		virtual ~MultinameLNamespace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultinameLNamespace* get( Reader *r, int end, Context *ctx );
		static MultinameLNamespace* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class QName : public MultinameConstant {
	public:
		QName();
		virtual ~QName();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static QName* get( Reader *r, int end, Context *ctx );
		static QName* getByName( const char *name );

		std::uint32_t getnamespaceIndex();
			void setnamespaceIndex( std::uint32_t );
	std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	

	protected:
		std::uint32_t namespaceIndex; // u30
std::uint32_t nameIndex; // u30

			static int id;
		
};

class QNameA : public MultinameConstant {
	public:
		QNameA();
		virtual ~QNameA();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static QNameA* get( Reader *r, int end, Context *ctx );
		static QNameA* getByName( const char *name );

		std::uint32_t getnamespaceIndex();
			void setnamespaceIndex( std::uint32_t );
	std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	

	protected:
		std::uint32_t namespaceIndex; // u30
std::uint32_t nameIndex; // u30

			static int id;
		
};

class Multiname : public MultinameConstant {
	public:
		Multiname();
		virtual ~Multiname();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Multiname* get( Reader *r, int end, Context *ctx );
		static Multiname* getByName( const char *name );

		std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	std::uint32_t getnamespaceSetIndex();
			void setnamespaceSetIndex( std::uint32_t );
	

	protected:
		std::uint32_t nameIndex; // u30
std::uint32_t namespaceSetIndex; // u30

			static int id;
		
};

class MultinameA : public MultinameConstant {
	public:
		MultinameA();
		virtual ~MultinameA();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultinameA* get( Reader *r, int end, Context *ctx );
		static MultinameA* getByName( const char *name );

		std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	std::uint32_t getnamespaceSetIndex();
			void setnamespaceSetIndex( std::uint32_t );
	

	protected:
		std::uint32_t nameIndex; // u30
std::uint32_t namespaceSetIndex; // u30

			static int id;
		
};

class RTQName : public MultinameConstant {
	public:
		RTQName();
		virtual ~RTQName();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RTQName* get( Reader *r, int end, Context *ctx );
		static RTQName* getByName( const char *name );

		std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	

	protected:
		std::uint32_t nameIndex; // u30

			static int id;
		
};

class RTQNameA : public MultinameConstant {
	public:
		RTQNameA();
		virtual ~RTQNameA();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RTQNameA* get( Reader *r, int end, Context *ctx );
		static RTQNameA* getByName( const char *name );

		std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	

	protected:
		std::uint32_t nameIndex; // u30

			static int id;
		
};

class MultinameL : public MultinameConstant {
	public:
		MultinameL();
		virtual ~MultinameL();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultinameL* get( Reader *r, int end, Context *ctx );
		static MultinameL* getByName( const char *name );

		std::uint32_t getnamespaceSetIndex();
			void setnamespaceSetIndex( std::uint32_t );
	

	protected:
		std::uint32_t namespaceSetIndex; // u30

			static int id;
		
};

class RTQNameL : public MultinameConstant {
	public:
		RTQNameL();
		virtual ~RTQNameL();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RTQNameL* get( Reader *r, int end, Context *ctx );
		static RTQNameL* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class RTQNameLA : public MultinameConstant {
	public:
		RTQNameLA();
		virtual ~RTQNameLA();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RTQNameLA* get( Reader *r, int end, Context *ctx );
		static RTQNameLA* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class TypeName : public MultinameConstant {
	public:
		TypeName();
		virtual ~TypeName();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TypeName* get( Reader *r, int end, Context *ctx );
		static TypeName* getByName( const char *name );

		std::uint32_t getnameIndex();
			void setnameIndex( std::uint32_t );
	std::uint32_t getnameCount();
			void setnameCount( std::uint32_t );
	List<U30> *gettypes();
	

	protected:
		std::uint32_t nameIndex; // u30
std::uint32_t nameCount; // u30
List<U30> types; // list

			static int id;
		
};

class Slot : public Trait {
	public:
		Slot();
		virtual ~Slot();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Slot* get( Reader *r, int end, Context *ctx );
		static Slot* getByName( const char *name );

		std::uint32_t getslotID();
			void setslotID( std::uint32_t );
	std::uint32_t gettypeIndex();
			void settypeIndex( std::uint32_t );
	std::uint32_t getvalueIndex();
			void setvalueIndex( std::uint32_t );
	std::uint8_t getvalueKind();
			void setvalueKind( std::uint8_t );
	

	protected:
		std::uint32_t slotID; // u30
std::uint32_t typeIndex; // u30
std::uint32_t valueIndex; // u30
std::uint8_t valueKind; // byte

			static int id;
		
};

class Const : public Trait {
	public:
		Const();
		virtual ~Const();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Const* get( Reader *r, int end, Context *ctx );
		static Const* getByName( const char *name );

		std::uint32_t getslotID();
			void setslotID( std::uint32_t );
	std::uint32_t gettypeIndex();
			void settypeIndex( std::uint32_t );
	std::uint32_t getvalueIndex();
			void setvalueIndex( std::uint32_t );
	std::uint8_t getvalueKind();
			void setvalueKind( std::uint8_t );
	

	protected:
		std::uint32_t slotID; // u30
std::uint32_t typeIndex; // u30
std::uint32_t valueIndex; // u30
std::uint8_t valueKind; // byte

			static int id;
		
};

class Method : public Trait {
	public:
		Method();
		virtual ~Method();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Method* get( Reader *r, int end, Context *ctx );
		static Method* getByName( const char *name );

		std::uint32_t getdispID();
			void setdispID( std::uint32_t );
	std::uint32_t getmethodInfo();
			void setmethodInfo( std::uint32_t );
	

	protected:
		std::uint32_t dispID; // u30
std::uint32_t methodInfo; // u30

			static int id;
		
};

class Getter : public Trait {
	public:
		Getter();
		virtual ~Getter();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Getter* get( Reader *r, int end, Context *ctx );
		static Getter* getByName( const char *name );

		std::uint32_t getdispID();
			void setdispID( std::uint32_t );
	std::uint32_t getmethodInfo();
			void setmethodInfo( std::uint32_t );
	

	protected:
		std::uint32_t dispID; // u30
std::uint32_t methodInfo; // u30

			static int id;
		
};

class Setter : public Trait {
	public:
		Setter();
		virtual ~Setter();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Setter* get( Reader *r, int end, Context *ctx );
		static Setter* getByName( const char *name );

		std::uint32_t getdispID();
			void setdispID( std::uint32_t );
	std::uint32_t getmethodInfo();
			void setmethodInfo( std::uint32_t );
	

	protected:
		std::uint32_t dispID; // u30
std::uint32_t methodInfo; // u30

			static int id;
		
};

class Class : public Trait {
	public:
		Class();
		virtual ~Class();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Class* get( Reader *r, int end, Context *ctx );
		static Class* getByName( const char *name );

		std::uint32_t getslotID();
			void setslotID( std::uint32_t );
	std::uint32_t getclassInfo();
			void setclassInfo( std::uint32_t );
	

	protected:
		std::uint32_t slotID; // u30
std::uint32_t classInfo; // u30

			static int id;
		
};

class Function : public Trait {
	public:
		Function();
		virtual ~Function();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Function* get( Reader *r, int end, Context *ctx );
		static Function* getByName( const char *name );

		std::uint32_t getslotID();
			void setslotID( std::uint32_t );
	std::uint32_t getmethodInfo();
			void setmethodInfo( std::uint32_t );
	

	protected:
		std::uint32_t slotID; // u30
std::uint32_t methodInfo; // u30

			static int id;
		
};

class UnknownOpCode : public OpCode {
	public:
		UnknownOpCode();
		virtual ~UnknownOpCode();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UnknownOpCode* get( Reader *r, int end, Context *ctx );
		static UnknownOpCode* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class OpBkPt : public OpCode {
	public:
		OpBkPt();
		virtual ~OpBkPt();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpBkPt* get( Reader *r, int end, Context *ctx );
		static OpBkPt* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpNop : public OpCode {
	public:
		OpNop();
		virtual ~OpNop();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNop* get( Reader *r, int end, Context *ctx );
		static OpNop* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpThrow : public OpCode {
	public:
		OpThrow();
		virtual ~OpThrow();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpThrow* get( Reader *r, int end, Context *ctx );
		static OpThrow* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpGetSuper : public OpCode {
	public:
		OpGetSuper();
		virtual ~OpGetSuper();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetSuper* get( Reader *r, int end, Context *ctx );
		static OpGetSuper* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpSetSuper : public OpCode {
	public:
		OpSetSuper();
		virtual ~OpSetSuper();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetSuper* get( Reader *r, int end, Context *ctx );
		static OpSetSuper* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpDXNs : public OpCode {
	public:
		OpDXNs();
		virtual ~OpDXNs();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDXNs* get( Reader *r, int end, Context *ctx );
		static OpDXNs* getByName( const char *name );

		std::uint32_t getdxns();
			void setdxns( std::uint32_t );
	

	protected:
		std::uint32_t dxns; // u30

			static int id;
		
};

class OpDXNsLate : public OpCode {
	public:
		OpDXNsLate();
		virtual ~OpDXNsLate();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDXNsLate* get( Reader *r, int end, Context *ctx );
		static OpDXNsLate* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpKill : public OpCode {
	public:
		OpKill();
		virtual ~OpKill();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpKill* get( Reader *r, int end, Context *ctx );
		static OpKill* getByName( const char *name );

		std::uint32_t getaddress();
			void setaddress( std::uint32_t );
	

	protected:
		std::uint32_t address; // u30

			static int id;
		
};

class OpLabel : public OpCode {
	public:
		OpLabel();
		virtual ~OpLabel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpLabel* get( Reader *r, int end, Context *ctx );
		static OpLabel* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpIfNlt : public OpCode {
	public:
		OpIfNlt();
		virtual ~OpIfNlt();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfNlt* get( Reader *r, int end, Context *ctx );
		static OpIfNlt* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfNle : public OpCode {
	public:
		OpIfNle();
		virtual ~OpIfNle();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfNle* get( Reader *r, int end, Context *ctx );
		static OpIfNle* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfNgt : public OpCode {
	public:
		OpIfNgt();
		virtual ~OpIfNgt();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfNgt* get( Reader *r, int end, Context *ctx );
		static OpIfNgt* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfNge : public OpCode {
	public:
		OpIfNge();
		virtual ~OpIfNge();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfNge* get( Reader *r, int end, Context *ctx );
		static OpIfNge* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpJump : public OpCode {
	public:
		OpJump();
		virtual ~OpJump();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpJump* get( Reader *r, int end, Context *ctx );
		static OpJump* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfTrue : public OpCode {
	public:
		OpIfTrue();
		virtual ~OpIfTrue();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfTrue* get( Reader *r, int end, Context *ctx );
		static OpIfTrue* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfFalse : public OpCode {
	public:
		OpIfFalse();
		virtual ~OpIfFalse();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfFalse* get( Reader *r, int end, Context *ctx );
		static OpIfFalse* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfEq : public OpCode {
	public:
		OpIfEq();
		virtual ~OpIfEq();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfEq* get( Reader *r, int end, Context *ctx );
		static OpIfEq* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfNe : public OpCode {
	public:
		OpIfNe();
		virtual ~OpIfNe();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfNe* get( Reader *r, int end, Context *ctx );
		static OpIfNe* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfLt : public OpCode {
	public:
		OpIfLt();
		virtual ~OpIfLt();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfLt* get( Reader *r, int end, Context *ctx );
		static OpIfLt* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfLe : public OpCode {
	public:
		OpIfLe();
		virtual ~OpIfLe();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfLe* get( Reader *r, int end, Context *ctx );
		static OpIfLe* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfGt : public OpCode {
	public:
		OpIfGt();
		virtual ~OpIfGt();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfGt* get( Reader *r, int end, Context *ctx );
		static OpIfGt* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfGe : public OpCode {
	public:
		OpIfGe();
		virtual ~OpIfGe();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfGe* get( Reader *r, int end, Context *ctx );
		static OpIfGe* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfStrictEq : public OpCode {
	public:
		OpIfStrictEq();
		virtual ~OpIfStrictEq();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfStrictEq* get( Reader *r, int end, Context *ctx );
		static OpIfStrictEq* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpIfStrictNe : public OpCode {
	public:
		OpIfStrictNe();
		virtual ~OpIfStrictNe();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIfStrictNe* get( Reader *r, int end, Context *ctx );
		static OpIfStrictNe* getByName( const char *name );

		std::int32_t gettarget();
			void settarget( std::int32_t );
	

	protected:
		std::int32_t target; // s24

			static int id;
		
};

class OpLookupSwitch : public OpCode {
	public:
		OpLookupSwitch();
		virtual ~OpLookupSwitch();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpLookupSwitch* get( Reader *r, int end, Context *ctx );
		static OpLookupSwitch* getByName( const char *name );

		std::int32_t getdefaulTarget();
			void setdefaulTarget( std::int32_t );
	std::uint32_t getcaseCount();
			void setcaseCount( std::uint32_t );
	List<S24> *gettargetTable();
	

	protected:
		std::int32_t defaulTarget; // s24
std::uint32_t caseCount; // u30
List<S24> targetTable; // list

			static int id;
		
};

class OpPushWith : public OpCode {
	public:
		OpPushWith();
		virtual ~OpPushWith();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushWith* get( Reader *r, int end, Context *ctx );
		static OpPushWith* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPopScope : public OpCode {
	public:
		OpPopScope();
		virtual ~OpPopScope();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPopScope* get( Reader *r, int end, Context *ctx );
		static OpPopScope* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpNextName : public OpCode {
	public:
		OpNextName();
		virtual ~OpNextName();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNextName* get( Reader *r, int end, Context *ctx );
		static OpNextName* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpHasNext : public OpCode {
	public:
		OpHasNext();
		virtual ~OpHasNext();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpHasNext* get( Reader *r, int end, Context *ctx );
		static OpHasNext* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPushNull : public OpCode {
	public:
		OpPushNull();
		virtual ~OpPushNull();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushNull* get( Reader *r, int end, Context *ctx );
		static OpPushNull* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPushUndefined : public OpCode {
	public:
		OpPushUndefined();
		virtual ~OpPushUndefined();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushUndefined* get( Reader *r, int end, Context *ctx );
		static OpPushUndefined* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpNextValue : public OpCode {
	public:
		OpNextValue();
		virtual ~OpNextValue();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNextValue* get( Reader *r, int end, Context *ctx );
		static OpNextValue* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPushByte : public OpCode {
	public:
		OpPushByte();
		virtual ~OpPushByte();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushByte* get( Reader *r, int end, Context *ctx );
		static OpPushByte* getByName( const char *name );

		std::uint8_t getvalue();
			void setvalue( std::uint8_t );
	

	protected:
		std::uint8_t value; // byte

			static int id;
		
};

class OpPushShort : public OpCode {
	public:
		OpPushShort();
		virtual ~OpPushShort();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushShort* get( Reader *r, int end, Context *ctx );
		static OpPushShort* getByName( const char *name );

		std::uint32_t getvalue();
			void setvalue( std::uint32_t );
	

	protected:
		std::uint32_t value; // u30

			static int id;
		
};

class OpPushTrue : public OpCode {
	public:
		OpPushTrue();
		virtual ~OpPushTrue();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushTrue* get( Reader *r, int end, Context *ctx );
		static OpPushTrue* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPushFalse : public OpCode {
	public:
		OpPushFalse();
		virtual ~OpPushFalse();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushFalse* get( Reader *r, int end, Context *ctx );
		static OpPushFalse* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPushNaN : public OpCode {
	public:
		OpPushNaN();
		virtual ~OpPushNaN();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushNaN* get( Reader *r, int end, Context *ctx );
		static OpPushNaN* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPop : public OpCode {
	public:
		OpPop();
		virtual ~OpPop();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPop* get( Reader *r, int end, Context *ctx );
		static OpPop* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpDup : public OpCode {
	public:
		OpDup();
		virtual ~OpDup();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDup* get( Reader *r, int end, Context *ctx );
		static OpDup* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpSwap : public OpCode {
	public:
		OpSwap();
		virtual ~OpSwap();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSwap* get( Reader *r, int end, Context *ctx );
		static OpSwap* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPushString : public OpCode {
	public:
		OpPushString();
		virtual ~OpPushString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushString* get( Reader *r, int end, Context *ctx );
		static OpPushString* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class OpPushInt : public OpCode {
	public:
		OpPushInt();
		virtual ~OpPushInt();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushInt* get( Reader *r, int end, Context *ctx );
		static OpPushInt* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class OpPushUInt : public OpCode {
	public:
		OpPushUInt();
		virtual ~OpPushUInt();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushUInt* get( Reader *r, int end, Context *ctx );
		static OpPushUInt* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class OpPushDouble : public OpCode {
	public:
		OpPushDouble();
		virtual ~OpPushDouble();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushDouble* get( Reader *r, int end, Context *ctx );
		static OpPushDouble* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class OpPushScope : public OpCode {
	public:
		OpPushScope();
		virtual ~OpPushScope();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushScope* get( Reader *r, int end, Context *ctx );
		static OpPushScope* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpPushNamespace : public OpCode {
	public:
		OpPushNamespace();
		virtual ~OpPushNamespace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpPushNamespace* get( Reader *r, int end, Context *ctx );
		static OpPushNamespace* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class OpHasNext2 : public OpCode {
	public:
		OpHasNext2();
		virtual ~OpHasNext2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpHasNext2* get( Reader *r, int end, Context *ctx );
		static OpHasNext2* getByName( const char *name );

		std::uint32_t getobject();
			void setobject( std::uint32_t );
	std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t object; // u30
std::uint32_t index; // u30

			static int id;
		
};

class OpNewFunction : public OpCode {
	public:
		OpNewFunction();
		virtual ~OpNewFunction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNewFunction* get( Reader *r, int end, Context *ctx );
		static OpNewFunction* getByName( const char *name );

		std::uint32_t getindex();
			void setindex( std::uint32_t );
	

	protected:
		std::uint32_t index; // u30

			static int id;
		
};

class OpCall : public OpCode {
	public:
		OpCall();
		virtual ~OpCall();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCall* get( Reader *r, int end, Context *ctx );
		static OpCall* getByName( const char *name );

		std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t argc; // u30

			static int id;
		
};

class OpConstruct : public OpCode {
	public:
		OpConstruct();
		virtual ~OpConstruct();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConstruct* get( Reader *r, int end, Context *ctx );
		static OpConstruct* getByName( const char *name );

		std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t argc; // u30

			static int id;
		
};

class OpCallMethod : public OpCode {
	public:
		OpCallMethod();
		virtual ~OpCallMethod();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCallMethod* get( Reader *r, int end, Context *ctx );
		static OpCallMethod* getByName( const char *name );

		std::uint32_t getdispID();
			void setdispID( std::uint32_t );
	std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t dispID; // u30
std::uint32_t argc; // u30

			static int id;
		
};

class OpCallStatic : public OpCode {
	public:
		OpCallStatic();
		virtual ~OpCallStatic();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCallStatic* get( Reader *r, int end, Context *ctx );
		static OpCallStatic* getByName( const char *name );

		std::uint32_t getmethodID();
			void setmethodID( std::uint32_t );
	std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t methodID; // u30
std::uint32_t argc; // u30

			static int id;
		
};

class OpCallSuper : public OpCode {
	public:
		OpCallSuper();
		virtual ~OpCallSuper();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCallSuper* get( Reader *r, int end, Context *ctx );
		static OpCallSuper* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30
std::uint32_t argc; // u30

			static int id;
		
};

class OpCallProperty : public OpCode {
	public:
		OpCallProperty();
		virtual ~OpCallProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCallProperty* get( Reader *r, int end, Context *ctx );
		static OpCallProperty* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30
std::uint32_t argc; // u30

			static int id;
		
};

class OpReturnVoid : public OpCode {
	public:
		OpReturnVoid();
		virtual ~OpReturnVoid();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpReturnVoid* get( Reader *r, int end, Context *ctx );
		static OpReturnVoid* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpReturnValue : public OpCode {
	public:
		OpReturnValue();
		virtual ~OpReturnValue();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpReturnValue* get( Reader *r, int end, Context *ctx );
		static OpReturnValue* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpConstructSuper : public OpCode {
	public:
		OpConstructSuper();
		virtual ~OpConstructSuper();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConstructSuper* get( Reader *r, int end, Context *ctx );
		static OpConstructSuper* getByName( const char *name );

		std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t argc; // u30

			static int id;
		
};

class OpConstructProp : public OpCode {
	public:
		OpConstructProp();
		virtual ~OpConstructProp();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConstructProp* get( Reader *r, int end, Context *ctx );
		static OpConstructProp* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30
std::uint32_t argc; // u30

			static int id;
		
};

class OpCallPropLex : public OpCode {
	public:
		OpCallPropLex();
		virtual ~OpCallPropLex();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCallPropLex* get( Reader *r, int end, Context *ctx );
		static OpCallPropLex* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30
std::uint32_t argc; // u30

			static int id;
		
};

class OpCallSuperVoid : public OpCode {
	public:
		OpCallSuperVoid();
		virtual ~OpCallSuperVoid();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCallSuperVoid* get( Reader *r, int end, Context *ctx );
		static OpCallSuperVoid* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30
std::uint32_t argc; // u30

			static int id;
		
};

class OpCallPropVoid : public OpCode {
	public:
		OpCallPropVoid();
		virtual ~OpCallPropVoid();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCallPropVoid* get( Reader *r, int end, Context *ctx );
		static OpCallPropVoid* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30
std::uint32_t argc; // u30

			static int id;
		
};

class OpApplyType : public OpCode {
	public:
		OpApplyType();
		virtual ~OpApplyType();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpApplyType* get( Reader *r, int end, Context *ctx );
		static OpApplyType* getByName( const char *name );

		std::uint32_t gettype();
			void settype( std::uint32_t );
	

	protected:
		std::uint32_t type; // u30

			static int id;
		
};

class OpNewObject : public OpCode {
	public:
		OpNewObject();
		virtual ~OpNewObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNewObject* get( Reader *r, int end, Context *ctx );
		static OpNewObject* getByName( const char *name );

		std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t argc; // u30

			static int id;
		
};

class OpNewArray : public OpCode {
	public:
		OpNewArray();
		virtual ~OpNewArray();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNewArray* get( Reader *r, int end, Context *ctx );
		static OpNewArray* getByName( const char *name );

		std::uint32_t getargc();
			void setargc( std::uint32_t );
	

	protected:
		std::uint32_t argc; // u30

			static int id;
		
};

class OpNewActivation : public OpCode {
	public:
		OpNewActivation();
		virtual ~OpNewActivation();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNewActivation* get( Reader *r, int end, Context *ctx );
		static OpNewActivation* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpNewClass : public OpCode {
	public:
		OpNewClass();
		virtual ~OpNewClass();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNewClass* get( Reader *r, int end, Context *ctx );
		static OpNewClass* getByName( const char *name );

		std::uint32_t getclassIndex();
			void setclassIndex( std::uint32_t );
	

	protected:
		std::uint32_t classIndex; // u30

			static int id;
		
};

class OpGetDescendants : public OpCode {
	public:
		OpGetDescendants();
		virtual ~OpGetDescendants();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetDescendants* get( Reader *r, int end, Context *ctx );
		static OpGetDescendants* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpNewCatch : public OpCode {
	public:
		OpNewCatch();
		virtual ~OpNewCatch();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNewCatch* get( Reader *r, int end, Context *ctx );
		static OpNewCatch* getByName( const char *name );

		std::uint32_t getexceptionIndex();
			void setexceptionIndex( std::uint32_t );
	

	protected:
		std::uint32_t exceptionIndex; // u30

			static int id;
		
};

class OpFindPropStrict : public OpCode {
	public:
		OpFindPropStrict();
		virtual ~OpFindPropStrict();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpFindPropStrict* get( Reader *r, int end, Context *ctx );
		static OpFindPropStrict* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpFindProperty : public OpCode {
	public:
		OpFindProperty();
		virtual ~OpFindProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpFindProperty* get( Reader *r, int end, Context *ctx );
		static OpFindProperty* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpFindDef : public OpCode {
	public:
		OpFindDef();
		virtual ~OpFindDef();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpFindDef* get( Reader *r, int end, Context *ctx );
		static OpFindDef* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpGetLex : public OpCode {
	public:
		OpGetLex();
		virtual ~OpGetLex();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetLex* get( Reader *r, int end, Context *ctx );
		static OpGetLex* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpSetProperty : public OpCode {
	public:
		OpSetProperty();
		virtual ~OpSetProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetProperty* get( Reader *r, int end, Context *ctx );
		static OpSetProperty* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpGetLocal : public OpCode {
	public:
		OpGetLocal();
		virtual ~OpGetLocal();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetLocal* get( Reader *r, int end, Context *ctx );
		static OpGetLocal* getByName( const char *name );

		std::uint32_t getaddress();
			void setaddress( std::uint32_t );
	

	protected:
		std::uint32_t address; // u30

			static int id;
		
};

class OpSetLocal : public OpCode {
	public:
		OpSetLocal();
		virtual ~OpSetLocal();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetLocal* get( Reader *r, int end, Context *ctx );
		static OpSetLocal* getByName( const char *name );

		std::uint32_t getaddress();
			void setaddress( std::uint32_t );
	

	protected:
		std::uint32_t address; // u30

			static int id;
		
};

class OpGetGlobalScope : public OpCode {
	public:
		OpGetGlobalScope();
		virtual ~OpGetGlobalScope();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetGlobalScope* get( Reader *r, int end, Context *ctx );
		static OpGetGlobalScope* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpGetScopeObject : public OpCode {
	public:
		OpGetScopeObject();
		virtual ~OpGetScopeObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetScopeObject* get( Reader *r, int end, Context *ctx );
		static OpGetScopeObject* getByName( const char *name );

		std::uint8_t getscopeIndex();
			void setscopeIndex( std::uint8_t );
	

	protected:
		std::uint8_t scopeIndex; // byte

			static int id;
		
};

class OpGetProperty : public OpCode {
	public:
		OpGetProperty();
		virtual ~OpGetProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetProperty* get( Reader *r, int end, Context *ctx );
		static OpGetProperty* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpInitProperty : public OpCode {
	public:
		OpInitProperty();
		virtual ~OpInitProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpInitProperty* get( Reader *r, int end, Context *ctx );
		static OpInitProperty* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpDeleteProperty : public OpCode {
	public:
		OpDeleteProperty();
		virtual ~OpDeleteProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDeleteProperty* get( Reader *r, int end, Context *ctx );
		static OpDeleteProperty* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpGetSlot : public OpCode {
	public:
		OpGetSlot();
		virtual ~OpGetSlot();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetSlot* get( Reader *r, int end, Context *ctx );
		static OpGetSlot* getByName( const char *name );

		std::uint32_t getslotID();
			void setslotID( std::uint32_t );
	

	protected:
		std::uint32_t slotID; // u30

			static int id;
		
};

class OpSetSlot : public OpCode {
	public:
		OpSetSlot();
		virtual ~OpSetSlot();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetSlot* get( Reader *r, int end, Context *ctx );
		static OpSetSlot* getByName( const char *name );

		std::uint32_t getslotID();
			void setslotID( std::uint32_t );
	

	protected:
		std::uint32_t slotID; // u30

			static int id;
		
};

class OpGetGlobalSlot : public OpCode {
	public:
		OpGetGlobalSlot();
		virtual ~OpGetGlobalSlot();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetGlobalSlot* get( Reader *r, int end, Context *ctx );
		static OpGetGlobalSlot* getByName( const char *name );

		std::uint32_t getslotID();
			void setslotID( std::uint32_t );
	

	protected:
		std::uint32_t slotID; // u30

			static int id;
		
};

class OpSetGlobalSlot : public OpCode {
	public:
		OpSetGlobalSlot();
		virtual ~OpSetGlobalSlot();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetGlobalSlot* get( Reader *r, int end, Context *ctx );
		static OpSetGlobalSlot* getByName( const char *name );

		std::uint32_t getslotID();
			void setslotID( std::uint32_t );
	

	protected:
		std::uint32_t slotID; // u30

			static int id;
		
};

class OpConvertS : public OpCode {
	public:
		OpConvertS();
		virtual ~OpConvertS();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConvertS* get( Reader *r, int end, Context *ctx );
		static OpConvertS* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpEscXelem : public OpCode {
	public:
		OpEscXelem();
		virtual ~OpEscXelem();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpEscXelem* get( Reader *r, int end, Context *ctx );
		static OpEscXelem* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpEscXattr : public OpCode {
	public:
		OpEscXattr();
		virtual ~OpEscXattr();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpEscXattr* get( Reader *r, int end, Context *ctx );
		static OpEscXattr* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpConvertI : public OpCode {
	public:
		OpConvertI();
		virtual ~OpConvertI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConvertI* get( Reader *r, int end, Context *ctx );
		static OpConvertI* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpConvertU : public OpCode {
	public:
		OpConvertU();
		virtual ~OpConvertU();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConvertU* get( Reader *r, int end, Context *ctx );
		static OpConvertU* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpConvertD : public OpCode {
	public:
		OpConvertD();
		virtual ~OpConvertD();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConvertD* get( Reader *r, int end, Context *ctx );
		static OpConvertD* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpConvertB : public OpCode {
	public:
		OpConvertB();
		virtual ~OpConvertB();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConvertB* get( Reader *r, int end, Context *ctx );
		static OpConvertB* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpConvertO : public OpCode {
	public:
		OpConvertO();
		virtual ~OpConvertO();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpConvertO* get( Reader *r, int end, Context *ctx );
		static OpConvertO* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpCheckFilter : public OpCode {
	public:
		OpCheckFilter();
		virtual ~OpCheckFilter();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCheckFilter* get( Reader *r, int end, Context *ctx );
		static OpCheckFilter* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpCoerce : public OpCode {
	public:
		OpCoerce();
		virtual ~OpCoerce();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCoerce* get( Reader *r, int end, Context *ctx );
		static OpCoerce* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpCoerceB : public OpCode {
	public:
		OpCoerceB();
		virtual ~OpCoerceB();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCoerceB* get( Reader *r, int end, Context *ctx );
		static OpCoerceB* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpCoerceA : public OpCode {
	public:
		OpCoerceA();
		virtual ~OpCoerceA();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCoerceA* get( Reader *r, int end, Context *ctx );
		static OpCoerceA* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpCoerceI : public OpCode {
	public:
		OpCoerceI();
		virtual ~OpCoerceI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCoerceI* get( Reader *r, int end, Context *ctx );
		static OpCoerceI* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpCoerceD : public OpCode {
	public:
		OpCoerceD();
		virtual ~OpCoerceD();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCoerceD* get( Reader *r, int end, Context *ctx );
		static OpCoerceD* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpCoerceS : public OpCode {
	public:
		OpCoerceS();
		virtual ~OpCoerceS();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCoerceS* get( Reader *r, int end, Context *ctx );
		static OpCoerceS* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpAsType : public OpCode {
	public:
		OpAsType();
		virtual ~OpAsType();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpAsType* get( Reader *r, int end, Context *ctx );
		static OpAsType* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpAsTypeLate : public OpCode {
	public:
		OpAsTypeLate();
		virtual ~OpAsTypeLate();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpAsTypeLate* get( Reader *r, int end, Context *ctx );
		static OpAsTypeLate* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpCoerceU : public OpCode {
	public:
		OpCoerceU();
		virtual ~OpCoerceU();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCoerceU* get( Reader *r, int end, Context *ctx );
		static OpCoerceU* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpCoerceO : public OpCode {
	public:
		OpCoerceO();
		virtual ~OpCoerceO();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpCoerceO* get( Reader *r, int end, Context *ctx );
		static OpCoerceO* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpNegate : public OpCode {
	public:
		OpNegate();
		virtual ~OpNegate();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNegate* get( Reader *r, int end, Context *ctx );
		static OpNegate* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpIncrement : public OpCode {
	public:
		OpIncrement();
		virtual ~OpIncrement();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIncrement* get( Reader *r, int end, Context *ctx );
		static OpIncrement* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpIncLocal : public OpCode {
	public:
		OpIncLocal();
		virtual ~OpIncLocal();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIncLocal* get( Reader *r, int end, Context *ctx );
		static OpIncLocal* getByName( const char *name );

		std::uint32_t getaddress();
			void setaddress( std::uint32_t );
	

	protected:
		std::uint32_t address; // u30

			static int id;
		
};

class OpDecrement : public OpCode {
	public:
		OpDecrement();
		virtual ~OpDecrement();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDecrement* get( Reader *r, int end, Context *ctx );
		static OpDecrement* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpDecLocal : public OpCode {
	public:
		OpDecLocal();
		virtual ~OpDecLocal();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDecLocal* get( Reader *r, int end, Context *ctx );
		static OpDecLocal* getByName( const char *name );

		std::uint32_t getaddress();
			void setaddress( std::uint32_t );
	

	protected:
		std::uint32_t address; // u30

			static int id;
		
};

class OpTypeOf : public OpCode {
	public:
		OpTypeOf();
		virtual ~OpTypeOf();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpTypeOf* get( Reader *r, int end, Context *ctx );
		static OpTypeOf* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpNot : public OpCode {
	public:
		OpNot();
		virtual ~OpNot();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNot* get( Reader *r, int end, Context *ctx );
		static OpNot* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpBitNot : public OpCode {
	public:
		OpBitNot();
		virtual ~OpBitNot();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpBitNot* get( Reader *r, int end, Context *ctx );
		static OpBitNot* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpAdd : public OpCode {
	public:
		OpAdd();
		virtual ~OpAdd();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpAdd* get( Reader *r, int end, Context *ctx );
		static OpAdd* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpSubtract : public OpCode {
	public:
		OpSubtract();
		virtual ~OpSubtract();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSubtract* get( Reader *r, int end, Context *ctx );
		static OpSubtract* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpMultiply : public OpCode {
	public:
		OpMultiply();
		virtual ~OpMultiply();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpMultiply* get( Reader *r, int end, Context *ctx );
		static OpMultiply* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpDivide : public OpCode {
	public:
		OpDivide();
		virtual ~OpDivide();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDivide* get( Reader *r, int end, Context *ctx );
		static OpDivide* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpModulo : public OpCode {
	public:
		OpModulo();
		virtual ~OpModulo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpModulo* get( Reader *r, int end, Context *ctx );
		static OpModulo* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpLShift : public OpCode {
	public:
		OpLShift();
		virtual ~OpLShift();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpLShift* get( Reader *r, int end, Context *ctx );
		static OpLShift* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpRShift : public OpCode {
	public:
		OpRShift();
		virtual ~OpRShift();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpRShift* get( Reader *r, int end, Context *ctx );
		static OpRShift* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpURShift : public OpCode {
	public:
		OpURShift();
		virtual ~OpURShift();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpURShift* get( Reader *r, int end, Context *ctx );
		static OpURShift* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpBitAnd : public OpCode {
	public:
		OpBitAnd();
		virtual ~OpBitAnd();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpBitAnd* get( Reader *r, int end, Context *ctx );
		static OpBitAnd* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpBitOr : public OpCode {
	public:
		OpBitOr();
		virtual ~OpBitOr();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpBitOr* get( Reader *r, int end, Context *ctx );
		static OpBitOr* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpBitXor : public OpCode {
	public:
		OpBitXor();
		virtual ~OpBitXor();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpBitXor* get( Reader *r, int end, Context *ctx );
		static OpBitXor* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpEquals : public OpCode {
	public:
		OpEquals();
		virtual ~OpEquals();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpEquals* get( Reader *r, int end, Context *ctx );
		static OpEquals* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpStrictEquals : public OpCode {
	public:
		OpStrictEquals();
		virtual ~OpStrictEquals();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpStrictEquals* get( Reader *r, int end, Context *ctx );
		static OpStrictEquals* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpLessThan : public OpCode {
	public:
		OpLessThan();
		virtual ~OpLessThan();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpLessThan* get( Reader *r, int end, Context *ctx );
		static OpLessThan* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpLessEquals : public OpCode {
	public:
		OpLessEquals();
		virtual ~OpLessEquals();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpLessEquals* get( Reader *r, int end, Context *ctx );
		static OpLessEquals* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpGreaterThan : public OpCode {
	public:
		OpGreaterThan();
		virtual ~OpGreaterThan();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGreaterThan* get( Reader *r, int end, Context *ctx );
		static OpGreaterThan* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpGreaterEquals : public OpCode {
	public:
		OpGreaterEquals();
		virtual ~OpGreaterEquals();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGreaterEquals* get( Reader *r, int end, Context *ctx );
		static OpGreaterEquals* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpInstanceOf : public OpCode {
	public:
		OpInstanceOf();
		virtual ~OpInstanceOf();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpInstanceOf* get( Reader *r, int end, Context *ctx );
		static OpInstanceOf* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpIsType : public OpCode {
	public:
		OpIsType();
		virtual ~OpIsType();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIsType* get( Reader *r, int end, Context *ctx );
		static OpIsType* getByName( const char *name );

		std::uint32_t getname();
			void setname( std::uint32_t );
	

	protected:
		std::uint32_t name; // u30

			static int id;
		
};

class OpIsTypeLate : public OpCode {
	public:
		OpIsTypeLate();
		virtual ~OpIsTypeLate();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIsTypeLate* get( Reader *r, int end, Context *ctx );
		static OpIsTypeLate* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpIn : public OpCode {
	public:
		OpIn();
		virtual ~OpIn();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIn* get( Reader *r, int end, Context *ctx );
		static OpIn* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpIncrementI : public OpCode {
	public:
		OpIncrementI();
		virtual ~OpIncrementI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIncrementI* get( Reader *r, int end, Context *ctx );
		static OpIncrementI* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpDecrementI : public OpCode {
	public:
		OpDecrementI();
		virtual ~OpDecrementI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDecrementI* get( Reader *r, int end, Context *ctx );
		static OpDecrementI* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpIncLocalI : public OpCode {
	public:
		OpIncLocalI();
		virtual ~OpIncLocalI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpIncLocalI* get( Reader *r, int end, Context *ctx );
		static OpIncLocalI* getByName( const char *name );

		std::uint32_t getaddress();
			void setaddress( std::uint32_t );
	

	protected:
		std::uint32_t address; // u30

			static int id;
		
};

class OpDecLocalI : public OpCode {
	public:
		OpDecLocalI();
		virtual ~OpDecLocalI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDecLocalI* get( Reader *r, int end, Context *ctx );
		static OpDecLocalI* getByName( const char *name );

		std::uint32_t getaddress();
			void setaddress( std::uint32_t );
	

	protected:
		std::uint32_t address; // u30

			static int id;
		
};

class OpNegateI : public OpCode {
	public:
		OpNegateI();
		virtual ~OpNegateI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpNegateI* get( Reader *r, int end, Context *ctx );
		static OpNegateI* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpAddI : public OpCode {
	public:
		OpAddI();
		virtual ~OpAddI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpAddI* get( Reader *r, int end, Context *ctx );
		static OpAddI* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpSubtractI : public OpCode {
	public:
		OpSubtractI();
		virtual ~OpSubtractI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSubtractI* get( Reader *r, int end, Context *ctx );
		static OpSubtractI* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpMultiplyI : public OpCode {
	public:
		OpMultiplyI();
		virtual ~OpMultiplyI();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpMultiplyI* get( Reader *r, int end, Context *ctx );
		static OpMultiplyI* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpGetLocal0 : public OpCode {
	public:
		OpGetLocal0();
		virtual ~OpGetLocal0();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetLocal0* get( Reader *r, int end, Context *ctx );
		static OpGetLocal0* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpGetLocal1 : public OpCode {
	public:
		OpGetLocal1();
		virtual ~OpGetLocal1();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetLocal1* get( Reader *r, int end, Context *ctx );
		static OpGetLocal1* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpGetLocal2 : public OpCode {
	public:
		OpGetLocal2();
		virtual ~OpGetLocal2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetLocal2* get( Reader *r, int end, Context *ctx );
		static OpGetLocal2* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpGetLocal3 : public OpCode {
	public:
		OpGetLocal3();
		virtual ~OpGetLocal3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpGetLocal3* get( Reader *r, int end, Context *ctx );
		static OpGetLocal3* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpSetLocal0 : public OpCode {
	public:
		OpSetLocal0();
		virtual ~OpSetLocal0();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetLocal0* get( Reader *r, int end, Context *ctx );
		static OpSetLocal0* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpSetLocal1 : public OpCode {
	public:
		OpSetLocal1();
		virtual ~OpSetLocal1();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetLocal1* get( Reader *r, int end, Context *ctx );
		static OpSetLocal1* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpSetLocal2 : public OpCode {
	public:
		OpSetLocal2();
		virtual ~OpSetLocal2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetLocal2* get( Reader *r, int end, Context *ctx );
		static OpSetLocal2* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpSetLocal3 : public OpCode {
	public:
		OpSetLocal3();
		virtual ~OpSetLocal3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpSetLocal3* get( Reader *r, int end, Context *ctx );
		static OpSetLocal3* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OpDebugReg : public OpCode {
	public:
		OpDebugReg();
		virtual ~OpDebugReg();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDebugReg* get( Reader *r, int end, Context *ctx );
		static OpDebugReg* getByName( const char *name );

		std::uint8_t getunknown();
			void setunknown( std::uint8_t );
	std::uint32_t getname();
			void setname( std::uint32_t );
	std::uint32_t getreg();
			void setreg( std::uint32_t );
	std::uint32_t getline();
			void setline( std::uint32_t );
	

	protected:
		std::uint8_t unknown; // byte
std::uint32_t name; // u30
std::uint32_t reg; // u30
std::uint32_t line; // u30

			static int id;
		
};

class OpDebugLine : public OpCode {
	public:
		OpDebugLine();
		virtual ~OpDebugLine();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDebugLine* get( Reader *r, int end, Context *ctx );
		static OpDebugLine* getByName( const char *name );

		std::uint32_t getline();
			void setline( std::uint32_t );
	

	protected:
		std::uint32_t line; // u30

			static int id;
		
};

class OpDebugFile : public OpCode {
	public:
		OpDebugFile();
		virtual ~OpDebugFile();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpDebugFile* get( Reader *r, int end, Context *ctx );
		static OpDebugFile* getByName( const char *name );

		std::uint32_t getfile();
			void setfile( std::uint32_t );
	

	protected:
		std::uint32_t file; // u30

			static int id;
		
};

class OpBkPtLine : public OpCode {
	public:
		OpBkPtLine();
		virtual ~OpBkPtLine();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpBkPtLine* get( Reader *r, int end, Context *ctx );
		static OpBkPtLine* getByName( const char *name );

		std::uint32_t getline();
			void setline( std::uint32_t );
	

	protected:
		std::uint32_t line; // u30

			static int id;
		
};

class OpTimestamp : public OpCode {
	public:
		OpTimestamp();
		virtual ~OpTimestamp();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OpTimestamp* get( Reader *r, int end, Context *ctx );
		static OpTimestamp* getByName( const char *name );

		

	protected:
		
			static int id;
		
};


}
#endif
