;; Copyright (C) 2008-2013 Tommi Höynälänmaa
;; Distributed under GNU General Public License version 3,
;; see file doc/GPL-3.


;; *** Parser core definitions ***


(import (rnrs exceptions)
	(srfi srfi-1)
	(th-scheme-utilities stdutils)
	(th-scheme-utilities hrecord))


(define gl-i-globals-by-address-size 10000)
(define gl-i-globals-by-name-size 10000)
(define gl-i-cycles-size 1000)
(define gl-i-tvars-size 1000)
(define gl-i-goops-classes-size 1000)
(define gl-i-prim-classes-size 100)
(define gl-i-procs-size 50)


(define-hrecord-type <compiler> ()
  binder
  state
  unit-type
  module-name
  env
  env-all
  imports
  imports-with-reexports
  l-used-modules
  l-prelinked-bodies
  l-interface-imports
  l-body-source
  exported-objects
  public-decls
  method-decls
  lst-visited
  ht-cycles
  lst-enclosing-cycles
  ht-type-variables
  body
  expanded-body
  toplevel-unit-name
  work-dir
  module-search-path
  pretty-print-modules?
  backtrace?
  expand-only?
  no-expansion?
  next-free-loc
  imported-modules
  reexports
  ht-globals-by-name
  ht-goops-classes
  ht-prim-classes
  ht-procs
  inside-pure-proc?
  inside-param-def?
  current-letrec-env
  current-expr
  current-toplevel-expr
  current-interface-var
  current-repr
  current-toplevel-repr
  s-cur-toplevel-def
  error-info
  display-erroneous-expr?
  module-to-import
  variable-to-import
  show-imported-symbols?
  target-output-filename
  target-output-file)


(define (compiler-alloc-loc compiler s-name toplevel?)
  (if (not (eqv? s-name 'main))
      (let ((new-loc (hfield-ref compiler 'next-free-loc)))
	(hfield-set! compiler 'next-free-loc (+ new-loc 1))
	(make-hrecord <address> '() new-loc s-name toplevel?))
      (make-hrecord <address> '() address-number-target '_main
		    toplevel?)))


(define (compiler-get-binder compiler)
  (hfield-ref compiler 'binder))


(define (compiler-get-globals-by-address compiler)
  (hfield-ref (hfield-ref compiler 'binder) 'ht-globals-by-address))


(define (compiler-get-fixed-tvars compiler)
  (hfield-ref (hfield-ref compiler 'binder) 'fixed-tvars))


(define (compiler-set-fixed-tvars! compiler obj)
  (let ((binder (hfield-ref compiler 'binder)))
    (hfield-set! binder 'fixed-tvars obj)))


(define (is-null-sexpr? obj)
  (or (null? obj) (eq? obj 'null)))


(define (get-current-module-name compiler)
  (assert (hrecord-is-instance? compiler <compiler>))
  (hfield-ref compiler 'module-name))


