_uftrace () {
    local cur prev subcmd options uftrace_comp

    cur=${COMP_WORDS[COMP_CWORD]}
    prev=${COMP_WORDS[COMP_CWORD - 1]}

    COMPREPLY=()

    subcmds='record replay report live dump graph info recv'
    options=$(uftrace -? | awk '$1 ~ /--[a-z]/ { split($1, r, "="); print r[1] } \
                                $2 ~ /--[a-z]/ { split($2, r, "="); print r[1] }')

    uftrace_comp="${subcmds} ${options}"

    case $prev in
	-d|--data)
	    # complete directory name
	    COMPREPLY=($(compgen -d -- "${cur}"))
	    ;;
	*)
	    # complete subcommand or long option
	    COMPREPLY=($(compgen -W "${uftrace_comp}" -- "${cur}"))
	    ;;
    esac
    return 0
}
complete -F _uftrace uftrace
