/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __filepicker_h
#define __filepicker_h

#include "galeon.h"

typedef struct 
{
	/* description of the file format */
	gchar *description;
	/* tipical sufixes, NULL terminated */
	gchar **extensions;
} FileFormat;

////////////////////////////////////////////////////////////////////////////////
/**
 * show_file_picker: Shows a file picker. Can be configured to select a
 * file or a directory.
 * @parentWidget: Parent Widget for file picker.
 * @title: Title for file picker.
 * @directory: Initial directory to start in.
 * @file: Initial filename to show in filepicker.
 * @mode: Mode to run filepicker in (modeOpen, modeSave, modeGetFolder)
 * @ret_fullpath: On a successful return, will hold the full path to selected
 *		file or directory.
 * @ret_save_content: If this arg is not NULL, then the file picker will
 *		contain a checkbox to indicate whether document content should
 *		be saved along with the document. It will contain the value
 *		of the checkbox on return.
 * @file_formats: an array of FileFormat structures to fill the format chooser
 *              optionmenu. NULL if not needed. The last item must have 
 *              description == NULL;
 * @ret_file_format: where to store the index of the format selected (can be
 *              NULL)
 * returns: TRUE for success, FALSE for failure.
 */
////////////////////////////////////////////////////////////////////////////////

#ifndef __cplusplus

extern gboolean
show_file_picker (GtkWidget *parentWidget, const char* title,
		  const char* directory, const char* file, FilePickerMode mode,
		  char * *ret_fullpath, gboolean* ret_save_content, 
		  FileFormat *file_formats, gint *ret_file_format);

#endif

#endif
