/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __prefs_h
#define __prefs_h

#ifdef __cplusplus
extern "C" {
#endif

#include "eel-gconf-extensions.h"
#include "galeon_types.h"

#include <glade/glade-xml.h>

/**
 * PreferencesDialog: structure representing Preferences dialog box
 */
typedef struct
{
	GladeXML *gxml;

	GaleonWindow *parent_window;

	GtkWidget *dialog;
	GtkWidget *notebook;
	GtkWidget *sidebar;
	GtkWidget *themes_page;

        gboolean enable_edit_mime;
        gint mime_last_sort_column;
        GtkSortType mime_last_sort_type;
	MimeItem *selected_mime;
	GtkWidget *mime_list;
	GtkWidget *mime_type_label;
	GtkWidget *mime_type_entry;
	GtkWidget *mime_save_to_disk;
	GtkWidget *mime_helper_frame;
	GtkWidget *mime_helper_entry;
	GtkWidget *mime_always_use;
	GtkWidget *mime_terminal;
	GtkWidget *mime_url_helper;
	GtkWidget *mime_delete_button;
	GtkWidget *mime_action_frame;

	GtkWidget *current_clist;
	GtkWidget *available_clist;
	GtkWidget *add_button;
	GtkWidget *remove_button;
	GtkWidget *up_button;
	GtkWidget *down_button;

	GtkWidget *custom_css_clist;
	GtkWidget *custom_css_remove_button;
	GtkWidget *custom_css_default_check;
	GtkWidget *serif_font_fpicker;
	GtkWidget *sansserif_font_fpicker;
	GtkWidget *cursive_font_fpicker;
	GtkWidget *fantasy_font_fpicker;
	GtkWidget *monospace_font_fpicker;
	GtkWidget *minimum_font_size_spin;
	GtkWidget *default_charset_combo;
	GtkWidget *lang_encoding_optionmenu;
	GtkWidget *theme_iconlist;
	GtkWidget *theme_dir_entry;
	GtkWidget *startpage_entry;

	GtkWidget *lang_list;
	GtkWidget *lang_remove_button;
	GtkWidget *lang_up_button;
	GtkWidget *lang_down_button;

	GtkWidget *spinner_dir_entry;
	GtkWidget *spinner_iconlist;
	GtkWidget *lang_entry;
	GtkWidget *proxy_auto_url_entry;
	GtkWidget *proxy_auto_reload_button;

	GtkWidget *serif_font_picker;
	GtkWidget *sansserif_font_picker;
	GtkWidget *cursive_font_picker;
	GtkWidget *fantasy_font_picker;
	GtkWidget *monospace_font_picker;
	GtkWidget *minsize_spinbutton;

	int last_language;
	LanguageFontInfo *fonts;

	GtkWidget **widgets;
} PreferencesDialog;

void prefs_open (GaleonWindow *window);
void prefs_show_page (GaleonWindow *window, PreferencesPageId id);
void prefs_load (void);
void prefs_destroy (void);
gboolean prefs_galeon_used_by_gnome_for_protocol (const char *protocol);

#ifdef __cplusplus
}
#endif

#endif /* __prefs_h */
