/* $Id: filter.cc,v 1.5 2000/02/20 21:45:32 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2000 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include "transient.h"
#include "filter.h"
#include "gps.h"
#include "tstring.h"
#include "importglobals.h"

GtkWidget *filter_dlg,*lf1,*lf2;
GtkWidget *cb[3],*ch;

gchar opfilter[3][2]={"<","=",">"};

void clear_filter (GtkWidget * widget, gpointer data) {
  have_filter=FALSE;
  gtk_label_set_text(GTK_LABEL(status_label[0]),"Filter: none");
  refresh();
}

void set_filter_dialog (GtkWidget * widget, gpointer data) {
  GtkWidget *dlg,*v1,*h1;
  GtkWidget *b[10],*h2,*h3,*h4,*l3,*s1,*ok,*can,*h5;
  static GtkWidget *l1,*l2,*e1,*il;
  static int acoxambre[10]={0,1,2,3,4,5,6,7,8,9};
  int i,j;
  char buffer[5][64];
  GList *combo;

  memcpy(&fi_stru,&fi_work,sizeof(struct filter_info));

  dlg=gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_transient_for(GTK_WINDOW(dlg),MainWindow);
  filter_dlg=dlg;

  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(dlg),v1);
  gtk_window_set_title(GTK_WINDOW(dlg),"Set Filter");
  gtk_container_set_border_width(GTK_CONTAINER(dlg),6);
  gtk_window_set_position(GTK_WINDOW(dlg),GTK_WIN_POS_CENTER);
  gtk_widget_realize(dlg);

  /* Field */

  h1=gtk_hbox_new(FALSE,0);
  strcpy(buffer[0],"Field to filter:");
  l1=gtk_label_new(buffer[0]);
  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,FALSE,2);
  gtk_box_pack_start(GTK_BOX(h1),l1,FALSE,FALSE,2);
  gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_LEFT);

  ch=gtk_combo_new();
  combo=NULL;
  for(i=0,combo=NULL;i<PROCESS_LIST_COLUMNS;i++)
    combo=g_list_append(combo,col_title[i]);
  gtk_combo_set_popdown_strings(GTK_COMBO(ch),combo);
  gtk_box_pack_start(GTK_BOX(v1),ch,FALSE,FALSE,2);


  /* Comparison */
  strcpy(buffer[1],"Processes to show:");
  l2=gtk_label_new(buffer[1]);
  h2=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(v1),h2,FALSE,TRUE,2);
  gtk_label_set_justify(GTK_LABEL(l2),GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(h2),l2,FALSE,TRUE,2);

  cb[0]=gtk_toggle_button_new_with_label("Lesser");
  cb[1]=gtk_toggle_button_new_with_label("Equal");
  cb[2]=gtk_toggle_button_new_with_label("Greater");

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb[0]),(fi_stru.cmp==-1));
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb[1]),(fi_stru.cmp==0));
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb[2]),(fi_stru.cmp==1));

  h3=gtk_hbox_new(TRUE,0);
  gtk_box_pack_start(GTK_BOX(v1),h3,FALSE,TRUE,2);
  for(i=0;i<3;i++) {
    gtk_box_pack_start(GTK_BOX(h3),cb[i],FALSE,TRUE,0);
    gtk_widget_show(cb[i]);
  }

  /* value */
  l3=gtk_label_new("Value for comparison:");
  h4=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(v1),h4,FALSE,TRUE,2);
  gtk_label_set_justify(GTK_LABEL(l3),GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(h4),l3,FALSE,TRUE,2);

  e1=gtk_entry_new_with_max_length(30);
  gtk_entry_set_text(GTK_ENTRY(e1),fi_stru.value);
  gtk_entry_set_editable(GTK_ENTRY(e1),TRUE);
  gtk_box_pack_start(GTK_BOX(v1),e1,FALSE,TRUE,4);

  /* bottom */
  s1=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),s1,FALSE,TRUE,4);

  h5=gtk_hbox_new(TRUE,4);
  il=gtk_label_new(" ");
  ok=gtk_button_new_with_label("Ok");
  can=gtk_button_new_with_label("Cancel");

  gtk_box_pack_start(GTK_BOX(v1),h5,FALSE,TRUE,2);

  gtk_box_pack_start(GTK_BOX(h5),il,FALSE,TRUE,4);
  gtk_box_pack_start(GTK_BOX(h5),ok,FALSE,TRUE,4);
  gtk_box_pack_start(GTK_BOX(h5),can,FALSE,TRUE,4);

  gtk_widget_show(il);
  gtk_widget_show(ok);
  gtk_widget_show(can);
  gtk_widget_show(h5);
  gtk_widget_show(s1);
  gtk_widget_show(e1);
  gtk_widget_show(h4);
  gtk_widget_show(l3);
  gtk_widget_show(h3);
  gtk_widget_show(h2);
  gtk_widget_show(l2);
  gtk_widget_show(l1);
  gtk_widget_show(h1);
  gtk_widget_show(ch);
  gtk_widget_show(v1);
  gtk_widget_show(dlg);

  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(ch)->entry),col_title[fi_stru.field]);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(ch)->entry),false);

  lf1=l1;
  lf2=l2;

  for(i=0;i<3;i++)
    gtk_signal_connect(GTK_OBJECT(cb[i]),"toggled",
		       GTK_SIGNAL_FUNC(filter_set_cmp),
		       (gpointer)(&acoxambre[i]));

  gtk_signal_connect(GTK_OBJECT(ok),"clicked",
		     GTK_SIGNAL_FUNC(filter_set_ok),(gpointer)(e1));  
  gtk_signal_connect(GTK_OBJECT(can),"clicked",
		     GTK_SIGNAL_FUNC(filter_set_cancel),NULL);  
  gtk_grab_add(dlg);
}

void filter_set_field(GtkWidget *gw,gpointer data) {
  int *k;
  static char buffer[64];
  k=(int *)data;
  sprintf(buffer,"Field to filter: %s",col_title[*k]);
  gtk_label_set_text(GTK_LABEL(lf1),buffer);
  fi_stru.field=*k;
}

void filter_set_cmp(GtkWidget *gw,gpointer data) {
  int *k;
  int i;
  k=(int *)data;

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gw))==false)
    return;

  for(i=0;i<3;i++)
    if (i!=(*k))
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb[i]),false);

  switch(*k) {
  case 0:
    fi_stru.cmp=-1;
    break;
  case 1:
    fi_stru.cmp=0;
    break;
  case 2:
    fi_stru.cmp=1;
    break;
  }
}

void filter_set_cancel(GtkWidget *gw,gpointer data) {
  gtk_grab_remove(filter_dlg);
  gtk_widget_destroy(filter_dlg);
}

void filter_set_ok(GtkWidget *gw,gpointer data) {
  GtkWidget *e;
  int i;
  char *result;
  char buffer[256];

  e=(GtkWidget *)data;

  result=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ch)->entry));
  for(i=0;i<PROCESS_LIST_COLUMNS;i++)
    if (strcmp(result,col_title[i])==0) {
      fi_stru.field=i;
      break;
    }

  strcpy(fi_stru.value,(char *)(gtk_entry_get_text( GTK_ENTRY(e) )));

  if (fi_stru.field==10) {
    strcpy(buffer,fi_stru.value);
    if (buffer[2]!=':')
      parse_time_reference(&fi_stru,buffer);
  }

  memcpy(&fi_work,&fi_stru,sizeof(struct filter_info));
  have_filter=TRUE;
  gtk_grab_remove(filter_dlg);
  gtk_widget_destroy(filter_dlg);

  sprintf(buffer,"Filter: %s %s %s",
	  col_title[fi_work.field],
	  opfilter[fi_work.cmp+1],
	  fi_work.value);
  gtk_label_set_text(GTK_LABEL(status_label[0]),buffer);

  refresh();
}

void parse_time_reference(struct filter_info *dest,char *src) {
  TString *t;
  char *s;
  time_t ref,tmp;
  struct tm *tm_stru;
  long count;
  time_t now,diff;
  int relative=0;

  t=new TString(src);
  dest->value[0]=0;
  count=0;
  diff=0;

  while( (s=t->token(" \t")) != NULL ) {
    now=time(NULL);
    if (!strcmp(s,"yesterday")) {
      count=1;
      diff=3600*24;
      relative=0;
      break;
    }
    if (!strcmp(s,"today")) {
      count=0;
      diff=3600*24;
      relative=0;
      break;
    }
    /* units */
    if (!strcmp(s,"ago")) {
      relative=1;
      break;
    }
    if (strstr(s,"day")) {
      diff=3600*24;
      continue;
    }
    if (strstr(s,"week")) {
      diff=7*3600*24;
      continue;
    }
    if (strstr(s,"hour")) {
      diff=3600;
      continue;
    }
    if (strstr(s,"minute")) {
      diff=60;
      continue;
    }
    if (strstr(s,"second")) {
      diff=1;
      continue;
    }
    if (strstr(s,"month")) {
      diff=31*24*3600;
      continue;
    }
    if (strstr(s,"year")) {
      diff=366*24*3600;
      continue;
    }

    count=atoi(s);
  }

  now=time(NULL);
  now-=(time_t)(count)*diff;
  tm_stru=localtime(&now);
  /* today | yesterday */
  if (!relative) {
    tm_stru->tm_hour=0;
    tm_stru->tm_min=0;
    tm_stru->tm_sec=0;
    now=mktime(tm_stru);
  }
  time_to_gps(now,dest->value);
}
