/* $Id: edges.h,v 1.9 2005/04/05 12:02:56 ellson Exp $ $Revision: 1.9 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#ifndef EDGES_H
#define EDGES_H

#include "voronoi/site.h"
#include "voronoi/info.h"

namespace Voronoi {

struct Edge {
    double      a,b,c;         /* edge on line ax + by = c */
    Site       *ep[2];        /* endpoints (vertices) of edge; initially NULL */
    Site       *reg[2];       /* sites forming edge */
    int        edgenbr;
};

typedef enum _EdgeEnds {le = 0, re = 1} EdgeEnd;
inline EdgeEnd opp(EdgeEnd e) {
	if(e==le)
		return re;
	else
		return le;
}

struct Edges {
	Freelist<Edge> fedges;
	int nedges;
	Sites &sites;
	Infos &infos;
	Bounds &bounds;

	Edges(Sites &sites,Infos &infos,Bounds &bounds,int N) : 
	  fedges(ROUND(sqrt((double)N))),
	  nedges(0),
	  sites(sites),
	  infos(infos),
	  bounds(bounds) {}

	void endpoint(Edge*, EdgeEnd, Site*);
	void clip_line(Edge *e);
	Edge *bisect(Site*, Site*);
private:
	void doSeg (Edge *e, double x1, double y1, double x2, double y2);
};

struct Whattux {};

} // namespace Voronoi
#endif
