/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: socketdefs.h,v 1.1.32.3 2004/07/09 01:45:39 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef __OPWAVESOCKETS__
#define __OPWAVESOCKETS__


#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

//#ifndef mode_t
//typedef unsigned long	mode_t;
//#endif

#ifndef _HXTYPES_H_
#include "hxtypes.h"
#endif

#define	INADDR_ANY  (unsigned long)0x00000000
#define	AF_INET			2			/* internetwork: UDP, TCP, etc. 				*/


/*
 * Basic system type definitions, taken from the BSD file sys/types.h.
 */
typedef unsigned char   u_char;
typedef unsigned short  u_short;
typedef unsigned int    u_int;
typedef unsigned long   u_long;

/*
 * These definitions are the placeholders for Openwave's SDK
 */
#define ntohl(x)	(x)
#define ntohs(x)	(x)
#define htonl(x)	(x)
#define htons(x)	(x)

/*
 * Internet address (a structure for historical reasons)
 */
struct in_addr {
	unsigned long s_addr;
};

/*
 * Socket address, internet style.
 */
struct sockaddr_in {
	unsigned char	sin_len;
	unsigned	char	sin_family;
	unsigned short	sin_port;
	struct			in_addr sin_addr;
	char				sin_zero[8]; /* Flawfinder: ignore */
};

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* __OPWAVESOCKETS__ */
