/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: plugins.cpp,v 1.1.2.3 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "plugins.h"

/* Helix headers */
#include "hxcom.h"
#include "hxwintyp.h"
#include "hxplugn.h"
#include "hxcore.h"
#include "ihxpckts.h"

#include "commonapp.h"

#include "hxplayer-i18n.h"


typedef struct
{
    GladeXML* xml;
} HXPluginsDialog;


static void
hxplay_plugins_dialog_destroy (GtkWidget* /* widget */,
                               HXPluginsDialog* info)
{
    glade_xml_destroy (info->xml);

    g_free(info);
}

GtkDialog*
hxplay_plugins_dialog_new(HXPlayer* player)
{
    GladeXML *xml;
    GtkWidget *dialog;
    GtkWidget *tree_view;
    GtkListStore *store;
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;
    GtkTreeIter tree_iter;
    HXPluginsDialog* info;     

    gchar *filename;
    gboolean result;
    gchar* plugin_name;
    gchar* plugin_description;
    
    filename = hxcommon_locate_file("plugins.glade");
    xml = glade_xml_new (filename, NULL, NULL);
    g_free(filename);
    g_return_val_if_fail(xml != NULL, NULL);

    tree_view = glade_xml_get_widget (xml, "hplgd_tree_view");
    g_return_val_if_fail(tree_view != NULL, NULL);

    /* Get the plugin enumerator */
    IHXPlugin2Handler* pPlugin2Handler;
    UINT32 nNumPlugins;
    UINT32 nIndex;
    IHXValues* pPluginProps;
    const char* szPropName;
    IHXBuffer* pPropValue;
    IUnknown* pUnk;
    HX_RESULT retVal;
    
    result = hx_player_get_unknown(player,
                                   (void**)&pUnk);
    g_return_val_if_fail(result != FALSE, NULL);

    retVal = pUnk->QueryInterface(IID_IHXPlugin2Handler,
                                  (void**)&pPlugin2Handler);
    g_return_val_if_fail(pPlugin2Handler && SUCCEEDED(retVal), NULL);
    
    nNumPlugins = pPlugin2Handler->GetNumOfPlugins2();
    
    /* Populate the store */
    store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
    for(nIndex = 0; nIndex < nNumPlugins; nIndex++)
    {
        pPlugin2Handler->GetPluginInfo(nIndex, pPluginProps);

        plugin_name = NULL;
        plugin_description = NULL;
        
        retVal = pPluginProps->GetFirstPropertyCString(szPropName, pPropValue);
        while(SUCCEEDED(retVal))
        {
            if(strcmp(szPropName, "PluginFilename") == 0)
            {
                plugin_name = (gchar*)pPropValue->GetBuffer();
            }

            if(strcmp(szPropName, "Description") == 0)
            {
                plugin_description = (gchar*)pPropValue->GetBuffer();
            }

            retVal = pPluginProps->GetNextPropertyCString(szPropName, pPropValue);
        }

        if(plugin_name && plugin_description)
        {
            gtk_list_store_append(store, &tree_iter);
            gtk_list_store_set (store, &tree_iter,
                                0, plugin_name,
                                1, plugin_description,
                                -1);
        }

        HX_RELEASE(pPluginProps);
    }
    
    HX_RELEASE(pPlugin2Handler);
    HX_RELEASE(pUnk);

    /* Configure the tree view */
    gtk_tree_view_set_model(GTK_TREE_VIEW(tree_view),
			    GTK_TREE_MODEL(store));

    renderer = gtk_cell_renderer_text_new();
    column = gtk_tree_view_column_new_with_attributes(_("Plugin"),
                                                      renderer,
                                                      "text", 0,
                                                      NULL);                                                                                
    gtk_tree_view_append_column(GTK_TREE_VIEW(tree_view), column);
    gtk_tree_view_column_set_sort_column_id(column, 0);
    
    column = gtk_tree_view_column_new_with_attributes(_("Description"),
                                                      renderer,
                                                      "text", 1,
                                                      NULL);                                                                                
    gtk_tree_view_append_column(GTK_TREE_VIEW(tree_view), column);
    gtk_tree_view_column_set_sort_column_id(column, 1);

    /* Launch the dialog */
    dialog = glade_xml_get_widget (xml, "hxplayer_plugins_dialog");

    g_object_unref (store);

    info = g_new0(HXPluginsDialog, 1);
    info->xml = xml;

    g_signal_connect (G_OBJECT (dialog), "destroy",
                      G_CALLBACK (hxplay_plugins_dialog_destroy),
                      info);

    return GTK_DIALOG(dialog);
}
