#!/bin/sh

# script arguments
INSTDIR=$1
LOGFILE=$2


# no instdir passed in? guess it
if [ -z $INSTDIR ] ; then
    if [ -f ../hxplay.bin -o -f ../realplay.bin ] ; then
	INSTDIR=`( cd ..; pwd )`
    elif [ -f hxplay.bin -o -f realplay.bin ] ; then
	INSTDIR=`pwd`
    else
	echo "cannot find the installation directory--aborting setup!"
	exit 1
    fi
fi


# which target are we installing for?
if [ -f $INSTDIR/realplay ] ; then
    TARGET=realplay
elif [ -f $INSTDIR/hxplay ] ; then
    TARGET=hxplay
else
    echo "cannot find either hxplay or realplay--aborting setup!"
    exit 2
fi


# make sure we know exactly where our logfile is
if [ -n "$LOGFILE" ] ; then
    if [ -f $INSTDIR/$LOGFILE ]; then
	LOGFILE=$INSTDIR/$LOGFILE
    fi
fi


# for logging our commands
eval_cmd()
{
    eval $*
    if [ -n "$LOGFILE" ] ; then
	echo $* >> $LOGFILE
    fi
}


# configure the player startup script
echo "Configuring $TARGET script..."
(
    cd $INSTDIR ;
    EXPR="s%#[ \t]*HELIX_LIBS[ \t]*=.*$%HELIX_LIBS=`pwd` ; export HELIX_LIBS%"
    eval_cmd cp $TARGET $TARGET.bak
    eval_cmd "sed -e \"$EXPR\" $TARGET.bak > $TARGET"
)

