/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: wingapiblt.cpp,v 1.2.4.1 2004/07/09 01:59:24 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxcom.h"
#include "hxtypes.h"
#include "hxwintyp.h"
#include "wingapiblt.h"

CGAPIBlt::CGAPIBlt()
 :  CWinBlt()
 ,  m_bxdp(NULL)
 ,  m_pMemory(NULL)

{
    memset(&m_gxdp,0,sizeof(m_gxdp));
}

CGAPIBlt::~CGAPIBlt()
{
    DestroySurface(0);
}

//----------------------------------------------
// determine if the gapi interface works on this device
// and whether we can use it

BOOL CGAPIBlt::CanCreateSurface()
{
    if (!GXOpenDisplay(NULL, NULL))
	return false;

    // Get the Display properties
    m_gxdp = GXGetDisplayProperties();
    GXCloseDisplay();

    if (m_gxdp.cBPP != 16 || m_gxdp.cbxPitch != 2)
	return false;

    return true;
}

HX_RESULT CGAPIBlt::CreateSurface(int cidIn, int& cidOut,
                                int nWidth, int nHeight,
                                int nFlags, HWND hWnd,
                                int nCountIn, int& nCountOut)
{
    HRESULT hr = HXR_OK;

    m_hWnd = hWnd;

    if (!m_bxdp)
    {
	//if (GXOpenDisplay(hWnd, GX_FULLSCREEN))
	if (GXOpenDisplay(NULL, NULL))
	{
	    // Initialize the Hardware Buttons
	    GXOpenInput();
	    // Get the Display properties
	    m_gxdp = GXGetDisplayProperties();

	    if (m_gxdp.cBPP == 16 /*|| m_gxdp.cBPP == 8*/)
	    {
		m_nCID = CID_UNKNOWN;
		if (m_gxdp.ffFormat & kfDirect555)
		    m_nCID = CID_RGB555;
		if (m_gxdp.ffFormat & kfDirect565)
		    m_nCID = CID_RGB565;
		//if (m_gxdp.cBPP == 8)
		//    m_nCID = CID_RGB8;
		if (m_nCID == CID_UNKNOWN)
		{
		    hr = HXR_FAIL;
		}
		else
		{
		    m_nMemoryYPitch = nWidth * m_gxdp.cbxPitch;
		    int len = m_nMemoryYPitch*nHeight;
		    m_pMemory = (UCHAR *) malloc(len);
		    if (NULL == m_pMemory)
			hr = HXR_FAIL;
		    else
    			m_bxdp = true;
		}
	    }
	    else
	    {
		hr = HXR_FAIL;
	    }
	}
	else
	{
	    hr = HXR_FAIL;
	}
    }
    return hr;
}

HX_RESULT CGAPIBlt::LockSurface(UCHAR** ppDestPtr,
                              LONG32* pnDestPitch,
                              int& cid,
                              REF(HXxSize) dstSize,
                              int nIndex)
{
//    *ppDestPtr = (UCHAR *) GXBeginDraw();

    *ppDestPtr = m_pMemory;
    *pnDestPitch = m_nMemoryYPitch;
    if (m_pMemory)
	return HXR_OK;
    else
	return HXR_FAIL;

}

//-----------------------------------------------------------
HX_RESULT CGAPIBlt::FillSurface(int cidIn,
                              UCHAR* pSrcBuffer,
                              HXxSize* pSrcSize,
                              HXxRect* prSrcRect,
                              UCHAR* pDstBuffer,
                              LONG32 nDstPitch,
                              HXxRect* prDestRect)
{
    return HXR_FAIL;
}

//-----------------------------------------------------
HX_RESULT CGAPIBlt::UnlockSurface(UCHAR* pSurfPtr, int nIndex)
{
//    GXEndDraw();

    if (m_pMemory)
        return HXR_OK;
    else
	return HXR_FAIL;
}
//----------------------------------------------------------
HX_RESULT CGAPIBlt::RenderSurface(HXxSize* pSrcSize,
                                HXxRect* prSrcRect,
                                HXxRect* prDestRect,
                                int nIndex)
{
    int nLeft=0,nTop=0; // number of off screen pixels/lines

    if (NULL == m_pMemory)
	return HXR_FAIL;


    // Map to screen coordinates
    POINT   po = {0,0};
    ClientToScreen(m_hWnd, &po);
    if (po.x < 0)
    {
	nLeft = abs(po.x);
	po.x = 0;
    }
    if (po.y < 0)
    {
	nTop = abs(po.y);
	po.y = 0;
    }


    RECT rc;
    GetClientRect(m_hWnd, &rc);


    POINT pul = {rc.left,rc.top};
    ClientToScreen(m_hWnd,&pul);

    if (pul.x >= GetSystemMetrics(SM_CXSCREEN))
	return HXR_OK;// left is off screen to right
    if (pul.y >= GetSystemMetrics(SM_CYSCREEN))
	return HXR_OK;// top is off screen to bottom

    // width of image, width of window
    int nWidth = min(rc.right,pSrcSize->cx-nLeft);
    if ((po.x+nWidth) > GetSystemMetrics(SM_CXSCREEN))
	nWidth = GetSystemMetrics(SM_CXSCREEN)-po.x;
    if (nWidth <= 0)
	return HXR_OK;
    // height of image, height of window
    int nHeight = min(rc.bottom,pSrcSize->cy-nTop);
    if ((po.y+nHeight) > GetSystemMetrics(SM_CYSCREEN))
	nHeight = GetSystemMetrics(SM_CYSCREEN)-po.y;
    if (nHeight <= 0)
	return HXR_OK;

    unsigned short *dptr = (unsigned short *) GXBeginDraw();
    unsigned short *sptr = (unsigned short *) m_pMemory;
    if (NULL == dptr)
    {
	GXEndDraw();
	return HXR_FAIL;
    }

    unsigned short * puDst;
    unsigned short * puSrc;

    for (int y = 0; y < nHeight; y++) // for each line
    {
	puDst = dptr + (y+po.y)*m_gxdp.cbyPitch/2 + po.x;
	puSrc = sptr + (y+nTop)*m_nMemoryYPitch/2 + nLeft;
	memcpy(puDst,puSrc,2*nWidth);
    }
    GXEndDraw();

    return HXR_OK;
}
//-------------------------------------------------------
HX_RESULT CGAPIBlt::DestroySurface(int cid)
{
    if (m_pMemory)
	free(m_pMemory);
    m_pMemory = NULL;
    GXCloseDisplay();
    GXCloseInput();
    return HXR_OK;
}
