/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: unixsite.h,v 1.2.34.2 2004/07/09 01:58:44 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 *                 Phil Dibowitz (jaymzh)
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _UNIXSITE_H
#define _UNIXSITE_H

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/extensions/XShm.h>

#include "basesite.h"

class CHXUnixSite : public CHXBaseSite
{
public:

   friend class CUnixSurf;
   friend class CUnixRootSurf;
   
   CHXUnixSite( IUnknown* pContext,
                IUnknown* pUnkOuter,
                INT32 lInitialZorder);
   
   static void ProcessEvent(HXxEvent* pEvent);
   Window CreateXWindow( Window win ); 

   void _ForwardUpdateEvent(HXxEvent* pEvent);

   //static member vars.
   static Display* zm_display;
   void _UpdateOverlayIfNeeded();
   BOOL m_bIgnoreFocusOutInFS;

   //We override this.
   void CheckColorSettings();

protected:
   
   virtual ~CHXUnixSite();
   
   //
   // CHXUnixSite only methods....
   //
   HX_RESULT   _OpenXDisplay(char* DiplayString);
   static void _CollapseExposeEvents(XEvent* xevent);
   BOOL        _ShouldProcess(HXxEvent* pEvent);
   void        _DrawArrows();
   void        _CreateHorizScrollBar(void);
   void        _CreateVertScrollBar(void);
   BOOL        _InButton(HXxPoint& pt, int x, int y );
   void        _DestroyScrollButtons();
   void        _MapScrollButtons();
   void        _MapHorzScroll();
   void        _MapVertScroll();
   void        _UnmapHorzScroll();
   void        _UnmapVertScroll();
   void        _UnmapScrollButtons();
   void        _BuildClipRegion();
   void        _ReleaseClippingRegion();

   //
   // Seperate object for our callbacks to keep the events flowing.
   //
   class UnixEventHandler : public IHXCallback
   {
   public:
      UnixEventHandler(CHXUnixSite* pParent);
        
      //IUnknown methods
      virtual HX_RESULT QueryInterface(REFIID riid, void** ppvObj);
      virtual ULONG32 AddRef();
      virtual ULONG32 Release();

      //IHXCallback methods
      virtual HX_RESULT Func(); 
      void CancelCallback();
        
   private:
      virtual ~UnixEventHandler();
      PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME
       
      UnixEventHandler();
      UnixEventHandler(const UnixEventHandler&);
      UnixEventHandler& operator=(const UnixEventHandler& it );
        
      CHXUnixSite*   m_pParent;
      LONG32         m_lRefCount;
      CallbackHandle m_cbHandle;
   };
    

   //
   // CHXBaseSite inherited methods
   //
   virtual void  _NeedWindowedSite();
   virtual void  _AttachWindow();
   virtual void  _DetachWindow();
   virtual void* _Create(void* ParentWindow, UINT32 style);
   virtual void  _Destroy(HXxWindow* pWindow); 
   virtual void  _SetSize(HXxSize size); 
   virtual void  _SetPosition(HXxPoint position); 
   virtual void  _DamageRect(HXxRect rect);
   virtual void  _DamageRegion(HXxRegion rect);
   virtual BOOL  _ShouldEnterForceRedraw(); 
   virtual void  _ExitForceRedraw(); 
   virtual void  _SendOSUpdateMessage(); 
   virtual void  _ShowSite(BOOL bShow); 
   virtual BOOL  _AtSystemTime(); 
   virtual void  _GetDeviceCaps( void* hdc,
                                 UINT16& uBitesPerPixel,
                                 UINT16& uHorzRes,
                                 UINT16& uVertRes ); 
   virtual void  _GetWindowRect(HXxRect* destRect);
   virtual void  _DestroySliders();
   virtual BOOL  _HandleOSEvents(HXxEvent* pEvent);
   virtual BOOL  _ConvertToHXEvent(HXxEvent* pEvent);
   virtual void  _GenerateOSEvent(HXxEvent* pEvent, HXxEvent* pEvent2);
   virtual void  _GenerateSetCursorEvent();
   virtual void  _TryCreateXSlider();
   virtual void  _SetXSliderValues(INT32 range, INT32 pageSize);
   virtual void  _TryCreateYSlider();
   virtual void  _SetYSliderValues(INT32 range, INT32 pageSize);
   virtual void  _GetSystemSizeOfSliders(INT32* pWidth, INT32* pHeight);
   virtual BOOL  _IsWindowVisible();
   virtual void  _ShowXSlider(BOOL bShow);
   virtual void  _MoveXSlider( INT32 left,
                               INT32 top,
                               INT32 right,
                               INT32 bottom,
                               BOOL bRedraw );
   virtual void  _ShowYSlider(BOOL bShow);
   virtual void  _MoveYSlider( INT32 left,
                               INT32 top,
                               INT32 right,
                               INT32 bottom,
                               BOOL bRedraw);
   virtual BOOL  _DoesXSliderExist();
   virtual void* _GetContainingWindow();
   virtual void  _GetCursorPos(HXxPoint* pPoint);
   virtual void  _MapPointToOSWindow(HXxPoint* pPt, void** pWindowHandle);
   virtual void* _GetWindowWithCursor();
   virtual void  _ReInitPrimarySurface();
   virtual BOOL  _MoveWindow( void* ,
                              INT32 X,
                              INT32 Y,
                              INT32 nWidth,
                              INT32 nHeight,
                              BOOL bRepaint);
   virtual BOOL  _UpdateWindow(void* hWnd);
   virtual BOOL  _ShowWindow(void* hWnd, INT32 nCmdShow);
   virtual BOOL  _SetWindowPos(void* hWnd,
                               void* hWndInsertAfter,
                               INT32 X,
                               INT32 Y,
                               INT32 cx,
                               INT32 cy,
                               INT32 uFlags);
   virtual BOOL  _SetWindowRgn(void* hWnd, HXREGION* hRgn, BOOL bRedraw);
   virtual void _SetFocus(void* pWindow);
    
   virtual HX_RESULT _EnterFullScreen();
   virtual HX_RESULT _EventOccurred(HXxEvent* pEvent);
   virtual HX_RESULT _ExitFullScreen();
   virtual HX_RESULT _TestFullScreen( void* hTestBitmap,
                                      const char* pszStatusText );

private:

   //Protect unintentional copy and default ctors.
   CHXUnixSite();
   CHXUnixSite( const CHXUnixSite& );
   CHXUnixSite& operator=( const CHXUnixSite& it );
    
   //member vars.
   UnixEventHandler* m_pUnixEventHandler;
   static Cursor zm_GrabCursor;
   Window        m_ScrollHorizButtonL;
   Window        m_ScrollHorizButtonR;
   Window        m_ScrollVertButtonT;
   Window        m_ScrollVertButtonB;
   Window        m_winFullScreenWindow;
   Window        m_winOldParent;
   HXxPoint      m_ptScrollHorizPosL;
   HXxPoint      m_ptScrollHorizPosR;
   HXxPoint      m_ptScrollVertPosT;
   HXxPoint      m_ptScrollVertPosB;
   HXxPoint      m_ptFullScreenOffset;
   HXxSize       m_PreFullScreenSize;
   BOOL          m_bScrollingInProgress;
   int           m_nScrollDir;
   BOOL          m_bLastPointInSite;
   BOOL          m_bDamaged;
   //
   //Private helpers...
   //

   //returns the HX_VK associated with this keysym....
   UINT32 _MapKeySymToHXVK(KeySym tmpSym, UINT32& uFlags);
};


/////////////////////////////////////////////////////////
//
// CHXSiteEventHandler
//
/////////////////////////////////////////////////////////
class CHXSiteEventHandler : public IHXSiteEventHandler
{
public:
   CHXSiteEventHandler(IUnknown* pContext);

   virtual HX_RESULT QueryInterface(REFIID riid, void** ppvObj);
   virtual ULONG32 AddRef();
   virtual ULONG32 Release();
   virtual HX_RESULT EventOccurred(HXxEvent* pEvent);

private:
   ~CHXSiteEventHandler();
   PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

   IUnknown* m_pContext; 
   ULONG32   m_lRefCount;
};


#endif //_UNIXSITE_H
