/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: unixsurf.h,v 1.1.1.1.42.2 2004/07/09 01:58:44 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _UNIXSURF_H
#define _UNIXSURF_H

#include "basesurf.h"
#include "baseroot.h"

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/extensions/XShm.h>

//This was never added to the XShm.h header file for some reason.
extern "C"
{
    extern int XShmGetEventBase( Display *);
}


#if defined(_LINUX) && defined(_OVERLAY)
#  include <X11/extensions/Xv.h>
#  include <X11/extensions/Xvlib.h>
#endif

#if defined(HELIX_FEATURE_HARDWARE_COLOR_CONTROLS)

//For use to store min/max port attribute values for
//the color controls.
typedef struct _PortAttribute
{
    _PortAttribute(int min, int max)
        :nMinValue(min),
         nMaxValue(max)
        {}
    _PortAttribute()
        :nMinValue(0),
         nMaxValue(0)
        {}
    int nMinValue;
    int nMaxValue;
} stPortAttribute;

#endif

class CUnixSurf : public CBaseSurface
{
public:
   CUnixSurf( IUnknown* pContext, CHXBaseSite* pSite );
   
protected:
   virtual void      _ReleaseSurface(CBaseRootSurface* pSurface);
   virtual void      _DrawBlack(void* pWindow);
   virtual HX_RESULT _BltToPrimary(HXxRect& rDestRect, HXxRect& rSrcRect);
   virtual void      _CreateBuffer();
   virtual HX_RESULT _GetCaps(UINT32 *pfSurfaceCaps);
   virtual HX_RESULT _CreateOverlay(BOOL bOverlay, int cid, int x, int y);
   virtual HX_RESULT _LockInternalSurface(UCHAR** ppSurfPtr,
                                          LONG32* pnSurfPitch,
                                          HXxSize& notused);
   virtual HX_RESULT _UnlockInternalSurface(UCHAR* pSurfPtr);
   virtual void      _SetupDCObjects(HXxDC hxxDC,
                                     void** phOldBrush, void** phOldPen);
   virtual void      _FillRectangle(HXxDC hxxDC,
                                    UINT32 left, UINT32 top,
                                    UINT32 right, UINT32 bottom);
   virtual void      _RestoreDCObjects(HXxDC hxxDC,
                                       void* hOldBrush, void* hOldPen);
   virtual void      _GetCompositionSurfaceHXxDC(HXxDC *hdc);
   virtual void      _ReleaseCompositionSurfaceHXxDC(HXxDC hdc);
   virtual INT32     _InsureColorMatch(INT32 InColor);
   virtual void      _SetColorKey(INT32 nColorSpaceLowValue,
                                  INT32 nColorSpaceHighValue);
   virtual void      _UpdateOverlay(HXxRect* src, HXxRect* dest, INT32 inFlags);
   virtual BOOL      _IsSurfaceVisible();
   virtual void      _ReleaseSurface();
   virtual HXxDC     _GetDC(HXxWindow*);
   virtual void      _ReleaseDC(HXxWindow*, HXxDC);

   //Helpers
   // returns true if there is a port that supports the fourcc.
   // if called with no parameters, return wether or not overlays
   // are supported at all.
   BOOL _OverlayAvailable(int fourccWanted=-1, int* nPortID=NULL );

   //Converts window coordinates into device coordinates
   //if needed. This is used on Windows at least because
   //its overlays use screen coords instead of window coords.
   //This is a noop on unix as its overlays are in window coords.
   virtual void _GetWindowDeviceCords(HXxRect* rect );


private:
   virtual ~CUnixSurf();

   int m_nCompletionEventID;
    
   //Protect unintentional copy and default ctors.
   CUnixSurf();
   CUnixSurf( const CUnixSurf& );
   CUnixSurf& operator=(const CUnixSurf& it );

#if defined(_LINUX) && defined(_OVERLAY)
   static CUnixSurf* zm_pXvOwner;
   
   BOOL        m_bWallPaperMode;
   ULONG32     m_ulColorKey;
   BOOL        m_bPaintClipList;
   BOOL        m_bStretchToFill;
   INT32       m_nPortID;
   XvImage**   m_pXvImage;
   Atom        m_atomColorKey;
   Atom        m_atomClipKey;


#if defined(HELIX_FEATURE_HARDWARE_COLOR_CONTROLS)

   Atom        m_atomBrightness;
   Atom        m_atomContrast;
   Atom        m_atomHue;
   Atom        m_atomSaturation;

   stPortAttribute paBrightness;
   stPortAttribute paContrast;
   stPortAttribute paHue;
   stPortAttribute paSaturation;

   int m_nCurrBrightness;
   int m_nCurrContrast;
   int m_nCurrSaturation;
   int m_nCurrHue;
   
  public:
   void SetHWColorControls();
   BOOL HasHWColorConrols();
       
#endif
   
#endif //_OVERLAY
  public:
   ULONG32     m_ulLastOverlayUpdateTime;
  private:
   

   UCHAR**     m_pcVideoBuf;
   int         m_nVideoPitch;
   ULONG32     m_ulFourCCID;
   
   //Shared memory members.
   BOOL             m_bUseShm;
   XShmSegmentInfo* m_shmInfo;
   int*             m_nShmId;
   
   Display*    m_display;
   GC          m_GC;
   int         m_nScreenNumber;
   int         m_nCurrentBuffer;
   int         m_nMultiBufferCount;
};

#endif
