/* 
 *	HT Editor
 *	dataanaly.h
 *
 *	Copyright (C) 1999, 2000, 2001 Sebastian Biallas (sb@web-productions.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef dataanaly_h
#define dataanaly_h

#include "global.h"
#include "analy.h"


typedef enum {op_read, op_write, op_offset} OP;

/*
 * general type of an address
 */
typedef enum {
	dtunknown = 0,
	dtcode,
	dtunknowndata,
	dtint,
	dtfloat,
	dtarray
} taddrtypetype;

typedef enum {
	dstcunknown = 0,
	dstlocation,
	dstfunction
} taddrcodesubtype;

typedef enum {
	dstiunknown = 0,
	dstibyte,
	dstiword,
	dstidword,
	dstipword,
	dstiqword
} taddrintsubtype;

typedef enum {
	dstfunknown = 0,
	dstfdouble,
	dstfextended
} taddrfloatsubtype;

typedef enum {
	dstaunknown = 0,
	dstabyte,
	dstaword,
	dstadword,
	dstapword,
	dstaqword,
	dststring,
	dstunistring
} taddrarraysubtype;

struct taddrtype {
	taddrtypetype	type;
	union {
		byte				subtype;
		taddrcodesubtype	codesubtype;
		taddrintsubtype	intsubtype;
		taddrfloatsubtype	floatsubtype;
		taddrarraysubtype	arraysubtype;
	};
	union {
		int  length;
		// ...?
	};
};

void analyser_put_addrtype(ht_object_stream *f, const taddrtype *at);
int analyser_get_addrtype(ht_object_stream *f, taddrtype *at);

class analyser;

struct taddr;

class dataanalyser: public object	{
public:
	analyser		*analy;
			void		init(analyser *Analy);
			int		load(ht_object_stream *f);
	virtual	void		done();
	virtual	OBJECT_ID	object_id();

			void		access(ADDR Addr, OP op, int size);
			void		setaddrtype(ADDR Addr, taddrtypetype type, int subtype, int length);
			void		setaddrtype(taddr *Addr, taddrtypetype type, int subtype, int length);
			void		setcodeaddrtype(ADDR Addr, taddrcodesubtype subtype);
			void		setcodeaddrtype(taddr *Addr, taddrcodesubtype subtype);
			void		setintaddrtype(ADDR Addr, taddrintsubtype subtype, int length);
			void		setintaddrtype(taddr *Addr, taddrintsubtype subtype, int length);
			void		setfloataddrtype(ADDR Addr, taddrfloatsubtype subtype, int length);
			void		setfloataddrtype(taddr *Addr, taddrfloatsubtype subtype, int length);
			void		setarrayaddrtype(ADDR Addr, taddrarraysubtype subtype, int length);
			void		setarrayaddrtype(taddr *Addr, taddrarraysubtype subtype, int length);
	virtual	void		store(ht_object_stream *f);
};

void analyser_put_addrtype(ht_object_stream *f, const taddrtype *at);
int analyser_get_addrtype(ht_object_stream *f, taddrtype *at);

#endif
