/* This file is part of the KDE Linux Kernel Configurator
   Copyright (c) 2001 Malte Starostik <malte.starostik@t-online.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

// $Id: configlist.h,v 1.7 2001/06/17 16:49:01 malte Exp $

#ifndef _CONFIGLIST_H_
#define _CONFIGLIST_H_

#include <qptrdict.h>
#include <klistview.h>

namespace Config {
	class Node;
}

typedef QPtrDict<QListViewItem> ItemDict;

class ConfigListItem : public QListViewItem
{
public:
	ConfigListItem(QListView *parent, Config::Node *node)
		: QListViewItem(parent), m_node(node) {};
	ConfigListItem(QListViewItem *parent, QListViewItem *after,
		Config::Node *node)
		: QListViewItem(parent, after), m_node(node) {};

	virtual void setOpen(const bool);
	virtual void initialize();
	bool canEdit() const;
	QString help() const;
	void apply();

protected:
	virtual void activate();

private:
	QListViewItem *buildTree(Config::Node *node, ItemDict &dict,
		QListViewItem *after = 0);

protected:
	friend class ChoiceListItem;
	Config::Node *m_node;
};

class ChoiceListItem : public ConfigListItem
{
public:
	ChoiceListItem(ConfigListItem *parent, QListViewItem *after, int index)
		: ConfigListItem(parent, after, parent->m_node), m_index(index) {};

	virtual void initialize();

protected:
	virtual void activate();

private:
	int m_index;
};

class ConfigListView : public KListView
{
	Q_OBJECT
public:
	ConfigListView(QWidget *parent, const char *name = 0);

	virtual void rename(QListViewItem *item, int c);

	void apply();

signals:
	void changed();

private slots:
	void slotUpdate();
	void edited(QListViewItem *);
};

#endif
// vim: ts=4 sw=4 noet
