#include <qobject.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qscrollview.h>

#include <kaction.h>
#include <kdebug.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kinstance.h>
#include <kio/job.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstdaction.h>


#include "marklist.h"

#include "kmultipage.moc"

KMultiPage::KMultiPage(QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name)
  : DCOPObject("kmultipage"), KParts::ReadOnlyPart(parent, name), mainWidget(0)
{
  // For reasons which I don't understand, the initialization of the
  // DCOPObject above does not work properly, the name is ignored. It
  // works fine if we repeat the name here. -- Stefan Kebekus
  // This is because of the virtual inheritance. Get rid of it (but it's BC, and this is a lib...) -- DF
  setObjId("kmultipage");
  _scrollView = new CenteringScrollview(parentWidget, widgetName);
  _scrollView->setResizePolicy(QScrollView::AutoOne);
  _scrollView->setVScrollBarMode(QScrollView::Auto);
  _scrollView->setHScrollBarMode(QScrollView::Auto);
  _scrollView->viewport()->setBackgroundMode(QWidget::PaletteMid );

  setWidget(_scrollView);
}


KMultiPage::~KMultiPage()
{
}

QString KMultiPage::name_of_current_file()
{
  return m_file;
}

bool KMultiPage::is_file_loaded(QString filename)
{
  return (filename == m_file);
}

void KMultiPage::slotSave_defaultFilename()
{
  slotSave();
}

void KMultiPage::slotSave()
{
  // Try to guess the proper ending...
  QString formats;
  QString ending;
  int rindex = m_file.findRev(".");
  if (rindex == -1) {
    ending = QString::null;
    formats = QString::null;
  } else {
    ending = m_file.mid(rindex); // e.g. ".dvi"
    formats = fileFormats().grep(ending).join("\n");
  }

  QString fileName = KFileDialog::getSaveFileName(QString::null, formats, 0, i18n("Save File As"));

  if (fileName.isEmpty())
    return;

  // Add the ending to the filename. I hope the user likes it that
  // way.
  if (!ending.isEmpty() && fileName.find(ending) == -1)
    fileName = fileName+ending;

  if (QFile(fileName).exists()) {
    int r = KMessageBox::warningYesNo (0, i18n("The file %1\nexists. Shall I overwrite that file?").arg(fileName),
				       i18n("Overwrite File"));
    if (r == KMessageBox::No)
      return;
  }

  KIO::Job *job = KIO::file_copy( KURL( m_file ), KURL( fileName ), 0600, true, false, true );
  connect( job, SIGNAL( result( KIO::Job * ) ), this, SLOT( slotIOJobFinished ( KIO::Job * ) ) );

  return;
}

void KMultiPage::slotShowScrollbars(bool status)
{
  if (status == true) {
    _scrollView->setVScrollBarMode(QScrollView::Auto);
    _scrollView->setHScrollBarMode(QScrollView::Auto);
  } else {
    _scrollView->setVScrollBarMode(QScrollView::AlwaysOff);
    _scrollView->setHScrollBarMode(QScrollView::AlwaysOff);
  }  

  // Remember the state of the scrollbars so that we can restore
  // scrollbar visibility when we switch back from fullscreen mode to
  // normal mode
  showScrollBars = status;
}

void KMultiPage::slotIOJobFinished ( KIO::Job *job )
{
  if ( job->error() )
    job->showErrorDialog( 0L );
}


void KMultiPage::slotSetFullPage(bool fullpage)
{
  //  kdDebug() << "KMultiPage::slotSetFullPage() called" << endl;

  if (fullpage == true) {
    _scrollView->setVScrollBarMode(QScrollView::AlwaysOff);
    _scrollView->setHScrollBarMode(QScrollView::AlwaysOff);
    frameStyle = _scrollView->frameStyle();
    _scrollView->setFrameStyle(QFrame::NoFrame);
    backgroundColor = _scrollView->viewport()->paletteBackgroundColor();
    _scrollView->viewport()->setPaletteBackgroundColor( Qt::black ) ;
     //   _scrollView->repaintContents(true);
  } else {
    _scrollView->viewport()->setPaletteBackgroundColor( backgroundColor ) ;
    slotShowScrollbars(showScrollBars);
    _scrollView->setFrameStyle(frameStyle);
  }
}
