=begin
$Id: extconf.rb,v 1.10 2003/07/16 07:03:00 gotoyuzo Exp $
'OpenSSL for Ruby' project
Copyright (C) 2001-2002  Michal Rokos <m.rokos@sh.cvut.cz>
All rights reserved.

This program is licenced under the same licence as Ruby.
(See the file 'LICENCE'.)
=end

require "mkmf"

if RUBY_PLATFORM =~ /mswin32/
  CRYPTOLIB="libeay32"
  SSLLIB="ssleay32"
else
  CRYPTOLIB="crypto"
  SSLLIB="ssl"
end

dir_config("openssl")

have_func("strptime", "time.h")

if with_config("debug") or enable_config("debug")
  # '--enable-debug' or '--with-debug=yes'
  $defs.push("-DOSSL_DEBUG") unless $defs.include? "-DOSSL_DEBUG"
  $CPPFLAGS += " " + "-Wall" unless $CPPFLAGS.split.include? "-Wall"
end

result  = have_header("openssl/ssl.h")
result &= have_library(CRYPTOLIB, "CRYPTO_malloc")
result &= have_library(SSLLIB, "SSLv23_method")
if result
  have_header("openssl/e_os.h")
  create_makefile("openssl")
end
