/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;

public class SVGEllipseFigure
extends SVGAttributedFigure
implements SVGFigure {
    private Ellipse2D.Double ellipse;
    private transient Shape cachedTransformedShape;
    private transient Shape cachedHitShape;

    public SVGEllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public SVGEllipseFigure(double d, double d2, double d3, double d4) {
        this.ellipse = new Ellipse2D.Double(d, d2, d3, d4);
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        if (this.ellipse.width > 0.0 && this.ellipse.height > 0.0) {
            graphics2D.fill(this.ellipse);
        }
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        if (this.ellipse.width > 0.0 && this.ellipse.height > 0.0) {
            graphics2D.draw(this.ellipse);
        }
    }

    public double getX() {
        return this.ellipse.x;
    }

    public double getY() {
        return this.ellipse.y;
    }

    public double getWidth() {
        return this.ellipse.getWidth();
    }

    public double getHeight() {
        return this.ellipse.getHeight();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.ellipse.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double double_;
        Rectangle2D rectangle2D = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double double_2 = double_ = rectangle2D instanceof Rectangle2D.Double ? (Rectangle2D.Double)rectangle2D : new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
            double d = SVGAttributeKeys.getPerpendicularHitGrowth(this) * 2.0 + 1.0;
            Geom.grow(double_, d, d);
        } else {
            double d = AttributeKeys.getStrokeTotalWidth(this);
            double d2 = d / 2.0;
            Geom.grow(double_, d2 *= Math.max(((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).getScaleX(), ((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).getScaleY()) + 1.0, d2);
        }
        return double_;
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        return this.getHitShape().contains(double_);
    }

    private Shape getTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = this.get(SVGAttributeKeys.TRANSFORM) == null ? this.ellipse : ((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(this.ellipse);
        }
        return this.cachedTransformedShape;
    }

    private Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = this.get(SVGAttributeKeys.FILL_COLOR) != null || this.get(SVGAttributeKeys.FILL_GRADIENT) != null ? new GrowStroke((float)SVGAttributeKeys.getStrokeTotalWidth(this) / 2.0f, (float)SVGAttributeKeys.getStrokeTotalMiterLimit(this)).createStrokedShape(this.getTransformedShape()) : SVGAttributeKeys.getHitStroke(this).createStrokedShape(this.getTransformedShape());
        }
        return this.cachedHitShape;
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.ellipse.x = Math.min(double_.x, double_2.x);
        this.ellipse.y = Math.min(double_.y, double_2.y);
        this.ellipse.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.ellipse.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
        this.invalidate();
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (affineTransform.getType() & 1) != affineTransform.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                SVGAttributeKeys.TRANSFORM.setClone(this, affineTransform);
            } else {
                AffineTransform affineTransform2 = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                affineTransform2.preConcatenate(affineTransform);
                this.set(SVGAttributeKeys.TRANSFORM, affineTransform2);
            }
        } else {
            Gradient gradient;
            Point2D.Double double_ = this.getStartPoint();
            Point2D.Double double_2 = this.getEndPoint();
            this.setBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
            if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null && !this.get(SVGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                gradient = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                gradient.transform(affineTransform);
                this.set(SVGAttributeKeys.FILL_GRADIENT, gradient);
            }
            if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null && !this.get(SVGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                gradient = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                gradient.transform(affineTransform);
                this.set(SVGAttributeKeys.STROKE_GRADIENT, gradient);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object object) {
        Object[] objectArray = (Object[])object;
        this.ellipse = (Ellipse2D.Double)((Ellipse2D.Double)objectArray[0]).clone();
        SVGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)objectArray[1]);
        SVGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)objectArray[2]);
        SVGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)objectArray[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.ellipse.clone(), SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n % 2) {
            case -1: {
                linkedList.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, linkedList);
                linkedList.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, linkedList);
                break;
            }
        }
        return linkedList;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return null;
    }

    @Override
    public SVGEllipseFigure clone() {
        SVGEllipseFigure sVGEllipseFigure = (SVGEllipseFigure)super.clone();
        sVGEllipseFigure.ellipse = (Ellipse2D.Double)this.ellipse.clone();
        sVGEllipseFigure.cachedTransformedShape = null;
        return sVGEllipseFigure;
    }

    @Override
    public boolean isEmpty() {
        Rectangle2D.Double double_ = this.getBounds();
        return double_.width <= 0.0 || double_.height <= 0.0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedTransformedShape = null;
        this.cachedHitShape = null;
    }
}

