/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SliderUI;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.event.FigureAttributeEditorHandler;
import org.jhotdraw.gui.event.SelectionComponentDisplayer;
import org.jhotdraw.gui.event.SelectionComponentRepainter;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.SelectionOpacityIcon;
import org.jhotdraw.text.ColorFormatter;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.Images;
import org.jhotdraw.util.ResourceBundleUtil;

public class StrokeToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;

    public StrokeToolBar() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(resourceBundleUtil.getString("stroke.toolbar"));
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(drawingEditor);
        if (drawingEditor != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
                SVGAttributeKeys.STROKE_GRADIENT.put(hashMap, null);
                JPopupButton jPopupButton = ButtonFactory.createSelectionColorButton(this.editor, SVGAttributeKeys.STROKE_COLOR, ButtonFactory.HSV_COLORS, 12, "attribute.strokeColor", resourceBundleUtil, hashMap, new Rectangle(3, 3, 10, 10), this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setAction(null, null);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                JPopupButton jPopupButton2 = new JPopupButton();
                JAttributeSlider jAttributeSlider = new JAttributeSlider(1, 0, 100, 100);
                jPopupButton2.add(jAttributeSlider);
                resourceBundleUtil.configureToolBarButton(jPopupButton2, "attribute.strokeOpacity");
                jPopupButton2.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton2));
                jPopupButton2.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.STROKE_OPACITY, null, (AttributeKey<Color>)SVGAttributeKeys.STROKE_COLOR, Images.createImage(this.getClass(), resourceBundleUtil.getString("attribute.strokeOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                jPopupButton2.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, jPopupButton2));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jPopupButton2, gridBagConstraints);
                jAttributeSlider.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider));
                jAttributeSlider.setScaleFactor(100.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_OPACITY, jAttributeSlider, this.editor));
                JPopupButton jPopupButton3 = new JPopupButton();
                JAttributeSlider jAttributeSlider2 = new JAttributeSlider(1, 0, 50, 1);
                jAttributeSlider2.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider2));
                jPopupButton3.add(jAttributeSlider2);
                resourceBundleUtil.configureToolBarButton(jPopupButton3, "attribute.strokeWidth");
                jPopupButton3.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton3));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jPopupButton3, gridBagConstraints);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_WIDTH, jAttributeSlider2, this.editor));
                jPopupButton = ButtonFactory.createStrokeJoinButton(this.editor, resourceBundleUtil, this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 3, 0, 0);
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                jPopupButton = ButtonFactory.createStrokeCapButton(this.editor, resourceBundleUtil, this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                jPopupButton = ButtonFactory.createStrokeDashesButton(this.editor, new double[][]{null, {4.0, 4.0}, {2.0, 2.0}, {4.0, 2.0}, {2.0, 4.0}, {8.0, 2.0}, {6.0, 2.0, 2.0, 2.0}}, resourceBundleUtil, this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                break;
            }
            case 2: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
                SVGAttributeKeys.STROKE_GRADIENT.put(hashMap, null);
                JAttributeTextField jAttributeTextField = new JAttributeTextField();
                jAttributeTextField.setColumns(7);
                jAttributeTextField.setToolTipText(resourceBundleUtil.getString("attribute.strokeColor.toolTipText"));
                jAttributeTextField.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField));
                jAttributeTextField.setFormatterFactory(ColorFormatter.createFormatterFactory());
                jAttributeTextField.setHorizontalAlignment(2);
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.STROKE_COLOR, hashMap, jAttributeTextField, this.editor, true));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 23;
                jPanel.add(jAttributeTextField, gridBagConstraints);
                JPopupButton jPopupButton = ButtonFactory.createSelectionColorButton(this.editor, SVGAttributeKeys.STROKE_COLOR, ButtonFactory.HSV_COLORS, 12, "attribute.strokeColor", resourceBundleUtil, hashMap, new Rectangle(3, 3, 10, 10), this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                jPopupButton.setAction(null, null);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.anchor = 23;
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                JAttributeTextField jAttributeTextField2 = new JAttributeTextField();
                jAttributeTextField2.setColumns(3);
                jAttributeTextField2.setToolTipText(resourceBundleUtil.getString("attribute.strokeOpacity.toolTipText"));
                jAttributeTextField2.setHorizontalAlignment(4);
                jAttributeTextField2.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField2.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField2));
                jAttributeTextField2.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1.0, 100.0));
                jAttributeTextField2.setHorizontalAlignment(2);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_OPACITY, jAttributeTextField2, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 23;
                jPanel.add(jAttributeTextField2, gridBagConstraints);
                JPopupButton jPopupButton4 = new JPopupButton();
                JAttributeSlider jAttributeSlider = new JAttributeSlider(1, 0, 100, 100);
                jPopupButton4.add(jAttributeSlider);
                resourceBundleUtil.configureToolBarButton(jPopupButton4, "attribute.strokeOpacity");
                jPopupButton4.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton4));
                jPopupButton4.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.STROKE_OPACITY, null, (AttributeKey<Color>)SVGAttributeKeys.STROKE_COLOR, Images.createImage(this.getClass(), resourceBundleUtil.getString("attribute.strokeOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                jPopupButton4.setPopupAnchor(4);
                this.disposables.add(new SelectionComponentRepainter(this.editor, jPopupButton4));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jPopupButton4, gridBagConstraints);
                jAttributeSlider.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider));
                jAttributeSlider.setScaleFactor(100.0);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_OPACITY, jAttributeSlider, this.editor));
                JAttributeTextField jAttributeTextField3 = new JAttributeTextField();
                jAttributeTextField3.setColumns(2);
                jAttributeTextField3.setToolTipText(resourceBundleUtil.getString("attribute.strokeWidth.toolTipText"));
                jAttributeTextField3.setHorizontalAlignment(2);
                jAttributeTextField3.putClientProperty("Palette.Component.segmentPosition", "first");
                jAttributeTextField3.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField3));
                jAttributeTextField3.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 100.0, 1.0));
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.STROKE_WIDTH, jAttributeTextField3, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.fill = 1;
                jPanel.add(jAttributeTextField3, gridBagConstraints);
                JPopupButton jPopupButton5 = new JPopupButton();
                JAttributeSlider jAttributeSlider3 = new JAttributeSlider(1, 0, 50, 1);
                jAttributeSlider3.setUI((SliderUI)PaletteSliderUI.createUI(jAttributeSlider3));
                jPopupButton5.add(jAttributeSlider3);
                resourceBundleUtil.configureToolBarButton(jPopupButton5, "attribute.strokeWidth");
                jPopupButton5.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton5));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jPopupButton5, gridBagConstraints);
                this.disposables.add(new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_WIDTH, jAttributeSlider3, this.editor));
                jPopupButton = ButtonFactory.createStrokeJoinButton(this.editor, resourceBundleUtil, this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.insets = new Insets(0, 3, 0, 0);
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                jPopupButton = ButtonFactory.createStrokeCapButton(this.editor, resourceBundleUtil, this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jPopupButton, gridBagConstraints);
                JAttributeTextField jAttributeTextField4 = new JAttributeTextField();
                jAttributeTextField4.setColumns(1);
                jAttributeTextField4.setToolTipText(resourceBundleUtil.getString("attribute.strokeDashPhase.toolTipText"));
                jAttributeTextField4.setHorizontalAlignment(2);
                jAttributeTextField4.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(jAttributeTextField4));
                jAttributeTextField4.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(-1000.0, 1000.0, 1.0));
                this.disposables.add(new FigureAttributeEditorHandler(SVGAttributeKeys.STROKE_DASH_PHASE, jAttributeTextField4, this.editor));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridwidth = 2;
                jPanel.add(jAttributeTextField4, gridBagConstraints);
                jPopupButton = ButtonFactory.createStrokeDashesButton(this.editor, new double[][]{null, {4.0, 4.0}, {2.0, 2.0}, {4.0, 2.0}, {2.0, 4.0}, {8.0, 2.0}, {6.0, 2.0, 2.0, 2.0}}, resourceBundleUtil, this.disposables);
                jPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jPopupButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 23;
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jPopupButton, gridBagConstraints);
            }
        }
        return jPanel;
    }

    @Override
    protected String getID() {
        return "stroke";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }

    private void initComponents() {
        this.setOpaque(false);
    }
}

