/*  VER 011  TAB P   $Id: newstemp.c,v 1.1.2.1 2003/01/21 20:19:45 egil Exp $
 *
 *  make temporary file name for news
 *
 *  copyright 2003 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: newstemp.c,v $
 *  Revision 1.1.2.1  2003/01/21 20:19:45  egil
 *  mktemp() replaced by newstemp()
 *
 */

#include "common.h"
#include "proto.h"
#include "self.h"
#include "stat.h"

/*
 *  make temporary file 
 *  could be replaced by mktemp()
 *
 *  NOTE: the primary reason for this function is that the perfectly fine
 *  function mktemp() from glibc complains when it is being linked.
 *  That complaint is not relevant when using it for incoming news, but it
 *  is a nuisance. Additionally, some standard mktemp() implementations are
 *  pretty lousy. The one in glibc is good.
 */
int
newstemp(char *template)
{
    char *random_part;
    long value;
    int count;

    {
	int len = strlen(template);
	if (len < 6 || strcmp((random_part = &template[len - 6]), "XXXXXX") != 0) {
	    return 0;
	}
    }

#if HAVE_GETTIMEOFDAY
    {
	struct timeval tv;
	gettimeofday(&tv, NULL);
	value = (tv.tv_usec << 10) ^ tv.tv_sec;
    }
#else
    value = (long) time(NULL);
#endif
    value += my_pid;

    for (count=0; count < 32768; ++count) {
	long v = value + count;
	int n;
	struct stat st;

	/* fill in 30 random bits */
	for (n=0; n<6; ++n) {
	    unsigned char c = v & 31;
	    v >>= 5;
	    random_part[n] = (c < 10) ? (c+'0') : ((c-10)+'A');
	}

	if (lstat(template, &st) < 0) {
	    if (errno == ENOENT) {
		return 1; /* all is well */
	    }
	    /* else, give up now */
	    return 0;
	}

	/* oops, there is already a file like this, so try to bump the count */
	{
	    static int did_srand = 0;
	    if (!did_srand) {
		srand(my_pid);
		did_srand = 1;
	    }
	    value += rand();
	}
    }

    /* ok, this is getting silly */
    return 0;
}
