/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class Window2
implements BIFFRecord {
    private static final int FROZEN = 8;
    private static final int NOSPLIT = 1;
    private byte[] rwTop = new byte[2];
    private byte colLeft;
    private byte[] grbit = new byte[2];

    public Window2() {
        this.rwTop = EndianConverter.writeShort((short)0);
        this.colLeft = 0;
        this.grbit = EndianConverter.writeShort((short)0);
    }

    public Window2(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public short getBiffType() {
        return 62;
    }

    public boolean isFrozen() {
        if ((this.grbit[0] & 8) != 8) {
            return false;
        }
        return (this.grbit[1] & 1) == 1;
    }

    public boolean isSplit() {
        if ((this.grbit[0] & 8) == 8) {
            return false;
        }
        return (this.grbit[1] & 1) != 1;
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.rwTop);
        this.colLeft = (byte)inputStream.read();
        ++n;
        Debug.log((int)4, (String)("\trwTop : " + EndianConverter.readShort((byte[])this.rwTop) + " colLeft : " + this.colLeft + " grbit : " + EndianConverter.readShort((byte[])this.grbit)));
        return n += inputStream.read(this.grbit);
    }

    public void setSplitType(Point point) {
        if (point.getX() == 1.0) {
            this.grbit[0] = (byte)(this.grbit[0] & 0xFFFFFFF7);
            this.grbit[1] = (byte)(this.grbit[1] & 0xFFFFFFFE);
        } else {
            this.grbit[0] = (byte)(this.grbit[0] | 8);
            this.grbit[1] = (byte)(this.grbit[1] | 1);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.rwTop);
        outputStream.write(this.colLeft);
        outputStream.write(this.grbit);
        Debug.log((int)4, (String)"Writing Window2 record");
    }
}

