/*************************************************************************
 *
 *  $RCSfile: t_storg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/02 13:49:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_STORE_T_STORG_HXX
#define ARY_STORE_T_STORG_HXX



// USED SERVICES
	// BASE CLASSES
#include "ti_storg.hxx"
	// COMPONENTS
	// PARAMETERS
#include <cosv/template/tpltools.hxx>
#include <manip.hxx>


namespace ary
{
namespace store
{


/** This is the standard structure for all data saved within the
    autodoc repository.
*/
template <class RE>
class StdReStorage : public ReStorage<RE>
{
  public:
    typedef UINT32      KEY;

    // LIFECYCLE
						StdReStorage();
						~StdReStorage();
  private:
    // Interface ReStorage<>
    virtual RE &        do_Add(
                            const KEY &         i_rKey,
                            DYN RE &            let_drElement );
    virtual uintt       do_ForEach(
                            const Manipulator< RE > &
                                                i_rManip );
	virtual RE *  		access_Find(
							const KEY &         i_rKey );

    typedef std::map< KEY, DYN RE * >   DataBase;

	// DATA
    DataBase            aDataBase;
};



// IMPLEMENTATION


template <class RE>
StdReStorage<RE>::StdReStorage()
//  :   aDataBase
{
}

template <class RE>
StdReStorage<RE>::~StdReStorage()
{
    csv::erase_map_of_heap_ptrs(aDataBase);
}


template <class RE>
RE &
StdReStorage<RE>::do_Add( const KEY &         i_rKey,
						  DYN RE &            let_drElement )
{
	std::pair<DataBase::iterator, bool> result
			= aDataBase.insert(DataBase::value_type(i_rKey, &let_drElement));
	if (result.second == false)
		delete &let_drElement;
	return *(*result.first).second;
}

template <class RE>
uintt
StdReStorage<RE>::do_ForEach( const Manipulator< RE > & i_rManip )
{
    for ( typename DataBase::iterator it = aDataBase.begin();
          it != aDataBase.end();
          ++it )
    {
     	i_rManip( *(*it).second );
    }

    return aDataBase.size();
}

template <class RE>
RE *
StdReStorage<RE>::access_Find( const KEY & i_rKey )
{
	return csv::value_from_map( aDataBase, i_rKey );
}


}   // namespace store
}   // namespace ary



#endif

