/*************************************************************************
 *
 *  $RCSfile: castmacs.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CASTMACS_HXX
#define _CASTMACS_HXX

/** Wrapper around the C++ keywors 'const_cast', 'reinterpret_cast', and
	'static_cast'.
 */
#if defined WNT && defined MSC
#define CONST_CAST(type, expr) (const_cast<type>(expr))
#define REINTERPRET_CAST(type, expr) (reinterpret_cast<type>(expr))
#define STATIC_CAST(type, expr) (static_cast<type>(expr))
#else // WNT, MSC
#define CONST_CAST(type, expr) ((type) (expr))
#define REINTERPRET_CAST(type, expr) ((type) (expr))
#define STATIC_CAST(type, expr) ((type) (expr))
#endif // WNT, MSC

/** Use INSECURE_DYNAMIC_CAST() in cases were due to lack of true RTTI
	  dynamic_cast<type>(expr)
	would be expressed as
	  (type) expr
	which is less visible.
 */
#define INSECURE_DYNAMIC_CAST(type, expr) ((type) (expr))

/** Use CAST_TO_BOOL() for casts that would not be needed if 'BOOL' were
	'bool', e.g. in
	  BOOL bRead = CAST_TO_BOOL(nBits & MASK_READ);
	to stand for
	  bool bRead = nBits & MASK_READ;
	or in
	  aStream << CAST_TO_BOOL(TRUE);
	to stand for
	  aStream << true;
 */
#define CAST_TO_BOOL(expr) BOOL((expr) != 0)

/** Use BOOL_CAST() for casts that are needed even if 'BOOL' were 'bool', e.g.
	in
	  BOOL bEq
	   = BOOL_CAST(nBits & MASK_READ) == BOOL_CAST(nBits & MASK_WRITE);
	to stand for
	  bool bEq = bool(nBits & MASK_READ) == bool(nBits & MASK_WRITE);
 */
#define BOOL_CAST(expr) BOOL((expr) != 0)

/** Wrapper around the C++ keyword 'mutable'.

	@descr  Non-const access to mutable members must be written using the
	MUTATE() macro.
 */
#if 0
#define MUTABLE mutable
#define MUTATE(cls, member) member
#else // 0
#define MUTABLE
#define MUTATE(cls, member) CONST_CAST(cls *, this)->member
#endif // 0

#endif // _CASTMACS_HXX

