/*************************************************************************
 *
 *  $RCSfile: privdata.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "sections.hrc"
#include "privdata.hxx"
#include "adrresid.hxx"
#include "datman.hxx"

#define LSTR_MAILGREATING	L"Mailgreeting"
#define LSTR_BIRTHDAY		L"Birthday"
#define LSTR_ANNIVERSARY 	L"Anniversary"
#define LSTR_NOTE		  	L"Note"
#define LSTR_PRIVAT 		L"Privat"

AdrPrivatData::AdrPrivatData( Window * pParent, AdrDataManagerHdl pDM)
    : AdrBasePage( pParent,pDM,AdrResId(RID_TP_PRIVDATA)),
    aFtMailgreating	( this, ResId( FT_MAILGREATING	) ),
    aEdMailgreating	( this, ResId( ED_MAILGREATING	) ),
    aFtBirthday		( this, ResId( FT_BIRTHDAY		) ),
    aEdBirthday		( this, ResId( ED_BIRTHDAY		) ),
    aFtAnniversary	( this, ResId( FT_ANNIVERSARY	) ),
    aEdAnniversary	( this, ResId( ED_ANNIVERSARY	) ),
    aFtNote			( this, ResId( FT_NOTE			) ),
    aEdNote			( this, ResId( ED_NOTE			) )
{
    FreeResource();

	Sequence<UString> seqEmpty;

	InsertToFieldList(&aEdMailgreating,	LSTR_MAILGREATING,	seqEmpty);
	InsertToFieldList(&aEdBirthday,		LSTR_BIRTHDAY,		seqEmpty);
	InsertToFieldList(&aEdAnniversary,	LSTR_ANNIVERSARY,	seqEmpty);
	InsertToFieldList(&aEdNote,			LSTR_NOTE,			seqEmpty);
}

AdrPrivatData* CreatePrivatData( Window * pParent, AdrDataManagerHdl ppDM)
{
	AdrPrivatData* pAdrPrivatData=NULL;

	if(*ppDM != NULL)
	{
		AdrDataManagerPtr pDM= *ppDM;
		Sequence<UString> seqEmpty;

		if(	pDM -> GetMaxFieldCount(LSTR_MAILGREATING	,seqEmpty) >0 ||
			pDM -> GetMaxFieldCount(LSTR_BIRTHDAY		,seqEmpty) >0 ||
			pDM -> GetMaxFieldCount(LSTR_ANNIVERSARY	,seqEmpty) >0 ||
			pDM -> GetMaxFieldCount(LSTR_NOTE			,seqEmpty) >0 )
		{
			pAdrPrivatData = new AdrPrivatData(pParent,ppDM);
		}
	}
	return pAdrPrivatData;
}

