/*************************************************************************
 *
 *  $RCSfile: sdbfileaccess.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_SDBFILEACCESS_HXX_
#define _EXTENSIONS_DBI_SDBFILEACCESS_HXX_

#ifndef _EXTENSIONS_DBI_SDBSTORAGE_HXX_
#include "sdbstorage.hxx"
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _VOS_REFERNCE_HXX_ 
#include <vos/refernce.hxx>
#endif
#ifndef _EXTENSIONS_DBI_DBITYPES_HXX_
#include "dbitypes.hxx"
#endif
#ifndef _SVTOOLS_CMDPARSE_HXX
#include <svtools/cmdparse.hxx>
#endif
#ifndef _EXTENSIONS_COMPONENT_MODULE_HXX_
#include "componentmodule.hxx"
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	//==============================================================================
	//= OSdbQueryDescriptor
	//==============================================================================
	struct OQueryDescriptor
	{
		String			sStatement;
		sal_Bool		bEscapeProcessing;
	};

	//==============================================================================
	//= OSdbFileAccess
	//==============================================================================
	class OSdbFileAccess
			:public OModuleResourceClient
			,public ::vos::OReference
	{
	protected:
		::vos::ORef< SdbStorage >		m_aFile;
		::vos::ORef< SdbStorage >		m_aQueries;
		::vos::ORef< SdbStorage >		m_aForms;
		::vos::ORef< SdbStorage >		m_aTables;

		String							m_sFileName;
		String							m_sFileURL;
		String							m_sTitle;

		::svt::CommandParser			m_aDSNParser;

		sal_uInt32						m_nError;

	protected:
		~OSdbFileAccess() { }

	public:
		OSdbFileAccess();

		// open/close
		sal_Bool	open(const String& _rFile);
		sal_Bool	isOpen() { return m_aFile.isValid(); }
		void		close();

		// info from the file
		String		getFileName() const { return m_sFileName; }
		String		getFileURL() const { return m_sFileURL; }
		String		getTitle() const { return m_sTitle; }
		sal_uInt16	getTypeLogical() const;

		void		getQueryNames(StringArray& _rNames) const;
		void		getFormNames(StringArray& _rNames) const;
		void		getTableNames(StringArray& _rNames) const;

		sal_uInt32	getQueryCount() const;
		sal_uInt32	getFormCount() const;

		sal_Bool	getQuery(const String& _rName, OQueryDescriptor& /*[out]*/ _rDescr);

		SvStorageStreamRef
					getFormStream(const String& _rName);

		// error handling
		sal_uInt32	getError() const { return (ERRCODE_NONE != m_nError) || !m_aFile.isValid() ? m_nError : m_aFile->getError(); }
		sal_Bool	isError() const { return ERRCODE_NONE != getError(); }
		sal_Bool	isSuccess() const { return !isError(); }

		// access to the tokenized DSN string
		String		getDSNStringToken(const String& _rTokenName) const { return m_aDSNParser.OptionString(_rTokenName); }
		String		getDSNStringToken(const sal_Char* _pTokenName) const { return m_aDSNParser.OptionString(String::CreateFromAscii(_pTokenName)); }
		sal_Bool	getDSNBoolToken(const String& _rTokenName) const { return m_aDSNParser.OptionBool(_rTokenName); }
		sal_Bool	getDSNBoolToken(const sal_Char* _pTokenName) const { return m_aDSNParser.OptionBool(String::CreateFromAscii(_pTokenName)); }
		sal_Int32	getDSNIntToken(const String& _rTokenName) const { return m_aDSNParser.OptionInt(_rTokenName); }
		sal_Int32	getDSNIntToken(const sal_Char* _pTokenName) const { return m_aDSNParser.OptionInt(String::CreateFromAscii(_pTokenName)); }
		sal_Bool	hasDSNToken(const String& _rTokenName) const { return m_aDSNParser.Exists(_rTokenName); }
		sal_Bool	hasDSNToken(const sal_Char* _pTokenName) const { return m_aDSNParser.Exists(String::CreateFromAscii(_pTokenName)); }

		void		overwriteStringToken( const String& _rTokenName, const String& _rNewTokenValue);
		void		overwriteStringToken( const sal_Char* _pTokenName, const String& _rNewTokenValue) { overwriteStringToken(String::CreateFromAscii(_pTokenName), _rNewTokenValue); }

	protected:
		sal_Bool	readString(SvStorageStream& _rStream, String& _rValue, BOOL _bDecrypt);
		sal_Bool	readDSN();
		void		readTitle();

		String		decryptSdbString(const String& _rEncrypted);

		// reset the own error indicator (not the storage's error flag!)
		void		resetError() { m_nError = ERRCODE_NONE; }
	};

//.........................................................................
}	// namespace dbi
//.........................................................................

#endif // _EXTENSIONS_DBI_SDBFILEACCESS_HXX_

