
package org.netbeans.modules.openoffice;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.openide.compiler.Compiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.MapFormat;

/**
 *
 * @author  Michael Bohn, Bertram Nolte
 *
 */



public class OOREGCompilerGroup extends ExternalCompilerGroup {
    
    public void add(Compiler c) throws IllegalArgumentException {
        if (! (c instanceof OOREGCompiler))
            throw new IllegalArgumentException();
        super.add(c);
        OOREGCompiler mc = (OOREGCompiler) c;
        
    }
    
    /** Create the process to run the SDK tool regmerge.
     * @param desc the command template
     * @param files must be one filename
     * @throws IOException if not, or any other problem
     * @return the process
     */
    protected Process createProcess(NbProcessDescriptor desc, String[] files)
    throws IOException {
        // Declare a string array for the environment variables.
        String[] stringEnvironmentVariables = null;
        
        if ( System.getProperty( "os.name" ).indexOf( "Windows" ) != -1 ) {
            // Create environment variables for windows in a string array.
            stringEnvironmentVariables = new String[] { "LIB="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program;"
            + OOIDLGlobalSettings.getDefault().getSDKDirectory()
            + System.getProperty( "file.separator" ) + "windows"
            + System.getProperty( "file.separator" ) + "lib",
            "PATH="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program;"
            + OOIDLGlobalSettings.getDefault().getSDKDirectory()
            + System.getProperty( "file.separator" ) + "windows"
            + System.getProperty( "file.separator" ) + "bin"
            };
        }
        else if ( ( System.getProperty( "os.name" ).indexOf( "Linux" ) != -1 )
        || ( System.getProperty( "os.name" ).indexOf( "SunOS" ) != -1 ) ) {
            // Create environment variables for Linux or Solaris in a string
            // array.
            stringEnvironmentVariables = new String []{ "LD_LIBRARY_PATH="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program" };
        }
                
        return desc.exec( new Format( files[ 0 ] ),
        stringEnvironmentVariables );
    }
    
    /** Formats files and directory tags.
     */
    public static class Format extends MapFormat {
        /** Tag for the idl fiel basename.
         */
        
        public static final String TAG_URD_FILE = "urdfile";
        /** Tag for the idl files containing directory.
         */
        public static final String TAG_PROJECT_DIR = "project_directory";
        
        public static final String TAG_URD_FILE_PATH = "urdfile_directory";
        
        public static final String TAG_UDKINSTALL_DIRECTORY =
        "udk_install_directory";
        
        /** Creates the format.
         * @param file the makefile
         * @param target the make target
         */
        
        public Format(String file) {
            super ( new HashMap( 3 ) );
            
            OOIDLGlobalSettings oGlobalSettings =
            OOIDLGlobalSettings.getDefault();
            
            File f = new File( file );
            
            getMap().put( TAG_URD_FILE, f.getName() );
            
            getMap().put( TAG_URD_FILE_PATH, f.getParent() );
            
            getMap().put( TAG_PROJECT_DIR, OOTools.getFilesystemName( f ) );
            
            getMap().put( TAG_UDKINSTALL_DIRECTORY,
            oGlobalSettings.getSDKDirectory()
            + System.getProperty( "file.separator" )
            + OOTools.getODKSystemDirectory() );
        }
    }
}

