/*************************************************************************
 *
 *  $RCSfile: test.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ka $ $Date: 2000/10/30 10:42:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <tools/debug.hxx>
#include <vcl/window.hxx>
#include <stardiv/one/frame/xcollect.hxx>

#ifndef _SFX_ITEMPROP_HXX
#include <svtools/itemprop.hxx>
#endif

#include <stardiv/one/drawing/ximodel.hxx>

#include <usr/ustring.hxx>

#include <stardiv/one/drawing/drawenum.hxx>
#include <stardiv/one/drawing/drawpage.hxx>
#include <stardiv/one/drawing/shape.hxx>

#include <stardiv/uno/awt/vclout.hxx>
#include <stardiv/one/drawing/drstruct.hxx>

#include <stardiv/one/text/offtext.hxx>


#ifndef _VCL_GRADIENT_HXX //autogen
#include <vcl/gradient.hxx>
#endif
#ifndef _SVX__XGRADIENT_HXX //autogen
#include <svx/xgrad.hxx>
#endif
#ifndef _SVX_XHATCH_HXX //autogen
#include <svx/xhatch.hxx>
#endif
#ifndef _XENUM_HXX //autogen
#include <svx/xenum.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#include <vcl/fixed.hxx>
#include <vcl/lstbox.hxx>
#include <vcl/wintypes.hxx>

#include <vcl/dialog.hxx>
#include <vcl/msgbox.hxx>

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SV_UNOIFACE_HXX
#include <vcl/unoiface.hxx>
#endif

// von OS !

#define U2S(string) OUStringToString(string, CHARSET_SYSTEM)
#define S2U(string) StringToOUString(string, CHARSET_SYSTEM)
/*-----------------24.02.98 09:41-------------------

--------------------------------------------------*/
#define MAX_BOXES 80

enum BoxType
{
	BOXTYPE_CHECKBOX,
	BOXTYPE_FIXEDTEXT,
	BOXTYPE_NUMERIC,
	BOXTYPE_DBL_NUMERIC,
	BOXTYPE_FLOAT,
	BOXTYPE_STRING,
	BOXTYPE_ENUM,
	BOXTYPE_DD_LISTBOX
};
/*-----------------25.02.98 11:42-------------------

--------------------------------------------------*/
class AnyAndBox
{
	BoxType eBox;
	UsrAny aVal;
	FixedText* 		pTxt;
	NumericField*	pField2;
	union
	{
		CheckBox* 		pBox;
		Edit* 			pValueTxt;
		NumericField* 	pField;
		ListBox*		pListBox;

		Window* 		pWin;
	};

	DECL_LINK(ClickHdl, CheckBox*);
	DECL_LINK(EditHdl, Edit*);

	public:
		AnyAndBox(BoxType eSet, Window* pParent, UsrAny& rVal);
		~AnyAndBox();
	Window* 		GetWin(){return pWin;}
	UsrAny&     	GetAny(){return aVal;}
	const String& 	GetPropName(){return pTxt ? pTxt->GetText() : pBox->GetText();}
	BOOL			HasValueChanged() const;
	void			SetPosSizePixel(Point, Size);
	void 			SetValue(long nVal, long nVal2 = 0)
					{
						if(eBox == BOXTYPE_NUMERIC || eBox == BOXTYPE_DBL_NUMERIC)
						{
							pField->SetValue(nVal);
							pField->SaveValue();
							if(pField2)
							{
								pField2->SetValue(nVal2);
								pField2->SaveValue();
							}
						}
					}

	void			SetValue(double fVal)
					{
						long nVal = (long)(fVal * 1000.);
						pField->SetValue(nVal);
						pField->SaveValue();

					};

	void 			SetText(String rText, String* pValueText = 0)
					{
						if(eBox == BOXTYPE_CHECKBOX)
							pBox->SetText(rText);
						else
							pTxt->SetText(rText);
						if(eBox == BOXTYPE_STRING && pValueText)
						{
							pValueTxt->SetText(*pValueText);
							pValueTxt->SaveValue();
						}
					}
	void			AppendValue(const String& rEntry)
					{
						pListBox->InsertEntry(rEntry);
					}

};
/*-----------------25.02.98 11:42-------------------

--------------------------------------------------*/
AnyAndBox::AnyAndBox(BoxType eSet, Window* pParent, UsrAny& rSet) :
	aVal(rSet),
	eBox(eSet),
	pTxt(0),
	pWin(0),
	pField2(0)
{
	switch ( eBox )
	{
		case BOXTYPE_CHECKBOX :
			pBox = new CheckBox(pParent);
			pBox->SetClickHdl(LINK(this, AnyAndBox, ClickHdl ));
			pBox->SaveValue();
		break;
		case BOXTYPE_ENUM:
		case BOXTYPE_DBL_NUMERIC:
			pField2 = new NumericField(pParent, WB_BORDER);
			pField2->SetMin(-1000000);
			pField2->SetMax(+1000000);
			pField2->Show();
			pField2->SetModifyHdl(LINK(this, AnyAndBox, EditHdl ));
		// kein break
		case BOXTYPE_NUMERIC:
			pField = new NumericField(pParent, WB_BORDER);
			pField->SetMin(-1000000);
			pField->SetMax(+1000000);
			pField->SetModifyHdl(LINK(this, AnyAndBox, EditHdl ));
		break;
		case BOXTYPE_FLOAT:
			pField = new NumericField(pParent, WB_BORDER);
			pField->SetMin(-1000000);
			pField->SetMax(+1000000);
			pField->SetDecimalDigits( 4 );
		break;
		case BOXTYPE_STRING:
			pValueTxt = new Edit(pParent);
			pValueTxt->SetModifyHdl(LINK(this, AnyAndBox, EditHdl ));
			pValueTxt->SaveValue();
		break;
		case BOXTYPE_DD_LISTBOX:
			pListBox = new ListBox(pParent, WB_DROPDOWN);
			pListBox->SetSizePixel(Size(100, 100));
		break;
	}
	if(eBox != BOXTYPE_CHECKBOX)
	{
		pTxt = new FixedText(pParent);
		pTxt->SetSizePixel(Size(100, 20));
		pTxt->Show();
	}
	if(pWin)
	{
		if(eBox != BOXTYPE_DD_LISTBOX)
			pWin->SetSizePixel(Size(100, 20));
		pWin->Show();
	}
}
AnyAndBox::~AnyAndBox()
{
	delete pTxt;
	delete pField2;
	switch ( eBox )
	{
		case BOXTYPE_CHECKBOX :
			delete pBox;
		break;
		case BOXTYPE_NUMERIC:
			delete pField;
		break;
		case BOXTYPE_DD_LISTBOX:
			delete pListBox;
		break;
		case BOXTYPE_STRING:
			delete pValueTxt;
		break;
	}
}

void AnyAndBox::SetPosSizePixel(Point aPt, Size aSz)
{
	if(pTxt)
	{
		pTxt->SetPosPixel(aPt);
		Size aFSz(aSz);
		aFSz.Width() /= 3;
		aFSz.Width() *= 2;
		pTxt->SetSizePixel(aFSz);
		aPt.X() += aFSz.Width() + 3;
		aSz.Width() -= (aFSz.Width() + 3);
	}
	if(pField2)
	{
		Size aFSz(aSz);
		aFSz.Width() /= 2;
		aFSz.Width() -= 4;
		pField->SetSizePixel(aFSz);
		pField2->SetSizePixel(aFSz);
		pField->SetPosPixel(aPt);
		aPt.X() += aFSz.Width() + 3;
		pField2->SetPosPixel(aPt);
	}
	else if(pWin)
	{
		pWin->SetPosPixel(aPt);
		if(eBox == BOXTYPE_DD_LISTBOX)
			aSz.Height() += 100;
		pWin->SetSizePixel(aSz);
	}

}

BOOL AnyAndBox::HasValueChanged() const
{
	BOOL bRet = FALSE;
	switch ( eBox )
	{
		case BOXTYPE_CHECKBOX :
			bRet = pBox->GetSavedValue() != pBox->IsChecked();
		break;
		case BOXTYPE_ENUM:
		break;
		case BOXTYPE_DBL_NUMERIC:
			bRet|= pField2->GetSavedValue() != pField2->GetText();
		case BOXTYPE_NUMERIC:
			bRet|= pField->GetSavedValue() != pField->GetText();
		break;
		case BOXTYPE_FLOAT:
		break;
		case BOXTYPE_STRING:
			bRet = pValueTxt->GetSavedValue() != pValueTxt->GetText();
		break;
	}
	return bRet;
}

IMPL_LINK(AnyAndBox, ClickHdl, CheckBox*, pBox)
{
	aVal.setBOOL(pBox->IsChecked());
	return 0;
}
IMPL_LINK(AnyAndBox, EditHdl, Edit*, pEdt)
{
	if(eBox == BOXTYPE_STRING)
	{
		aVal.setString(S2U(pValueTxt->GetText()));
	}
	else if(pEdt == pField)
	{
		if(eBox == BOXTYPE_NUMERIC)
		{
			if( aVal.getReflection()->getName() == UINT32_getReflection()->getName() )
				aVal.setUINT32(pField->GetValue());
			else if(aVal.getReflection()->getName() == INT32_getReflection()->getName())
				aVal.setINT32(pField->GetValue());
			else if(aVal.getReflection()->getName() == UINT16_getReflection()->getName())
				aVal.setUINT16((UINT16)pField->GetValue());
			else if(aVal.getReflection()->getName() == INT16_getReflection()->getName())
				aVal.setINT16((INT16)pField->GetValue());
			else if(aVal.getReflection()->getName() == BYTE_getReflection()->getName())
				aVal.setBYTE((BYTE)pField->GetValue());
			else if( aVal.getReflection() == FillStyle_getReflection() )
			{
				FillStyle eFS = (FillStyle)pField->GetValue();
				aVal.set( &eFS, FillStyle_getReflection() );
			}
			else
				aVal.setINT16((INT16)pField->GetValue());
		}


//		else if(aVal.getReflection()->getName() == LeftRightMargin_getReflection()->getName())
//		{
//			LeftRightMargin* pLR = (LeftRightMargin*)aVal.get();
//			pLR->Left = pField->GetValue();
//		}
//		else if(aVal.getReflection()->getName() ==
//				TopBottomMargin_getReflection()->getName())
//		{
//			TopBottomMargin* pLR = (TopBottomMargin*)aVal.get();
//			pLR->Top = pField->GetValue();
//		}
	}
//	else if(pEdt == pField2)
//	{
//		if(aVal.getReflection()->getName() == LeftRightMargin_getReflection()->getName())
//		{
//			LeftRightMargin* pLR = (LeftRightMargin*)aVal.get();
//			pLR->Right = pField2->GetValue();
//		}
//		else if(aVal.getReflection()->getName() ==
//				TopBottomMargin_getReflection()->getName())
//		{
//			TopBottomMargin* pLR = (TopBottomMargin*)aVal.get();
//			pLR->Bottom = pField2->GetValue();
//		}
//	}
	return 0;
}

/************************************************************************

************************************************************************/

class PropertyDialog : public ModalDialog
{
		OKButton		aOk;
		CancelButton	aCancel;
		long 			nXPos;
		long 			nYPos;
		AnyAndBox*      aBoxes[MAX_BOXES];
		XPropertySetRef xPropSet;

			DECL_LINK(OkHdl, PushButton*);
	public:
		PropertyDialog(Window* pParent, XPropertySetRef xProp );
		~PropertyDialog();
		void AddProperty(const String& rName, UsrAny aVal);
		UsrAny* getAny(unsigned short nIndex);

};

/*-----------------24.02.98 09:45-------------------

--------------------------------------------------*/
PropertyDialog::PropertyDialog(Window* pParent, XPropertySetRef xProp) :
			ModalDialog(pParent, WB_STDMODAL),
			xPropSet(xProp),
			aOk(this),
			aCancel(this),
			nYPos(6),
			nXPos(0)
{
	SetOutputSizePixel(Size(660, 600));
	aCancel.SetPosSizePixel(Point(605, 35), Size(45, 20));
	aCancel.Show();
	aOk.SetPosSizePixel(Point(605, 10), Size(45, 20));
	aOk.SetClickHdl(LINK(this, PropertyDialog, OkHdl));
	aOk.Show();
	USHORT n = 0;
	while(n < MAX_BOXES)
	{
		aBoxes[n] = 0;
		n++;
	}


	XPropertySetInfoRef xInfo = xPropSet->getPropertySetInfo();
	Sequence<Property> aSeq = xInfo->getProperties();
	const Property* pProp = aSeq.getConstArray();

	for(USHORT i = 0; i < aSeq.getLen(); i++ )
	{
		UsrAny aAny = xProp->getPropertyValue(pProp->Name);
		AddProperty(U2S(pProp->Name), aAny);
		pProp++;
	}

}
/*-----------------24.02.98 10:02-------------------

--------------------------------------------------*/
PropertyDialog::~PropertyDialog()
{
	USHORT n = 0;
	while(n < MAX_BOXES)
	{
		delete aBoxes[n];
		n++;
	}
}
/*-----------------24.02.98 09:48-------------------

--------------------------------------------------*/
INT32 lcl_getInt32(UsrAny aVal)
{
	INT32 nRet = 0;
	if( aVal.getReflection() == BYTE_getReflection())
		nRet = (INT32)aVal.getBYTE();
	if( aVal.getReflection() == UINT16_getReflection())
		nRet = (INT32)aVal.getUINT16();
	if( aVal.getReflection() == INT16_getReflection())
		nRet = (INT32)aVal.getINT16();
	if( aVal.getReflection() == UINT32_getReflection())
		nRet = (INT32)aVal.getUINT32();
	if( aVal.getReflection() == INT32_getReflection())
		nRet = aVal.getINT32();
	return nRet;
}


void PropertyDialog::AddProperty(const String& rName, UsrAny aVal)
{
	USHORT n = 0;

	while(n <= MAX_BOXES && aBoxes[n])
		n++;
	if(n<MAX_BOXES)
	{
		const String& rReflName = U2S(aVal.getReflection()->getName());
		if(aVal.getReflection() == BOOL_getReflection())
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_CHECKBOX, this, aVal);
			((CheckBox*)aBoxes[n]->GetWin())->Check(aVal.getBOOL());
			((CheckBox*)aBoxes[n]->GetWin())->SaveValue();
		}
		else if( aVal.getReflection() == BYTE_getReflection()||
				 aVal.getReflection() == UINT16_getReflection()||
				 aVal.getReflection() == INT16_getReflection()||
				 aVal.getReflection() == UINT32_getReflection()||
				 aVal.getReflection() == INT32_getReflection())
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_NUMERIC, this, aVal);
			aBoxes[n]->SetValue(lcl_getInt32(aVal));
		}
//		else if(rReflName ==
//                        U2S(ShadowFormat_getReflection()->getName()))
//		{
//			ShadowFormat* pShadow = (ShadowFormat*)aVal.get();
//			aBoxes[n] = new AnyAndBox(BOXTYPE_NUMERIC, this, aVal);
//			aBoxes[n]->SetValue((long)pShadow->Location);
//		}
//        else if(rReflName == U2S(LeftRightMargin_getReflection()->getName()) ||
//                    rReflName == U2S(TopBottomMargin_getReflection()->getName()))
//		{
//			TopBottomMargin* pTB = (TopBottomMargin*)aVal.get();
//			aBoxes[n] = new AnyAndBox(BOXTYPE_DBL_NUMERIC, this, aVal);
//			aBoxes[n]->SetValue(pTB->Top, pTB->Bottom);
//		}
//		else if(aVal.getReflection()->getName() ==
//			LineSpacingFormat_getReflection()->getName())
//		{
//			LineSpacingFormat* pFormat = (LineSpacingFormat*)aVal.get();
//			aBoxes[n] = new AnyAndBox(BOXTYPE_DBL_NUMERIC, this, aVal);
//			aBoxes[n]->SetValue(pFormat->LineSpacingType, pFormat->LineHeight);

//		}
//		else if(aVal.getReflection()->getName() ==
//                Sequence<TabStop>::getReflection()->getName())
//		{
//            Sequence<TabStop>* pSeq = (Sequence<TabStop>*) aVal.get();
//			aBoxes[n] = new AnyAndBox(BOXTYPE_DD_LISTBOX, this, aVal);
//			TabStop* pArray = pSeq->getArray();
//			for( USHORT i = 0; i < pSeq->getLen(); i++  )
//			{
//				String sEntry(pArray[i].Position);
//				sEntry += ' ';
//				sEntry += String((USHORT)pArray[i].Alignment);
//				sEntry += ' ';
//				sEntry += pArray[i].DecimalChar;
//				sEntry += ' ';
//				sEntry += pArray[i].FillChar;
//				aBoxes[n]->AppendValue(sEntry);
//			}

//		}
		else if(aVal.getReflection() == Float_getReflection()||
			aVal.getReflection() == Double_getReflection())
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_FLOAT, this, aVal);
			aBoxes[n]->SetValue(TypeConversion::toDouble(aVal));

		}
		else if(aVal.getReflection() == OUString_getReflection())
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_STRING, this, aVal);
			String sVal(U2S(aVal.getString()));
			aBoxes[n]->SetText(rName, &sVal);
		}
//        else if(rReflName == U2S(SectionFileLink_getReflection()->getName()))
//		{
//			SectionFileLink* pLink = (SectionFileLink*)aVal.get();
//			aBoxes[n] = new AnyAndBox(BOXTYPE_SECT_LINK, this, aVal);
//            String sUrl = U2S(pLink->FileURL);
//            aBoxes[n]->SetText(rName, &sUrl);

//		}
		else if(aVal.getReflection()->getTypeClass() == TYPECLASS_ENUM)
		{
			enum AnyEnum
			{
				VALUE_1,
				VALUE_2
			};
			AnyEnum* pAnyEnum = (AnyEnum*)aVal.get();
			aBoxes[n] = new AnyAndBox(BOXTYPE_NUMERIC, this, aVal);
			aBoxes[n]->SetValue((INT32)*pAnyEnum);

		}
		else
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_FIXEDTEXT, this, aVal);
		}
		aBoxes[n]->SetPosSizePixel(Point(nXPos + 5,nYPos), Size(200, 20));
		aBoxes[n]->SetText(rName);
		nYPos += 20;
		long nHeight = GetSizePixel().Height();
		if(nYPos + 40 > nHeight)
		{
			nYPos = 5;
			nXPos += 200;
		}

	}
}

/*-----------------07.03.98 15:22-------------------

--------------------------------------------------*/
IMPL_LINK(PropertyDialog, OkHdl, PushButton*, EMPTYARG)
{
	USHORT n = 0;
	while(aBoxes[n])
	{
		if(aBoxes[n]->HasValueChanged())
		{
			xPropSet->setPropertyValue(S2U(aBoxes[n]->GetPropName()),
				aBoxes[n]->GetAny());
		}
		else
		{
			// Vars for counts and sizes
			static UINT16 nNumPolys=1;
			static UINT16 nNumPoints=4;
			static Rectangle aOuter(0,0,1000,1000);
			static PolygonFlags aPolyFlags = POLYFLAGS_NORMAL;
			// POLYFLAGS_NORMAL
			// POLYFLAGS_SMOOTH
			// POLYFLAGS_CONTROL
			// POLYFLAGS_SYMMETRIC

			if(aBoxes[n]->GetPropName() == "PolyPolygon")
			{
				PolyPolygonShape aRetval;

				// Polygone innerhalb vrobereiten
				aRetval.CoordinateX.realloc((INT32)nNumPolys);
				aRetval.CoordinateY.realloc((INT32)nNumPolys);

				// Zeiger auf aeussere Arrays holen
				CoordinateSequence* pOuterSequenceX = aRetval.CoordinateX.getArray();
				CoordinateSequence* pOuterSequenceY = aRetval.CoordinateY.getArray();

				for(UINT16 a=0;a<nNumPolys;a++)
				{
					// Platz in Arrays schaffen
					pOuterSequenceX->realloc((INT32)nNumPoints);
					pOuterSequenceY->realloc((INT32)nNumPoints);

					// Pointer auf arrays holen
					INT32* pInnerSequenceX = pOuterSequenceX->getArray();
					INT32* pInnerSequenceY = pOuterSequenceY->getArray();

					for(UINT16 b=0;b<nNumPoints;b++)
					{
						*pInnerSequenceX++ = aOuter.Left() + ((aOuter.GetWidth() * rand()) / RAND_MAX);
						*pInnerSequenceY++ = aOuter.Top() + ((aOuter.GetHeight() * rand()) / RAND_MAX);
					}

					pOuterSequenceX++;
					pOuterSequenceY++;
				}
				UsrAny aParam(&aRetval, PolyPolygonShape_getReflection());
				xPropSet->setPropertyValue(S2U(aBoxes[n]->GetPropName()), aParam);
			}
			if(aBoxes[n]->GetPropName() == "PolyPolygonBezier")
			{
				PolyPolygonBezier aRetval;

				// Polygone innerhalb vrobereiten
				aRetval.CoordinateX.realloc((INT32)nNumPolys);
				aRetval.CoordinateY.realloc((INT32)nNumPolys);
				aRetval.Flags.realloc((INT32)nNumPolys);

				// Zeiger auf aeussere Arrays holen
				CoordinateSequence* pOuterSequenceX = aRetval.CoordinateX.getArray();
				CoordinateSequence* pOuterSequenceY = aRetval.CoordinateY.getArray();
				FlagSequence* pOuterFlags = aRetval.Flags.getArray();

				for(UINT16 a=0;a<nNumPolys;a++)
				{
					// Platz in Arrays schaffen
					pOuterSequenceX->realloc((INT32)nNumPoints);
					pOuterSequenceY->realloc((INT32)nNumPoints);
					pOuterFlags->realloc((INT32)nNumPoints);

					// Pointer auf arrays holen
					INT32* pInnerSequenceX = pOuterSequenceX->getArray();
					INT32* pInnerSequenceY = pOuterSequenceY->getArray();
					PolygonFlags* pInnerFlags = pOuterFlags->getArray();

					for(UINT16 b=0;b<nNumPoints;b++)
					{
						*pInnerSequenceX++ = aOuter.Left() + ((aOuter.GetWidth() * rand()) / RAND_MAX);
						*pInnerSequenceY++ = aOuter.Top() + ((aOuter.GetHeight() * rand()) / RAND_MAX);
						*pInnerFlags++ = aPolyFlags;
					}

					pOuterSequenceX++;
					pOuterSequenceY++;
					pOuterFlags++;
				}
				UsrAny aParam(&aRetval, PolyPolygonBezier_getReflection());
				xPropSet->setPropertyValue(S2U(aBoxes[n]->GetPropName()), aParam);
			}
		}
		n++;
	}
	EndDialog(RET_OK);
	return TRUE;
}


/************************************************************************

************************************************************************/
class MyWindow : public Window
{
	USHORT 		nIndex;
	FixedText	aFt1;
	ListBox 	aLb1;
	FixedText	aFt2;
	Edit		aEdt2;
	Edit		aEdt22;
	FixedText	aFt3;
	Edit		aEdt3;
	Edit		aEdt32;
	Edit		aEdt4;
	Edit		aEdt5;
	PushButton 	aBtn1;
	PushButton 	aBtn2;
	PushButton 	aBtn3;
	PushButton 	aBtn4;
	PushButton 	aBtn5;
	PushButton 	aBtn6;
	PushButton 	aBtn7;

	XDrawPageRef	xDrawPage;
	XDrawPagesRef	xImpressDocRef;

	DECL_LINK(ClickHdl, PushButton*);

public:
	MyWindow( Window *pParent );
	~MyWindow();
};

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
MyWindow::MyWindow( Window *pParent )
				: Window( pParent ),
				aFt1	( this ),
				aLb1	( this, WinBits( WB_DROPDOWN | WB_BORDER ) ),
				aFt2	( this ),
				aEdt2	( this ),
				aEdt22	( this ),
				aFt3	( this ),
				aEdt3	( this ),
				aEdt32	( this ),
				aEdt4	( this ),
				aEdt5	( this ),
				aBtn1	( this ),
				aBtn2	( this ),
				aBtn3	( this ),
				aBtn4	( this ),
				aBtn5	( this ),
				aBtn6	( this ),
				aBtn7	( this ),
				nIndex	( 0 )
{
	Link aLink( LINK( this, MyWindow, ClickHdl ) );

	aFt1.SetPosSizePixel( 10, 10, 40, 20 );
	aFt1.SetText("Shape");
	aFt1.Show();

	aLb1.SetPosSizePixel( 50, 10, 110, 20 );

	aFt2.SetPosSizePixel( 10, 35, 50, 20 );
	aFt2.SetText("Size");
	aFt2.Show();

	aEdt2.SetPosSizePixel( 60, 35, 47, 20 );
	aEdt2.SetText("1000");
	aEdt2.Show();

	aEdt22.SetPosSizePixel( 113, 35, 47, 20 );
	aEdt22.SetText("1000");
	aEdt22.Show();

	aFt3.SetPosSizePixel( 10, 60, 47, 20 );
	aFt3.SetText("Position");
	aFt3.Show();

	aEdt3.SetPosSizePixel( 60, 60, 47, 20 );
	aEdt3.SetText("500");
	aEdt3.Show();

	aEdt32.SetPosSizePixel( 113, 60, 47, 20 );
	aEdt32.SetText("1000");
	aEdt32.Show();

	aEdt4.SetPosSizePixel( 10, 85, 150, 20 );
	aEdt4.SetText("0");
	aEdt4.Show();

	aEdt5.SetPosSizePixel( 10, 400, 150, 20 );
	//aEdt5.SetText("0");
	aEdt5.Show();

	aBtn1.SetText("Do it!");
	aBtn1.SetPosSizePixel( 10, 110, 150, 30 );
	aBtn1.SetClickHdl( aLink );
	aBtn1.Show();

	aBtn2.SetText("Modify Attributes");
	aBtn2.SetPosSizePixel( 10, 150, 150, 30 );
	aBtn2.SetClickHdl( aLink );
	aBtn2.Show();

	aBtn3.SetText("Properties");
	aBtn3.SetPosSizePixel( 10, 190, 150, 30 );
	aBtn3.SetClickHdl( aLink );
	aBtn3.Show();

	aBtn4.SetText("init");
	aBtn4.SetPosSizePixel( 10, 230, 150, 30 );
	aBtn4.SetClickHdl( aLink );
	aBtn4.Show();

	aBtn5.SetText("SetText");
	aBtn5.SetPosSizePixel( 10, 270, 150, 30 );
	aBtn5.SetClickHdl( aLink );
	aBtn5.Show();

	aBtn6.SetText("GetText");
	aBtn6.SetPosSizePixel( 10, 310, 150, 30 );
	aBtn6.SetClickHdl( aLink );
	aBtn6.Show();

	aBtn7.SetText("Connect All");
	aBtn7.SetPosSizePixel( 10, 350, 150, 30 );
	aBtn7.SetClickHdl( aLink );
	aBtn7.Show();

	ClickHdl( NULL );
}
//--------------------------------------------------
MyWindow::~MyWindow()
{
//	if( xDrawPage )
//		xDrawPage->release();

	if( xImpressDocRef )
		xImpressDocRef->release();
}

//--------------------------------------------------
IMPL_LINK( MyWindow, ClickHdl, PushButton*, pBtn )
{
	XServiceManagerRef xProv = getGlobalServiceManager();
	DBG_ASSERT( xProv, "Kein ServiceManager!" );
	XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
	if ( !xReg )
		return 0;

	Sequence<Uik> aIfaces( 1 );
	aIfaces.getArray()[0] = XModelCollection::getSmartUik();
	XServiceProviderRef xSSI = xProv->getServiceProvider( L"stardiv.desktop.ModelCollection", aIfaces, Sequence<Uik>() );

	XModelCollectionRef xModelCollRef = (XModelCollection*) xSSI->newInstance()->queryInterface( XModelCollection::getSmartUik() );
	USHORT nCount = xModelCollRef->getCount();
	BOOL bDone = FALSE;
	for (  USHORT i = 0; i < nCount && !bDone; i++ )
	{
		XModelRef aRef = xModelCollRef->getItemByIndex( i );
		if ( aRef )
		{
			UString aName = aRef->getClassName();
//			XDrawPages* xImpressDocument = (XDrawPages*)aRef->queryInterface(XDrawPages::getSmartUik());

			if( !xImpressDocRef )
			{
				xImpressDocRef = (XDrawPages*)aRef->queryInterface(XDrawPages::getSmartUik());
				if( xImpressDocRef )
					xImpressDocRef->acquire();
			}

			if( xImpressDocRef )
			{
				INT32 nCount = xImpressDocRef->getCount();
				if( nCount > 0 )
				{
					if( !xDrawPage )
					{
						xDrawPage = (XDrawPage*)(XInterface*)xImpressDocRef->getElementByIndex( 0 );
//						xDrawPage->acquire();
					}

					if( xDrawPage )
					{
						bDone = TRUE;

						if( pBtn == NULL || pBtn == &aBtn4 ) // Init
						{
							XShapeFactory* xShapeFactory = (XShapeFactory*)
								xDrawPage->queryInterface( XShapeFactory::getSmartUik() );

							if( xShapeFactory )
							{
								Sequence<UString> aStringSequence = xShapeFactory->getShapeTypes();
								long nCount = aStringSequence.getLen();
								if( nCount > 0 )
								{
									UString* pStrings = aStringSequence.getArray();
									for( long i = 0; i < nCount; i++ )
									{
										aLb1.InsertEntry( OUStringToString( pStrings[i], CHARSET_SYSTEM ) );
									}
									aLb1.SelectEntryPos(0);
									aLb1.Show();
								}
							}
						}
						/*
						else if( pBtn == &aBtn3 )
						{
							USHORT nTmp = aEdt4.GetText();
							xDrawPage->setLayout( (AutoLayout)nTmp );
						}
						 * /
						/*else if( pBtn == &aBtn4 )
						{
							String aStr = aEdt2.GetText();
							xDrawPage->setName( aStr );
						}*/
						else if( pBtn == &aBtn2 )
						{
							XShapes* xShapes = (XShapes*)
								xDrawPage->queryInterface( XShapes::getSmartUik() );
							if( xShapes )
							{
								USHORT nTmp = aEdt4.GetText();
								XShapeRef xShape = (XShape*)(XInterface*)xShapes->getElementByIndex( nTmp );
								if( xShape )
								{
									XPropertySetRef xPropSet = (XPropertySet*)xShape->queryInterface( XPropertySet::getSmartUik() );
									if( xPropSet )
									{
										BOOL bDialog = TRUE;
										if( bDialog )
										{
											PropertyDialog aDlg(this, xPropSet);
											aDlg.SetText("Shape-Properties");
											aDlg.Execute();
										}
										else
										{
											UString aUStr( L"FillStyle" );
											UsrAny aAny;

											aAny = xPropSet->getPropertyValue( aUStr );

											if( aAny.getReflection() &&
												aAny.getReflection()->getName() == aUStr )
											{
	//											INT16 nTmp = aAny.getINT16();
												FillStyle eFS = *(FillStyle*) aAny.get();

												// FillStyle
												UINT16 nTmp = ( eFS + 1 ) % 5;
												eFS = (FillStyle)nTmp;
												aAny.set( &eFS, FillStyle_getReflection() );
												xPropSet->setPropertyValue( aUStr, aAny );

												switch( eFS )
												{
													case 1 :  // Color
													{
														aUStr = L"FillColor";
														UINT32 nTmp2 = 0x00ffffff;
														aAny.setUINT32( nTmp2 );
														xPropSet->setPropertyValue( aUStr, aAny );
													}
													break;

													case 2 :  // Gradient
													{
														Gradient aGradient;
														GradientStyle eStyle = GRADIENT_LINEAR;
														Color aColor;
														USHORT nTmp = 100;

														aGradient.SetStyle( eStyle );
														aGradient.SetStartColor( aColor );
														aGradient.SetEndColor( aColor );
														aGradient.SetStartIntensity( nTmp );
														aGradient.SetEndIntensity( nTmp );
														aGradient.SetSteps( nTmp );

														aUStr = L"FillGradient";
														aAny.set( &aGradient, Gradient_getReflection() );
														xPropSet->setPropertyValue( aUStr, aAny );
													}
													break;

													case 3 :  // Hatch
													{
														XHatch aHatch;
														XHatchStyle eStyle;
														Color aColor;

														long nTmp = 100;
														aHatch.SetHatchStyle( eStyle );
														aHatch.SetColor( aColor );
														aHatch.SetDistance( nTmp );
														aHatch.SetAngle( nTmp );

														aUStr = L"FillHatch";
														aAny.set( &aHatch, Hatch_getReflection() );
														xPropSet->setPropertyValue( aUStr, aAny );
													}
													break;

													case 4 :  // Bitmap
													{
														Bitmap aBitmap;
														SvFileStream aStream("c:\\windows\\desktop\\image1.bmp", STREAM_READ);
														aBitmap.Read(aStream);

														FillBitmap aFillBitmap;
														VCLXBitmap* pVCLXBitmap;
														aFillBitmap.Bitmap = pVCLXBitmap = new VCLXBitmap();
														pVCLXBitmap->SetBitmap(aBitmap);

														aUStr = L"FillBitmap";
														aAny.set( &aFillBitmap, FillBitmap_getReflection() );
														xPropSet->setPropertyValue( aUStr, aAny );


														// Weitere testen
														BOOL bTile = FALSE;
														aUStr = L"FillBitmapTile";
														aAny.set( &bTile, BOOL_getReflection() );
														xPropSet->setPropertyValue( aUStr, aAny );
													}
													break;
												}
											}
										}
									}
								}
							}
						}
/*
						else if( pBtn == &aBtn2 )
						{
							XShapes* xShapes = (XShapes*)
								xDrawPage->queryInterface( XShapes::getSmartUik() );
							if( xShapes )
							{
								USHORT nTmp = aEdt4.GetText();
								XShapeRef xShape = (XShape*)(XInterface*)xShapes->getElementByIndex( nTmp );
								if( xShape )
								{
									// Position
									Point aPos( xShape->getPosition() );
									aEdt3.SetText( aPos.X() );
									aEdt32.SetText( aPos.Y() );
									// Groesse
									Size aSize( xShape->getSize() );
									aEdt2.SetText( aSize.Width() );
									aEdt22.SetText( aSize.Height() );
								}
							}
						}
 */
						else if( pBtn == &aBtn3 )
						{
							XPropertySetRef xPropSet = (XPropertySet*)xDrawPage->queryInterface( XPropertySet::getSmartUik() );
							if( xPropSet )
							{
								PropertyDialog aDlg(this, xPropSet);
								aDlg.SetText("SdDrawPage-Properties");
								aDlg.Execute();

/*								XPropertySetInfoRef xPropSetInfo = xPropSet->getPropertySetInfo();
								Sequence<Property> aPropertySequence = xPropSetInfo->getProperties();

								long nCount = aPropertySequence.getLen();
								if( nCount > 0 )
								{
									Property* pProperties = aPropertySequence.getArray();
									for( long i = 0; i < nCount; i++ )
									{
										Property aProp = pProperties[i];
									}
								}*/

//								UString aUStr( L"FillStyle" );
//								UsrAny aAny;

//								aAny = xPropSet->getPropertyValue( aUStr );

//								if( aAny.getReflection() &&
//									aAny.getReflection()->getName() == aUStr )
//								{
//									FillStyle eFS = *(FillStyle*) aAny.get();

//									// FillStyle
//									UINT16 nTmp = ( eFS + 1 ) % 5;
//									eFS = (FillStyle)nTmp;
//									aAny.set( &eFS, FillStyle_getReflection() );
//									xPropSet->setPropertyValue( aUStr, aAny );

//									switch( eFS )
//									{
//										case 1 :  // Color
//										{
//											aUStr = L"FillColor";
//											UINT32 nTmp2 = 0x00ffffff;
//											aAny.setUINT32( nTmp2 );
//											xPropSet->setPropertyValue( aUStr, aAny );
//										}
//										break;
//								}
							}
						}
						else if( pBtn == &aBtn5 )
						{
							XShapes* xShapes = (XShapes*)
								xDrawPage->queryInterface( XShapes::getSmartUik() );
							if( xShapes )
							{
								USHORT nTmp = aEdt4.GetText();
								XShapeRef xShape = (XShape*)(XInterface*)xShapes->getElementByIndex( nTmp );
								if( xShape )
								{
									XTextRef xText = (XText*)xShape->queryInterface( XText::getSmartUik() );
									if( xText )
									{
										aEdt5.GetText();
										UString aStr( S2U( aEdt5.GetText() ) );
										xText->setText( aStr );
									}
								}
							}
						}
						else if( pBtn == &aBtn6 )
						{
							XShapes* xShapes = (XShapes*)
								xDrawPage->queryInterface( XShapes::getSmartUik() );
							if( xShapes )
							{
								USHORT nTmp = aEdt4.GetText();
								XShapeRef xShape = (XShape*)(XInterface*)xShapes->getElementByIndex( nTmp );
								if( xShape )
								{
									XTextRef xText = (XText*)xShape->queryInterface( XText::getSmartUik() );
									if( xText )
									{
										UString aStr( xText->getText() );
										aEdt5.SetText( U2S( aStr ) );
									}
								}
							}
						}
						else if( pBtn == &aBtn7 )
						{
							XShapes* xShapes = (XShapes*)
								xDrawPage->queryInterface( XShapes::getSmartUik() );
							if( xShapes )
							{
								XShapeFactory* xShapeFactory = (XShapeFactory*)
									xDrawPage->queryInterface( XShapeFactory::getSmartUik() );

								if( xShapeFactory )
								{
									USHORT nCount = xShapes->getCount();
									for( USHORT i = 0; i < nCount-1; i++ )
									{
										XShapeRef xShape1 = (XShape*)(XInterface*)xShapes->getElementByIndex( i );
										XShapeRef xShape2 = (XShape*)(XInterface*)xShapes->getElementByIndex( i+1 );
										if( xShape1 && xShape2 )
										{
											Size aSize( 100, 100 );
											Point aPos( 100, 100 );

											UString aUStr( L"ShapeConnector" );
											XShapeDescriptorRef xShapeDescription = xShapeFactory->createShape( aUStr, aSize );

											XShapeRef xInsShape = xShapes->insertShape( xShapeDescription, aPos );

											XShapeConnector* xShapeConnector = (XShapeConnector*)
												xInsShape->queryInterface( XShapeConnector::getSmartUik() );
											if( xShapeConnector )
											{
												ConnectionType nPos = CONNECTIONTYPE_AUTO;
												xShapeConnector->connectStart( xShape1, nPos );
												xShapeConnector->connectEnd( xShape2, nPos );
											}
										}
									}
								}
							}
						}
						else
						{
							XShapeFactory* xShapeFactory = (XShapeFactory*)
								xDrawPage->queryInterface( XShapeFactory::getSmartUik() );

							if( xShapeFactory )
							{
								String aStr1( aEdt2.GetText() );
								String aStr2( aEdt22.GetText() );
								Size aSize( aStr1, aStr2 );

								aStr1 = aEdt3.GetText();
								aStr2 = aEdt32.GetText();
								Point aPos( aStr1, aStr2 );

								aStr1 = aLb1.GetSelectEntry();
								XShapeDescriptorRef xShapeDescription = xShapeFactory->createShape(
										StringToOUString( aStr1, CHARSET_SYSTEM ), aSize );

								XShapes* xShapes = (XShapes*)
									xDrawPage->queryInterface( XShapes::getSmartUik() );
								if( xShapes )
								{
									XShapeRef xShape = xShapes->insertShape( xShapeDescription, aPos );
								}
							}
						}
					}
				}
			}
		}
	}
	return 0;
}

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
extern "C" Window* __LOADONCALLAPI CreateWindow( Window *pParent, const String& rParam )
{
	MyWindow *pWin = new MyWindow( pParent );


	return pWin;
}
