/*************************************************************************
 *
 *  $RCSfile: migplug.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "migplug.hxx"

SiSetupFnc				aMigSetupFnc;

SiCustomEnvironment* 	static_pEnv			= NULL;
SiCustomModuleList*		static_pModuleList	= NULL;


/////////////////////////////////////////////////////////////////////////////
// base class SetupMigrationTask

SetupMigrationTask::SetupMigrationTask( SetupMigrationPlugin* pPlugin )
{ m_pPlugin = pPlugin; }

/////////////////////////////////////////////////////////////////////////////
// base class SetupMigrationPlugin

SetupMigrationPlugin::SetupMigrationPlugin()
{
	m_pEnv			= NULL;
	m_pModuleList	= NULL;
}

SetupMigrationPlugin::~SetupMigrationPlugin()
{
	for( USHORT i = 0; i < m_aTaskList.Count(); ++i )
		delete m_aTaskList.GetObject(i);
}

ULONG SetupMigrationPlugin::ExecuteTaskList( MigrationExecType eType )
{
	ULONG nSize = 0;
	for( USHORT i = 0; i < m_aTaskList.Count(); ++i )
	{
		SetupMigrationTask* pTask = m_aTaskList.GetObject(i);
		nSize += pTask->Execute( eType, m_pEnv->GetBigEnv() );
	}
	return nSize;
}

ByteString SetupMigrationPlugin::GetCodeFileName()
{
	return aMigSetupFnc.fncGetCodeFilename();
}

/////////////////////////////////////////////////////////////////////////////
// Setup Plugin API

extern "C" {

void _SV_CALL Kill()
{
#ifndef LINUX
	delete pPlugin;
	pPlugin = NULL;
#endif
}

BOOL _SV_CALL SupportVersion(const ByteString& rVersionKey)
{
	if( !pPlugin ) return FALSE;
	return pPlugin->SupportMigrationFor( rVersionKey );
}

void _SV_CALL Execute()
{
	if( !pPlugin ) return;
	pPlugin->ExecuteTaskList( EXECUTE );
}

ULONG _SV_CALL ExecuteCalc()
{
	if( !pPlugin ) return 0L;
	return pPlugin->ExecuteTaskList( CALCULATE_SIZE );
}

BOOL _SV_CALL CustomMain(SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList)
{
	if( !pPlugin ) return FALSE;

	pPlugin->SetEnvironment( pEnv );
	pPlugin->SetModuleList( pModuleList );

	return TRUE;
}

BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
{
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return FALSE;

	pCustomFnc->fncMain				= (FncPtrCustomMain)CustomMain;
	pCustomFnc->fncKill				= (FncPtrKill)Kill;
	pCustomFnc->fncSupportVersion	= (FncPtrSupportVersion)SupportVersion;
	pCustomFnc->fncPtrExecute		= (FncPtrExecute)Execute;
	pCustomFnc->fncPtrExecuteCalc	= (FncPtrExecuteCalc)ExecuteCalc;

	aMigSetupFnc.nVersion 			= pSetupFnc->nVersion;
	aMigSetupFnc.fncHideSetup		= pSetupFnc->fncHideSetup;
	aMigSetupFnc.fncShowSetup		= pSetupFnc->fncShowSetup;
	aMigSetupFnc.fncGetCodeFilename	= pSetupFnc->fncGetCodeFilename;

	return TRUE;
}
};


