/*************************************************************************
 *
 *  $RCSfile: undo_atr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:50:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop


#include "shellio.hxx"
#include "doc.hxx"
#include "ndtxt.hxx"
#include "pam.hxx"
#include "frmatr.hxx"

#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _FRMFMT_HXX //autogen
#include <frmfmt.hxx>
#endif

#include "sortopt.hxx"

#include "wrt_undo.hxx"
#include "undobj.hxx"
#include "rolbck.hxx"

/*
 * um nicht immer wieder nach einem Update festzustellen, das irgendwelche
 * Hint-Ids dazugekommen sind, wird hier definiert, die Groesse der Tabelle
 * definiert und mit der akt. verglichen. Bei unterschieden wird der
 * Compiler schon meckern.
 */
#define UNDOFNTAB_SIZE 22
#if !defined(UNX) && !defined(MSC) && !defined(CSET) && !defined(__MWERKS__)
#if UNDOFNTAB_SIZE != UNDO_STD_END - UNDO_STD_BEGIN
#error Undo-Tabelle ist ungueltigt. Wurden neue Undo-Aktionen zugefuegt ??
#endif
#endif

#define ROLBCKFNTAB_SIZE 12
#if !defined(UNX) && !defined(MSC) && !defined(__MWERKS__)
#if ROLBCKFNTAB_SIZE != HSTRY_END
#error Rolback-Tabelle ist ungueltigt. Wurden neue Rollback-Actionen zugefuegt ??
#endif
#endif


//  ---- private Ableitungen der Undo-Objecte ----------

Writer& OutUndo_UndoRange( Writer& rWrt, const SwUndRng& rRg )
{
	rWrt.Strm() << "Start: (";
	rWrt.OutULong( rRg.nSttNode ) << '|';
	rWrt.OutULong( rRg.nSttCntnt ) << ") Ende: (";
	rWrt.OutULong( rRg.nEndNode ) << '|';
	rWrt.OutULong( rRg.nEndCntnt) << ") ";
	return rWrt;
}

Writer& OutUndo_SaveCntnt( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoSaveCntnt& rU = (const SwUndoSaveCntnt&)rUndo;
	rWrt.Strm() << "\n{ SwUndoSaveCntnt }\n";
	return rWrt;
}



Writer& OutUndo_SaveSection( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoSaveSection& rU = (const SwUndoSaveSection&)rUndo;
	rWrt.Strm() << "\n{ SwUndoSaveSection }\n";
	return rWrt;
}




Writer& OutUndo_FlyBase( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoFlyBase& rU = (const SwUndoFlyBase&)rUndo;
	rWrt.Strm() << "{ SwUndoFlyBase ";
	switch( rU.nRndId )
	{
	case FLY_PAGE:
		rWrt.Strm() << " Seite: ";
		rWrt.OutULong( rU.nNdPgPos );
		break;
	case FLY_AT_CNTNT:
		rWrt.Strm() << " Absatz: ";
		rWrt.OutULong( rU.nNdPgPos );
		break;
	case FLY_IN_CNTNT:
		rWrt.Strm() << " Pos: (";
		rWrt.OutULong( rU.nNdPgPos ) << '|';
		rWrt.OutULong( rU.nCntPos ) << ')';
		break;
	}

	rWrt.Strm() << " DelFmt: " << (rU.bDelFmt ? "TRUE" : "FALSE" )
				<< " Format: <";
	rWrt.Strm().WriteByteString(rU.pFrmFmt->GetName(), gsl_getSystemTextEncoding());
	rWrt.Strm() << '>';
	OutUndo_SaveSection( rWrt, rU );
	rWrt.Strm() << "}\n";
	return rWrt;
}

Writer& OutUndo_Inserts( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "\n{ SwUndoInserts }\n";
	return rWrt;
}

void OutNode( Writer& rWrt, const SwNodeIndex& rNdIdx,
			USHORT nStart = USHRT_MAX,
			USHORT nLen = USHRT_MAX )
{
	SwNode* pNd = &rNdIdx.GetNode();
	switch( pNd->GetNodeType() )
	{
	case ND_TEXTNODE:
		if( USHRT_MAX == nStart )		// gesamten Node
			rWrt.Strm().WriteByteString(((SwTxtNode*)pNd)->GetTxt(), gsl_getSystemTextEncoding());
		else
			rWrt.Strm().WriteByteString(((SwTxtNode*)pNd)->GetTxt().Copy(
								nStart, nLen ), gsl_getSystemTextEncoding());
		break;
	case ND_GRFNODE:
		rWrt.Strm() << "<Grafik-Node>";
		break;
	case ND_OLENODE:
		rWrt.Strm() << "<OLE-Node>";
		break;
	}
}
// ----------------------------------------------------------



// --- die Undo-Objecte -------------------------------------

Writer& OutUndo_Start( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoStart& rU = (const SwUndoStart&)rUndo;
	rWrt.Strm() << "SwUndoStart{ Id:";
	rWrt.OutULong( rU.nUserId ) << "}\n";
	return rWrt;
}

Writer& OutUndo_End( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoEnd& rU = (const SwUndoEnd&)rUndo;
	rWrt.Strm() << "SwUndoEnd{ Id:";
	rWrt.OutULong( rU.nUserId ) << "}\n";
	return rWrt;
}

Writer& OutUndo_Delete( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoDelete& rU = (const SwUndoDelete&)rUndo;
	rWrt.Strm() << "SwUndoDelete{ ";
	OutUndo_UndoRange( rWrt, rU );
	rWrt.Strm() << "Inhalt: {";

	// Inhalt ausgeben
	if( rU.pSttStr )
	{
		rWrt.Strm().WriteByteString(*rU.pSttStr, gsl_getSystemTextEncoding());
		rWrt.Strm() << '\n';
	}
	if( rU.nNode )
	{
		SwNodeIndex aIdx( *rU.pMvStt );
		for( ULONG n = 0; n < rU.nNode; ++n, aIdx++ )
		{
			OutNode( rWrt, aIdx );
			rWrt.Strm() << '\n';
		}
	}
	if( rU.pEndStr )
	{
		rWrt.Strm().WriteByteString(*rU.pEndStr, gsl_getSystemTextEncoding());
		rWrt.Strm() << '\n';
	}

	rWrt.Strm() << "} Nodes: ";
	rWrt.OutULong( rU.nNode ) << " NodeDiff: ";
	rWrt.OutULong( rU.nNdDiff )
				<< " GroupFlag: " << ( rU.bGroup    ? "TRUE" : "FALSE" )
				<< " BackSpace: " << ( rU.bBackSp   ? "TRUE" : "FALSE" )
				<< " JoinNext: "  << ( rU.bJoinNext ? "TRUE" : "FALSE" )
				;
	OutUndo_SaveCntnt( rWrt, rU );
	rWrt.Strm() << "} \n";

	return rWrt;
}

Writer& OutUndo_Insert( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoInsert& rU = (const SwUndoInsert&)rUndo;
	rWrt.Strm() << "SwUndoInsert{ Pos: (";
	rWrt.OutULong( rU.nNode ) << '|';
	rWrt.OutULong( rU.nCntnt ) << ") Len: ";
	rWrt.OutULong( rU.nLen );
	if( rU.bIsWordDelim )
		rWrt.Strm() << " Trenner";

	if( rU.pPos )		// eine Redo-Aktion ? gebe Inhalt aus
	{
		rWrt.Strm() << " Inhalt: {";
		OutNode( rWrt, rU.pPos->nNode, rU.pPos->nContent.GetIndex(), rU.nLen );
		rWrt.Strm() << '}';
		OutUndo_SaveCntnt( rWrt, rU );
	}

	rWrt.Strm() << "}\n";
	return rWrt;
}

Writer& OutUndo_Overwrite( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoOverwrite& rU = (const SwUndoOverwrite&)rUndo;
	rWrt.Strm() << "SwUndoOverwrite{ Pos: (";
	rWrt.OutULong( rU.nSttNode ) << '|';
	rWrt.OutULong( rU.nSttCntnt )
				<< ") InsStr: <";
	rWrt.Strm().WriteByteString(rU.aInsStr, gsl_getSystemTextEncoding());
	rWrt.Strm() << "> DelStr: <";
	rWrt.Strm().WriteByteString(rU.aDelStr, gsl_getSystemTextEncoding());
	rWrt.Strm() << "> InsChar: " << (rU.bInsChar ? "TRUE" : "FALSE" )
				<< "> Goup: "    << (rU.bGroup   ? "TRUE" : "FALSE" )
				;
	OutUndo_SaveCntnt( rWrt, rU );
	rWrt.Strm() << "]\n";
	return rWrt;
}

Writer& OutUndo_SplitNode( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoSplitNode& rU = (const SwUndoSplitNode&)rUndo;
	rWrt.Strm() << "SwUndoSplitNode{ Pos: (";
	rWrt.OutULong( rU.nNode ) << '|';
	rWrt.OutULong( rU.nCntnt ) << ")\n";
	// ?? rU.pHistory;
	return rWrt;
}

Writer& OutUndo_InsAttr( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoAttr& rU = (const SwUndoAttr&)rUndo;
	rWrt.Strm() << "SwUndoAttr{ ";
	OutUndo_UndoRange( rWrt, rU );
	if( rU.aSet.Count() )
	{
		SfxItemIter aIter( rU.aSet );
		do {
			rWrt.Strm() << " HintId: ";
			rWrt.OutULong( aIter.GetCurItem()->Which() ) << ", ";
			if( aIter.IsAtEnd() )
				break;
			aIter.NextItem();
		} while( TRUE );
	}
	rWrt.Strm() << "}\n";
	return rWrt;
}

Writer& OutUndo_SetFmtColl( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoFmtColl& rU = (const SwUndoFmtColl&)rUndo;
	rWrt.Strm() << "SwUndoFmtColl{ ";
	OutUndo_UndoRange( rWrt, rU );
	if( rU.pFmtColl )
	{
		rWrt.Strm() << " Collection: ";
		rWrt.Strm().WriteByteString(rU.pFmtColl->GetName(), gsl_getSystemTextEncoding());
	}
	rWrt.Strm() << "}\n";
	return rWrt;
}

Writer& OutUndo_ResetAttr( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoRstAttr& rU = (const SwUndoRstAttr&)rUndo;
	rWrt.Strm() << "SwUndoRstAttr{ ";
	OutUndo_UndoRange( rWrt, rU );
	rWrt.Strm() << " FormatId: ";
	rWrt.OutULong( rU.nFmtId ) << "}\n";
	return rWrt;
}

Writer& OutUndo_InsFmtAttr( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoFmtAttr& rU = (const SwUndoFmtAttr&)rUndo;
	rWrt.Strm() << "SwUndoInsFmtAttr{ ";
	if( rU.pFmt )
	{
//		rWrt.Strm() << "HintId: ";
//		rWrt.OutULong( rU.pAttr->Which() );
		rWrt.Strm() << " Format: ";
		rWrt.Strm().WriteByteString(rU.pFmt->GetName(), gsl_getSystemTextEncoding());
	}
	rWrt.Strm() << "}\n";
	return rWrt;
}

Writer& OutUndo_InsDoc( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "SwUndoInsDoc\n";
	return rWrt;
}

Writer& OutUndo_Copy( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "SwUndoCopy\n";
	return rWrt;
}

Writer& OutUndo_InsTable( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoInsTbl& rU = (const SwUndoInsTbl&)rUndo;
	rWrt.Strm() << "SwUndoInsTable{ "
				<< " SttNode: ";
	rWrt.OutULong( rU.nSttNode ) << " Row|Col: (";
	rWrt.OutULong( rU.nRows ) << '|';
	rWrt.OutULong( rU.nCols ) << " ) Adjust: ";
	rWrt.OutULong( rU.nAdjust ) << "}\n";
	return rWrt;
}

Writer& OutUndo_TableToText( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoTblToTxt& rU = (const SwUndoTblToTxt&)rUndo;
	rWrt.Strm() << "SwUndoTblToTxt{ Pos: (";
	rWrt.OutULong( rU.nSttNd ) << '|';
	rWrt.OutULong( rU.nEndNd ) << ") Adjust: ";
	rWrt.OutULong( rU.nAdjust ) << " Trenner: ";
	rWrt.OutHex4(  rU.cTrenner ) << "}\n";
	return rWrt;
}

Writer& OutUndo_TextToTable( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoTxtToTbl& rU = (const SwUndoTxtToTbl&)rUndo;
	rWrt.Strm() << "SwUndoTxtToTbl{ ";
	OutUndo_UndoRange( rWrt, rU );
	rWrt.Strm() << " Adjust: ";
	rWrt.OutULong( rU.nAdjust ) << " Trenner: ";
	rWrt.OutHex4(  rU.cTrenner )
		<< " SplitEnd: " << (rU.bSplitEnd ? "TRUE" : "FALSE" )
		<< "}\n";
	return rWrt;
}

Writer& OutUndo_Sort( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoSort& rU = (const SwUndoSort&)rUndo;
	rWrt.Strm() << "SwUndoSort{ ";
	OutUndo_UndoRange( rWrt, rU );

	if( rU.pSortOpt->bTable)
		rWrt.Strm() << "Table";
	else
		rWrt.Strm() << "Text";

	rWrt.Strm() << " Elemente: ";
	rWrt.OutULong( rU.aSortList.Count() ) << "}\n";
	return rWrt;
}

Writer& OutUndo_InsLayFmt( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoInsLayFmt& rU = (const SwUndoInsLayFmt&)rUndo;
	rWrt.Strm() << "SwUndoInsLayFmt{ ";
	OutUndo_FlyBase( rWrt, rU );
	rWrt.Strm() << "}\n";
	return rWrt;
}

Writer& OutUndo_Move( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoMove& rU = (const SwUndoMove&)rUndo;
	rWrt.Strm() << "SwUndoMove{ ";
	OutUndo_UndoRange( rWrt, rU );

	rWrt.Strm() << "NewRange: {Start: (";
	rWrt.OutULong( rU.nDestSttNode) << '|';
	rWrt.OutULong( rU.nDestSttCntnt) << ") Ende: (";
	rWrt.OutULong( rU.nDestEndNode)	<< '|';
	rWrt.OutULong( rU.nDestEndCntnt)	<< ")} InsPos: (";
	rWrt.OutULong( rU.nInsPosNode)	<< '|';
	rWrt.OutULong( rU.nInsPosCntnt)	<< ") MovePos: (";
	rWrt.OutULong( rU.nMvDestNode) << '|';
	rWrt.OutULong( rU.nMvDestCntnt )
				<< ") JoinNext: " << (rU.bJoinNext ? "TRUE" : "FALSE" )
				<< " JoinPrev: "  << (rU.bJoinPrev ? "TRUE" : "FALSE" )
				<< "}\n";
	return rWrt;
}

Writer& OutUndo_InsGlossary( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "SwUndoInsGlossary\n";
	return rWrt;
}

Writer& OutUndo_DelBookmark( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoDelBookmark& rU = (const SwUndoDelBookmark&)rUndo;
	rWrt.Strm() << "SwUndoDelBookmark\n";
/*
	rWrt.Strm() << "SwUndoDelBookmark{ Pos: (" << rU.nNode << '|' << rU.nCntnt
				<< ") Name: <" << rU.aName.GetStr()
				<< "> ShortName: <" << rU.aShortName.GetStr()
				<< "> KeyCode: " << hex << rU.nKeyCode
				<< "}\n";
*/
	return rWrt;
}



Writer& OutUndo_InsBookmark( Writer& rWrt, const SwUndo& rUndo )
{
	const SwUndoInsBookmark& rU = (const SwUndoInsBookmark&)rUndo;
	rWrt.Strm() << "SwUndoInsBookmark\n";
/*
	const SwUndoDelBookmark& rU = (const SwUndoDelBookmark&)rUndo;
	rWrt.Strm() << "SwUndoDelBookmark{ Pos: (" << rU.nNode << '|' << rU.nCntnt
				<< ") Name: <" << rU.aName.GetStr()
				<< "> ShortName: <" << rU.aShortName.GetStr()
				<< "> KeyCode: " << hex << rU.nKeyCode
				<< "}\n";
*/
	return rWrt;
}


Writer& OutUndo_DelLayFmt( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "SwUndoDelLayFmt\n";
	return rWrt;
}

Writer& OutUndo_AutoFormat( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "SwAutoFormat\n";
	return rWrt;
}

Writer& OutUndo_SwUndoTblHeadline( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "SwUndoTblHeadline\n";
	return rWrt;
}

Writer& OutUndo_Replace( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "Replace\n";
	return rWrt;
}

Writer& OutUndo_SwUndoInsSection( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "InsSection\n";
	return rWrt;
}

Writer& OutUndo_SwUndoDelSection( Writer& rWrt, const SwUndo& rUndo )
{
	rWrt.Strm() << "DelSection\n";
	return rWrt;
}

//-------------------------------------------------------------------

Writer& OutUndo_Hstr_SetFmtHnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_ResetFmtHnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_SetTxtHnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_SetTxtFldHnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_SetRefMarkHnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_SetToxMarkHnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_ResetTxtHnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_SetFtnHnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_ChgFmt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_ChgFmtColl( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_FlyCnt( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}

Writer& OutUndo_Hstr_Bookmark( Writer& rWrt, const SwHstryHint& rHH )
{
	return rWrt;
}



/*
 * lege hier die Tabellen fuer die Undo-Funktions-Pointer auf
 * die Ausgabe-Funktionen an.
 * Es sind lokale Strukturen, die nur innerhalb der UNDO-DLL
 * bekannt sein muessen.
 */

SwUndoFnTab aUndoFnTab = {
/* UNDO_START */			OutUndo_Start,
/* UNDO_END */				OutUndo_End,
/* UNDO_DELETE */			OutUndo_Delete,
/* UNDO_INSERT */			OutUndo_Insert,
/* UNDO_OVERWRITE */		OutUndo_Overwrite,
/* UNDO_SPLITNODE */		OutUndo_SplitNode,
/* UNDO_INSATTR */			OutUndo_InsAttr,
/* UNDO_SETFMTCOLL */		OutUndo_SetFmtColl,
/* UNDO_RESETATTR */		OutUndo_ResetAttr,
/* UNDO_INSFMTATTR */		OutUndo_InsFmtAttr,
/* UNDO_INSDOKUMENT */		OutUndo_InsDoc,
/* UNDO_COPY */				OutUndo_Copy,
/* UNDO_INSTABLE */			OutUndo_InsTable,
/* UNDO_TABLETOTEXT */		OutUndo_TableToText,
/* UNDO_TEXTTOTABLE */		OutUndo_TextToTable,
/* UNDO_SORT_TXT */			OutUndo_Sort,
/* UNDO_INSLAYFMT */		OutUndo_InsLayFmt,
/* UNDO_TABLEHEADLINE */    OutUndo_SwUndoTblHeadline,
/* UNDO_INSSECTION */       OutUndo_SwUndoInsSection,

/* UNDO_MOVE */             OutUndo_Move,
/* UNDO_INSGLOSSARY */		OutUndo_InsGlossary,
/* UNDO_DELBOOKMARK */		OutUndo_DelBookmark,
/* UNDO_INSBOOKMARK */		OutUndo_InsBookmark,
/* UNDO_SORT_TBL */			OutUndo_Sort,
/* UNDO_DELLAYFMT */		OutUndo_DelLayFmt,
/* UNDO_AUTOFORMAT */		OutUndo_AutoFormat,		// nur eine Klammerung
/* UNDO_REPLACE */          OutUndo_Replace,
/* UNDO_DELSECTION */       OutUndo_SwUndoDelSection
};

SwRolbckFnTab aRolbckFnTab = {
/* HSTRY_SETFMTHNT */		OutUndo_Hstr_SetFmtHnt,
/* HSTRY_RESETFMTHNT */		OutUndo_Hstr_ResetFmtHnt,
/* HSTRY_SETTXTHNT */		OutUndo_Hstr_SetTxtHnt,
/* HSTRY_SETTXTFLDHNT */	OutUndo_Hstr_SetTxtFldHnt,
/* HSTRY_SETREFMARKHNT */	OutUndo_Hstr_SetRefMarkHnt,
/* HSTRY_SETTOXMARKHNT */	OutUndo_Hstr_SetToxMarkHnt,
/* HSTRY_RESETTXTHNT */		OutUndo_Hstr_ResetTxtHnt,
/* HSTRY_SETFTNHNT */		OutUndo_Hstr_SetFtnHnt,
/* HSTRY_CHGFMT */			OutUndo_Hstr_ChgFmt,
/* HSTRY_CHGFMTCOLL */		OutUndo_Hstr_ChgFmtColl,
/* HSTRY_FLYCNT */			OutUndo_Hstr_FlyCnt,
/* HSTRY_BOOKMARK */		OutUndo_Hstr_Bookmark
};



