/*************************************************************************
 *
 *  $RCSfile: rapproxyprovider.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/02/09 10:34:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPPROXYPROVIDER_HXX
#define INCLUDED_UCB_RAPPROXYPROVIDER_HXX

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE3_HXX_
#include <cppuhelper/implbase3.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

namespace com { namespace sun { namespace star {
	namespace lang { class XMultiServiceFactory; }
	namespace uno { class XInterface; }
} } }
namespace rtl { class OUString; }

namespace ucprmt {

class ProxyProvider:
	public cppu::WeakImplHelper3<
               com::sun::star::lang::XServiceInfo,
			   com::sun::star::ucb::XContentProvider,
			   com::sun::star::ucb::XContentIdentifierFactory >
{
public:
	virtual ~ProxyProvider() throw ();

    virtual rtl::OUString SAL_CALL getImplementationName() throw ();

    virtual sal_Bool SAL_CALL
	supportsService(rtl::OUString const & rServiceName)
		throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL
	getSupportedServiceNames()
		throw (com::sun::star::uno::RuntimeException);

	virtual
	com::sun::star::uno::Reference< com::sun::star::ucb::XContent> SAL_CALL
	queryContent(com::sun::star::uno::Reference<
				         com::sun::star::ucb::XContentIdentifier > const &
				     rIdentifier)
		throw (com::sun::star::ucb::IllegalIdentifierException,
			   com::sun::star::uno::RuntimeException);

	virtual sal_Int32 SAL_CALL
	compareContentIds(
		com::sun::star::uno::Reference<
				com::sun::star::ucb::XContentIdentifier > const &
			rId1,
		com::sun::star::uno::Reference<
				com::sun::star::ucb::XContentIdentifier > const &
			rId2)
		throw (com::sun::star::uno::RuntimeException);

	virtual
	com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
	SAL_CALL
	createContentIdentifier(rtl::OUString const & rContentId)
		throw (com::sun::star::uno::RuntimeException);

	static sal_Char const * getImplementationName_static();

	static com::sun::star::uno::Sequence< rtl::OUString >
	getSupportedServiceNames_static();

	static
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
	createInstance(
		com::sun::star::uno::Reference<
		        com::sun::star::lang::XMultiServiceFactory > const &
		    rServiceFactory);

private:
	com::sun::star::uno::Reference<
			com::sun::star::lang::XMultiServiceFactory >
		m_xServiceFactory;

	ProxyProvider(com::sun::star::uno::Reference<
				          com::sun::star::lang::XMultiServiceFactory > const &
				      rServiceFactory);

	com::sun::star::uno::Reference< com::sun::star::ucb::XContentProvider >
	getTarget(rtl::OUString const & rUrl)
		throw (com::sun::star::uno::RuntimeException);
};

}

#endif // INCLUDED_UCB_RAPROXYPROVIDER_HXX
