/*************************************************************************
 *
 *  $RCSfile: rmoutdev.cxx,v $
 *
 *  $Revision: 1.36 $
 *
 *  last change: $Author: ssa $ $Date: 2002/08/29 15:37:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef REMOTE_APPSERVER

#define _SV_RMOUTDEV_CXX

#include <tools/ref.hxx>
#include <rmoutdev.hxx>
#include <svdata.hxx>
#include <virdev.hxx>
#include <tools/stream.hxx>
#include <tools/debug.hxx>
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#include <outfont.hxx>
#include <gradient.hxx>
#include <hatch.hxx>
#include "rmvirdev.hxx"

#include <unotools/atom.hxx>
#include <com/sun/star/portal/client/FontAtomType.hpp>

using namespace ::com::sun::star::uno;
using namespace utl;

#include <gcach_rpeer.hxx>
#include <bitmap.hxx>

#ifdef ENABLE_CTL
#include <sallayout.hxx>
#endif

// -----------------------------------------------------------------------

static RemoteGlyphPeer aRemoteGlyphPeer;

// -----------------------------------------------------------------------

/*
 *	two atomproviders for the shared font atoms of virtual and window
 *	devices. printers need their own atom lists
 */

// =======================================================================

void ImplServerGraphics::ImplCopyFontMetric( const NMSP_CLIENT::IDLFontMetricData& rFrom, ImplFontMetricData& rTo )
{
	rTo.mnWidth = rFrom.mnWidth;
	rTo.mnAscent = rFrom.mnAscent;
	rTo.mnDescent = rFrom.mnDescent;
	rTo.mnLeading = rFrom.mnLeading;
	rTo.mnSlant = rFrom.mnSlant;
	rTo.mnFirstChar = rFrom.mnFirstChar;
	rTo.mnLastChar = rFrom.mnLastChar;

	rTo.maName = mpAtoms->getString( NMSP_CLIENT::FontAtomType::NAME, rFrom.mnName );
	rTo.maStyleName = mpAtoms->getString( NMSP_CLIENT::FontAtomType::STYLE, rFrom.mnStyleName );
	rTo.mnOrientation = rFrom.mnOrientation;
	rTo.meFamily = (FontFamily)rFrom.meFamily;
	rTo.meCharSet = (CharSet)rFrom.meCharSet;
	rTo.meWeight = (FontWeight)rFrom.meWeight;
	rTo.meItalic = (FontItalic)rFrom.meItalic;
	rTo.mePitch = (FontPitch)rFrom.mePitch;
	rTo.meType = (FontType)rFrom.meType;
	rTo.mbDevice = rFrom.mbDevice;
}

// -----------------------------------------------------------------------

void ImplServerGraphics::ImplCopyFontData( const NMSP_CLIENT::IDLFontData& rFrom, ImplFontData& rTo )
{
	rTo.mpNext = NULL;
	rTo.mpSysData = NULL;

	rTo.maName = mpAtoms->getString( NMSP_CLIENT::FontAtomType::NAME, rFrom.mnName );
	rTo.maStyleName = mpAtoms->getString( NMSP_CLIENT::FontAtomType::STYLE, rFrom.mnStyleName );
	rTo.mnWidth = rFrom.mnWidth;
	rTo.mnHeight = rFrom.mnHeight;
	rTo.meFamily = (FontFamily)rFrom.meFamily;
	rTo.meCharSet = (CharSet)rFrom.meCharSet;
	rTo.mePitch = (FontPitch)rFrom.mePitch;
	rTo.meWidthType = (FontWidth)rFrom.meWidthType;
	rTo.meWeight = (FontWeight)rFrom.meWeight;
	rTo.meItalic = (FontItalic)rFrom.meItalic;
	rTo.meType = (FontType)rFrom.meType;
	rTo.mbOrientation = (rFrom.mnBools & 1) ? TRUE : FALSE;
	rTo.mbDevice = (rFrom.mnBools & 2) ? TRUE : FALSE;
    rTo.mbEmbeddable = FALSE;
    rTo.mbSubsettable = FALSE;
}

// =======================================================================

BOOL RemoteFont::operator ==( const RemoteFont& rFont ) const
{
	if ( (mnWidth			== rFont.mnWidth)		&&
		 (mnHeight			== rFont.mnHeight)		&&
		 (meWeight			== rFont.meWeight)		&&
		 (meItalic			== rFont.meItalic)		&&
		 (meFamily			== rFont.meFamily)		&&
		 (maName			== rFont.maName)		&&
		 (maStyleName		== rFont.maStyleName)	&&
		 (meCharSet 		== rFont.meCharSet) 	&&
		 (meWidthType		== rFont.meWidthType)	&&
		 (mePitch			== rFont.mePitch)		&&
		 (mnOrientation 	== rFont.mnOrientation) )
		return TRUE;
	else
		return FALSE;
}

// =======================================================================

ImplServerGraphics::ImplServerGraphics( AtomClient* pAtoms ) :
	maLineColor( COL_BLACK ),
	maFillColor( COL_WHITE ),
	maTextColor( COL_BLACK ),
	maClipRegion(),
	mpAtoms( pAtoms ),
	mpLastOutDev( NULL ),
	mpServerSideFont( NULL ),
    mnWidthFactor( 0 )
{
	GlyphCache::EnsureInstance( aRemoteGlyphPeer, true );

	maFontSelectData.mpFontData		= NULL;
	maFontSelectData.mnWidth		= 0;
	maFontSelectData.mnHeight 		= 0;
	maFontSelectData.meFamily 		= FAMILY_DONTKNOW;
	maFontSelectData.meCharSet		= RTL_TEXTENCODING_DONTKNOW;
	maFontSelectData.meWidthType	= WIDTH_DONTKNOW;
	maFontSelectData.meWeight		= WEIGHT_DONTKNOW;
	maFontSelectData.meItalic		= ITALIC_NONE;
	maFontSelectData.mePitch		= PITCH_DONTKNOW;
	maFontSelectData.mnOrientation	= 0;

	mnDPIX					= 96;
	mnDPIY					= 96;
	meRasterOp				= ROP_OVERPAINT;
	mnBitCount				= 24;
	mbClipRegion			= FALSE;
	mbSendClipRegion		= TRUE;
	mbSendFont				= FALSE;
	mbGetResolution 		= TRUE;

	if( mpAtoms == NULL )
	{
		ImplSVData* pSVData = ImplGetSVData();
		mpAtoms = pSVData->mpAtoms;
	}
}

// -----------------------------------------------------------------------

ImplServerGraphics::~ImplServerGraphics()
{
}

// -----------------------------------------------------------------------

BOOL ImplServerGraphics::Init()
{
	if ( mbSendClipRegion )
	{
		if ( !mbClipRegion )
		{
			CHECK_FOR_RVPSYNC_NORMAL();
            try
            {
			    mxRemoteDevice->ResetClipRegion();
            }
            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
            }
		}
		else
		{
			CHECK_FOR_RVPSYNC_NORMAL();
			
			SvMemoryStream aMem;
			aMem.SetCompressMode( COMPRESSMODE_FULL );
			aMem << maClipRegion;

			const NMSP_CLIENT::ByteSequence aSeq( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) );
            try
            {
			    mxRemoteDevice->SetClipRegion( aSeq );
            }
            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
            }
		}
		mbSendClipRegion = FALSE;
	}

	return TRUE;
}

// -----------------------------------------------------------------------

void ImplServerGraphics::SetClipRegion()
{
	if ( mbClipRegion )
	{
		mbClipRegion		= FALSE;
		mbSendClipRegion	= TRUE;
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::SetClipRegion( const Region& rRegion )
{
	mbClipRegion		= TRUE;
	mbSendClipRegion	= TRUE;
	maClipRegion		= rRegion;
}

// -----------------------------------------------------------------------

void ImplServerGraphics::GetResolution( long& rDPIX, long& rDPIY )
{
	if ( mbGetResolution )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->GetResolution( mnDPIX, mnDPIY, mnBitCount );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            mnDPIX = 0;
            mnDPIY = 0;
            mnBitCount=0;
        }
		mbGetResolution = FALSE;

	}
	rDPIX = mnDPIX;
	rDPIY = mnDPIY;
}

// -----------------------------------------------------------------------

USHORT ImplServerGraphics::GetBitCount()
{
	if ( mbGetResolution )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->GetResolution( mnDPIX, mnDPIY, mnBitCount );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            mnDPIX = 0;
            mnDPIY = 0;
            mnBitCount = 0;
        }
		mbGetResolution = FALSE;

	}
	return mnBitCount;
}

// -----------------------------------------------------------------------

Color ImplServerGraphics::GetPixel( const Point& rPos )
{
	Color			aColor;
	unsigned long	nColor;

	Init();
	CHECK_FOR_RVPSYNC_NORMAL();
    try
    {
	    mxRemoteDevice->GetPixel( rPos.X(), rPos.Y(), nColor );
    }
    catch( RuntimeException &e )
    {
        rvpExceptionHandler();
        nColor = 0;
    }
	aColor.SetColor( nColor );


	return aColor;
}

// -----------------------------------------------------------------------

Color* ImplServerGraphics::GetPixel( const Polygon& rPoints )
{
	NMSP_CLIENT::ULongSequence	aColSeq;
	SvMemoryStream				aMem;
	Color*						pRet = NULL;

	aMem.SetCompressMode( COMPRESSMODE_FULL );
	aMem << rPoints;

	CHECK_FOR_RVPSYNC_NORMAL();
    try
    {
	    mxRemoteDevice->GetPixelArray( NMSP_CLIENT::ByteSequence( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) ), aColSeq );
    }
    catch( RuntimeException &e )
    {
        rvpExceptionHandler();
        aColSeq = NMSP_CLIENT::ULongSequence();
    }
	const long nLen = aColSeq.getLength();

	if( nLen && ( rPoints.GetSize() == nLen ) )
	{
		const ULONG* pBuffer = aColSeq.getConstArray();

		pRet = new Color[ nLen ];

		for( long i = 0; i < nLen; i++ )
			pRet[ i ].SetColor( pBuffer[ i ] );
	}

	return pRet;
}

// -----------------------------------------------------------------------

void ImplServerGraphics::GetCharWidth( USHORT nChar1, USHORT nChar2, long* pWidthAry )
{
#ifdef USE_BUILTIN_RASTERIZER
    if( mpServerSideFont != NULL )
    {
        GlyphCache& rGC = GlyphCache::GetInstance();
        for( int i = nChar1; i <= nChar2; ++i )
        {
            const int nGlyphIndex = mpServerSideFont->GetGlyphIndex( i );
            const GlyphMetric& rGM = mpServerSideFont->GetGlyphMetric( nGlyphIndex );
            pWidthAry[ i - nChar1 ] = rGM.GetCharWidth() * mnWidthFactor;
        }
        return;
    }
#endif // USE_BUILTIN_RASTERIZER

	CHECK_FOR_RVPSYNC_NORMAL();
    Sequence< sal_Int32 > aSeq;
    try
    {
	    aSeq = mxRemoteDevice->GetCharWidth( nChar1, nChar2 );
    }
    catch( RuntimeException &e )
    {
        rvpExceptionHandler();
        aSeq = Sequence< sal_Int32 >();
    }
	for( int i = 0; i <= nChar2-nChar1; i++ )
		pWidthAry[i] = aSeq.getConstArray()[i];
}

// -----------------------------------------------------------------------

void ImplServerGraphics::GetFontMetric( ImplFontMetricData& rMetric, long& rFactor, unsigned short firstChar, unsigned short lastChar, long* pWidths, BOOL bGetKernPairs, ImplKernPairData** ppKernPairs, long& rKernPairs )
{
#ifdef USE_BUILTIN_RASTERIZER
    if( mpServerSideFont != NULL )
    {
        // TODO: set server side font width factor to 1
        mpServerSideFont->FetchFontMetric( rMetric, rFactor );
        mnWidthFactor = rFactor;

        for( int i = firstChar; i <= lastChar; ++i )
        {
            const int nGlyphIndex = mpServerSideFont->GetGlyphIndex( i );
            const GlyphMetric& rGM = mpServerSideFont->GetGlyphMetric( nGlyphIndex );
            pWidths[ i - firstChar ] = rGM.GetCharWidth() * rFactor;
        }

        if( bGetKernPairs )
        {
            rKernPairs = mpServerSideFont->GetKernPairs( ppKernPairs );
            if( ppKernPairs && (rFactor != 1) )
                for( int i = 0; i < rKernPairs; ++i )
                    (*ppKernPairs)[i].mnKern *= rFactor;
        }

        return;
    }
#endif // USE_BUILTIN_RASTERIZER

	// cache FontMetric ?!
	NMSP_CLIENT::IDLFontMetricData aMetric;

	CHECK_FOR_RVPSYNC_NORMAL();
    try
    {
	    mxRemoteDevice->GetFontMetric( aMetric, firstChar, lastChar, bGetKernPairs );
    }
    catch( RuntimeException &e )
    {
        rvpExceptionHandler();
        aMetric = NMSP_CLIENT::IDLFontMetricData();
		aMetric.mnFactor = 1;
    }
	rFactor 	= aMetric.mnFactor;
    mnWidthFactor = rFactor;

	if( firstChar != lastChar )
	{
		// relies on sizeof( sal_Int32 ) == sizeof( long )
		memcpy( pWidths, aMetric.maCharWidths.getConstArray(), aMetric.maCharWidths.getLength() * sizeof( sal_Int32 ) );
	}
	if( bGetKernPairs )
	{
		rKernPairs = aMetric.maKerningPairs.getLength();
		if( rKernPairs )
		{
			*ppKernPairs = new ImplKernPairData[ rKernPairs ];
			const NMSP_CLIENT::KernPair* pIDLPairs = aMetric.maKerningPairs.getConstArray();
			for( ULONG n = 0; n < rKernPairs; n++ )
			{
				(*ppKernPairs)[ n ].mnChar1 = pIDLPairs[ n ].Char1;
				(*ppKernPairs)[ n ].mnChar2 = pIDLPairs[ n ].Char2;
				(*ppKernPairs)[ n ].mnKern	= pIDLPairs[ n ].Kerning;
			}
		}
		else
			ppKernPairs = NULL;
	}
	ImplCopyFontMetric( aMetric, rMetric );
}

// -----------------------------------------------------------------------

ULONG ImplServerGraphics::GetFontCodeRanges( sal_uInt32* pCodePairs ) const
{
    ULONG nPairs = 0;
#ifdef USE_BUILTIN_RASTERIZER
    if( mpServerSideFont )
        nPairs = mpServerSideFont->GetFontCodeRanges( pCodePairs );
#endif //USE_BUILTIN_RASTERIZER
    return nPairs;
}

//--------------------------------------------------------------------------

ULONG ImplServerGraphics::GetKernPairs( ImplKernPairData** ppKernPairs )
{
#ifdef USE_BUILTIN_RASTERIZER
	if( mpServerSideFont != NULL )
		return mpServerSideFont->GetKernPairs( ppKernPairs );
#endif // USE_BUILTIN_RASTERIZER

	CHECK_FOR_RVPSYNC_NORMAL();
    Sequence< NMSP_CLIENT::KernPair > aKernPairs;
    try
    {
	    aKernPairs = mxRemoteDevice->GetKernPairs();
    }
    catch( RuntimeException &e )
    {
       rvpExceptionHandler();
       aKernPairs = Sequence< NMSP_CLIENT::KernPair >();
    }

	ULONG nPairs = aKernPairs.getLength();
	if ( nPairs )
	{
		*ppKernPairs = new ImplKernPairData[ nPairs ];
		const NMSP_CLIENT::KernPair* pIDLPairs = aKernPairs.getConstArray();
		for ( ULONG n = 0; n < nPairs; n++ )
		{
			(*ppKernPairs)[ n ].mnChar1 = pIDLPairs[ n ].Char1;
			(*ppKernPairs)[ n ].mnChar2 = pIDLPairs[ n ].Char2;
			(*ppKernPairs)[ n ].mnKern	= pIDLPairs[ n ].Kerning;
		}
	}
	else
		*ppKernPairs = NULL;

	return nPairs;
}

// -----------------------------------------------------------------------

void ImplServerGraphics::GetDevFontList( ImplDevFontList* pList )
{
	CHECK_FOR_RVPSYNC_NORMAL();
    NMSP_CLIENT::IDLFontDataSequence aSeqFontData;
    try
    {
	    aSeqFontData = mxRemoteDevice->GetDevFontList();
    }
    catch( RuntimeException &e )
    {
        rvpExceptionHandler();
        aSeqFontData = NMSP_CLIENT::IDLFontDataSequence();
    }
	Sequence< sal_Int32 > aSeq( 2 );
	aSeq.getArray()[0] = NMSP_CLIENT::FontAtomType::NAME;
	aSeq.getArray()[1] = NMSP_CLIENT::FontAtomType::STYLE;

	for( ULONG n = 0, nFonts = aSeqFontData.getLength(); n < nFonts; n++ )
	{
		ImplFontData* pData = new ImplFontData;
		ImplCopyFontData( aSeqFontData[(int)n], *pData );
		pList->Add( pData );
	}

#ifdef USE_BUILTIN_RASTERIZER
    GlyphCache::GetInstance().FetchFontList( pList );
#endif // USE_BUILTIN_RASTERIZER
}

// -----------------------------------------------------------------------

long ImplServerGraphics::SetFont( const ImplFontSelectData* pFontSelectData )
{
    maGlyphWidths.clear();

    maFontSelectData = *pFontSelectData;
    mnWidthFactor = 0;

    if( mpServerSideFont != NULL )
    {
        // the old server side font is currently no longer needed
        GlyphCache::GetInstance().UncacheFont( *mpServerSideFont );
        mpServerSideFont = NULL;
    }

    // requesting a font that is only available on the server?
    if( pFontSelectData->mpFontData && pFontSelectData->mpFontData->mpSysData )
        mpServerSideFont = GlyphCache::GetInstance().CacheFont( *pFontSelectData );

    if( mpServerSideFont == NULL )
    {
        // map the requested font to one that the client can display himself
        ImplFontSelectData aIFSD = *pFontSelectData;
        if( aIFSD.mpFontData )
        {
            // the server manages the mapping of a requested font to a client font
            // the client does not and can not know the font substitution mappings
            aIFSD.maName        = aIFSD.mpFontData->maName;
            aIFSD.maStyleName   = aIFSD.mpFontData->maStyleName;
            aIFSD.mpFontData    = NULL;
        }

		NMSP_CLIENT::IDLFont aIDLFont;
		aIDLFont.mnName 		= mpAtoms->getAtom( NMSP_CLIENT::FontAtomType::NAME, aIFSD.maName, sal_True );
		aIDLFont.mnStyleName	= mpAtoms->getAtom( NMSP_CLIENT::FontAtomType::STYLE, aIFSD.maStyleName, sal_True );
		aIDLFont.mnWidth		= pFontSelectData->mnWidth;
		aIDLFont.mnHeight		= pFontSelectData->mnHeight;
		aIDLFont.meFamily		= (UINT16)pFontSelectData->meFamily;
		aIDLFont.meCharSet		= (UINT16)pFontSelectData->meCharSet;
		aIDLFont.meWidthType	= (UINT16)pFontSelectData->meWidthType;
		aIDLFont.meWeight		= (UINT16)pFontSelectData->meWeight;
		aIDLFont.meItalic		= (UINT16)pFontSelectData->meItalic;
		aIDLFont.mePitch		= (UINT16)pFontSelectData->mePitch;
		aIDLFont.mnOrientation	= pFontSelectData->mnOrientation;
        aIDLFont.meLanguage         = ConvertLanguageToIsoString( pFontSelectData->meLanguage );
        aIDLFont.mbVertical         = pFontSelectData->mbVertical;
        aIDLFont.mbNonAntialiased   = pFontSelectData->mbNonAntialiased;

		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->SetFont( aIDLFont );
        }
        catch( RuntimeException &e )
        {
           rvpExceptionHandler();
        }
	}

	return 0;
}

// -----------------------------------------------------------------------

void ImplServerGraphics::SetTextColor( const Color& rColor )
{
	if( rColor != maTextColor )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        maTextColor = rColor;
        try
        {
		    mxRemoteDevice->SetTextColor( rColor.GetColor() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::SetLineColor( const Color& rColor )
{
	if( rColor != maLineColor )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        maLineColor = rColor;
        try
        {
		    mxRemoteDevice->SetLineColor( rColor.GetColor() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::SetFillColor( const Color& rColor )
{
	if( rColor != maFillColor )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
		maFillColor = rColor;
        try
        {
		    mxRemoteDevice->SetFillColor( rColor.GetColor() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::SetRasterOp( RasterOp eROP )
{
	if( meRasterOp != eROP )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
		meRasterOp = eROP;
        try
        {
		    mxRemoteDevice->SetRasterOp( (USHORT)eROP );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::CopyArea( long nDestX, long nDestY,
								   long nSrcX, long nSrcY,
								   long nSrcWidth, long nSrcHeight,
								   USHORT nFlags )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->CopyArea( nSrcX, nSrcY, nSrcWidth, nSrcHeight, nDestX, nDestY, nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::CopyBits( const RemoteTwoRect* pPosAry, ImplServerGraphics* pSrcGraphics, const OutputDevice*, const OutputDevice* )
{
	if ( Init() )
	{
		REF( NMSP_CLIENT::XRmOutputDevice ) xOutDev;

		if( pSrcGraphics )
			xOutDev = pSrcGraphics->GetInterface();

		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->CopyBits( pPosAry->mnSrcX, pPosAry->mnSrcY, pPosAry->mnSrcWidth, pPosAry->mnSrcHeight,
								  pPosAry->mnDestX, pPosAry->mnDestY, pPosAry->mnDestWidth, pPosAry->mnDestHeight, xOutDev );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::Invert( const Rectangle& rRect, USHORT nFlags )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->Invert( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::Invert( const Polygon& rPoly, USHORT nFlags )
{
	if ( Init() )
	{
		SvMemoryStream aMem;
		aMem.SetCompressMode( COMPRESSMODE_FULL );
		aMem << rPoly;

		CHECK_FOR_RVPSYNC_NORMAL();
		NMSP_CLIENT::ByteSequence aSeq( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) );
        try
        {
		    mxRemoteDevice->InvertPolygon( aSeq, nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::InvertTracking( const Rectangle& rRect, USHORT nFlags )
{
	if ( Init() )

	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->InvertTracking( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::InvertTracking( const Polygon& rPoly, USHORT nFlags )
{
	if ( Init() )
	{
		SvMemoryStream aMem;
		aMem.SetCompressMode( COMPRESSMODE_FULL );
		aMem << rPoly;

		NMSP_CLIENT::ByteSequence aSeq( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) );
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->InvertTrackingPolygon( aSeq, nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawPixel( const Point& rPos )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPixel( rPos.X(), rPos.Y() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawPixel( const Point& rPos, const Color& rColor )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawColoredPixel( rPos.X(), rPos.Y(), rColor.GetColor() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawPixel( const Polygon& rPoints, const Color* pColors )
{
	if ( Init() )
	{
		SvMemoryStream aMem;
		aMem.SetCompressMode( COMPRESSMODE_FULL );
		aMem << rPoints;

		const USHORT				nCount = rPoints.GetSize();
		NMSP_CLIENT::ByteSequence	aPointSeq( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) );
		NMSP_CLIENT::ULongSequence	aColorSeq( nCount );

		for( USHORT i = 0; i < nCount; i++ )
			aColorSeq[ (int) i ] = pColors[ i ].GetColor();

		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPixelArray( aPointSeq, aColorSeq );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawLine( const Point& rStartPos, const Point& rEndPos )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawLine( rStartPos.X(), rStartPos.Y(), rEndPos.X(), rEndPos.Y() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawRect( const Rectangle& rRect )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawRect( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawPolyLine( const Polygon& rPoly )
{
	if ( Init() )
	{
		SvMemoryStream aMem;
		aMem.SetCompressMode( COMPRESSMODE_FULL );
		aMem << rPoly;

		NMSP_CLIENT::ByteSequence aSeq( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) );
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPolyLine( aSeq );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawPolygon( const Polygon& rPoly )
{
	if ( Init() )
	{
		SvMemoryStream aMem;
		aMem.SetCompressMode( COMPRESSMODE_FULL );
		aMem << rPoly;
		NMSP_CLIENT::ByteSequence aSeq( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) );
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPolygon( aSeq );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawPolyPolygon( const PolyPolygon& rPoly )
{
	if ( Init() )
	{
		SvMemoryStream aMem;
		aMem.SetCompressMode( COMPRESSMODE_FULL );

		aMem << rPoly;

		NMSP_CLIENT::ByteSequence aSeq( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) );
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPolyPolygon( aSeq );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawRect( const Rectangle& rRect, ULONG nHorzRound, ULONG nVertRound )

{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawRoundedRect( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), nHorzRound, nVertRound );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------


void ImplServerGraphics::DrawEllipse( const Rectangle& rRect )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
    		mxRemoteDevice->DrawEllipse( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawArc( const Rectangle& rRect, const Point& rStartPt, const Point& rEndPt )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawArc( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), rStartPt.X(), rStartPt.Y(), rEndPt.X(), rEndPt.Y() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawPie( const Rectangle& rRect, const Point& rStartPt, const Point& rEndPt )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPie( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), rStartPt.X(), rStartPt.Y(), rEndPt.X(), rEndPt.Y() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawChord( const Rectangle& rRect, const Point& rStartPt, const Point& rEndPt )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawChord( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), rStartPt.X(), rStartPt.Y(), rEndPt.X(), rEndPt.Y() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}


// -----------------------------------------------------------------------

void ImplServerGraphics::DrawGradient( const Rectangle& rRect, const Gradient& rGradient )
{
	if ( Init() )
	{
		SvMemoryStream aMem;
		aMem.SetCompressMode( COMPRESSMODE_FULL );
		aMem << rGradient;

		NMSP_CLIENT::ByteSequence aSeq( (sal_Int8*) aMem.GetData(), aMem.Seek( STREAM_SEEK_TO_END ) );
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawGradient( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), aSeq );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawGradient( const PolyPolygon& rPolyPoly, const Gradient& rGradient )
{
	if ( Init() )
	{
		SvMemoryStream aGradMem;
		SvMemoryStream aPolyPolyMem;

		aPolyPolyMem.SetCompressMode( COMPRESSMODE_FULL );
		aPolyPolyMem << rPolyPoly;

		aGradMem.SetCompressMode( COMPRESSMODE_FULL );
		aGradMem << rGradient;

		NMSP_CLIENT::ByteSequence aPolyPolySeq( (sal_Int8*) aPolyPolyMem.GetData(), aPolyPolyMem.Seek( STREAM_SEEK_TO_END ) );
		NMSP_CLIENT::ByteSequence aGradSeq( (sal_Int8*) aGradMem.GetData(), aGradMem.Seek( STREAM_SEEK_TO_END ) );

		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPolyPolyGradient( aPolyPolySeq, aGradSeq );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawHatch( const PolyPolygon& rPolyPoly, const Hatch& rHatch )
{
	if ( Init() )
	{
		SvMemoryStream aHatchMem;
		SvMemoryStream aPolyPolyMem;

		aPolyPolyMem.SetCompressMode( COMPRESSMODE_FULL );
		aPolyPolyMem << rPolyPoly;

		aHatchMem.SetCompressMode( COMPRESSMODE_FULL );
		aHatchMem << rHatch;

		NMSP_CLIENT::ByteSequence aPolyPolySeq( (sal_Int8*) aPolyPolyMem.GetData(), aPolyPolyMem.Seek( STREAM_SEEK_TO_END ) );
		NMSP_CLIENT::ByteSequence aHatchSeq( (sal_Int8*) aHatchMem.GetData(), aHatchMem.Seek( STREAM_SEEK_TO_END ) );

		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPolyPolyHatch( aPolyPolySeq, aHatchSeq );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

#ifdef ENABLE_CTL

BOOL ImplServerGraphics::GetGlyphBoundRect( long nIndex, bool bIsGlyphIndex, Rectangle& rRect, const OutputDevice* )
{
    // TODO: fully implement CTL
    return FALSE;
}

// -----------------------------------------------------------------------

BOOL ImplServerGraphics::GetGlyphOutline( long nIndex, bool bIsGlyphIndex, PolyPolygon&, const OutputDevice* )
{
    // TODO: fully implement CTL
    return FALSE;
}

// -----------------------------------------------------------------------

SalLayout* ImplServerGraphics::LayoutText( const ImplLayoutArgs& rArgs, const OutputDevice* )
{
    GenericSalLayout* pLayout = NULL;

	if( !Init() )
        return NULL;

    if( !mnWidthFactor )
    {
        ImplFontMetricData aFMD;
        long nDummy;
        // TODO: maybe also request advance widths for performance reasons?
        GetFontMetric( aFMD, nDummy, 0x21, 0x20, NULL, FALSE, NULL, nDummy );
    }

    // layout text with server side font
    if( mpServerSideFont )
    {
        pLayout = mpServerSideFont->LayoutText( rArgs );
    }
    else
    {
        // layout text with remote font
        int nGlyphCount = rArgs.mnEndCharIndex - rArgs.mnFirstCharIndex;
        GlyphItem* pGlyphBuffer = new GlyphItem[ nGlyphCount ];

		// try to avoid GetCharWidth calls
		// TODO: move to more appropriate layers
        sal_Unicode cMinChar = rArgs.mpStr[ rArgs.mnFirstCharIndex ];
        sal_Unicode cMaxChar = cMinChar;
        bool bGetWidths = false;
        for( int j = rArgs.mnFirstCharIndex; j < rArgs.mnEndCharIndex; ++j )
        {
            sal_Unicode c = rArgs.mpStr[j];
            if (maGlyphWidths.find(c) != maGlyphWidths.end())
                continue;
            bGetWidths = true;
            if( cMinChar > c )
                cMinChar = c;
            if( cMaxChar < c )
                cMaxChar = c;
			if( (cMaxChar - cMinChar) > 256 )
				break;
        }
        if( bGetWidths && (cMaxChar - cMinChar) < 256 )
        {
            if (cMinChar >= 32 && cMaxChar <= 127)
            {
                // Heuristic to get all of ASCII if part of ASCII is requested
                // (hoping that more from ASCII will be requested soon):
                cMinChar = 32;
                cMaxChar = 127;
            }
            else if (cMaxChar - cMinChar < 128)
            {
                // Heuristic to get large range if small range is requested
                // (hoping that rest of range will be requested soon):
                cMinChar &= ~63;
                cMaxChar |= 63;
            }
            long aWidths[256];
            GetCharWidth( cMinChar, cMaxChar, aWidths );
            int i = 0;
            for (sal_Unicode c = cMinChar; c <= cMaxChar; ++c)
                maGlyphWidths[c] = aWidths[i++];
        }

        bool bRightToLeft = (0 != (rArgs.mnFlags & SAL_LAYOUT_BIDI_RTL));

        long nWidth = 0;
        Point aNewPos( 0, 0);

        for( int i = 0; i < nGlyphCount; ++i )
        {
            int nLogicalIndex = bRightToLeft ? (rArgs.mnEndCharIndex-1-i) : (rArgs.mnFirstCharIndex+i);
            sal_Unicode cChar = rArgs.mpStr[ nLogicalIndex ];
            long nGlyphIndex = cChar;   // TODO: use real glyph ids

            long nGlyphWidth;
            GlyphWidthMap::iterator aIt(maGlyphWidths.find(cChar));
            if( aIt == maGlyphWidths.end() )
                GetCharWidth( cChar, cChar, &nGlyphWidth );
            else
                nGlyphWidth = aIt->second;
            pGlyphBuffer[i] = GlyphItem( nLogicalIndex, nGlyphIndex, aNewPos,
                GlyphItem::CLUSTER_START, nGlyphWidth );
            nWidth += nGlyphWidth;

            aNewPos = Point( nWidth, 0 );
        }

        pLayout = new GenericSalLayout( rArgs );
        pLayout->SetGlyphItems( pGlyphBuffer, nGlyphCount );
        pLayout->SetUnitsPerPixel( mnWidthFactor );
        pLayout->SetOrientation( rArgs.mnOrientation );
        pLayout->SetWantFallback( false );


        // justify if requested
        if( rArgs.mnLayoutWidth )
            pLayout->Justify( rArgs.mnLayoutWidth );

        // adjust positions if requested
        if( rArgs.mpDXArray )
            pLayout->ApplyDXArray( rArgs.mpDXArray );

    }

    return pLayout;
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawSalLayout( const SalLayout& rLayout, const OutputDevice* )
{
    const GenericSalLayout* pLayout = reinterpret_cast<const GenericSalLayout*>(&rLayout);

    static const int MAXGLYPHS = 160;
    int nMaxGlyphs = pLayout->GetOrientation() ? 1 : MAXGLYPHS;

    // TODO: implement glyph fallbacks
    Point aPos;
    for( int nStart=0;;)
    {
        long aGlyphAry[ MAXGLYPHS ];
        long aWidthAry[ MAXGLYPHS ];
        int nGlyphs = pLayout->GetNextGlyphs( nMaxGlyphs, aGlyphAry, aPos, nStart, aWidthAry );
        if( !nGlyphs )
            break;

        if( mpServerSideFont != NULL )
        {
            // draw text with server side font
            OutputDevice* pOutDev = GetOutputDevice();
            for( int i = 0; i < nGlyphs; ++i )
            {
                int nGlyphIndex = aGlyphAry[ i ];
                const Bitmap* pBmp = aRemoteGlyphPeer.GetBitmap1( *mpServerSideFont, nGlyphIndex );
                const GlyphMetric& rGM = mpServerSideFont->GetGlyphMetric( nGlyphIndex );
                if( pBmp )
                {
                    pBmp->ImplDrawRemoteMask( pOutDev, Point(0,0), pBmp->GetSizePixel(),
                        aPos+rGM.GetOffset(), pBmp->GetSizePixel(), maTextColor );
                }

                aPos += Point( rGM.GetCharWidth(), 0 );
            }
        }
        else
        {
            // draw text with remote font
            sal_Unicode pStr[ MAXGLYPHS ];
            for( int i = 0; i < nGlyphs; ++i )
                pStr[ i ] = aGlyphAry[ i ];

    		const OUSTRING aStr( pStr, nGlyphs );

            CHECK_FOR_RVPSYNC_NORMAL();
            try
            {
                // TODO: use DrawText when using natural glyph widths
                com::sun::star::uno::Sequence< sal_Int32 > aSeq(nGlyphs);
                sal_Int32 nSum = 0;
                for (int i = 0; i < nGlyphs; ++i)
                {
                    nSum += aWidthAry[i];
                    aSeq[i] = nSum;
                }
                mxRemoteDevice->DrawTextArray( aPos.X(), aPos.Y(), aStr, aSeq );
            }
            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
            }
        }
    }
}

// -----------------------------------------------------------------------

#else // ENABLE_CTL

// -----------------------------------------------------------------------

BOOL ImplServerGraphics::GetGlyphBoundRect( xub_Unicode cChar, Rectangle& rRect, BOOL bOptimize )
{
    BOOL bRet;
#ifdef USE_BUILTIN_RASTERIZER
    if( mpServerSideFont != NULL )
    {
        const int nGlyphIndex = mpServerSideFont->GetGlyphIndex( cChar );
        const GlyphMetric& pGM = mpServerSideFont->GetGlyphMetric( nGlyphIndex );
        rRect = Rectangle( pGM.GetOffset(), pGM.GetSize() );
        bRet = TRUE;
    }
    else
#endif // USE_BUILTIN_RASTERIZER
	{
		long nLeft, nTop, nWidth, nHeight;
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    bRet = mxRemoteDevice->GetGlyphBoundRect( cChar, nLeft, nTop, nWidth, nHeight, bOptimize );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            bRet = FALSE;
        }
		if ( bRet )
			rRect = Rectangle( Point( nLeft, nTop ), Size( nWidth, nHeight ) );
	}
	return bRet;
}

// -----------------------------------------------------------------------

BOOL ImplServerGraphics::GetGlyphOutline( xub_Unicode cChar, PolyPolygon& rPolyPoly, BOOL bOptimize )
{
    BOOL bRet;
#ifdef USE_BUILTIN_RASTERIZER
    if( mpServerSideFont != NULL )
    {
        const int nGlyphIndex = mpServerSideFont->GetGlyphIndex( cChar );
        bRet = mpServerSideFont->GetGlyphOutline( nGlyphIndex, rPolyPoly );
        // bOptimize
    }
    else
#endif // USE_BUILTIN_RASTERIZER
	{
		NMSP_CLIENT::ByteSequence	aSeq;
	
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    bRet = mxRemoteDevice->GetGlyphOutline( cChar, aSeq, bOptimize );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            bRet = FALSE;
        }

		if( bRet )
		{
			SvMemoryStream aMem( (char*) aSeq.getConstArray(), aSeq.getLength(), STREAM_READ );
			aMem.SetCompressMode( COMPRESSMODE_FULL );
			aMem >> rPolyPoly;
		}
	}

	return bRet;
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawText( long nX, long nY, const xub_Unicode* pStr, USHORT nLen )
{
	if ( Init() )
	{
#ifdef USE_BUILTIN_RASTERIZER
        if( mpServerSideFont != NULL )
        {
            Point aPos( nX, nY );
            OutputDevice* pOutDev = GetOutputDevice();
            for( USHORT i = 0; i < nLen; ++i )
            {
                int nGlyphIndex = mpServerSideFont->GetGlyphIndex( pStr[ i ] );
                const Bitmap* pBmp = aRemoteGlyphPeer.GetBitmap1( *mpServerSideFont, nGlyphIndex );

                const GlyphMetric& rGM = mpServerSideFont->GetGlyphMetric( nGlyphIndex );
                if( pBmp )
                {
                    pBmp->ImplDrawRemoteMask( pOutDev, Point(0,0), pBmp->GetSizePixel(),
                        aPos+rGM.GetOffset(), pBmp->GetSizePixel(), maTextColor );
                }

                aPos += mpServerSideFont->TransformPoint( Point(rGM.GetCharWidth(),0) );
            }
        }
        else
#endif // USE_BUILTIN_RASTERIZER
		{
			const OUSTRING aStr( pStr, nLen );
			CHECK_FOR_RVPSYNC_NORMAL();
            try
            {
			    mxRemoteDevice->DrawText( nX, nY, aStr );
            }
            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
            }
		}
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawTextArray( long nX, long nY, const xub_Unicode* pStr, USHORT nLen, const long* pDXAry )
{
	if ( Init() )
	{
#ifdef USE_BUILTIN_RASTERIZER
        if( mpServerSideFont != NULL )
        {
            Point aPos( nX, nY );
            OutputDevice* pOutDev = GetOutputDevice();
            for( int i = 0; i < nLen; ++i )
            {
                int nGlyphIndex = mpServerSideFont->GetGlyphIndex( pStr[ i ] );
                const Bitmap* pBmp = aRemoteGlyphPeer.GetBitmap1( *mpServerSideFont, nGlyphIndex );

                if( pBmp )
                {
                    const GlyphMetric& rGM  = mpServerSideFont->GetGlyphMetric( nGlyphIndex );
                    pBmp->ImplDrawRemoteMask( pOutDev, Point(0,0), pBmp->GetSizePixel(),
                        aPos+rGM.GetOffset(), pBmp->GetSizePixel(), maTextColor );
                }

                aPos = Point( nX, nY );
                aPos += mpServerSideFont->TransformPoint( Point( pDXAry[i], 0 ) );
            }
        }
        else
#endif // USE_BUILTIN_RASTERIZER
		{
			const OUSTRING aStr( pStr, nLen );
			CHECK_FOR_RVPSYNC_NORMAL();
            try
            {
			    mxRemoteDevice->DrawTextArray( nX, nY, aStr, NMSP_CLIENT::LongSequence( pDXAry, nLen ) );
            }
            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
            }
		}
	}
}

#endif // ENABLE_CTL

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawWaveLine( const Point& rStartPos, const Point& rEndPos, USHORT nStyle )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawWaveLine( rStartPos.X(), rStartPos.Y(), rEndPos.X(), rEndPos.Y(), nStyle );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawGrid(	long nMinX, long nMaxX, const SEQ( long )& rHorzValues,
									long nMinY, long nMaxY, const SEQ( long )& rVertValues,
									USHORT nFlags )
{
	if ( Init() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawGrid( nMinX, nMaxX, rHorzValues, nMinY, nMaxY, rVertValues, nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::DrawTransparent( const PolyPolygon& rPolyPoly, USHORT nTransparencyPercent )
{
	if ( Init() )
	{
		SvMemoryStream aPolyPolyMem;

		aPolyPolyMem.SetCompressMode( COMPRESSMODE_FULL );
		aPolyPolyMem << rPolyPoly;

		NMSP_CLIENT::ByteSequence aPolyPolySeq( (sal_Int8*) aPolyPolyMem.GetData(), aPolyPolyMem.Seek( STREAM_SEEK_TO_END ) );
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->DrawPolyPolyTransparent( aPolyPolySeq, nTransparencyPercent );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------

void ImplServerGraphics::Draw2ColorFrame( const Rectangle& rRect,
										  const Color& rLeftTopColor,
										  const Color& rRightBottomColor )
{
	if ( Init() )
	{
/*
		mxRemoteDevice->SetFillColor( rLeftTopColor.GetColor() );
		mxRemoteDevice->DrawRect( rRect.Left(), rRect.Top(), 1, rRect.Bottom()-rRect.Top() );
		mxRemoteDevice->DrawRect( rRect.Left(), rRect.Top(), rRect.Right()-rRect.Left(), 1 );
		mxRemoteDevice->SetFillColor( rRightBottomColor.GetColor() );
		mxRemoteDevice->DrawRect( rRect.Left(), rRect.Bottom(), rRect.Right()-rRect.Left()+1, 1 );
		mxRemoteDevice->DrawRect( rRect.Right(), rRect.Top(), 1, rRect.Bottom()-rRect.Top()+1 );
*/

		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxRemoteDevice->Draw2ColorFrame( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(),
										 rLeftTopColor.GetColor(),
										 rRightBottomColor.GetColor() );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }

		maFillColor = rRightBottomColor;
	}
}

BOOL ImplServerGraphics::CreateFontSubset( const rtl::OUString& rToFile,
                                           ImplFontData* pFont,
                                           long* pGlyphIDs,
                                           sal_uInt8* pEncoding,
                                           sal_Int32* pWidths,
                                           int nGlyphs,
                                           FontSubsetInfo& rInfo // out parameter
                                           )
{
    return FALSE;
}

const void* ImplServerGraphics::GetEmbedFontData( ImplFontData* pFont, sal_Int32* pWidths, FontSubsetInfo& rInfo, long* pDataLen )
{
    return NULL;
}

void ImplServerGraphics::FreeEmbedFontData( const void* pData, long nDataLen )
{
}

// =======================================================================

ImplServerGraphics* OutputDevice::ImplGetServerGraphics( BOOL bGlobal )
{
	if (mpGraphics && (mpGraphics->GetOutputDevice() != this))
	{
		mpGraphics->SetOutputDevice( this );

		if ( !mbInitLineColor && (maLineColor != mpGraphics->maLineColor) )
			mbInitLineColor = TRUE;
		if ( !mbInitFillColor && (maFillColor != mpGraphics->maFillColor) )
			mbInitFillColor = TRUE;
		if ( !mbInitTextColor && (GetTextColor() != mpGraphics->maTextColor) )
			mbInitTextColor = TRUE;
		// Font wird bei SetFont verglichen
		mbInitFont = TRUE;
		if ( !bGlobal )
		{
			mbInitClipRegion = TRUE;
			ImplInitClipRegion();
		}
	}
	else
	{
		if ( !bGlobal )
		{
			if ( mbInitClipRegion )
				ImplInitClipRegion();
		}
		else
			mbInitClipRegion = TRUE;
	}

	if (mpGraphics)
	{
		if ( bGlobal )
		{
			mpGraphics->SetClipRegion();
			mpGraphics->SetRasterOp( ROP_OVERPAINT );
			return mpGraphics;
		}
		else
		{
			if ( mbOutputClipped )
				return NULL;
			else
			{
				if ( meRasterOp != mpGraphics->meRasterOp )
					mpGraphics->SetRasterOp( meRasterOp );
				return mpGraphics;
			}
		}
	}
	else
		return NULL;
}


// -----------------------------------------------------------------------

void OutputDevice::ImplReleaseServerGraphics()
{
	if ( mpGraphics && (mpGraphics->GetOutputDevice() == this))
		mpGraphics->SetOutputDevice( NULL );
}

// =======================================================================

#endif
