/*************************************************************************
 *
 *  $RCSfile: helpcontentprovider.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/24 11:25:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif
#ifndef _HELPCONTENTPROVIDER_HXX_
#include "helpcontentprovider.hxx"
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XUNOURLRESOLVER_HPP_
#include <com/sun/star/bridge/XUnoUrlResolver.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif

using namespace helpaccess;
using namespace com::sun::star;
using namespace com::sun::star::ucb;


rtl::OUString SAL_CALL
getImplementationName_static( void )
{
	return rtl::OUString::createFromAscii( "HelpContentProvider" );
}


uno::Sequence< rtl::OUString > SAL_CALL
getSupportedServiceNames_static( void )
{
	rtl::OUString Supported = rtl::OUString::createFromAscii( "com.sun.star.ucb.HelpContentProvider" ) ;
	uno::Sequence< rtl::OUString > Seq( &Supported,1 );
	return Seq;
}


//=========================================================================
static sal_Bool writeInfo( void * pRegistryKey,
						   const rtl::OUString & rImplementationName,
   						   uno::Sequence< rtl::OUString > const & rServiceNames )
{
	rtl::OUString aKeyName( rtl::OUString::createFromAscii( "/" ) );
	aKeyName += rImplementationName;
	aKeyName += rtl::OUString::createFromAscii( "/UNO/SERVICES" );

	uno::Reference< registry::XRegistryKey > xKey;
	try
	{
		xKey = static_cast< registry::XRegistryKey * >(
			pRegistryKey )->createKey( aKeyName );
	}
	catch ( registry::InvalidRegistryException const & )
	{
	}

	if ( !xKey.is() )
		return sal_False;

	sal_Bool bSuccess = sal_True;

	for ( sal_Int32 n = 0; n < rServiceNames.getLength(); ++n )
	{
		try
		{
			xKey->createKey( rServiceNames[ n ] );
		}
		catch ( registry::InvalidRegistryException const & )
		{
			bSuccess = sal_False;
			break;
		}
	}
	return bSuccess;
}

//=========================================================================
extern "C" void SAL_CALL component_getImplementationEnvironment(
	const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}



//=========================================================================
extern "C" sal_Bool SAL_CALL component_writeInfo(
	void * pServiceManager, void * pRegistryKey )
{
	return 
		pRegistryKey &&
		writeInfo( pRegistryKey,
				   ::getImplementationName_static(),
				   ::getSupportedServiceNames_static() );
}



//=========================================================================
extern "C" void * SAL_CALL component_getFactory(
	const sal_Char * pImplName, void * pServiceManager, void * pRegistryKey )
{
	void * pRet = 0;
	
	uno::Reference< lang::XMultiServiceFactory > xSMgr(
		reinterpret_cast< lang::XMultiServiceFactory * >( pServiceManager ) );
	uno::Reference< lang::XSingleServiceFactory > xFactory;
	
	if ( ::getImplementationName_static().compareToAscii( pImplName ) == 0 )
	{
		xFactory = HelpContentProvider::createServiceFactory( xSMgr );
	}
	
	//////////////////////////////////////////////////////////////////////
	
	if ( xFactory.is() )
	{
		xFactory->acquire();
		pRet = xFactory.get();
	}
	
	return pRet;
}

/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                     HelpContentProvider                                  */
/*                                                                          */
/*                                                                          */
/****************************************************************************/


HelpContentProvider::HelpContentProvider( const uno::Reference< lang::XMultiServiceFactory >& xMultiServiceFactory )
	: m_xMultiServiceFactory( xMultiServiceFactory ),
	  m_xRemoteProvider( 0 ),
	  m_xContentIdentifierFactory( 0 ),
	  init( false )
{
}

HelpContentProvider::~HelpContentProvider()
{
	m_xRemoteProvider = 0;
	m_xContentIdentifierFactory = 0;
}


//////////////////////////////////////////////////////////////////////////
// XInterface
//////////////////////////////////////////////////////////////////////////

void SAL_CALL
HelpContentProvider::acquire(
	void )
	throw()
{
	OWeakObject::acquire();
}


void SAL_CALL
HelpContentProvider::release(
	void )
	throw()
{
	OWeakObject::release();
}

uno::Any SAL_CALL
HelpContentProvider::queryInterface(
	const uno::Type& rType )
	throw( uno::RuntimeException )
{
	uno::Any aRet = cppu::queryInterface( rType,
										  SAL_STATIC_CAST( XContentProvider*, this ),
										  SAL_STATIC_CAST( XContentIdentifierFactory*, this ),
										  SAL_STATIC_CAST( lang::XServiceInfo*,     this ) );
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface( rType );
}



////////////////////////////////////////////////////////////////////////////////
// XServiceInfo methods.

rtl::OUString SAL_CALL
HelpContentProvider::getImplementationName()
	throw( uno::RuntimeException )
{
	return ::getImplementationName_static();
}


sal_Bool SAL_CALL
HelpContentProvider::supportsService(
	const rtl::OUString& ServiceName )
	throw( uno::RuntimeException )
{
	return ServiceName == rtl::OUString::createFromAscii( "com.sun.star.ucb.HelpContentProvider" );
}


uno::Sequence< rtl::OUString > SAL_CALL
HelpContentProvider::getSupportedServiceNames(
	void )
	throw( uno::RuntimeException )
{
	return ::getSupportedServiceNames_static();
}



uno::Reference< lang::XSingleServiceFactory > SAL_CALL
HelpContentProvider::createServiceFactory(
	const uno::Reference< lang::XMultiServiceFactory >& rxServiceMgr )
{
	/**
	 * Create a single service factory.<BR>
	 * Note: The function pointer ComponentInstantiation points to a function throws Exception.
	 *
	 * @param rServiceManager		the service manager used by the implementation.
	 * @param rImplementationName	the implementation name. An empty string is possible.
	 * @param ComponentInstantiation the function pointer to create an object.
	 * @param rServiceNames			the service supported by the implementation.
	 * @return a factory that support the interfaces XServiceProvider, XServiceInfo
	 *			XSingleServiceFactory and XComponent.
	 *
	 * @see createOneInstanceFactory
	 */
	/*
	 *  Reference< ::com::sun::star::lang::XSingleServiceFactory > createSingleFactory
	 *  (
	 *  const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > & rServiceManager,
	 *  const ::rtl::OUString & rImplementationName,
	 *  ComponentInstantiation pCreateFunction,

	 *  const ::com::sun::star::uno::Sequence< ::rtl::OUString > & rServiceNames
	 *  );
	 */

	return uno::Reference< lang::XSingleServiceFactory > ( cppu::createSingleFactory(
		rxServiceMgr,
		::getImplementationName_static(),
		HelpContentProvider::CreateInstance,
		::getSupportedServiceNames_static() ) );
}



uno::Reference< uno::XInterface > SAL_CALL
HelpContentProvider::CreateInstance(
	const uno::Reference< lang::XMultiServiceFactory >& xMultiServiceFactory )
{
	lang::XServiceInfo* xP = (lang::XServiceInfo*) new HelpContentProvider( xMultiServiceFactory );
	return uno::Reference< uno::XInterface >::query( xP );
}



////////////////////////////////////////////////////////////////////////////////
// XContent
////////////////////////////////////////////////////////////////////////////////


uno::Reference< XContent > SAL_CALL
HelpContentProvider::queryContent(
	const uno::Reference< XContentIdentifier >& xIdentifier )
	throw( IllegalIdentifierException,
		   uno::RuntimeException)
{
	if( ! init ) 
		initialize();
	
	uno::Reference< XContent > xContent( 0 );
	if( m_xRemoteProvider.is() )
		xContent = m_xRemoteProvider->queryContent( xIdentifier );   // may throw IllegalIdentifierException
	else
		throw uno::RuntimeException();
	
	return xContent;
}



sal_Int32 SAL_CALL
HelpContentProvider::compareContentIds(
	const uno::Reference< XContentIdentifier >& Id1,
	const uno::Reference< XContentIdentifier >& Id2 )
	throw( uno::RuntimeException )
{
	if( ! init ) 
		initialize();
	
	if( m_xRemoteProvider.is() )
		return m_xRemoteProvider->compareContentIds( Id1,Id2 );
	else
		throw uno::RuntimeException();
}



uno::Reference< XContentIdentifier > SAL_CALL
HelpContentProvider::createContentIdentifier(
	const rtl::OUString& ContentId )
	throw( uno::RuntimeException )
{
 	if( ! init ) 
		initialize();
	
	if( m_xContentIdentifierFactory.is() )
		return m_xContentIdentifierFactory->createContentIdentifier( ContentId );
	else
		throw uno::RuntimeException();
}




void SAL_CALL HelpContentProvider::initialize()
{
	if( ! m_xMultiServiceFactory.is() )
		return;
	
	rtl::OUString unoUrlResolverStr = rtl::OUString::createFromAscii( "com.sun.star.bridge.UnoUrlResolver" );
	uno::Reference< bridge::XUnoUrlResolver > resolver( m_xMultiServiceFactory->createInstance( unoUrlResolverStr ),
														uno::UNO_QUERY );
	
	if( ! resolver.is() )
		return;
	
	// socket,host=localhost,port=12000

	rtl::OUString unoUrl = rtl::OUString::createFromAscii( "uno:portal,service=help;urp;HelpProvider" );
	uno::Reference< XContentProvider > xRP( resolver->resolve( unoUrl ),
											uno::UNO_QUERY );
	if( ! xRP.is() )
		return; // error
	
	// Now we have it
	m_xRemoteProvider = xRP;
	// It then is definitly a XContentIdentifierFactory
	uno::Reference< XContentIdentifierFactory > xCIF( xRP,uno::UNO_QUERY );
	if( xCIF.is() )
		m_xContentIdentifierFactory = xCIF;
	else
		return;

	
    //  Access to the configuration server must be granted,
	//  so give it to the remote provider with XInitialization
	
	uno::Reference< lang::XInitialization > xInit( xRP,uno::UNO_QUERY );
	if( xInit.is() )
	{
		uno::Reference< lang::XMultiServiceFactory > xMS( 0 );
		try
		{
			rtl::OUString sProviderService =
				rtl::OUString::createFromAscii( "com.sun.star.configuration.ConfigurationProvider" );
			
			uno::Reference< lang::XMultiServiceFactory >
				sPS( m_xMultiServiceFactory->createInstance( sProviderService ),
					 uno::UNO_QUERY );
			
			if( sPS.is() )
				xMS = sPS;
		}
		catch( ... )
		{
		}
		
		if( ! xMS.is() )
			return;
		
		uno::Sequence< uno::Any > seq( 1 );
		seq[0] <<= xMS;
		xInit->initialize( seq );
	}

	init = true;
}

