/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_connpoolconfig.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:11:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #ifndef _OFFAPP_CONNPOOLCONFIG_HXX_
//STRIP001 #include "connpoolconfig.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _OFFAPP_CONNPOOLSETTINGS_HXX_
//STRIP001 #include "connpoolsettings.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _SFXITEMSET_HXX 
//STRIP001 #include <svtools/itemset.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFF_OFAIDS_HRC
//STRIP001 #include "ofaids.hrc"
//STRIP001 #endif
//STRIP001 #ifndef _UNOTOOLS_CONFIGNODE_HXX_
//STRIP001 #include <unotools/confignode.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COMPHELPER_EXTRACT_HXX_
//STRIP001 #include <comphelper/extract.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXENUMITEM_HXX 
//STRIP001 #include <svtools/eitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
//STRIP001 #include <comphelper/processfactory.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFFMGR_SDBCDRIVERENUMERATION_HXX_
//STRIP001 #include "sdbcdriverenum.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _LEGACYBINFILTERMGR_HXX
//STRIP001 #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
//STRIP001 #endif
//STRIP001 //........................................................................
//STRIP001 namespace offapp
//STRIP001 {
//STRIP001 //........................................................................
//STRIP001 
//STRIP001 	using namespace ::utl;
//STRIP001 	using namespace ::com::sun::star::uno;
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	static const ::rtl::OUString& getConnectionPoolNodeName()
//STRIP001 	{
//STRIP001 		static ::rtl::OUString s_sNodeName = ::rtl::OUString::createFromAscii("org.openoffice.Office.DataAccess/ConnectionPool");
//STRIP001 		return s_sNodeName;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	static const ::rtl::OUString& getEnablePoolingNodeName()
//STRIP001 	{
//STRIP001 		static ::rtl::OUString s_sNodeName = ::rtl::OUString::createFromAscii("EnablePooling");
//STRIP001 		return s_sNodeName;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	static const ::rtl::OUString& getDriverSettingsNodeName()
//STRIP001 	{
//STRIP001 		static ::rtl::OUString s_sNodeName = ::rtl::OUString::createFromAscii("DriverSettings");
//STRIP001 		return s_sNodeName;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	static const ::rtl::OUString& getDriverNameNodeName()
//STRIP001 	{
//STRIP001 		static ::rtl::OUString s_sNodeName = ::rtl::OUString::createFromAscii("DriverName");
//STRIP001 		return s_sNodeName;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	static const ::rtl::OUString& getEnableNodeName()
//STRIP001 	{
//STRIP001 		static ::rtl::OUString s_sNodeName = ::rtl::OUString::createFromAscii("Enable");
//STRIP001 		return s_sNodeName;
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	static const ::rtl::OUString& getTimeoutNodeName()
//STRIP001 	{
//STRIP001 		static ::rtl::OUString s_sNodeName = ::rtl::OUString::createFromAscii("Timeout");
//STRIP001 		return s_sNodeName;
//STRIP001 	}
//STRIP001 
//STRIP001 	//====================================================================
//STRIP001 	//= ConnectionPoolConfig
//STRIP001 	//====================================================================
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ConnectionPoolConfig::GetOptions(SfxItemSet& _rFillItems)
//STRIP001 	{
//STRIP001 		// the config node where all pooling relevant info are stored under
//STRIP001 		OConfigurationTreeRoot aConnectionPoolRoot = OConfigurationTreeRoot::createWithServiceFactory(
//STRIP001 			::legacy_binfilters::getLegacyProcessServiceFactory(), getConnectionPoolNodeName(), -1, OConfigurationTreeRoot::CM_READONLY);
//STRIP001 
//STRIP001 		// the global "enabled" flag
//STRIP001 		Any aEnabled = aConnectionPoolRoot.getNodeValue(getEnablePoolingNodeName());
//STRIP001 		sal_Bool bEnabled = sal_True;
//STRIP001 		aEnabled >>= bEnabled;
//STRIP001 		_rFillItems.Put(SfxBoolItem(SID_SB_POOLING_ENABLED, bEnabled));
//STRIP001 
//STRIP001 		// the settings for the single drivers
//STRIP001 		DriverPoolingSettings aSettings;
//STRIP001 		// first get all the drivers register at the driver manager
//STRIP001 		ODriverEnumeration aEnumDrivers;
//STRIP001 		for	(	ODriverEnumeration::const_iterator aLoopDrivers = aEnumDrivers.begin();
//STRIP001 				aLoopDrivers != aEnumDrivers.end();
//STRIP001 				++aLoopDrivers
//STRIP001 			)
//STRIP001 		{
//STRIP001 			aSettings.push_back(DriverPooling(*aLoopDrivers, sal_False, 120));
//STRIP001 		}
//STRIP001 
//STRIP001 		// then look for which of them settings are stored in the configuration
//STRIP001 		OConfigurationNode aDriverSettings = aConnectionPoolRoot.openNode(getDriverSettingsNodeName());
//STRIP001 
//STRIP001 		Sequence< ::rtl::OUString > aDriverKeys = aDriverSettings.getNodeNames();
//STRIP001 		const ::rtl::OUString* pDriverKeys = aDriverKeys.getConstArray();
//STRIP001 		const ::rtl::OUString* pDriverKeysEnd = pDriverKeys + aDriverKeys.getLength();
//STRIP001 		for (;pDriverKeys != pDriverKeysEnd; ++pDriverKeys)
//STRIP001 		{
//STRIP001 			// the name of the driver in this round
//STRIP001 			OConfigurationNode aThisDriverSettings = aDriverSettings.openNode(*pDriverKeys);
//STRIP001 			::rtl::OUString sThisDriverName;
//STRIP001 			aThisDriverSettings.getNodeValue(getDriverNameNodeName()) >>= sThisDriverName;
//STRIP001 
//STRIP001 			// look if we (resp. the driver manager) know this driver
//STRIP001 			// doing O(n) search here, which is expensive, but this doesn't matter in this small case ...
//STRIP001 			for	(	DriverPoolingSettings::iterator aLookup = aSettings.begin();
//STRIP001 					aLookup != aSettings.end();
//STRIP001 					++aLookup
//STRIP001 				)
//STRIP001 				if (sThisDriverName.equals(aLookup->sName))
//STRIP001 					break;
//STRIP001 
//STRIP001 			if (aLookup == aSettings.end())
//STRIP001 			{	// do not know the driver - add it
//STRIP001 				aSettings.push_back(DriverPooling(sThisDriverName, sal_False, 120));
//STRIP001 
//STRIP001 				// and the position of the new entry
//STRIP001 				aLookup = aSettings.end();
//STRIP001 				--aLookup;
//STRIP001 			}
//STRIP001 
//STRIP001 			// now fill this entry with the settings from the configuration
//STRIP001 			aThisDriverSettings.getNodeValue(getEnableNodeName()) >>= aLookup->bEnabled;
//STRIP001 			aThisDriverSettings.getNodeValue(getTimeoutNodeName()) >>= aLookup->nTimeoutSeconds;
//STRIP001 		}
//STRIP001 
//STRIP001 		_rFillItems.Put(DriverPoolingSettingsItem(SID_SB_DRIVER_TIMEOUTS, aSettings));
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void ConnectionPoolConfig::SetOptions(const SfxItemSet& _rSourceItems)
//STRIP001 	{
//STRIP001 		// the config node where all pooling relevant info are stored under
//STRIP001 		OConfigurationTreeRoot aConnectionPoolRoot = OConfigurationTreeRoot::createWithServiceFactory(
//STRIP001 			::legacy_binfilters::getLegacyProcessServiceFactory(), getConnectionPoolNodeName(), -1, OConfigurationTreeRoot::CM_UPDATABLE);
//STRIP001 
//STRIP001 		if (!aConnectionPoolRoot.isValid())
//STRIP001 			// already asserted by the OConfigurationTreeRoot
//STRIP001 			return;
//STRIP001 
//STRIP001 		sal_Bool bNeedCommit = sal_False;
//STRIP001 
//STRIP001 		// the global "enabled" flag
//STRIP001 		SFX_ITEMSET_GET( _rSourceItems, pEnabled, SfxBoolItem, SID_SB_POOLING_ENABLED, sal_True );
//STRIP001 		if (pEnabled)
//STRIP001 		{
//STRIP001 			sal_Bool bEnabled = pEnabled->GetValue();
//STRIP001 			aConnectionPoolRoot.setNodeValue(getEnablePoolingNodeName(), Any(&bEnabled, ::getBooleanCppuType()));
//STRIP001 			bNeedCommit = sal_True;
//STRIP001 		}
//STRIP001 
//STRIP001 		// the settings for the single drivers
//STRIP001 		SFX_ITEMSET_GET( _rSourceItems, pDriverSettings, DriverPoolingSettingsItem, SID_SB_DRIVER_TIMEOUTS, sal_True );
//STRIP001 		if (pDriverSettings)
//STRIP001 		{
//STRIP001 			OConfigurationNode aDriverSettings = aConnectionPoolRoot.openNode(getDriverSettingsNodeName());
//STRIP001 			if (!aDriverSettings.isValid())
//STRIP001 				return;
//STRIP001 
//STRIP001 			::rtl::OUString sThisDriverName;
//STRIP001 			OConfigurationNode aThisDriverSettings;
//STRIP001 
//STRIP001 			const DriverPoolingSettings& rNewSettings = pDriverSettings->getSettings();
//STRIP001 			for (	DriverPoolingSettings::const_iterator aLoop = rNewSettings.begin();
//STRIP001 					aLoop != rNewSettings.end();
//STRIP001 					++aLoop
//STRIP001 				)
//STRIP001 			{
//STRIP001 				// need the name as ::rtl::OUString
//STRIP001 				sThisDriverName = aLoop->sName;
//STRIP001 
//STRIP001 				// the sub-node for this driver
//STRIP001 				if (aDriverSettings.hasByName(aLoop->sName))
//STRIP001 					aThisDriverSettings = aDriverSettings.openNode(aLoop->sName);
//STRIP001 				else
//STRIP001 					aThisDriverSettings = aDriverSettings.createNode(aLoop->sName);
//STRIP001 
//STRIP001 				// set the values
//STRIP001 				aThisDriverSettings.setNodeValue(getDriverNameNodeName(), makeAny(sThisDriverName));
//STRIP001 				aThisDriverSettings.setNodeValue(getEnableNodeName(), Any(&aLoop->bEnabled, ::getBooleanCppuType()));
//STRIP001 				aThisDriverSettings.setNodeValue(getTimeoutNodeName(), makeAny(aLoop->nTimeoutSeconds));
//STRIP001 			}
//STRIP001 			bNeedCommit = sal_True;
//STRIP001 		}
//STRIP001 		if (bNeedCommit)
//STRIP001 			aConnectionPoolRoot.commit();
//STRIP001 	}
//STRIP001 
//STRIP001 //........................................................................
//STRIP001 }	// namespace offapp
//STRIP001 //........................................................................

}
