/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_pfuncache.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:31:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "pfuncache.hxx"
// auto strip #include "printfun.hxx"
#include "docsh.hxx"
// auto strip #include "markdata.hxx"
namespace binfilter {

//------------------------------------------------------------------------

/*N*/ ScPrintFuncCache::ScPrintFuncCache( ScDocShell* pD, const ScMarkData& rMark,
/*N*/ 									const ScPrintSelectionStatus& rStatus ) :
/*N*/ 	aSelection( rStatus ),
/*N*/ 	pDocSh( pD ),
/*N*/ 	nTotalPages( 0 )
/*N*/ {
/*N*/ 	//	page count uses the stored cell widths for the printer anyway,
/*N*/ 	//	so ScPrintFunc with the document's printer can be used to count
/*N*/ 
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxPrinter* pPrinter = pDocSh->GetPrinter();
//STRIP001 
//STRIP001 	ScRange aRange;
//STRIP001 	const ScRange* pSelRange = NULL;
//STRIP001 	if ( rMark.IsMarked() )
//STRIP001 	{
//STRIP001 		rMark.GetMarkArea( aRange );
//STRIP001 		pSelRange = &aRange;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	USHORT nTab;
//STRIP001 	for ( nTab=0; nTab<nTabCount; nTab++ )
//STRIP001 	{
//STRIP001 		long nAttrPage = nTab ? nFirstAttr[nTab-1] : 1;
//STRIP001 
//STRIP001 		long nThisTab = 0;
//STRIP001 		if ( rMark.GetTableSelect( nTab ) )
//STRIP001 		{
//STRIP001 			ScPrintFunc aFunc( pDocSh, pPrinter, nTab, nAttrPage, 0, pSelRange );
//STRIP001 			nThisTab = aFunc.GetTotalPages();
//STRIP001 			nFirstAttr[nTab] = aFunc.GetFirstPageNo();			// from page style or previous sheet
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nFirstAttr[nTab] = nAttrPage;
//STRIP001 
//STRIP001 		nPages[nTab] = nThisTab;
//STRIP001 		nTotalPages += nThisTab;
//STRIP001 	}
/*N*/ }

/*N*/ ScPrintFuncCache::~ScPrintFuncCache()
/*N*/ {
/*N*/ }

/*N*/ BOOL ScPrintFuncCache::IsSameSelection( const ScPrintSelectionStatus& rStatus ) const
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 return aSelection == rStatus;
/*N*/ }

/*N*/ USHORT ScPrintFuncCache::GetTabForPage( long nPage ) const
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	USHORT nTab = 0;
//STRIP001 	while ( nTab < nTabCount && nPage >= nPages[nTab] )
//STRIP001 		nPage -= nPages[nTab++];
//STRIP001 	return nTab;
/*N*/ }

/*N*/ long ScPrintFuncCache::GetTabStart( USHORT nTab ) const
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 long nRet = 0;
//STRIP001 	for ( USHORT i=0; i<nTab; i++ )
//STRIP001 		nRet += nPages[i];
//STRIP001 	return nRet;
/*N*/ }

/*N*/ long ScPrintFuncCache::GetDisplayStart( USHORT nTab ) const
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 //!	merge with lcl_GetDisplayStart in preview?
//STRIP001 
//STRIP001 	long nDisplayStart = 0;
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	for (USHORT i=0; i<nTab; i++)
//STRIP001 	{
//STRIP001 		if ( pDoc->NeedPageResetAfterTab(i) )
//STRIP001 			nDisplayStart = 0;
//STRIP001 		else
//STRIP001 			nDisplayStart += nPages[i];
//STRIP001 	}
//STRIP001 	return nDisplayStart;
/*N*/ }


}
