/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drtxtob.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:35:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ITEMID_FRAMEDIR EE_PARA_WRITINGDIR

#ifndef _EEITEMID_HXX
#include <bf_svx/eeitemid.hxx>
#endif

#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

// auto strip #ifndef _ULSPITEM_HXX
// auto strip #include <bf_svx/ulspitem.hxx>
// auto strip #endif
// auto strip #ifndef _LSPCITEM_HXX
// auto strip #include <bf_svx/lspcitem.hxx>
// auto strip #endif
// auto strip #ifndef _ADJITEM_HXX
// auto strip #include <bf_svx/adjitem.hxx>
// auto strip #endif
// auto strip #ifndef _VCL_VCLENUM_HXX
// auto strip #include <vcl/vclenum.hxx>
// auto strip #endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
// auto strip #ifndef _SFX_WHITER_HXX //autogen
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMPOOL_HXX //autogen
// auto strip #include <svtools/itempool.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTYLE_HXX //autogen
// auto strip #include <svtools/style.hxx>
// auto strip #endif
// auto strip #ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
// auto strip #include <svtools/languageoptions.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_TPLPITEM_HXX //autogen
// auto strip #include <bf_sfx2/tplpitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_ESCPITEM_HXX //autogen
// auto strip #include <bf_svx/escpitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOUTL_HXX //autogen
// auto strip #include <bf_svx/svdoutl.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SRIPTTYPEITEM_HXX //autogen
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #endif
// auto strip #ifndef _OUTLOBJ_HXX
// auto strip #include <bf_svx/outlobj.hxx>
// auto strip #endif

#ifndef _XDEF_HXX
#include <bf_svx/xdef.hxx>
#endif

// auto strip #ifndef _SVX_WRITINGMODEITEM_HXX
// auto strip #include <bf_svx/writingmodeitem.hxx>
// auto strip #endif
#ifndef _SVX_FRMDIRITEM_HXX
#include <bf_svx/frmdiritem.hxx>
#endif

#pragma hdrstop


#include "app.hrc"
#include "glob.hrc"
#include "res_bmp.hrc"

// auto strip #include "eetext.hxx"
#include "drtxtob.hxx"
#include "drawdoc.hxx"
#include "drviewsh.hxx"
#include "outlnvsh.hxx"
// auto strip #include "futempl.hxx"
#include "sdresid.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "outlview.hxx"

#ifndef _SD_SDVIEW_HXX
#include "sdview.hxx"
#endif

/*************************************************************************
|*
|* Standardinterface deklarieren (Die Slotmap darf nicht leer sein, also
|* tragen wir etwas ein, was hier (hoffentlich) nie vorkommt).
|*
\************************************************************************/
namespace binfilter {

#define SdDrawTextObjectBar
#define FEATURE_DRAW_TEXT_OBJECTBAR		1L
#define FEATURE_GRAPHIC_TEXT_OBJECTBAR	2L

SFX_DECL_TYPE(13);

#include "sdslots.hxx"

/*N*/ SFX_IMPL_INTERFACE( SdDrawTextObjectBar, SfxShell, SdResId(STR_TEXTOBJECTBARSHELL) )
/*N*/ {
/*N*/ //    SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, SdResId(RID_DRAW_TEXT_TOOLBOX) );
/*N*/ 	SFX_FEATURED_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, SdResId(RID_DRAW_TEXT_TOOLBOX),
/*N*/ 										 FEATURE_DRAW_TEXT_OBJECTBAR );
/*N*/ 	SFX_FEATURED_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, SdResId(RID_GRAPHIC_TEXT_TOOLBOX),
/*N*/ 										 FEATURE_GRAPHIC_TEXT_OBJECTBAR );
/*N*/ }

TYPEINIT1( SdDrawTextObjectBar, SfxShell );

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

/*N*/ SdDrawTextObjectBar::SdDrawTextObjectBar( SdViewShell* pSdViewSh,
/*N*/ 				SfxItemPool& rItemPool, SdView* pSdView ) :
/*N*/ 	SfxShell(pSdViewSh),
/*N*/ 	rPool( rItemPool ),
/*N*/ 	pViewShell( pSdViewSh ),
/*N*/ 	pView( pSdView )
/*N*/ {
/*N*/ 	SetPool(&rItemPool);
/*N*/ 
/*N*/ 	if (pSdViewSh->ISA(SdOutlineViewShell))
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxUndoManager& rUndoMgr = ((SdOutlineView*)pSdView)->
//STRIP001 /*?*/ 									GetOutliner()->GetUndoManager();
//STRIP001 /*?*/ 		SetUndoManager(&rUndoMgr);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SdDrawDocument* pDoc	  = pView->GetDoc();
/*N*/ 		SdDrawDocShell* pDocShell = pDoc->GetDocSh();
/*N*/ 		SfxUndoManager* pUndoMgr  = pDocShell->GetUndoManager();
/*N*/ 		SetUndoManager(pUndoMgr);
/*N*/ 		if ( pSdViewSh->ISA(SdDrawViewShell) )
/*N*/ 			SetRepeatTarget(pSdView);
/*N*/ 	}
/*N*/ 
/*N*/ 	SetName( String( RTL_CONSTASCII_USTRINGPARAM( "SdDrawTextObjectBar" )));
/*N*/ 
/*N*/ 	// SetHelpId( SD_IF_SDDRAWTEXTOBJECTBAR );
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdDrawTextObjectBar::~SdDrawTextObjectBar()
/*N*/ {
/*N*/ 	SetRepeatTarget(NULL);
/*N*/ }

/*************************************************************************
|*
|* Status der Attribut-Items
|*
\************************************************************************/

//STRIP001 void SdDrawTextObjectBar::GetAttrState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxWhichIter	    aIter( rSet );
//STRIP001 	USHORT			    nWhich = aIter.FirstWhich();
//STRIP001 	BOOL			    bTemplate = FALSE;
//STRIP001 	SfxItemSet 		    aAttrSet( pView->GetDoc()->GetPool() );
//STRIP001     SvtLanguageOptions  aLangOpt;
//STRIP001     sal_Bool            bDisableParagraphTextDirection = !aLangOpt.IsCTLFontEnabled();
//STRIP001     sal_Bool			bDisableVerticalText = !aLangOpt.IsVerticalTextEnabled();
//STRIP001 
//STRIP001 	pView->GetAttributes( aAttrSet );
//STRIP001 
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		USHORT nSlotId = SfxItemPool::IsWhich(nWhich)
//STRIP001 			? GetPool().GetSlotId(nWhich)
//STRIP001 			: nWhich;
//STRIP001 
//STRIP001 		switch ( nSlotId )
//STRIP001 		{
//STRIP001 			case SID_ATTR_CHAR_FONT:
//STRIP001             case SID_ATTR_CHAR_FONTHEIGHT:
//STRIP001             case SID_ATTR_CHAR_WEIGHT:
//STRIP001             case SID_ATTR_CHAR_POSTURE:
//STRIP001             {
//STRIP001 				SfxItemPool& rPool = GetPool();
//STRIP001                 SvxScriptSetItem aSetItem( nSlotId, rPool );
//STRIP001                 aSetItem.GetItemSet().Put( aAttrSet, FALSE );
//STRIP001 
//STRIP001 				USHORT nScriptType = pView->GetScriptType();
//STRIP001                 const SfxPoolItem* pI = aSetItem.GetItemOfScript( nScriptType );
//STRIP001                 if( pI )
//STRIP001                 	aAttrSet.Put( *pI, nWhich );
//STRIP001                 else
//STRIP001                     aAttrSet.InvalidateItem( nWhich );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001 
//STRIP001 			case SID_STYLE_APPLY:
//STRIP001 			case SID_STYLE_FAMILY2:
//STRIP001 			{
//STRIP001 				SfxStyleSheet* pStyleSheet = pView->GetStyleSheetFromMarked();
//STRIP001 				if( pStyleSheet )
//STRIP001 					rSet.Put( SfxTemplateItem( nWhich, pStyleSheet->GetName() ) );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					rSet.Put( SfxTemplateItem( nWhich, String() ) );
//STRIP001 				}
//STRIP001 				bTemplate = TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_OUTLINE_LEFT:
//STRIP001 			case SID_OUTLINE_RIGHT:
//STRIP001 			case SID_OUTLINE_UP:
//STRIP001 			case SID_OUTLINE_DOWN:
//STRIP001 			{
//STRIP001 				BOOL bDisableLeft     = TRUE;
//STRIP001 				BOOL bDisableRight    = TRUE;
//STRIP001 				BOOL bDisableUp       = TRUE;
//STRIP001 				BOOL bDisableDown     = TRUE;
//STRIP001 				OutlinerView* pOLV = pView->GetTextEditOutlinerView();
//STRIP001 
//STRIP001 				if (pView->ISA(SdOutlineView))
//STRIP001 				{
//STRIP001 					pOLV = ((SdOutlineView*) pView)->GetViewByWindow(
//STRIP001 												 pViewShell->GetActiveWindow());
//STRIP001 				}
//STRIP001 
//STRIP001 				BOOL bOutlineViewSh = pViewShell->ISA(SdOutlineViewShell);
//STRIP001 
//STRIP001 				if (pOLV &&
//STRIP001 					( pOLV->GetOutliner()->GetMode() == OUTLINERMODE_OUTLINEOBJECT || bOutlineViewSh ) )
//STRIP001 				{
//STRIP001 					// Outliner im Gliederungsmodus
//STRIP001 					Outliner* pOutl = pOLV->GetOutliner();
//STRIP001 					List* pList = pOLV->CreateSelectionList();
//STRIP001 					Paragraph* pPara = (Paragraph*) pList->First();
//STRIP001 
//STRIP001 					// #96539# find out if we are a OutlineView
//STRIP001 					BOOL bIsOutlineView(OUTLINERMODE_OUTLINEVIEW == pOLV->GetOutliner()->GetMode());
//STRIP001 
//STRIP001 					// #96539# This is ONLY for OutlineViews
//STRIP001 					if(bIsOutlineView)
//STRIP001 					{
//STRIP001 						// #96250# and #78665#
//STRIP001 						// allow move up if position is 2 or greater OR it
//STRIP001 						// is a title object (and thus depth==0)
//STRIP001 						if(pOutl->GetAbsPos(pPara) > 1 || (1 == pOutl->GetAbsPos(pPara) && 0 == pOutl->GetDepth(1)))
//STRIP001 						{
//STRIP001 							// Nicht ganz oben
//STRIP001 							bDisableUp = FALSE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// #96539# old behaviour for OUTLINERMODE_OUTLINEOBJECT
//STRIP001 						if(pOutl->GetAbsPos(pPara) > 0)
//STRIP001 						{
//STRIP001 							// Nicht ganz oben
//STRIP001 							bDisableUp = FALSE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					USHORT nMinDepth = 0;
//STRIP001 
//STRIP001 					if (pViewShell->ISA(SdDrawViewShell))
//STRIP001 					{
//STRIP001 						nMinDepth = 1;
//STRIP001 					}
//STRIP001 
//STRIP001 					while (pPara)
//STRIP001 					{
//STRIP001 						USHORT nDepth = pOutl->GetDepth( (USHORT) pOutl->GetAbsPos( pPara ) );
//STRIP001 
//STRIP001 						if (nDepth > nMinDepth)
//STRIP001 						{
//STRIP001 							// Nicht minimale Tiefe
//STRIP001 							bDisableLeft = FALSE;
//STRIP001 						}
//STRIP001 
//STRIP001 						if (nDepth < 9 &&
//STRIP001 						    ( pOutl->GetAbsPos(pPara) != 0 || !bOutlineViewSh ) )
//STRIP001 						{
//STRIP001 							// Nicht maximale Tiefe und nicht ganz oben
//STRIP001 							bDisableRight = FALSE;
//STRIP001 						}
//STRIP001 
//STRIP001 						pPara = (Paragraph*) pList->Next();
//STRIP001 					}
//STRIP001 
//STRIP001 					if ( ( pOutl->GetAbsPos((Paragraph*) pList->Last()) < pOutl->GetParagraphCount() - 1 ) &&
//STRIP001 						 ( pOutl->GetParagraphCount() > 1 || !bOutlineViewSh) )
//STRIP001 					{
//STRIP001 						// Nicht letzter Absatz
//STRIP001 						bDisableDown = FALSE;
//STRIP001 					}
//STRIP001 
//STRIP001 					// #96250# and #78665#
//STRIP001 					// disable when first para and 2nd is not a title
//STRIP001 					pPara = (Paragraph*) pList->First();
//STRIP001 					if(!bDisableDown 
//STRIP001 						&& pPara
//STRIP001 						&& 0 == pOutl->GetAbsPos(pPara) 
//STRIP001 						&& pOutl->GetParagraphCount() > 1 
//STRIP001 						&& 0 != pOutl->GetDepth(1))
//STRIP001 					{
//STRIP001 						// #96539# This is ONLY for OutlineViews
//STRIP001 						if(bIsOutlineView)
//STRIP001 						{
//STRIP001 							// Needs to be disabled
//STRIP001 							bDisableDown = TRUE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					delete pList;
//STRIP001 				}
//STRIP001 
//STRIP001 				if (bDisableLeft)
//STRIP001 					rSet.DisableItem(SID_OUTLINE_LEFT);
//STRIP001 				if (bDisableRight)
//STRIP001 					rSet.DisableItem(SID_OUTLINE_RIGHT);
//STRIP001 				if (bDisableUp)
//STRIP001 					rSet.DisableItem(SID_OUTLINE_UP);
//STRIP001 				if (bDisableDown)
//STRIP001 					rSet.DisableItem(SID_OUTLINE_DOWN);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_TEXTDIRECTION_LEFT_TO_RIGHT:
//STRIP001 			case SID_TEXTDIRECTION_TOP_TO_BOTTOM:
//STRIP001 			{
//STRIP001 				if ( bDisableVerticalText )
//STRIP001 				{
//STRIP001 					rSet.DisableItem( SID_TEXTDIRECTION_LEFT_TO_RIGHT );
//STRIP001 					rSet.DisableItem( SID_TEXTDIRECTION_TOP_TO_BOTTOM );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					BOOL bLeftToRight = TRUE;
//STRIP001 
//STRIP001 					SdrOutliner* pOutl = pView->GetTextEditOutliner();
//STRIP001 					if( pOutl )
//STRIP001 					{
//STRIP001 						if( pOutl->IsVertical() )
//STRIP001 							bLeftToRight = FALSE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 						bLeftToRight = ( (const SvxWritingModeItem&) aAttrSet.Get( SDRATTR_TEXTDIRECTION ) ).GetValue() == ::com::sun::star::text::WritingMode_LR_TB;
//STRIP001 
//STRIP001 					rSet.Put( SfxBoolItem( SID_TEXTDIRECTION_LEFT_TO_RIGHT, bLeftToRight ) );
//STRIP001 					rSet.Put( SfxBoolItem( SID_TEXTDIRECTION_TOP_TO_BOTTOM, !bLeftToRight ) );
//STRIP001 
//STRIP001 					if( !bLeftToRight )
//STRIP001 						bDisableParagraphTextDirection = sal_True;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 
//STRIP001 	rSet.Put( aAttrSet, FALSE ); // <- FALSE, damit DontCare-Status uebernommen wird
//STRIP001 
//STRIP001 /*
//STRIP001 	FontUnderline eFU = ( (const SvxUnderlineItem&) rAttrSet.Get( ITEMID_UNDERLINE ) ).GetUnderline();
//STRIP001 	rSet.Put( SvxUnderlineItem( SID_ATTR_CHAR_UNDERLINE, eFU == UNDERLINE_SINGLE ? TRUE : FALSE ) );
//STRIP001 */
//STRIP001 
//STRIP001 	// die sind im Gliederungsmodus disabled
//STRIP001 	if (!pViewShell->ISA(SdDrawViewShell))
//STRIP001 	{
//STRIP001 		rSet.DisableItem( SID_ATTR_PARA_ADJUST_LEFT );
//STRIP001 		rSet.DisableItem( SID_ATTR_PARA_ADJUST_RIGHT );
//STRIP001 		rSet.DisableItem( SID_ATTR_PARA_ADJUST_CENTER );
//STRIP001 		rSet.DisableItem( SID_ATTR_PARA_ADJUST_BLOCK );
//STRIP001 		rSet.DisableItem( SID_ATTR_PARA_LINESPACE_10 );
//STRIP001 		rSet.DisableItem( SID_ATTR_PARA_LINESPACE_15 );
//STRIP001 		rSet.DisableItem( SID_ATTR_PARA_LINESPACE_20 );
//STRIP001 		rSet.DisableItem( SID_PARASPACE_INCREASE );
//STRIP001 		rSet.DisableItem( SID_PARASPACE_DECREASE );
//STRIP001 		rSet.DisableItem( SID_TEXTDIRECTION_TOP_TO_BOTTOM );
//STRIP001 		rSet.DisableItem( SID_TEXTDIRECTION_LEFT_TO_RIGHT );
//STRIP001         rSet.DisableItem( SID_ATTR_PARA_LEFT_TO_RIGHT );
//STRIP001         rSet.DisableItem( SID_ATTR_PARA_RIGHT_TO_LEFT );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Absatzabstand
//STRIP001 		OutlinerView* pOLV = pView->GetTextEditOutlinerView();
//STRIP001 		if( pOLV )
//STRIP001 		{
//STRIP001 			ESelection aSel = pOLV->GetSelection();
//STRIP001 			aSel.Adjust();
//STRIP001 			ULONG nStartPara = aSel.nStartPara;
//STRIP001 			ULONG nEndPara = aSel.nEndPara;
//STRIP001 			if( !aSel.HasRange() )
//STRIP001 			{
//STRIP001 				nStartPara = 0;
//STRIP001 				nEndPara = pOLV->GetOutliner()->GetParagraphCount() - 1;
//STRIP001 			}
//STRIP001 			long nUpper = 0L;
//STRIP001 			for( ULONG nPara = nStartPara; nPara <= nEndPara; nPara++ )
//STRIP001 			{
//STRIP001 				const SfxItemSet& rItems = pOLV->GetOutliner()->GetParaAttribs( nPara );
//STRIP001 				const SvxULSpaceItem& rItem = (const SvxULSpaceItem&) rItems.Get( ITEMID_ULSPACE );
//STRIP001 				nUpper = Max( nUpper, (long)rItem.GetUpper() );
//STRIP001 			}
//STRIP001 			if( nUpper == 0L )
//STRIP001 				rSet.DisableItem( SID_PARASPACE_DECREASE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Wird zur Zeit nie disabled !
//STRIP001 			//rSet.DisableItem( SID_PARASPACE_INCREASE );
//STRIP001 			//rSet.DisableItem( SID_PARASPACE_DECREASE );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Absatzausrichtung
//STRIP001 		SvxAdjust eAdj = ( (const SvxAdjustItem&) aAttrSet.Get( ITEMID_ADJUST ) ).GetAdjust();
//STRIP001 		switch( eAdj )
//STRIP001 		{
//STRIP001 			case SVX_ADJUST_LEFT:
//STRIP001 				rSet.Put( SfxBoolItem( SID_ATTR_PARA_ADJUST_LEFT, TRUE ) );
//STRIP001 			break;
//STRIP001 			case SVX_ADJUST_CENTER:
//STRIP001 				rSet.Put( SfxBoolItem( SID_ATTR_PARA_ADJUST_CENTER, TRUE ) );
//STRIP001 			break;
//STRIP001 			case SVX_ADJUST_RIGHT:
//STRIP001 				rSet.Put( SfxBoolItem( SID_ATTR_PARA_ADJUST_RIGHT, TRUE ) );
//STRIP001 			break;
//STRIP001 			case SVX_ADJUST_BLOCK:
//STRIP001 				rSet.Put( SfxBoolItem( SID_ATTR_PARA_ADJUST_BLOCK, TRUE ) );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001         // paragraph text direction
//STRIP001         if( bDisableParagraphTextDirection )
//STRIP001         {
//STRIP001             rSet.DisableItem( SID_ATTR_PARA_LEFT_TO_RIGHT );
//STRIP001             rSet.DisableItem( SID_ATTR_PARA_RIGHT_TO_LEFT );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             switch( ( ( (SvxFrameDirectionItem&) aAttrSet.Get( EE_PARA_WRITINGDIR ) ) ).GetValue() )
//STRIP001             {
//STRIP001                 case FRMDIR_VERT_TOP_LEFT:
//STRIP001                 case FRMDIR_VERT_TOP_RIGHT:
//STRIP001                 {
//STRIP001                     rSet.DisableItem( SID_ATTR_PARA_LEFT_TO_RIGHT );
//STRIP001                     rSet.DisableItem( SID_ATTR_PARA_RIGHT_TO_LEFT );
//STRIP001                 }
//STRIP001                 break;
//STRIP001 
//STRIP001                 case FRMDIR_HORI_LEFT_TOP:
//STRIP001 				    rSet.Put( SfxBoolItem( SID_ATTR_PARA_LEFT_TO_RIGHT, TRUE ) );
//STRIP001 				    rSet.Put( SfxBoolItem( SID_ATTR_PARA_RIGHT_TO_LEFT, FALSE ) );
//STRIP001                 break;
//STRIP001 
//STRIP001                 case FRMDIR_HORI_RIGHT_TOP:
//STRIP001 				    rSet.Put( SfxBoolItem( SID_ATTR_PARA_LEFT_TO_RIGHT, FALSE ) );
//STRIP001 				    rSet.Put( SfxBoolItem( SID_ATTR_PARA_RIGHT_TO_LEFT, TRUE ) );
//STRIP001                 break;
//STRIP001 
//STRIP001 				// #107865#
//STRIP001 				// The case for the superordinate object is missing.
//STRIP001 				case FRMDIR_ENVIRONMENT:
//STRIP001 				{
//STRIP001 					SdDrawDocument* pDoc = pView->GetDoc();
//STRIP001 					::com::sun::star::text::WritingMode eMode = pDoc->GetDefaultWritingMode();
//STRIP001 					sal_Bool bIsLeftToRight(sal_False);
//STRIP001 
//STRIP001 					if(::com::sun::star::text::WritingMode_LR_TB == eMode 
//STRIP001 						|| ::com::sun::star::text::WritingMode_TB_RL == eMode)
//STRIP001 					{
//STRIP001 						bIsLeftToRight = sal_True;
//STRIP001 					}
//STRIP001 
//STRIP001 					rSet.Put( SfxBoolItem( SID_ATTR_PARA_LEFT_TO_RIGHT, bIsLeftToRight ) );
//STRIP001 					rSet.Put( SfxBoolItem( SID_ATTR_PARA_RIGHT_TO_LEFT, !bIsLeftToRight ) );
//STRIP001 				}
//STRIP001 				break;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001 		if (aAttrSet.GetItemState(EE_PARA_BULLETSTATE) == SFX_ITEM_ON)
//STRIP001 		{
//STRIP001 			SfxUInt16Item aBulletState((const SfxUInt16Item&) aAttrSet.Get(EE_PARA_BULLETSTATE));
//STRIP001 
//STRIP001 			if (aBulletState.GetValue() != 0)
//STRIP001 			{
//STRIP001 				rSet.Put(SfxBoolItem(FN_NUM_BULLET_ON, TRUE));
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				rSet.Put(SfxBoolItem(FN_NUM_BULLET_ON, FALSE));
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nLineSpace = (USHORT) ( (const SvxLineSpacingItem&) aAttrSet.
//STRIP001 							Get( ITEMID_LINESPACING ) ).GetPropLineSpace();
//STRIP001 		switch( nLineSpace )
//STRIP001 		{
//STRIP001 			case 100:
//STRIP001 				rSet.Put( SfxBoolItem( SID_ATTR_PARA_LINESPACE_10, TRUE ) );
//STRIP001 			break;
//STRIP001 			case 150:
//STRIP001 				rSet.Put( SfxBoolItem( SID_ATTR_PARA_LINESPACE_15, TRUE ) );
//STRIP001 			break;
//STRIP001 			case 200:
//STRIP001 				rSet.Put( SfxBoolItem( SID_ATTR_PARA_LINESPACE_20, TRUE ) );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Ausrichtung (hoch/tief) wird auch im Gliederungsmodus gebraucht
//STRIP001 	SvxEscapement eEsc = (SvxEscapement ) ( (const SvxEscapementItem&)
//STRIP001 					aAttrSet.Get( ITEMID_ESCAPEMENT ) ).GetEnumValue();
//STRIP001 
//STRIP001 	if( eEsc == SVX_ESCAPEMENT_SUPERSCRIPT )
//STRIP001 		rSet.Put( SfxBoolItem( SID_SET_SUPER_SCRIPT, TRUE ) );
//STRIP001 	else if( eEsc == SVX_ESCAPEMENT_SUBSCRIPT )
//STRIP001 		rSet.Put( SfxBoolItem( SID_SET_SUB_SCRIPT, TRUE ) );
//STRIP001 }

/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

//STRIP001 void SdDrawTextObjectBar::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* Unterstuetzte Features erfragen
|*
\************************************************************************/

//STRIP001 BOOL SdDrawTextObjectBar::HasUIFeature( ULONG nFeature )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	DocumentType eDocType = pViewShell->GetDoc()->GetDocumentType();
//STRIP001 
//STRIP001 	if (nFeature == FEATURE_DRAW_TEXT_OBJECTBAR &&
//STRIP001 		eDocType == DOCUMENT_TYPE_IMPRESS)
//STRIP001 	{
//STRIP001 		// Impress-Objektleiste
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	else if (nFeature == FEATURE_GRAPHIC_TEXT_OBJECTBAR &&
//STRIP001 			 eDocType == DOCUMENT_TYPE_DRAW)
//STRIP001 	{
//STRIP001 		// Draw-Objektleiste
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }



}
