/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdruler.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:43:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXPTITEM_HXX //autogen
#include <svtools/ptitem.hxx>
#endif
// auto strip #ifndef _SVX_RULER_HXX //autogen
// auto strip #include <bf_svx/ruler.hxx>
// auto strip #endif
#ifndef _SVXIDS_HXX //autogen
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SFXCTRLITEM_HXX //autogen
#include <bf_sfx2/ctrlitem.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <bf_sfx2/bindings.hxx>
#endif

#pragma hdrstop

// auto strip #include "sdview.hxx"
// auto strip #include "drviewsh.hxx"
#include "sdwindow.hxx"
#include "sdruler.hxx"
namespace binfilter {


/*************************************************************************
|*
|* Controller-Item fuer SdRuler
|*
\************************************************************************/

class SdRulerCtrlItem : public SfxControllerItem
{
	SdRuler &rRuler;

 protected:
	virtual void StateChanged( USHORT nSId, SfxItemState eState,
								const SfxPoolItem* pItem );

 public:
	SdRulerCtrlItem(USHORT nId, SdRuler& rRlr, SfxBindings& rBind);
};

/*************************************************************************
|*
\************************************************************************/

SdRulerCtrlItem::SdRulerCtrlItem(USHORT nId, SdRuler& rRlr,
								 SfxBindings& rBind) :
	SfxControllerItem(nId, rBind),
	rRuler(rRlr)
{
}


/*************************************************************************
|*
\************************************************************************/

void SdRulerCtrlItem::StateChanged( USHORT nSId,
						SfxItemState eState, const SfxPoolItem* pState )
{
	switch( nSId )
	{
		case SID_RULER_NULL_OFFSET:
		{
			const SfxPointItem* pItem = PTR_CAST(SfxPointItem, pState);
			DBG_ASSERT(pState ? pItem != NULL : TRUE, "SfxPointItem erwartet");
			if ( pItem )
				rRuler.SetNullOffset(pItem->GetValue());
		}
		break;
	}
}


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SdRuler::SdRuler(SdDrawViewShell& rViewSh, Window* pParent, SdWindow* pWin,
				 USHORT nRulerFlags, SfxBindings& rBindings,
				 WinBits nWinStyle) :
	SvxRuler(pParent, pWin, nRulerFlags, rBindings, nWinStyle),
	pDrViewShell(&rViewSh),
	pSdWin(pWin)
{
	rBindings.EnterRegistrations();
	pCtrlItem = new SdRulerCtrlItem(SID_RULER_NULL_OFFSET, *this, rBindings);
	rBindings.LeaveRegistrations();

	if ( nWinStyle & WB_HSCROLL )	bHorz = TRUE;
	else							bHorz = FALSE;
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdRuler::~SdRuler()
/*N*/ {
/*N*/ 	SfxBindings& rBindings = pCtrlItem->GetBindings();
/*N*/ 	rBindings.EnterRegistrations();
/*N*/ 	delete pCtrlItem;
/*N*/ 	rBindings.LeaveRegistrations();
/*N*/ }

/*************************************************************************
|*
|* MouseButtonDown-Handler
|*
\************************************************************************/

//STRIP001 void SdRuler::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	Point aMPos = rMEvt.GetPosPixel();
//STRIP001 	RulerType eType = GetType(aMPos);
//STRIP001 
//STRIP001 	if ( !pDrViewShell->GetView()->IsTextEdit() &&
//STRIP001 		rMEvt.IsLeft() && rMEvt.GetClicks() == 1 &&
//STRIP001 		(eType == RULER_TYPE_DONTKNOW || eType == RULER_TYPE_OUTSIDE) )
//STRIP001 	{
//STRIP001 		pDrViewShell->StartRulerDrag(*this, rMEvt);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SvxRuler::MouseButtonDown(rMEvt);
//STRIP001 }

/*************************************************************************
|*
|* MouseMove-Handler
|*
\************************************************************************/

//STRIP001 void SdRuler::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	SvxRuler::MouseMove(rMEvt);
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp-Handler
|*
\************************************************************************/

//STRIP001 void SdRuler::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	SvxRuler::MouseButtonUp(rMEvt);
//STRIP001 }

/*************************************************************************
|*
|* NullOffset setzen
|*
\************************************************************************/

/*N*/ void SdRuler::SetNullOffset(const Point& rOffset)
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	long nOffset;
//STRIP001 
//STRIP001 	if ( bHorz )	nOffset = rOffset.X();
//STRIP001 	else			nOffset = rOffset.Y();
//STRIP001 
//STRIP001 	SetNullOffsetLogic(nOffset);
/*N*/ }

/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

//STRIP001 void SdRuler::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	if( rCEvt.GetCommand() == COMMAND_CONTEXTMENU &&
//STRIP001 		!pDrViewShell->GetView()->IsTextEdit() )
//STRIP001 	{
//STRIP001 #ifdef MAC
//STRIP001 		pDrViewShell->GetView()->BrkAction();	// Aktion wieder abbrechen
//STRIP001 #endif
//STRIP001 
//STRIP001 		SvxRuler::Command( rCEvt );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* ExtraDown
|*
\************************************************************************/

//STRIP001 void SdRuler::ExtraDown()
//STRIP001 {
//STRIP001 	if( !pDrViewShell->GetView()->IsTextEdit() )
//STRIP001 		SvxRuler::ExtraDown();
//STRIP001 }



}
