/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fontlb.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:42:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SVX_FONTLB_HXX
#include "fontlb.hxx"
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
namespace binfilter {

#pragma hdrstop

// ============================================================================

//STRIP001 DBG_NAME( SvLBoxFontString )

//STRIP001 SvLBoxFontString::SvLBoxFontString() :
//STRIP001     SvLBoxString()
//STRIP001 {
//STRIP001     DBG_CTOR( SvLBoxFontString, 0 );
//STRIP001 }

//STRIP001 SvLBoxFontString::SvLBoxFontString(
//STRIP001         SvLBoxEntry* pEntry, sal_uInt16 nFlags, const XubString& rString,
//STRIP001         const Font& rFont, const Color* pColor ) :
//STRIP001     SvLBoxString( pEntry, nFlags, rString ),
//STRIP001     maFont( rFont ),
//STRIP001     mbUseColor( pColor != NULL )
//STRIP001 {
//STRIP001     DBG_CTOR( SvLBoxFontString, 0 );
//STRIP001     SetText( pEntry, rString );
//STRIP001     if( pColor )
//STRIP001         maFont.SetColor( *pColor );
//STRIP001 }

//STRIP001 SvLBoxFontString::~SvLBoxFontString()
//STRIP001 {
//STRIP001     DBG_DTOR( SvLBoxFontString, 0 );
//STRIP001 }


//STRIP001 SvLBoxItem* SvLBoxFontString::Create() const
//STRIP001 {
//STRIP001     DBG_CHKTHIS( SvLBoxFontString, 0 );
//STRIP001     return new SvLBoxFontString;
//STRIP001 }

//STRIP001 void SvLBoxFontString::Paint( const Point& rPos, SvLBox& rDev, sal_uInt16 nFlags, SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001     DBG_CHKTHIS( SvLBoxFontString, 0 );
//STRIP001     Font aOldFont( rDev.GetFont() );
//STRIP001     Font aNewFont( maFont );
//STRIP001     bool bSel = (nFlags & SVLISTENTRYFLAG_SELECTED) != 0;
//STRIP001 //  if( !mbUseColor )               // selection gets font color, if available
//STRIP001     if( !mbUseColor || bSel )       // selection always gets highlight color
//STRIP001     {
//STRIP001         const StyleSettings& rSett = Application::GetSettings().GetStyleSettings();
//STRIP001         aNewFont.SetColor( bSel ? rSett.GetHighlightTextColor() : rSett.GetFieldTextColor() );
//STRIP001     }
//STRIP001 
//STRIP001     rDev.SetFont( aNewFont );
//STRIP001     SvLBoxString::Paint( rPos, rDev, nFlags, pEntry );
//STRIP001     rDev.SetFont( aOldFont );
//STRIP001 }

//STRIP001 void SvLBoxFontString::InitViewData( SvLBox* pView, SvLBoxEntry* pEntry, SvViewDataItem* pViewData )
//STRIP001 {
//STRIP001     DBG_CHKTHIS( SvLBoxFontString, 0 );
//STRIP001     Font aOldFont( pView->GetFont() );
//STRIP001     pView->SetFont( maFont );
//STRIP001     SvLBoxString::InitViewData( pView, pEntry, pViewData);
//STRIP001     pView->SetFont( aOldFont );
//STRIP001 }


// ============================================================================

//STRIP001 SvxFontListBox::SvxFontListBox( Window* pParent, const ResId& rResId ) :
//STRIP001     SvTabListBox( pParent, rResId ),
//STRIP001     maStdFont( GetFont() ),
//STRIP001     mbUseFont( false )
//STRIP001 {
//STRIP001     maStdFont.SetTransparent( TRUE );
//STRIP001     maEntryFont = maStdFont;
//STRIP001 }

//STRIP001 void SvxFontListBox::InsertFontEntry( const String& rString, const Font& rFont, const Color* pColor )
//STRIP001 {
//STRIP001     mbUseFont = true;           // InitEntry() will use maEntryFont
//STRIP001     maEntryFont = rFont;        // font to use in InitEntry() over InsertEntry()
//STRIP001     mpEntryColor = pColor;      // color to use in InitEntry() over InsertEntry()
//STRIP001     InsertEntry( rString );
//STRIP001     mbUseFont = false;
//STRIP001 }

//STRIP001 void SvxFontListBox::SelectEntryPos( sal_uInt16 nPos, bool bSelect )
//STRIP001 {
//STRIP001     SvLBoxEntry* pEntry = GetEntry( nPos );
//STRIP001     if( pEntry )
//STRIP001     {
//STRIP001         Select( pEntry, bSelect );
//STRIP001         ShowEntry( pEntry );
//STRIP001     }
//STRIP001 }

//STRIP001 void SvxFontListBox::SetNoSelection()
//STRIP001 {
//STRIP001     SelectAll( FALSE, TRUE );
//STRIP001 }

//STRIP001 sal_uInt32 SvxFontListBox::GetSelectEntryPos() const
//STRIP001 {
//STRIP001     SvLBoxEntry* pSvLBoxEntry = FirstSelected();
//STRIP001     return pSvLBoxEntry ? GetModel()->GetAbsPos( pSvLBoxEntry ) : LIST_ENTRY_NOTFOUND;
//STRIP001 }

//STRIP001 XubString SvxFontListBox::GetSelectEntry() const
//STRIP001 {
//STRIP001     return GetEntryText( GetSelectEntryPos() );
//STRIP001 }

//STRIP001 void SvxFontListBox::InitEntry(
//STRIP001         SvLBoxEntry* pEntry, const XubString& rEntryText,
//STRIP001         const Image& rCollImg, const Image& rExpImg )
//STRIP001 {
//STRIP001     if( mbUseFont )
//STRIP001     {
//STRIP001         if( nTreeFlags & TREEFLAG_CHKBTN )
//STRIP001             pEntry->AddItem( new SvLBoxButton( pEntry, 0, pCheckButtonData ) );
//STRIP001         pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, rCollImg, rExpImg, SVLISTENTRYFLAG_EXPANDED ) );
//STRIP001         pEntry->AddItem( new SvLBoxFontString( pEntry, 0, rEntryText, maEntryFont, mpEntryColor ) );
//STRIP001     }
//STRIP001     else
//STRIP001         SvTreeListBox::InitEntry( pEntry, rEntryText, rCollImg, rExpImg );
//STRIP001 }


// ============================================================================

}
