/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_optgenrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:36:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
//#ifndef _SV_SYSTEM_HXX
//#include <vcl/system.hxx>
//#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _PVER_HXX //autogen
#include <svtools/pver.hxx>
#endif
#include <svtools/saveopt.hxx>
#pragma hdrstop

#define _SVX_OPTGENRL_CXX

#include "dialogs.hrc"
#include "optgenrl.hrc"

#include "adritem.hxx"
#include "optgenrl.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
#include "strarray.hxx"
namespace binfilter {

//STRIP001 #define TRIM(s) s.EraseLeadingChars().EraseTrailingChars()
//STRIP001 
//STRIP001 // struct GeneralTabPage_Impl --------------------------------------------
//STRIP001 
//STRIP001 struct GeneralTabPage_Impl
//STRIP001 {
//STRIP001 	BOOL	mbStreetEnabled;
//STRIP001 	BOOL	mbPLZEnabled;
//STRIP001 	BOOL	mbCityEnabled;
//STRIP001 	BOOL	mbUsCityEnabled;
//STRIP001 	BOOL	mbUsZipEnabled;
//STRIP001 
//STRIP001 	String	maQueryStr;
//STRIP001 
//STRIP001 	GeneralTabPage_Impl() :
//STRIP001 		mbStreetEnabled	( FALSE ),
//STRIP001 		mbPLZEnabled	( FALSE ),
//STRIP001 		mbCityEnabled	( FALSE ),
//STRIP001 		mbUsCityEnabled	( FALSE ),
//STRIP001 		mbUsZipEnabled	( FALSE ) {}
//STRIP001 };
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 // kommt aus adritem.cxx
//STRIP001 extern String ConvertToStore_Impl( const String& );
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxGeneralTabPage::SvxGeneralTabPage( Window* pParent, const SfxItemSet& rCoreSet ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SVX_RES(RID_SFXPAGE_GENERAL), rCoreSet ),
//STRIP001 
//STRIP001 	aCompanyLbl		( this, ResId( FT_COMPANY ) ),
//STRIP001 	aCompanyEdit	( this, ResId( ED_COMPANY ) ),
//STRIP001 	aNameLbl		( this, ResId( FT_NAME ) ),
//STRIP001 	aNameLblRuss	( this, ResId( FT_NAME_RUSS ) ),
//STRIP001 	aFatherName		( this, ResId( ED_FATHERNAME ) ),
//STRIP001 	aFirstName		( this, ResId( ED_FIRSTNAME ) ),
//STRIP001 	aName			( this, ResId( ED_NAME ) ),
//STRIP001 	aShortName		( this, ResId( ED_SHORTNAME ) ),
//STRIP001 	aStreetLbl		( this, ResId( FT_STREET ) ),
//STRIP001 	aStreetLblRuss	( this, ResId( FT_STREET_RUSS ) ),
//STRIP001 	aStreetEdit		( this, ResId( ED_STREET ) ),
//STRIP001 	aApartmentNrEdit( this, ResId( ED_APARTMENTNR ) ),
//STRIP001 	aCityLbl		( this, ResId( FT_CITY ) ),
//STRIP001 	aPLZEdit		( this, ResId( ED_PLZ ) ),
//STRIP001 	aCityEdit		( this, ResId( ED_CITY ) ),
//STRIP001 	aUsCityEdit		( this, ResId( ED_US_CITY ) ),
//STRIP001 	aUsStateEdit	( this, ResId( ED_US_STATE ) ),
//STRIP001 	aUsZipEdit		( this, ResId( ED_US_ZIPCODE ) ),
//STRIP001 	aCountryLbl		( this, ResId( FT_COUNTRY ) ),
//STRIP001 	aCountryEdit	( this, ResId( ED_COUNTRY ) ),
//STRIP001 	aTitlePosLbl	( this, ResId( FT_TITLEPOS ) ),
//STRIP001 	aTitleEdit		( this, ResId( ED_TITLE ) ),
//STRIP001 	aPositionEdit	( this, ResId( ED_POSITION ) ),
//STRIP001 	aPhoneLbl		( this, ResId( FT_PHONE ) ),
//STRIP001 	aTelPrivEdit	( this, ResId( ED_TELPRIVAT ) ),
//STRIP001 	aTelCompanyEdit	( this, ResId( ED_TELCOMPANY ) ),
//STRIP001 	aFaxMailLbl		( this, ResId( FT_FAXMAIL ) ),
//STRIP001 	aFaxEdit		( this, ResId( ED_FAX ) ),
//STRIP001 	aEmailEdit		( this, ResId( ED_EMAIL ) ),
//STRIP001 	aAddrFrm		( this, ResId( GB_ADDRESS ) ),
//STRIP001 	aUseDataCB		( this, ResId( CB_USEDATA ) ),
//STRIP001 
//STRIP001 	pImpl			( new GeneralTabPage_Impl )
//STRIP001 
//STRIP001 {
//STRIP001     LanguageType eLang = Application::GetSettings().GetUILanguage();
//STRIP001 	pImpl->maQueryStr = String( ResId( STR_QUERY_REG ) );
//STRIP001 
//STRIP001 	if ( LANGUAGE_ENGLISH_US == eLang )
//STRIP001 	{
//STRIP001 		// amerikanische Postadresse aufbauen
//STRIP001 		aPLZEdit.Hide();
//STRIP001 		aCityEdit.Hide();
//STRIP001 		aCityLbl.SetText( ResId( STR_US_STATE ) );
//STRIP001 	}
//STRIP001 	else if ( LANGUAGE_RUSSIAN == eLang )
//STRIP001 	{
//STRIP001 		aUsCityEdit.Hide();
//STRIP001 		aUsStateEdit.Hide();
//STRIP001 		aUsZipEdit.Hide();
//STRIP001 		aNameLbl.Hide();
//STRIP001 		aNameLblRuss.Show();
//STRIP001 		aStreetLbl.Hide();
//STRIP001 		aStreetLblRuss.Show();
//STRIP001 
//STRIP001 		aFatherName.Show();
//STRIP001 		aFirstName.SetPosSizePixel( LogicToPixel( Point( 88, LINE(1) ), MAP_APPFONT ),
//STRIP001 									LogicToPixel( Size( 46, 12 ), MAP_APPFONT ) );
//STRIP001 		aFatherName.SetPosSizePixel( LogicToPixel( Point( 136, LINE(1) ), MAP_APPFONT ),
//STRIP001 								  	 LogicToPixel( Size( 46, 12 ), MAP_APPFONT ) );
//STRIP001 		aName.SetPosSizePixel( LogicToPixel( Point( 184, LINE(1) ), MAP_APPFONT ),
//STRIP001 							   LogicToPixel( Size( 46, 12 ), MAP_APPFONT ) );
//STRIP001 
//STRIP001 		aStreetEdit.SetSizePixel( LogicToPixel( Size( 132, 12 ), MAP_APPFONT ) );
//STRIP001 		aApartmentNrEdit.Show();
//STRIP001 		aApartmentNrEdit.SetPosSizePixel( LogicToPixel( Point( 222, LINE(2) ), MAP_APPFONT ),
//STRIP001 										  LogicToPixel( Size( 26, 12 ), MAP_APPFONT ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aUsCityEdit.Hide();
//STRIP001 		aUsStateEdit.Hide();
//STRIP001 		aUsZipEdit.Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxGeneralTabPage, ModifyHdl_Impl );
//STRIP001 	aFirstName.SetModifyHdl( aLink );
//STRIP001 	aName.SetModifyHdl( aLink );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxGeneralTabPage::~SvxGeneralTabPage()
//STRIP001 {
//STRIP001 	delete pImpl;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage*	SvxGeneralTabPage::Create( Window* pParent, const SfxItemSet& rAttrSet )
//STRIP001 {
//STRIP001 	return ( new SvxGeneralTabPage( pParent, rAttrSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxGeneralTabPage::FillItemSet( SfxItemSet& rCoreSet )
//STRIP001 {
//STRIP001 	// Eingaben trimmen (f"uhrende und nachfolgende Leerzeichen entfernen)
//STRIP001 	aCompanyEdit.SetText( TRIM(aCompanyEdit.GetText()) );
//STRIP001 	aFirstName.SetText( TRIM(aFirstName.GetText()) );
//STRIP001 	aName.SetText( TRIM(aName.GetText()) );
//STRIP001 	aShortName.SetText( TRIM(aShortName.GetText()) );
//STRIP001 	aStreetEdit.SetText( TRIM(aStreetEdit.GetText()) );
//STRIP001 	aCountryEdit.SetText( TRIM(aCountryEdit.GetText()) );
//STRIP001 	aPLZEdit.SetText( TRIM(aPLZEdit.GetText()) );
//STRIP001 	aCityEdit.SetText( TRIM(aCityEdit.GetText()) );
//STRIP001 	aUsCityEdit.SetText( TRIM(aUsCityEdit.GetText()) );
//STRIP001 	aUsStateEdit.SetText( TRIM(aUsStateEdit.GetText()) );
//STRIP001 	aUsZipEdit.SetText( TRIM(aUsZipEdit.GetText()) );
//STRIP001 	aTitleEdit.SetText( TRIM(aTitleEdit.GetText()) );
//STRIP001 	aPositionEdit.SetText( TRIM(aPositionEdit.GetText()) );
//STRIP001 	aTelPrivEdit.SetText( TRIM(aTelPrivEdit.GetText()) );
//STRIP001 	aTelCompanyEdit.SetText( TRIM(aTelCompanyEdit.GetText()) );
//STRIP001 	aFaxEdit.SetText( TRIM(aFaxEdit.GetText()) );
//STRIP001 	aEmailEdit.SetText( TRIM(aEmailEdit.GetText()) );
//STRIP001 
//STRIP001 	BOOL bModified = FALSE, bChgAddr = FALSE;
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	String sAddress = GetAddress_Impl();
//STRIP001 
//STRIP001 	if ( rOldSet.GetItemState( GetWhich( SID_ATTR_ADDRESS ) ) >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		const SvxAddressItem& rItem =
//STRIP001 			(const SvxAddressItem&)rOldSet.Get( GetWhich( SID_ATTR_ADDRESS ) );
//STRIP001 
//STRIP001 		if ( ( rItem.GetValue() != sAddress )					||
//STRIP001 			 ( rItem.GetName() != aName.GetText() ) 		 	||
//STRIP001 			 ( rItem.GetFirstName() != aFirstName.GetText() ) 	||
//STRIP001 			 ( rItem.GetShortName() != aShortName.GetText() ) 		)
//STRIP001 			bChgAddr = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bChgAddr = TRUE;
//STRIP001 
//STRIP001 	if ( bChgAddr )
//STRIP001 	{
//STRIP001 		SvxAddressItem rItem( sAddress, aShortName.GetText(),
//STRIP001 							  aFirstName.GetText(), aName.GetText(),
//STRIP001 							  GetWhich( SID_ATTR_ADDRESS ) );
//STRIP001 		rCoreSet.Put( rItem );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	SvtSaveOptions aSaveOpt;
//STRIP001 	if ( aUseDataCB.IsChecked() != aSaveOpt.IsUseUserData() )
//STRIP001 	{
//STRIP001 		aSaveOpt.SetUseUserData( aUseDataCB.IsChecked() );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxGeneralTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_ADDRESS );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich ) >= SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		const SvxAddressItem& rItem = (SvxAddressItem&)rSet.Get( nWhich );
//STRIP001 		SetAddress_Impl( rItem );
//STRIP001 	}
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_FIELD_GRABFOCUS );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		USHORT nField = ( (SfxUInt16Item&)rSet.Get( nWhich ) ).GetValue();
//STRIP001 
//STRIP001 		switch ( nField )
//STRIP001 		{
//STRIP001 			case COMPANY_EDIT:		aCompanyEdit.GrabFocus(); break;
//STRIP001 			case FIRSTNAME_EDIT:    aFirstName.GrabFocus(); break;
//STRIP001 			case LASTNAME_EDIT:		aName.GrabFocus(); break;
//STRIP001 			case STREET_EDIT:		aStreetEdit.GrabFocus(); break;
//STRIP001 			case COUNTRY_EDIT:		aCountryEdit.GrabFocus(); break;
//STRIP001 			case PLZ_EDIT:
//STRIP001 				if ( aPLZEdit.IsVisible() )
//STRIP001 					aPLZEdit.GrabFocus();
//STRIP001 				else
//STRIP001 					aUsZipEdit.GrabFocus();
//STRIP001 				break;
//STRIP001 			case CITY_EDIT:
//STRIP001 				if ( aCityEdit.IsVisible() )
//STRIP001 					aCityEdit.GrabFocus();
//STRIP001 				else
//STRIP001 					aUsCityEdit.GrabFocus();
//STRIP001 				break;
//STRIP001 			case STATE_EDIT:
//STRIP001 				if ( aUsStateEdit.IsVisible() )
//STRIP001 					aUsStateEdit.GrabFocus();
//STRIP001 				else
//STRIP001 					aCityEdit.GrabFocus();
//STRIP001 				break;
//STRIP001 			case TITLE_EDIT:		aTitleEdit.GrabFocus(); break;
//STRIP001 			case POSITION_EDIT:		aPositionEdit.GrabFocus(); break;
//STRIP001 			case SHORTNAME_EDIT:	aShortName.GrabFocus(); break;
//STRIP001 			case TELPRIV_EDIT:		aTelPrivEdit.GrabFocus(); break;
//STRIP001 			case TELCOMPANY_EDIT:	aTelCompanyEdit.GrabFocus(); break;
//STRIP001 			case FAX_EDIT:			aFaxEdit.GrabFocus(); break;
//STRIP001 			case EMAIL_EDIT:		aEmailEdit.GrabFocus(); break;
//STRIP001 			default:				aCompanyEdit.GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aUseDataCB.Check( SvtSaveOptions().IsUseUserData() );
//STRIP001 
//STRIP001 	aFirstName.SaveValue();
//STRIP001 	aName.SaveValue();
//STRIP001 	aEmailEdit.SaveValue();
//STRIP001 	aStreetEdit.SaveValue();
//STRIP001 	aPLZEdit.SaveValue();
//STRIP001 	aCityEdit.SaveValue();
//STRIP001 	aUsCityEdit.SaveValue();
//STRIP001 	aUsZipEdit.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxGeneralTabPage, ModifyHdl_Impl, Edit *, pEdit )
//STRIP001 {
//STRIP001 	if ( aShortName.IsEnabled() )
//STRIP001 	{
//STRIP001 		String aShortStr( aShortName.GetText() );
//STRIP001 		switch ( aShortStr.Len() )
//STRIP001 		{
//STRIP001 			case 0:
//STRIP001 				aShortStr = String( RTL_CONSTASCII_STRINGPARAM("  ") );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case 1:
//STRIP001 				aShortStr += ' ';
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nPos = ( pEdit == &aFirstName ) ? 0 : 1;
//STRIP001 		String aTxt = pEdit->GetText();
//STRIP001 		sal_Unicode cChar = ( aTxt.Len() > 0 ) ? aTxt.GetChar(0) : ' ';
//STRIP001 		aShortStr.SetChar( nPos, cChar );
//STRIP001 		aShortStr.EraseTrailingChars();
//STRIP001 		aShortName.SetText( aShortStr );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 String SvxGeneralTabPage::GetAddress_Impl()
//STRIP001 {
//STRIP001     LanguageType eLang = Application::GetSettings().GetUILanguage();
//STRIP001 	BOOL bUS = ( LANGUAGE_ENGLISH_US == eLang );
//STRIP001 
//STRIP001 	String aAddrStr( ::ConvertToStore_Impl( aCompanyEdit.GetText() ) );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( aStreetEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( aCountryEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( bUS ? aUsZipEdit.GetText() : aPLZEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( bUS ? aUsCityEdit.GetText() : aCityEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( aTitleEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( aPositionEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( aTelPrivEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( aTelCompanyEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( aFaxEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( aEmailEdit.GetText() );
//STRIP001 	aAddrStr += cAdrToken;
//STRIP001 	aAddrStr += ::ConvertToStore_Impl( bUS ? aUsStateEdit.GetText() : String() );
//STRIP001 
//STRIP001 	if ( LANGUAGE_RUSSIAN == eLang )
//STRIP001 	{
//STRIP001 		aAddrStr += cAdrToken;
//STRIP001 		aAddrStr += ::ConvertToStore_Impl( aFatherName.GetText() );
//STRIP001 		aAddrStr += cAdrToken;
//STRIP001 		aAddrStr += ::ConvertToStore_Impl( aApartmentNrEdit.GetText() );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aAddrStr;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxGeneralTabPage::SetAddress_Impl( const SvxAddressItem& rAddress )
//STRIP001 {
//STRIP001 	LanguageType eLang = Application::GetSettings().GetUILanguage();
//STRIP001 	BOOL bUS = ( LANGUAGE_ENGLISH_US == eLang );
//STRIP001 	aCompanyEdit.SetText( rAddress.GetCompany() );
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_COMPANY ) )
//STRIP001 	{
//STRIP001 		aCompanyLbl.Disable();
//STRIP001 		aCompanyEdit.Disable();
//STRIP001 	}
//STRIP001 	sal_Int16 nEditCount = 0;
//STRIP001 	aFirstName.SetText( rAddress.GetFirstName() );
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_FIRSTNAME ) )
//STRIP001 	{
//STRIP001 		aFirstName.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	aName.SetText( rAddress.GetName() );
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_LASTNAME ) )
//STRIP001 	{
//STRIP001 		aName.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	aShortName.SetText( rAddress.GetShortName() );
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_SHORTNAME ) )
//STRIP001 	{
//STRIP001 		aShortName.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	aNameLbl.Enable( ( nEditCount != 3 ) );
//STRIP001 	aStreetEdit.SetText( rAddress.GetStreet() );
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_STREET ) )
//STRIP001 	{
//STRIP001 		aStreetLbl.Disable();
//STRIP001 		aStreetEdit.Disable();
//STRIP001 	}
//STRIP001 	Edit* pPLZEdit = bUS ? &aUsZipEdit : &aPLZEdit;
//STRIP001 	Edit* pCityEdit = bUS ? &aUsCityEdit : &aCityEdit;
//STRIP001 	pPLZEdit->SetText( rAddress.GetPLZ() );
//STRIP001 	pCityEdit->SetText( rAddress.GetCity() );
//STRIP001 	nEditCount = 0;
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_PLZ ) )
//STRIP001 	{
//STRIP001 		pPLZEdit->Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_CITY ) )
//STRIP001 	{
//STRIP001 		pCityEdit->Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	if ( bUS )
//STRIP001 	{
//STRIP001 		aUsStateEdit.SetText( rAddress.GetState() );
//STRIP001 		if ( rAddress.IsTokenReadonly( POS_STATE ) )
//STRIP001 		{
//STRIP001 			aUsStateEdit.Disable();
//STRIP001 			nEditCount++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aCityLbl.Enable( ( nEditCount != ( bUS ? 3 : 2 ) ) );
//STRIP001 	aCountryEdit.SetText( rAddress.GetCountry() );
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_COUNTRY ) )
//STRIP001 	{
//STRIP001 		aCountryLbl.Disable();
//STRIP001 		aCountryEdit.Disable();
//STRIP001 	}
//STRIP001 	aTitleEdit.SetText( rAddress.GetTitle() );
//STRIP001 	aPositionEdit.SetText( rAddress.GetPosition() );
//STRIP001 	nEditCount = 0;
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_TITLE ) )
//STRIP001 	{
//STRIP001 		aTitleEdit.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_POSITION ) )
//STRIP001 	{
//STRIP001 		aPositionEdit.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	aTitlePosLbl.Enable( ( nEditCount != 2 ) );
//STRIP001 	aTelPrivEdit.SetText( rAddress.GetTelPriv() );
//STRIP001 	aTelCompanyEdit.SetText( rAddress.GetTelCompany() );
//STRIP001 	nEditCount = 0;
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_TEL_PRIVATE ) )
//STRIP001 	{
//STRIP001 		aTelPrivEdit.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_TEL_COMPANY ) )
//STRIP001 	{
//STRIP001 		aTelCompanyEdit.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	aPhoneLbl.Enable( ( nEditCount != 2 ) );
//STRIP001 	aFaxEdit.SetText( rAddress.GetFax() );
//STRIP001 	aEmailEdit.SetText( rAddress.GetEmail() );
//STRIP001 	nEditCount = 0;
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_FAX ) )
//STRIP001 	{
//STRIP001 		aFaxEdit.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	if ( rAddress.IsTokenReadonly( POS_EMAIL ) )
//STRIP001 	{
//STRIP001 		aEmailEdit.Disable();
//STRIP001 		nEditCount++;
//STRIP001 	}
//STRIP001 	aFaxMailLbl.Enable( ( nEditCount != 2 ) );
//STRIP001 
//STRIP001 	if ( LANGUAGE_RUSSIAN == eLang )
//STRIP001 	{
//STRIP001 		aFatherName.SetText( rAddress.GetFatherName() );
//STRIP001 		aApartmentNrEdit.SetText( rAddress.GetApartmentNr() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxGeneralTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }

}
