/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_optjsearch.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:38:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SVT_SEARCHOPT_HXX_
#include <svtools/searchopt.hxx>
#endif

#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HPP_
#include <com/sun/star/i18n/TransliterationModules.hpp>
#endif

#pragma hdrstop

#ifndef _SVX_DIALOGS_HRC
#include <dialogs.hrc>
#endif
#ifndef _SVX_DIALMGR_HXX
#include <dialmgr.hxx>
#endif

#ifndef _SVX_OPTJSEARCH_HXX_
#include <optjsearch.hxx>
#endif
#include "optjsearch.hrc"
namespace binfilter {

using namespace ::com::sun::star::i18n;

//////////////////////////////////////////////////////////////////////

//STRIP001 SvxJSearchOptionsPage::SvxJSearchOptionsPage( Window* pParent, const SfxItemSet& rSet ) :
//STRIP001 	SfxTabPage( pParent, SVX_RES( RID_SVXPAGE_JSEARCH_OPTIONS ), rSet ),
//STRIP001 
//STRIP001 	aTreatAsEqual				( this, ResId( FL_TREAT_AS_EQUAL ) ),
//STRIP001 	aMatchCase					( this, ResId( CB_MATCH_CASE ) ),
//STRIP001 	aMatchFullHalfWidth			( this, ResId( CB_MATCH_FULL_HALF_WIDTH ) ),
//STRIP001 	aMatchHiraganaKatakana		( this, ResId( CB_MATCH_HIRAGANA_KATAKANA ) ),
//STRIP001 	aMatchContractions			( this, ResId( CB_MATCH_CONTRACTIONS ) ),
//STRIP001 	aMatchMinusDashChoon		( this, ResId( CB_MATCH_MINUS_DASH_CHOON ) ),
//STRIP001 	aMatchRepeatCharMarks		( this, ResId( CB_MATCH_REPEAT_CHAR_MARKS ) ),
//STRIP001 	aMatchVariantFormKanji		( this, ResId( CB_MATCH_VARIANT_FORM_KANJI ) ),
//STRIP001 	aMatchOldKanaForms			( this, ResId( CB_MATCH_OLD_KANA_FORMS ) ),
//STRIP001 	aMatchDiziDuzu				( this, ResId( CB_MATCH_DIZI_DUZU ) ),
//STRIP001 	aMatchBavaHafa				( this, ResId( CB_MATCH_BAVA_HAFA ) ),
//STRIP001 	aMatchTsithichiDhizi		( this, ResId( CB_MATCH_TSITHICHI_DHIZI ) ),
//STRIP001 	aMatchHyuiyuByuvyu			( this, ResId( CB_MATCH_HYUFYU_BYUVYU ) ),
//STRIP001 	aMatchSesheZeje				( this, ResId( CB_MATCH_SESHE_ZEJE ) ),
//STRIP001 	aMatchIaiya					( this, ResId( CB_MATCH_IAIYA ) ),
//STRIP001 	aMatchKiku					( this, ResId( CB_MATCH_KIKU ) ),
//STRIP001 	aIgnore						( this, ResId( FL_IGNORE ) ),
//STRIP001 	aIgnorePunctuation			( this, ResId( CB_IGNORE_PUNCTUATION ) ),
//STRIP001 	aIgnoreWhitespace			( this, ResId( CB_IGNORE_WHITESPACES ) ),
//STRIP001     aMatchProlongedSoundMark    ( this, ResId( CB_MATCH_PROLONGED_SOUNDMARK ) ),
//STRIP001 	aIgnoreMiddleDot			( this, ResId( CB_IGNORE_MIDDLE_DOT ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	bSaveOptions = TRUE;
//STRIP001 	nTransliterationFlags = 0x00000000;
//STRIP001 }


//STRIP001 SvxJSearchOptionsPage::~SvxJSearchOptionsPage()
//STRIP001 {
//STRIP001 }


//STRIP001 SfxTabPage*  SvxJSearchOptionsPage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxJSearchOptionsPage( pParent, rSet );
//STRIP001 }


//STRIP001 void SvxJSearchOptionsPage::SetTransliterationFlags( INT32 nSettings )
//STRIP001 {
//STRIP001 	BOOL  bVal = 0 != (nSettings & TransliterationModules_IGNORE_CASE);
//STRIP001     aMatchCase               .Check( bVal );    //! treat as equal uppercase/lowercase
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_IGNORE_WIDTH);
//STRIP001     aMatchFullHalfWidth      .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_IGNORE_KANA);
//STRIP001     aMatchHiraganaKatakana   .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreSize_ja_JP);
//STRIP001     aMatchContractions       .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreMinusSign_ja_JP);
//STRIP001     aMatchMinusDashChoon     .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreIterationMark_ja_JP);
//STRIP001     aMatchRepeatCharMarks    .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreTraditionalKanji_ja_JP);
//STRIP001     aMatchVariantFormKanji   .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreTraditionalKana_ja_JP);
//STRIP001     aMatchOldKanaForms       .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreZiZu_ja_JP);
//STRIP001     aMatchDiziDuzu           .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreBaFa_ja_JP);
//STRIP001     aMatchBavaHafa           .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreTiJi_ja_JP);
//STRIP001     aMatchTsithichiDhizi     .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreHyuByu_ja_JP);
//STRIP001     aMatchHyuiyuByuvyu       .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreSeZe_ja_JP);
//STRIP001     aMatchSesheZeje          .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreIandEfollowedByYa_ja_JP);
//STRIP001     aMatchIaiya              .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreKiKuFollowedBySa_ja_JP);
//STRIP001     aMatchKiku               .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreSeparator_ja_JP);
//STRIP001 	aIgnorePunctuation		 .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreSpace_ja_JP);
//STRIP001 	aIgnoreWhitespace		 .Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreProlongedSoundMark_ja_JP);
//STRIP001     aMatchProlongedSoundMark.Check( bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_ignoreMiddleDot_ja_JP);
//STRIP001 	aIgnoreMiddleDot		 .Check( bVal );
//STRIP001 
//STRIP001 	nTransliterationFlags = nSettings;
//STRIP001 }


//STRIP001 INT32 SvxJSearchOptionsPage::GetTransliterationFlags_Impl()
//STRIP001 {
//STRIP001 	INT32 nTmp = 0;
//STRIP001     if (aMatchCase.IsChecked()) //! treat as equal uppercase/lowercase
//STRIP001 		nTmp |= TransliterationModules_IGNORE_CASE;
//STRIP001     if (aMatchFullHalfWidth.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_IGNORE_WIDTH;
//STRIP001     if (aMatchHiraganaKatakana.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_IGNORE_KANA;
//STRIP001     if (aMatchContractions.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreSize_ja_JP;
//STRIP001     if (aMatchMinusDashChoon.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreMinusSign_ja_JP;
//STRIP001     if (aMatchRepeatCharMarks.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreIterationMark_ja_JP;
//STRIP001     if (aMatchVariantFormKanji.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreTraditionalKanji_ja_JP;
//STRIP001     if (aMatchOldKanaForms.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreTraditionalKana_ja_JP;
//STRIP001     if (aMatchDiziDuzu.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreZiZu_ja_JP;
//STRIP001     if (aMatchBavaHafa.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreBaFa_ja_JP;
//STRIP001     if (aMatchTsithichiDhizi.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreTiJi_ja_JP;
//STRIP001     if (aMatchHyuiyuByuvyu.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreHyuByu_ja_JP;
//STRIP001     if (aMatchSesheZeje.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreSeZe_ja_JP;
//STRIP001     if (aMatchIaiya.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreIandEfollowedByYa_ja_JP;
//STRIP001     if (aMatchKiku.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreKiKuFollowedBySa_ja_JP;
//STRIP001     if (aIgnorePunctuation.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreSeparator_ja_JP;
//STRIP001     if (aIgnoreWhitespace.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreSpace_ja_JP;
//STRIP001     if (aMatchProlongedSoundMark.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreProlongedSoundMark_ja_JP;
//STRIP001     if (aIgnoreMiddleDot.IsChecked())
//STRIP001 		nTmp |= TransliterationModules_ignoreMiddleDot_ja_JP;
//STRIP001 
//STRIP001 	nTransliterationFlags = nTmp;
//STRIP001 	return nTransliterationFlags;
//STRIP001 }


//STRIP001 void SvxJSearchOptionsPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SvtSearchOptions aOpt;
//STRIP001 
//STRIP001 	// read settings from configuration
//STRIP001     aMatchCase               .Check(!aOpt.IsMatchCase() );  //! treat as equal uppercase/lowercase
//STRIP001 	aMatchFullHalfWidth		 .Check( aOpt.IsMatchFullHalfWidthForms() );
//STRIP001 	aMatchHiraganaKatakana	 .Check( aOpt.IsMatchHiraganaKatakana() );
//STRIP001 	aMatchContractions		 .Check( aOpt.IsMatchContractions() );
//STRIP001 	aMatchMinusDashChoon	 .Check( aOpt.IsMatchMinusDashChoon() );
//STRIP001 	aMatchRepeatCharMarks	 .Check( aOpt.IsMatchRepeatCharMarks() );
//STRIP001 	aMatchVariantFormKanji	 .Check( aOpt.IsMatchVariantFormKanji() );
//STRIP001 	aMatchOldKanaForms		 .Check( aOpt.IsMatchOldKanaForms() );
//STRIP001 	aMatchDiziDuzu			 .Check( aOpt.IsMatchDiziDuzu() );
//STRIP001 	aMatchBavaHafa			 .Check( aOpt.IsMatchBavaHafa() );
//STRIP001 	aMatchTsithichiDhizi	 .Check( aOpt.IsMatchTsithichiDhizi() );
//STRIP001 	aMatchHyuiyuByuvyu		 .Check( aOpt.IsMatchHyuiyuByuvyu() );
//STRIP001 	aMatchSesheZeje			 .Check( aOpt.IsMatchSesheZeje() );
//STRIP001 	aMatchIaiya				 .Check( aOpt.IsMatchIaiya() );
//STRIP001 	aMatchKiku				 .Check( aOpt.IsMatchKiku() );
//STRIP001 	aIgnorePunctuation		 .Check( aOpt.IsIgnorePunctuation() );
//STRIP001 	aIgnoreWhitespace		 .Check( aOpt.IsIgnoreWhitespace() );
//STRIP001     aMatchProlongedSoundMark .Check( aOpt.IsIgnoreProlongedSoundMark() );
//STRIP001 	aIgnoreMiddleDot		 .Check( aOpt.IsIgnoreMiddleDot() );
//STRIP001 
//STRIP001 	nTransliterationFlags = GetTransliterationFlags_Impl();
//STRIP001 	DBG_ASSERT( nTransliterationFlags == aOpt.GetTransliterationFlags(),
//STRIP001 			"Transliteration settings different" );
//STRIP001 
//STRIP001 	aMatchCase				 .SaveValue();
//STRIP001 	aMatchFullHalfWidth		 .SaveValue();
//STRIP001 	aMatchHiraganaKatakana	 .SaveValue();
//STRIP001 	aMatchContractions		 .SaveValue();
//STRIP001 	aMatchMinusDashChoon	 .SaveValue();
//STRIP001 	aMatchRepeatCharMarks	 .SaveValue();
//STRIP001 	aMatchVariantFormKanji	 .SaveValue();
//STRIP001 	aMatchOldKanaForms		 .SaveValue();
//STRIP001 	aMatchDiziDuzu			 .SaveValue();
//STRIP001 	aMatchBavaHafa			 .SaveValue();
//STRIP001 	aMatchTsithichiDhizi	 .SaveValue();
//STRIP001 	aMatchHyuiyuByuvyu		 .SaveValue();
//STRIP001 	aMatchSesheZeje			 .SaveValue();
//STRIP001 	aMatchIaiya				 .SaveValue();
//STRIP001 	aMatchKiku				 .SaveValue();
//STRIP001 	aIgnorePunctuation		 .SaveValue();
//STRIP001 	aIgnoreWhitespace		 .SaveValue();
//STRIP001     aMatchProlongedSoundMark .SaveValue();
//STRIP001 	aIgnoreMiddleDot		 .SaveValue();
//STRIP001 }


//STRIP001 BOOL SvxJSearchOptionsPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001     INT32 nOldVal = nTransliterationFlags;
//STRIP001 	nTransliterationFlags = GetTransliterationFlags_Impl();
//STRIP001     bModified = nOldVal != nTransliterationFlags;
//STRIP001 
//STRIP001 	if (!IsSaveOptions())
//STRIP001 		return bModified;
//STRIP001 
//STRIP001     bModified = FALSE;
//STRIP001 	SvtSearchOptions aOpt;
//STRIP001 	BOOL bNewVal, bChanged;
//STRIP001 
//STRIP001     bNewVal  = aMatchCase.IsChecked();  //! treat as equal uppercase/lowercase
//STRIP001 	bChanged = bNewVal != aMatchCase.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001         aOpt.SetMatchCase(!bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchFullHalfWidth.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchFullHalfWidth.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchFullHalfWidthForms( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchHiraganaKatakana.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchHiraganaKatakana.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchHiraganaKatakana( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchContractions.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchContractions.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchContractions( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchMinusDashChoon.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchMinusDashChoon.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchMinusDashChoon( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchRepeatCharMarks.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchRepeatCharMarks.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchRepeatCharMarks( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchVariantFormKanji.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchVariantFormKanji.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchVariantFormKanji( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchOldKanaForms.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchOldKanaForms.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchOldKanaForms( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchDiziDuzu.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchDiziDuzu.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchDiziDuzu( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchBavaHafa.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchBavaHafa.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchBavaHafa( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchTsithichiDhizi.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchTsithichiDhizi.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchTsithichiDhizi( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchHyuiyuByuvyu.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchHyuiyuByuvyu.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchHyuiyuByuvyu( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchSesheZeje.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchSesheZeje.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchSesheZeje( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchIaiya.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchIaiya.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchIaiya( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aMatchKiku.IsChecked();
//STRIP001 	bChanged = bNewVal != aMatchKiku.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetMatchKiku( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aIgnorePunctuation.IsChecked();
//STRIP001 	bChanged = bNewVal != aIgnorePunctuation.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetIgnorePunctuation( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aIgnoreWhitespace.IsChecked();
//STRIP001 	bChanged = bNewVal != aIgnoreWhitespace.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetIgnoreWhitespace( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001     bNewVal  = aMatchProlongedSoundMark.IsChecked();
//STRIP001     bChanged = bNewVal != aMatchProlongedSoundMark.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001         aOpt.SetIgnoreProlongedSoundMark( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	bNewVal  = aIgnoreMiddleDot.IsChecked();
//STRIP001 	bChanged = bNewVal != aIgnoreMiddleDot.GetSavedValue();
//STRIP001 	if (bChanged)
//STRIP001 	{
//STRIP001 		aOpt.SetIgnoreMiddleDot( bNewVal );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }


//////////////////////////////////////////////////////////////////////

}
