/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_gradtrns.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:50:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #include "gradtrns.hxx"
// auto strip #include "svdobj.hxx"

// auto strip #ifndef _B3D_B3DCOLOR_HXX
// auto strip #include <goodies/b3dcolor.hxx>
// auto strip #endif

// auto strip #ifndef _B2D_MATRIX3D_HXX
// auto strip #include <goodies/matrix3d.hxx>
// auto strip #endif
namespace binfilter {

//////////////////////////////////////////////////////////////////////////////

//STRIP001 void GradTransformer::GradToVec(GradTransGradient& rG, GradTransVector& rV, 
//STRIP001 	const SdrObject* pObj)
//STRIP001 {
//STRIP001 	// handle start color
//STRIP001 	rV.aCol1 = rG.aGradient.GetStartColor();
//STRIP001 	if(rG.aGradient.GetStartIntens() != 100)
//STRIP001 	{
//STRIP001 		double fFact = (double)rG.aGradient.GetStartIntens() / 100.0;
//STRIP001 		rV.aCol1 = (B3dColor)rV.aCol1 * fFact;
//STRIP001 	}
//STRIP001 
//STRIP001 	// handle end color
//STRIP001 	rV.aCol2 = rG.aGradient.GetEndColor();
//STRIP001 	if(rG.aGradient.GetEndIntens() != 100)
//STRIP001 	{
//STRIP001 		double fFact = (double)rG.aGradient.GetEndIntens() / 100.0;
//STRIP001 		rV.aCol2 = (B3dColor)rV.aCol2 * fFact;
//STRIP001 	}
//STRIP001 
//STRIP001 	// calc the basic positions
//STRIP001 	Rectangle aRect(pObj->GetSnapRect());
//STRIP001 	Vector2D aCenter(aRect.Center());
//STRIP001 	Vector2D aStartPos, aEndPos;
//STRIP001 
//STRIP001 	switch(rG.aGradient.GetGradientStyle())
//STRIP001 	{
//STRIP001 		case XGRAD_LINEAR :
//STRIP001 		{
//STRIP001 			aStartPos = Vector2D(aCenter.X(), aRect.Top());
//STRIP001 			aEndPos = Vector2D(aCenter.X(), aRect.Bottom());
//STRIP001 
//STRIP001 			if(rG.aGradient.GetBorder())
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aStartPos - aEndPos);
//STRIP001 				double fLen = (aFullVec.GetLength() * (100.0 - (double)rG.aGradient.GetBorder())) / 100.0;
//STRIP001 				aFullVec.Normalize();
//STRIP001 				aStartPos = aEndPos + (aFullVec * fLen);
//STRIP001 			}
//STRIP001 
//STRIP001 			if(rG.aGradient.GetAngle())
//STRIP001 			{
//STRIP001 				double fAngle = (double)rG.aGradient.GetAngle() * (F_PI180 / 10.0);
//STRIP001 				Matrix3D aTrans;
//STRIP001 				aTrans.Translate(-aCenter);
//STRIP001 				aTrans.Rotate(-fAngle);
//STRIP001 				aTrans.Translate(aCenter);
//STRIP001 				aStartPos *= aTrans;
//STRIP001 				aEndPos *= aTrans;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case XGRAD_AXIAL :
//STRIP001 		{
//STRIP001 			aStartPos = aCenter;
//STRIP001 			aEndPos = Vector2D(aCenter.X(), aRect.Bottom());
//STRIP001 
//STRIP001 			if(rG.aGradient.GetBorder())
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aEndPos - aStartPos);
//STRIP001 				double fLen = (aFullVec.GetLength() * (100.0 - (double)rG.aGradient.GetBorder())) / 100.0;
//STRIP001 				aFullVec.Normalize();
//STRIP001 				aEndPos = aStartPos + (aFullVec * fLen);
//STRIP001 			}
//STRIP001 			
//STRIP001 			if(rG.aGradient.GetAngle())
//STRIP001 			{
//STRIP001 				double fAngle = (double)rG.aGradient.GetAngle() * (F_PI180 / 10.0);
//STRIP001 				Matrix3D aTrans;
//STRIP001 				aTrans.Translate(-aCenter);
//STRIP001 				aTrans.Rotate(-fAngle);
//STRIP001 				aTrans.Translate(aCenter);
//STRIP001 				aStartPos *= aTrans;
//STRIP001 				aEndPos *= aTrans;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case XGRAD_RADIAL :
//STRIP001 		case XGRAD_SQUARE :
//STRIP001 		{
//STRIP001 			aStartPos = Vector2D(aRect.BottomLeft());
//STRIP001 			aEndPos = Vector2D(aRect.TopLeft());
//STRIP001 
//STRIP001 			if(rG.aGradient.GetBorder())
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aStartPos - aEndPos);
//STRIP001 				double fLen = (aFullVec.GetLength() * (100.0 - (double)rG.aGradient.GetBorder())) / 100.0;
//STRIP001 				aFullVec.Normalize();
//STRIP001 				aStartPos = aEndPos + (aFullVec * fLen);
//STRIP001 			}
//STRIP001 			
//STRIP001 			if(rG.aGradient.GetAngle())
//STRIP001 			{
//STRIP001 				double fAngle = (double)rG.aGradient.GetAngle() * (F_PI180 / 10.0);
//STRIP001 				Matrix3D aTrans;
//STRIP001 				aTrans.Translate(-aEndPos);
//STRIP001 				aTrans.Rotate(-fAngle);
//STRIP001 				aTrans.Translate(aEndPos);
//STRIP001 				aStartPos *= aTrans;
//STRIP001 				aEndPos *= aTrans;
//STRIP001 			}
//STRIP001 			
//STRIP001 			if(rG.aGradient.GetXOffset() || rG.aGradient.GetYOffset())
//STRIP001 			{
//STRIP001 				Vector2D aOffset(
//STRIP001 					((double)aRect.GetWidth() * rG.aGradient.GetXOffset()) / 100.0,
//STRIP001 					((double)aRect.GetHeight() * rG.aGradient.GetYOffset()) / 100.0);
//STRIP001 				aStartPos += aOffset;
//STRIP001 				aEndPos += aOffset;
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case XGRAD_ELLIPTICAL :
//STRIP001 		case XGRAD_RECT :
//STRIP001 		{
//STRIP001 			aStartPos = Vector2D(aRect.Left(), aCenter.Y());
//STRIP001 			aEndPos = Vector2D(aRect.TopLeft());
//STRIP001 
//STRIP001 			if(rG.aGradient.GetBorder())
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aStartPos - aEndPos);
//STRIP001 				double fLen = (aFullVec.GetLength() * (100.0 - (double)rG.aGradient.GetBorder())) / 100.0;
//STRIP001 				aFullVec.Normalize();
//STRIP001 				aStartPos = aEndPos + (aFullVec * fLen);
//STRIP001 			}
//STRIP001 			
//STRIP001 			if(rG.aGradient.GetAngle())
//STRIP001 			{
//STRIP001 				double fAngle = (double)rG.aGradient.GetAngle() * (F_PI180 / 10.0);
//STRIP001 				Matrix3D aTrans;
//STRIP001 				aTrans.Translate(-aEndPos);
//STRIP001 				aTrans.Rotate(-fAngle);
//STRIP001 				aTrans.Translate(aEndPos);
//STRIP001 				aStartPos *= aTrans;
//STRIP001 				aEndPos *= aTrans;
//STRIP001 			}
//STRIP001 			
//STRIP001 			if(rG.aGradient.GetXOffset() || rG.aGradient.GetYOffset())
//STRIP001 			{
//STRIP001 				Vector2D aOffset(
//STRIP001 					((double)aRect.GetWidth() * rG.aGradient.GetXOffset()) / 100.0,
//STRIP001 					((double)aRect.GetHeight() * rG.aGradient.GetYOffset()) / 100.0);
//STRIP001 				aStartPos += aOffset;
//STRIP001 				aEndPos += aOffset;
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// set values for vector positions now
//STRIP001 	rV.aPos1 = Point((INT32)(aStartPos.X() + 0.5), (INT32)(aStartPos.Y() + 0.5));
//STRIP001 	rV.aPos2 = Point((INT32)(aEndPos.X() + 0.5), (INT32)(aEndPos.Y() + 0.5));
//STRIP001 }

//////////////////////////////////////////////////////////////////////////////

//STRIP001 void GradTransformer::VecToGrad(GradTransVector& rV, GradTransGradient& rG, 
//STRIP001 	GradTransGradient& rGOld, const SdrObject* pObj, BOOL bMoveSingle, BOOL bMoveFirst)
//STRIP001 {
//STRIP001 	// fill old gradient to new gradient to have a base
//STRIP001 	rG = rGOld;
//STRIP001 
//STRIP001 	// handle color changes
//STRIP001 	if(rV.aCol1 != rGOld.aGradient.GetStartColor())
//STRIP001 	{
//STRIP001 		rG.aGradient.SetStartColor(rV.aCol1);
//STRIP001 		rG.aGradient.SetStartIntens(100);
//STRIP001 	}
//STRIP001 	if(rV.aCol2 != rGOld.aGradient.GetEndColor())
//STRIP001 	{
//STRIP001 		rG.aGradient.SetEndColor(rV.aCol2);
//STRIP001 		rG.aGradient.SetEndIntens(100);
//STRIP001 	}
//STRIP001 
//STRIP001 	// calc the basic positions
//STRIP001 	Rectangle aRect(pObj->GetSnapRect());
//STRIP001 	Vector2D aCenter(aRect.Center());
//STRIP001 	Vector2D aStartPos(rV.aPos1);
//STRIP001 	Vector2D aEndPos(rV.aPos2);
//STRIP001 
//STRIP001 	switch(rG.aGradient.GetGradientStyle())
//STRIP001 	{
//STRIP001 		case XGRAD_LINEAR :
//STRIP001 		{
//STRIP001 			if(!bMoveSingle || (bMoveSingle && !bMoveFirst))
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aEndPos - aStartPos);
//STRIP001 				if(bMoveSingle)
//STRIP001 					aFullVec = aEndPos - aCenter;
//STRIP001 				
//STRIP001 				aFullVec.Normalize();
//STRIP001 				
//STRIP001 				double fNewFullAngle = atan2(aFullVec.Y(), aFullVec.X());
//STRIP001 				fNewFullAngle /= F_PI180;
//STRIP001 				fNewFullAngle *= -10.0;
//STRIP001 				fNewFullAngle += 900.0;
//STRIP001 
//STRIP001 				// clip
//STRIP001 				while(fNewFullAngle < 0.0)
//STRIP001 					fNewFullAngle += 3600.0;
//STRIP001 				while(fNewFullAngle >= 3600.0)
//STRIP001 					fNewFullAngle -= 3600.0;
//STRIP001 
//STRIP001 				// to int and set
//STRIP001 				sal_Int32 nNewAngle = (sal_Int32)(fNewFullAngle + 0.5);
//STRIP001 				if(nNewAngle != rGOld.aGradient.GetAngle())
//STRIP001 					rG.aGradient.SetAngle(nNewAngle);
//STRIP001 			}
//STRIP001 
//STRIP001 			if(!bMoveSingle || (bMoveSingle && bMoveFirst))
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aEndPos - aStartPos);
//STRIP001 				Vector2D aOldVec(aRect.BottomLeft() - aRect.TopLeft());
//STRIP001 				double fFullLen = aFullVec.GetLength();
//STRIP001 				double fOldLen = aOldVec.GetLength();
//STRIP001 				double fNewBorder = (fFullLen * 100.0) / fOldLen;
//STRIP001 				sal_Int32 nNewBorder = 100 - (sal_Int32)(fNewBorder + 0.5);
//STRIP001 
//STRIP001 				// clip
//STRIP001 				if(nNewBorder < 0)
//STRIP001 					nNewBorder = 0;
//STRIP001 				if(nNewBorder > 100)
//STRIP001 					nNewBorder = 100;
//STRIP001 
//STRIP001 				// set
//STRIP001 				if(nNewBorder != rG.aGradient.GetBorder())
//STRIP001 					rG.aGradient.SetBorder((sal_uInt16)nNewBorder);
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case XGRAD_AXIAL :
//STRIP001 		{
//STRIP001 			if(!bMoveSingle || (bMoveSingle && !bMoveFirst))
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aEndPos - aCenter);
//STRIP001 				Vector2D aOldVec(Vector2D(aCenter.X(), aRect.Bottom()) - aCenter);
//STRIP001 				double fFullLen = aFullVec.GetLength();
//STRIP001 				double fOldLen = aOldVec.GetLength();
//STRIP001 				double fNewBorder = (fFullLen * 100.0) / fOldLen;
//STRIP001 				sal_Int32 nNewBorder = 100 - (sal_Int32)(fNewBorder + 0.5);
//STRIP001 
//STRIP001 				// clip
//STRIP001 				if(nNewBorder < 0)
//STRIP001 					nNewBorder = 0;
//STRIP001 				if(nNewBorder > 100)
//STRIP001 					nNewBorder = 100;
//STRIP001 
//STRIP001 				// set
//STRIP001 				if(nNewBorder != rG.aGradient.GetBorder())
//STRIP001 					rG.aGradient.SetBorder((sal_uInt16)nNewBorder);
//STRIP001 				
//STRIP001 				aFullVec.Normalize();
//STRIP001 				double fNewFullAngle = atan2(aFullVec.Y(), aFullVec.X());
//STRIP001 				fNewFullAngle /= F_PI180;
//STRIP001 				fNewFullAngle *= -10.0;
//STRIP001 				fNewFullAngle += 900.0;
//STRIP001 
//STRIP001 				// clip
//STRIP001 				while(fNewFullAngle < 0.0)
//STRIP001 					fNewFullAngle += 3600.0;
//STRIP001 				while(fNewFullAngle >= 3600.0)
//STRIP001 					fNewFullAngle -= 3600.0;
//STRIP001 
//STRIP001 				// to int and set
//STRIP001 				sal_Int32 nNewAngle = (sal_Int32)(fNewFullAngle + 0.5);
//STRIP001 				if(nNewAngle != rGOld.aGradient.GetAngle())
//STRIP001 					rG.aGradient.SetAngle(nNewAngle);
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case XGRAD_RADIAL :
//STRIP001 		case XGRAD_SQUARE :
//STRIP001 		{
//STRIP001 			if(!bMoveSingle || (bMoveSingle && !bMoveFirst))
//STRIP001 			{
//STRIP001 				Vector2D aOffset(aEndPos - aRect.TopLeft());
//STRIP001 				sal_Int32 nNewXOffset = (sal_Int32)(((aOffset.X() * 100.0) / (double)aRect.GetWidth()) + 0.5);
//STRIP001 				sal_Int32 nNewYOffset = (sal_Int32)(((aOffset.Y() * 100.0) / (double)aRect.GetHeight()) + 0.5);
//STRIP001 
//STRIP001 				// clip
//STRIP001 				if(nNewXOffset < 0)
//STRIP001 					nNewXOffset = 0;
//STRIP001 				if(nNewXOffset > 100)
//STRIP001 					nNewXOffset = 100;
//STRIP001 
//STRIP001 				if(nNewYOffset < 0)
//STRIP001 					nNewYOffset = 0;
//STRIP001 				if(nNewYOffset > 100)
//STRIP001 					nNewYOffset = 100;
//STRIP001 
//STRIP001 				rG.aGradient.SetXOffset((sal_uInt16)nNewXOffset);
//STRIP001 				rG.aGradient.SetYOffset((sal_uInt16)nNewYOffset);
//STRIP001 
//STRIP001 				aStartPos -= aOffset;
//STRIP001 				aEndPos -= aOffset;
//STRIP001 			}
//STRIP001 
//STRIP001 			if(!bMoveSingle || (bMoveSingle && bMoveFirst))
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aStartPos - aEndPos);
//STRIP001 				Vector2D aOldVec(aRect.BottomLeft() - aRect.TopLeft());
//STRIP001 				double fFullLen = aFullVec.GetLength();
//STRIP001 				double fOldLen = aOldVec.GetLength();
//STRIP001 				double fNewBorder = (fFullLen * 100.0) / fOldLen;
//STRIP001 				sal_Int32 nNewBorder = 100 - (sal_Int32)(fNewBorder + 0.5);
//STRIP001 
//STRIP001 				// clip
//STRIP001 				if(nNewBorder < 0)
//STRIP001 					nNewBorder = 0;
//STRIP001 				if(nNewBorder > 100)
//STRIP001 					nNewBorder = 100;
//STRIP001 
//STRIP001 				// set
//STRIP001 				if(nNewBorder != rG.aGradient.GetBorder())
//STRIP001 					rG.aGradient.SetBorder((sal_uInt16)nNewBorder);
//STRIP001 
//STRIP001 				// angle is not definitely necessary for these modes, but it makes
//STRIP001 				// controlling more fun for the user
//STRIP001 				aFullVec.Normalize();
//STRIP001 				double fNewFullAngle = atan2(aFullVec.Y(), aFullVec.X());
//STRIP001 				fNewFullAngle /= F_PI180;
//STRIP001 				fNewFullAngle *= -10.0;
//STRIP001 				fNewFullAngle += 900.0;
//STRIP001 
//STRIP001 				// clip
//STRIP001 				while(fNewFullAngle < 0.0)
//STRIP001 					fNewFullAngle += 3600.0;
//STRIP001 				while(fNewFullAngle >= 3600.0)
//STRIP001 					fNewFullAngle -= 3600.0;
//STRIP001 
//STRIP001 				// to int and set
//STRIP001 				sal_Int32 nNewAngle = (sal_Int32)(fNewFullAngle + 0.5);
//STRIP001 				if(nNewAngle != rGOld.aGradient.GetAngle())
//STRIP001 					rG.aGradient.SetAngle(nNewAngle);
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case XGRAD_ELLIPTICAL :
//STRIP001 		case XGRAD_RECT :
//STRIP001 		{
//STRIP001 			if(!bMoveSingle || (bMoveSingle && !bMoveFirst))
//STRIP001 			{
//STRIP001 				Vector2D aOffset(aEndPos - aRect.TopLeft());
//STRIP001 				sal_Int32  nNewXOffset = (sal_Int32)(((aOffset.X() * 100.0) / (double)aRect.GetWidth()) + 0.5);
//STRIP001 				sal_Int32  nNewYOffset = (sal_Int32)(((aOffset.Y() * 100.0) / (double)aRect.GetHeight()) + 0.5);
//STRIP001 
//STRIP001 				// clip
//STRIP001 				if(nNewXOffset < 0)
//STRIP001 					nNewXOffset = 0;
//STRIP001 				if(nNewXOffset > 100)
//STRIP001 					nNewXOffset = 100;
//STRIP001 
//STRIP001 				if(nNewYOffset < 0)
//STRIP001 					nNewYOffset = 0;
//STRIP001 				if(nNewYOffset > 100)
//STRIP001 					nNewYOffset = 100;
//STRIP001 
//STRIP001 				rG.aGradient.SetXOffset((sal_uInt16)nNewXOffset);
//STRIP001 				rG.aGradient.SetYOffset((sal_uInt16)nNewYOffset);
//STRIP001 
//STRIP001 				aStartPos -= aOffset;
//STRIP001 				aEndPos -= aOffset;
//STRIP001 			}
//STRIP001 
//STRIP001 			if(!bMoveSingle || (bMoveSingle && bMoveFirst))
//STRIP001 			{
//STRIP001 				Vector2D aFullVec(aStartPos - aEndPos);
//STRIP001 				Vector2D aOldVec(Vector2D(aRect.Left(), aCenter.Y()) - aRect.TopLeft());
//STRIP001 				double fFullLen = aFullVec.GetLength();
//STRIP001 				double fOldLen = aOldVec.GetLength();
//STRIP001 				double fNewBorder = (fFullLen * 100.0) / fOldLen;
//STRIP001 				sal_Int32 nNewBorder = 100 - (sal_Int32)(fNewBorder + 0.5);
//STRIP001 
//STRIP001 				// clip
//STRIP001 				if(nNewBorder < 0)
//STRIP001 					nNewBorder = 0;
//STRIP001 				if(nNewBorder > 100)
//STRIP001 					nNewBorder = 100;
//STRIP001 
//STRIP001 				// set
//STRIP001 				if(nNewBorder != rG.aGradient.GetBorder())
//STRIP001 					rG.aGradient.SetBorder((sal_uInt16)nNewBorder);
//STRIP001 
//STRIP001 				// angle is not definitely necessary for these modes, but it makes
//STRIP001 				// controlling more fun for the user
//STRIP001 				aFullVec.Normalize();
//STRIP001 				double fNewFullAngle = atan2(aFullVec.Y(), aFullVec.X());
//STRIP001 				fNewFullAngle /= F_PI180;
//STRIP001 				fNewFullAngle *= -10.0;
//STRIP001 				fNewFullAngle += 900.0;
//STRIP001 
//STRIP001 				// clip
//STRIP001 				while(fNewFullAngle < 0.0)
//STRIP001 					fNewFullAngle += 3600.0;
//STRIP001 				while(fNewFullAngle >= 3600.0)
//STRIP001 					fNewFullAngle -= 3600.0;
//STRIP001 
//STRIP001 				// to int and set
//STRIP001 				sal_Int32 nNewAngle = (sal_Int32)(fNewFullAngle + 0.5);
//STRIP001 				if(nNewAngle != rGOld.aGradient.GetAngle())
//STRIP001 					rG.aGradient.SetAngle(nNewAngle);
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//////////////////////////////////////////////////////////////////////////////
/*
void GradTransformer::CreateRotatedBoundRect(double fDegree)
{
	// create back-rotated BoundRect to get the vector length
	Vector2D aMid(aCenter);
	Matrix3D aTrans;
	Rectangle aNewRect;

	aTrans.Translate(-aMid);
	aTrans.Rotate(fDegree);
	aTrans.Translate(aMid);
	
	Vector2D aNew(aBoundRect.TopLeft());
	aNew *= aTrans;
	Point aNewTrans((INT32)(aNew.X() + 0.5), (INT32)(aNew.Y() + 0.5));
	aNewRect.Union(Rectangle(aNewTrans, aNewTrans));
	
	aNew = Vector2D(aBoundRect.TopRight());
	aNew *= aTrans;
	aNewTrans = Point((INT32)(aNew.X() + 0.5), (INT32)(aNew.Y() + 0.5));
	aNewRect.Union(Rectangle(aNewTrans, aNewTrans));
	
	aNew = Vector2D(aBoundRect.BottomLeft());
	aNew *= aTrans;
	aNewTrans = Point((INT32)(aNew.X() + 0.5), (INT32)(aNew.Y() + 0.5));
	aNewRect.Union(Rectangle(aNewTrans, aNewTrans));
	
	aNew = Vector2D(aBoundRect.BottomRight());
	aNew *= aTrans;
	aNewTrans = Point((INT32)(aNew.X() + 0.5), (INT32)(aNew.Y() + 0.5));
	aNewRect.Union(Rectangle(aNewTrans, aNewTrans));

	aBoundRect = aNewRect;
	aCenter = aBoundRect.Center();
}

//
// gradient to vector representation
//

void GradTransformer::GradToVec(GradTransGradient& rG, GradTransVector& rV, const SdrObject* pObj)
{
	// calc colors and set them
	rV.aCol1 = rG.aGradient.GetStartColor();
	rV.aCol2 = rG.aGradient.GetEndColor();

	if(rG.aGradient.GetStartIntens() != 100)
	{
		double fFact = (double)rG.aGradient.GetStartIntens() / 100.0;
		rV.aCol1 = (B3dColor)rV.aCol1 * fFact;
	}

	if(rG.aGradient.GetEndIntens() != 100)
	{
		double fFact = (double)rG.aGradient.GetEndIntens() / 100.0;
		rV.aCol2 = (B3dColor)rV.aCol2 * fFact;
	}

	// now calc the positions for the color handles
	aBoundRect = pObj->GetBoundRect();
	aCenter = aBoundRect.Center();
	fObjectAngle = 0.0;
	fGradientAngle = 0.0;

	// gradient rotates with the object (!!!)
	if(pObj->GetRotateAngle()) 
		fObjectAngle = (double)(pObj->GetRotateAngle() / 100) * F_PI180;

	// get gradient angle
	if(rG.aGradient.GetAngle())
		fGradientAngle = (double)rG.aGradient.GetAngle() * (F_PI180 / 10.0);

	// correct object and gradient rotation for object boundrect
	if(fGradientAngle || fObjectAngle)
		CreateRotatedBoundRect(fGradientAngle + fObjectAngle);

	// build the in-between vector (top-down)
	bInnerOuterChanged = FALSE;
	bDoCorrectOffset = FALSE;

	switch(rG.aGradient.GetGradientStyle())
	{
		case XGRAD_LINEAR :
		{
			// vector from top to bottom
			aStartPos = Vector2D(aCenter.X(), aBoundRect.Top());
			aEndPos = Vector2D(aCenter.X(), aBoundRect.Bottom());
			aCenterPos = Vector2D(aCenter);
			break;
		}
		case XGRAD_AXIAL :
		{
			// mirrored in center; set starpos, endpos from center to bottom
			aStartPos = Vector2D(aCenter);
			aEndPos = Vector2D(aCenter.X(), aBoundRect.Bottom());
			aCenterPos = Vector2D(aCenter);

			// here the border correction is vice-versa to the others
			bInnerOuterChanged = TRUE;

			break;
		}
		case XGRAD_RADIAL :
		case XGRAD_SQUARE :
		{
			// from bottom to center
			aStartPos = Vector2D(aBoundRect.BottomLeft());
			aEndPos = Vector2D(aBoundRect.TopLeft());
			aCenterPos = aEndPos;
			bDoCorrectOffset = TRUE;
			break;
		}
		case XGRAD_ELLIPTICAL :
		case XGRAD_RECT :
		{
			// from bottom to center
			aStartPos = Vector2D(aBoundRect.Left(), aBoundRect.Center().Y());
			aEndPos = Vector2D(aBoundRect.TopLeft());
			aCenterPos = aEndPos;
			bDoCorrectOffset = TRUE;
			break;
		}
	}

	// take in account border settings, this moves the start point
	if(rG.aGradient.GetBorder())
	{
		Vector2D aFullVec;

		if(bInnerOuterChanged)
			aFullVec = aEndPos - aStartPos;
		else
			aFullVec = aStartPos - aEndPos;

		double fLen = (aFullVec.GetLength() * (100.0 - (double)rG.aGradient.GetBorder())) / 100.0;
		aFullVec.Normalize();
		aFullVec *= fLen;

		if(bInnerOuterChanged)
			aEndPos = aStartPos + aFullVec;
		else
			aStartPos = aEndPos + aFullVec;
	}

	// take offset in account
	if(bDoCorrectOffset)
	{
		if(rG.aGradient.GetXOffset() || rG.aGradient.GetYOffset())
		{
			// get scaling factors (with and without gradient rotation),
			// center is the same
			Rectangle aObjectBoundRect = pObj->GetBoundRect();
			Vector2D aScale;
			aScale.X() = ((double)aBoundRect.GetWidth() + 1.0) / ((double)aObjectBoundRect.GetWidth() + 1.0);
			aScale.Y() = ((double)aBoundRect.GetHeight() + 1.0) / ((double)aObjectBoundRect.GetHeight() + 1.0);
			
			// calc transformation from gradient system to object system
			Matrix3D aTrans;
			Vector2D aObjectCenter = Vector2D(aBoundRect.Center());
			aTrans.Translate(-aObjectCenter);
			aTrans.Scale(aScale);
			aTrans.Rotate(-fObjectAngle);
			aTrans.Translate(aObjectCenter);
			
			// define coordinate system on top of ObjectBoundRect
			Vector2D aAxisCenter(aObjectBoundRect.TopLeft());
			Vector2D aXAxis(aObjectBoundRect.TopRight());
			Vector2D aYAxis(aObjectBoundRect.BottomLeft());
			
			// transform all to object system
			aAxisCenter *= aTrans;
			aXAxis *= aTrans;
			aYAxis *= aTrans;
			aXAxis -= aAxisCenter;
			aYAxis -= aAxisCenter;

			Vector2D aCorrectionVector(0,0);

			if(rG.aGradient.GetXOffset())
				aCorrectionVector += aXAxis * (((double)rG.aGradient.GetXOffset()) / 100.0);

			if(rG.aGradient.GetYOffset())
				aCorrectionVector += aYAxis * (((double)rG.aGradient.GetYOffset()) / 100.0);

			aStartPos += aCorrectionVector;
			aEndPos += aCorrectionVector;
			aCenterPos += aCorrectionVector;
		}
	}

	// rotate around fObjectAngle, go to rotated object coordinates
	if(fObjectAngle || fGradientAngle)
	{
		Matrix3D aTrans;

		aTrans.Translate(-aCenterPos);
		aTrans.Rotate(-(fObjectAngle + fGradientAngle));
		aTrans.Translate(aCenterPos);

		aStartPos *= aTrans;
		aEndPos *= aTrans;
	}

	// set values for vector positions now
	rV.aPos1 = Point((INT32)(aStartPos.X() + 0.5), (INT32)(aStartPos.Y() + 0.5));
	rV.aPos2 = Point((INT32)(aEndPos.X() + 0.5), (INT32)(aEndPos.Y() + 0.5));
}

//
// vector to gradient representation
//

void GradTransformer::VecToGrad(GradTransVector& rV, GradTransGradient& rG, GradTransGradient& rGOld, const SdrObject* pObj, BOOL bMoveSingle, BOOL bMoveFirst)
{
	// copy old item to new item to have a valid base
	rG = rGOld;

	// on this base, create aVOld to have the previous values
	// use full vector here (but rescue OldBorder)
	GradTransVector aVOld;
	UINT16 nOldBorder = rGOld.aGradient.GetBorder();
	rGOld.aGradient.SetBorder(0);
	GradToVec(rGOld, aVOld, pObj);
	rGOld.aGradient.SetBorder(nOldBorder);

	// color changes?
	if(rV.aCol1 != rGOld.aGradient.GetStartColor())
	{
		rG.aGradient.SetStartColor(rV.aCol1);
		rG.aGradient.SetStartIntens(100);
	}

	if(rV.aCol2 != rGOld.aGradient.GetEndColor())
	{
		rG.aGradient.SetEndColor(rV.aCol2);
		rG.aGradient.SetEndIntens(100);
	}

	// back-rotate around aCenterPos with fGradientAngle and fObjectAngle
	// to have the same conditions as above
	aStartPos = Vector2D(rV.aPos1);
	aEndPos = Vector2D(rV.aPos2);

	// which points were moved? What needs to be done?
	BOOL bRotAngleCheck(FALSE);
	BOOL bCenterMoveCheck(FALSE);
	BOOL bBorderMoveCheck(FALSE);
	BOOL bRotAngleInvert(FALSE);

	switch(rGOld.aGradient.GetGradientStyle())
	{
		case XGRAD_LINEAR :
		{
			bRotAngleCheck = bMoveSingle && !bMoveFirst;
			bBorderMoveCheck = bMoveSingle && bMoveFirst;
			break;
		}
		case XGRAD_AXIAL :
		{
			bRotAngleCheck = bMoveSingle && !bMoveFirst;
			bBorderMoveCheck = bMoveSingle && !bMoveFirst;
			break;
		}
		case XGRAD_RADIAL :
		case XGRAD_SQUARE :
		{
			bBorderMoveCheck = bMoveSingle && bMoveFirst;
			bCenterMoveCheck = (bMoveSingle && !bMoveFirst) || !bMoveSingle;
			break;
		}
		case XGRAD_ELLIPTICAL :
		case XGRAD_RECT :
		{
			bRotAngleCheck = bMoveSingle && bMoveFirst;
			bBorderMoveCheck = bMoveSingle && bMoveFirst;
			bCenterMoveCheck = (bMoveSingle && !bMoveFirst) || !bMoveSingle;
			bRotAngleInvert = TRUE;
			break;
		}
	}

	// check for rotation angle change
	if(bRotAngleCheck)
	{
		Vector2D aNewFullVec(aEndPos - aStartPos);
		aNewFullVec.Normalize();

		if(bRotAngleInvert)
			aNewFullVec = -aNewFullVec;

		double fNewFullAngle = atan2(aNewFullVec.Y(), aNewFullVec.X());
		fNewFullAngle /= F_PI180;
		fNewFullAngle *= -10.0;
		fNewFullAngle += 900.0;

		// correct object rotation
		INT32 nObjRotateAngle = pObj->GetRotateAngle();
		if(nObjRotateAngle) 
			fNewFullAngle -= (double)(nObjRotateAngle / 10);

		while(fNewFullAngle < 0.0)
			fNewFullAngle += 3600.0;

		while(fNewFullAngle >= 3600.0)
			fNewFullAngle -= 3600.0;

		INT32 nNewAngle = (INT32)(fNewFullAngle + 0.5);

		if(nNewAngle != rGOld.aGradient.GetAngle())
			rG.aGradient.SetAngle(nNewAngle);
	}

	// check for border, move of the outer pixel
	if(bBorderMoveCheck)
	{
		Vector2D aNewFullVec(aEndPos - aStartPos);
		Vector2D aOldFullVec(Vector2D(aVOld.aPos2) - Vector2D(aVOld.aPos1));
		double fNewFullLen = aNewFullVec.GetLength();
		double fOldFullLen = aOldFullVec.GetLength();

		double fNewBorder = (fNewFullLen * 100.0) / fOldFullLen;
		INT32 nNewBorder = 100 - (INT32)(fNewBorder + 0.5);

		if(nNewBorder < 0)
			nNewBorder = 0;

		if(nNewBorder > 100)
			nNewBorder = 100;

		if(nNewBorder != rG.aGradient.GetBorder())
		{
			rG.aGradient.SetBorder((UINT16)nNewBorder);
		}
	}

	// move center if allowed, move of the inner pixel
	if(bCenterMoveCheck)
	{
		// get scaling factors (with and without gradient rotation),
		// center is the same
		Rectangle aObjectBoundRect = pObj->GetBoundRect();
		Vector2D aScale;
		aScale.X() = ((double)aBoundRect.GetWidth() + 1.0) / ((double)aObjectBoundRect.GetWidth() + 1.0);
		aScale.Y() = ((double)aBoundRect.GetHeight() + 1.0) / ((double)aObjectBoundRect.GetHeight() + 1.0);
		
		// calc transformation from this system to gradient system
		Matrix3D aTrans;
		Vector2D aObjectCenter = Vector2D(aBoundRect.Center());
		aTrans.Translate(-aObjectCenter);
		aTrans.Scale(aScale);
		aTrans.Rotate(-fObjectAngle);
		aTrans.Translate(aObjectCenter);
		
		// define coordinate system on top of ObjectBoundRect
		Vector2D aAxisCenter(aObjectBoundRect.TopLeft());
		Vector2D aXAxis(aObjectBoundRect.TopRight());
		Vector2D aYAxis(aObjectBoundRect.BottomLeft());
		
		// transform all to gradient system
		aAxisCenter *= aTrans;
		aXAxis *= aTrans;
		aYAxis *= aTrans;
		aXAxis -= aAxisCenter;
		aYAxis -= aAxisCenter;

		// build the normalized coordinate system
		double fXAxisLen = aXAxis.GetLength();
		double fYAxisLen = aYAxis.GetLength();
		aXAxis.Normalize();
		aYAxis.Normalize();

		// calc part of new position in coordinate system
		Vector2D aNewPos(aEndPos - aAxisCenter);
		double fNewXAxisPart = aXAxis.Scalar(aNewPos);
		double fNewYAxisPart = aYAxis.Scalar(aNewPos);
		fNewXAxisPart = (fNewXAxisPart * 100.0) / fXAxisLen;
		fNewYAxisPart = (fNewYAxisPart * 100.0) / fYAxisLen;
		INT32 nNewX = (INT32)(fNewXAxisPart + 0.5);
		INT32 nNewY = (INT32)(fNewYAxisPart + 0.5);

		if(nNewX < 0)
			nNewX = 0;
		
		if(nNewX > 100)
			nNewX = 100;

		if(nNewY < 0)
			nNewY = 0;
		
		if(nNewY > 100)
			nNewY = 100;

		if(rGOld.aGradient.GetXOffset() != (UINT16)nNewX 
			|| rGOld.aGradient.GetYOffset() != (UINT16)nNewY)
		{
			rG.aGradient.SetXOffset((UINT16)nNewX);
			rG.aGradient.SetYOffset((UINT16)nNewY);
		}
	}
}

*/
}
