/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_itemwin.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:15:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWSH_HXX
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXMODULE_HXX
// auto strip #include <bf_sfx2/module.hxx>
// auto strip #endif
#pragma hdrstop

#define _SVX_ITEMWIN_CXX

#include "dialogs.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_DASH_LIST		SID_DASH_LIST

#define DELAY_TIMEOUT			100

// auto strip #include "xlnclit.hxx"
// auto strip #include "xlnwtit.hxx"
// auto strip #include "xlineit0.hxx"
// auto strip #include "xlndsit.hxx"
#include "xtable.hxx"
// auto strip #include "drawitem.hxx"
// auto strip #include "dialmgr.hxx"
// auto strip #include "dlgutil.hxx"
// auto strip #include "itemwin.hxx"
// auto strip #include "linectrl.hxx"
// auto strip #ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
// auto strip #include <svtools/colorcfg.hxx>
// auto strip #endif

#include "linectrl.hrc"
namespace binfilter {

#define LOGICAL_EDIT_HEIGHT         12
//========================================================================
// SvxLineBox
//========================================================================

//STRIP001 SvxLineBox::SvxLineBox( Window* pParent, SfxBindings& rBind, WinBits nBits ) :
//STRIP001 
//STRIP001 	LineLB( pParent, nBits ),
//STRIP001     aLogicalSize(40,140),
//STRIP001 	nCurPos		( 0 ),
//STRIP001     rBindings   ( rBind ),
//STRIP001     bRelease    ( TRUE ),
//STRIP001 	mpSh		( NULL ),
//STRIP001 	meBmpMode	( GetDisplayBackground().GetColor().IsDark() ? BMP_COLOR_HIGHCONTRAST : BMP_COLOR_NORMAL )
//STRIP001 {
//STRIP001     SetSizePixel( LogicToPixel( aLogicalSize, MAP_APPFONT ));
//STRIP001     Show();
//STRIP001 
//STRIP001 	aDelayTimer.SetTimeout( DELAY_TIMEOUT );
//STRIP001 	aDelayTimer.SetTimeoutHdl( LINK( this, SvxLineBox, DelayHdl_Impl ) );
//STRIP001 	aDelayTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxLineBox::~SvxLineBox()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLineBox, DelayHdl_Impl, Timer *, pTimer )
//STRIP001 {
//STRIP001 	if ( GetEntryCount() == 0 )
//STRIP001 	{
//STRIP001 		mpSh = SfxObjectShell::Current();
//STRIP001 		FillControl();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineBox::Select()
//STRIP001 {
//STRIP001     // Call the parent's Select() member to trigger accessibility events.
//STRIP001     LineLB::Select();
//STRIP001 
//STRIP001 	if ( !IsTravelSelect() )
//STRIP001 	{
//STRIP001 		XLineStyle eXLS;
//STRIP001 		USHORT nPos = GetSelectEntryPos();
//STRIP001 		SfxDispatcher* pDisp = rBindings.GetDispatcher();
//STRIP001 		DBG_ASSERT( pDisp, "invalid Dispatcher" );
//STRIP001 
//STRIP001 		switch ( nPos )
//STRIP001 		{
//STRIP001 			case 0:
//STRIP001 				eXLS = XLINE_NONE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case 1:
//STRIP001 				eXLS = XLINE_SOLID;
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			{
//STRIP001 				eXLS = XLINE_DASH;
//STRIP001 
//STRIP001 				if ( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001 					 SfxObjectShell::Current()	&&
//STRIP001 					 SfxObjectShell::Current()->GetItem( SID_DASH_LIST ) )
//STRIP001 				{
//STRIP001 					// LineDashItem wird nur geschickt, wenn es auch einen Dash besitzt.
//STRIP001 					// Notify k"ummert sich darum!
//STRIP001 					SvxDashListItem aItem( *(const SvxDashListItem*)(
//STRIP001 						SfxObjectShell::Current()->GetItem( SID_DASH_LIST ) ) );
//STRIP001 					XLineDashItem aLineDashItem( GetSelectEntry(),
//STRIP001 						aItem.GetDashList()->Get( nPos - 2 )->GetDash() );
//STRIP001 					pDisp->Execute( SID_ATTR_LINE_DASH, SFX_CALLMODE_RECORD, &aLineDashItem, 0L );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		XLineStyleItem aLineStyleItem( eXLS );
//STRIP001 		pDisp->Execute( SID_ATTR_LINE_STYLE, SFX_CALLMODE_RECORD, &aLineStyleItem, 0L );
//STRIP001 		ReleaseFocus_Impl();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxLineBox::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 
//STRIP001     switch(nType)
//STRIP001     {
//STRIP001         case EVENT_MOUSEBUTTONDOWN:
//STRIP001         case EVENT_GETFOCUS:
//STRIP001             nCurPos = GetSelectEntryPos();
//STRIP001         break;
//STRIP001         case EVENT_LOSEFOCUS:
//STRIP001             SelectEntryPos(nCurPos);
//STRIP001         break;
//STRIP001         case EVENT_KEYINPUT:
//STRIP001         {
//STRIP001             const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001             if( pKEvt->GetKeyCode().GetCode() == KEY_TAB)
//STRIP001             {
//STRIP001                 bRelease = FALSE;
//STRIP001                 Select();
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001     }
//STRIP001 	return LineLB::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxLineBox::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = LineLB::Notify( rNEvt );
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 
//STRIP001 		switch ( pKEvt->GetKeyCode().GetCode() )
//STRIP001 		{
//STRIP001 			case KEY_RETURN:
//STRIP001 				Select();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KEY_ESCAPE:
//STRIP001 				SelectEntryPos( nCurPos );
//STRIP001 				ReleaseFocus_Impl();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001         }
//STRIP001 	}
//STRIP001 	return nHandled;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineBox::ReleaseFocus_Impl()
//STRIP001 {
//STRIP001     if(!bRelease)
//STRIP001     {
//STRIP001         bRelease = TRUE;
//STRIP001         return;
//STRIP001     }
//STRIP001     Window* pShellWnd = SfxViewShell::Current()->GetWindow();
//STRIP001 
//STRIP001 	if ( pShellWnd )
//STRIP001 		pShellWnd->GrabFocus();
//STRIP001 }
//STRIP001 /* -----------------------------08.03.2002 15:39------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxLineBox::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         SetSizePixel(LogicToPixel(aLogicalSize, MAP_APPFONT));
//STRIP001         Size aDropSize( aLogicalSize.Width(), LOGICAL_EDIT_HEIGHT);
//STRIP001         SetDropDownSizePixel(LogicToPixel(aDropSize, MAP_APPFONT));
//STRIP001    }
//STRIP001 
//STRIP001     LineLB::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001 		BmpColorMode eMode = GetDisplayBackground().GetColor().IsDark() ? BMP_COLOR_HIGHCONTRAST : BMP_COLOR_NORMAL;
//STRIP001 		if( eMode != meBmpMode )
//STRIP001 		{
//STRIP001 			meBmpMode = eMode;
//STRIP001 			FillControl();
//STRIP001 		}
//STRIP001  	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLineBox::FillControl()
//STRIP001 {
//STRIP001 	Clear();
//STRIP001 
//STRIP001 	InsertEntry( SVX_RESSTR(RID_SVXSTR_INVISIBLE) );
//STRIP001 
//STRIP001 	Bitmap aBitmap ( SVX_RES ( RID_SVXCTRL_LINECTRL ) );
//STRIP001 
//STRIP001 	Color aSourceColors[2];
//STRIP001 	Color aDestColors[2];
//STRIP001 
//STRIP001 	aSourceColors[0] = Color( COL_WHITE );
//STRIP001 	aSourceColors[1] = Color( COL_BLACK );
//STRIP001 
//STRIP001 	const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 	aDestColors[0] = rStyles.GetFieldColor();
//STRIP001 	aDestColors[1] = rStyles.GetFieldTextColor();
//STRIP001 
//STRIP001 	aBitmap.Replace ( aSourceColors, aDestColors, 2 );
//STRIP001 	Image aSolidLine ( aBitmap );
//STRIP001 	InsertEntry( SVX_RESSTR(RID_SVXSTR_SOLID), aSolidLine );
//STRIP001 
//STRIP001 	if( mpSh )
//STRIP001 	{
//STRIP001 		const SvxDashListItem* pItem = (const SvxDashListItem*)( mpSh->GetItem( SID_DASH_LIST ) );
//STRIP001 		if ( pItem )
//STRIP001 			Fill( pItem->GetDashList() );
//STRIP001 	}
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_ATTR_LINE_DASH );
//STRIP001 }
//STRIP001 //========================================================================
//STRIP001 // SvxColorBox
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SvxColorBox::SvxColorBox( Window* pParent, USHORT nSID, SfxBindings& rBind, WinBits nBits ) :
//STRIP001 
//STRIP001 	ColorLB( pParent, nBits ),
//STRIP001     aLogicalSize(45,80),
//STRIP001 	nCurPos		( 0 ),
//STRIP001 	nId			( nSID ),
//STRIP001     rBindings   ( rBind ),
//STRIP001     bRelease    ( TRUE )
//STRIP001 
//STRIP001 {
//STRIP001     SetSizePixel( LogicToPixel( aLogicalSize , MAP_APPFONT));
//STRIP001     Show();
//STRIP001 
//STRIP001     SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 
//STRIP001 	if ( pSh )
//STRIP001 	{
//STRIP001 		const SvxColorTableItem* pItem =
//STRIP001 			(const SvxColorTableItem*)(	pSh->GetItem( SID_COLOR_TABLE ) );
//STRIP001 		if(pItem)
//STRIP001 			Fill( pItem->GetColorTable() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxColorBox, DelayHdl_Impl, Timer *, pTimer )
//STRIP001 {
//STRIP001 	SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 
//STRIP001 	if ( pSh )
//STRIP001 	{
//STRIP001 		const SvxColorTableItem* pItem = (const SvxColorTableItem*)( pSh->GetItem( SID_COLOR_TABLE ) );
//STRIP001 		if ( pItem )
//STRIP001 			Fill( pItem->GetColorTable() );
//STRIP001 		rBindings.Invalidate( nId );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxColorBox::~SvxColorBox()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorBox::Update( const XLineColorItem* pItem )
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 		SelectEntry( pItem->GetValue() );
//STRIP001 	else
//STRIP001 		SetNoSelection();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorBox::Select()
//STRIP001 {
//STRIP001 	// OJ: base class call needed here because otherwise no event is send for accessibility
//STRIP001 	ColorLB::Select();
//STRIP001 	if ( !IsTravelSelect() )
//STRIP001 	{
//STRIP001 		XLineColorItem aLineColorItem( GetSelectEntry(), GetSelectEntryColor() );
//STRIP001 		rBindings.GetDispatcher()->Execute( nId, SFX_CALLMODE_RECORD, &aLineColorItem, 0L );
//STRIP001 		nCurPos = GetSelectEntryPos();
//STRIP001 		ReleaseFocus_Impl();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxColorBox::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 
//STRIP001     switch(nType)
//STRIP001     {
//STRIP001         case  EVENT_MOUSEBUTTONDOWN:
//STRIP001         case EVENT_GETFOCUS:
//STRIP001             nCurPos = GetSelectEntryPos();
//STRIP001         break;
//STRIP001         case EVENT_LOSEFOCUS:
//STRIP001             SelectEntryPos(nCurPos);
//STRIP001         break;
//STRIP001         case EVENT_KEYINPUT:
//STRIP001         {
//STRIP001             const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 
//STRIP001             if( pKEvt->GetKeyCode().GetCode() == KEY_TAB)
//STRIP001             {
//STRIP001                 bRelease = FALSE;
//STRIP001                 Select();
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	return ColorLB::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxColorBox::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = ColorLB::Notify( rNEvt );
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 
//STRIP001 		switch ( pKEvt->GetKeyCode().GetCode() )
//STRIP001 		{
//STRIP001 			case KEY_RETURN:
//STRIP001 				Select();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KEY_ESCAPE:
//STRIP001 				SelectEntryPos( nCurPos );
//STRIP001 				ReleaseFocus_Impl();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001         }
//STRIP001 	}
//STRIP001 	return nHandled;
//STRIP001 }
//STRIP001 /* -----------------------------08.03.2002 15:35------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxColorBox::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         SetSizePixel(LogicToPixel(aLogicalSize, MAP_APPFONT));
//STRIP001         Size aDropSize( aLogicalSize.Width(), LOGICAL_EDIT_HEIGHT);
//STRIP001         SetDropDownSizePixel(LogicToPixel(aDropSize, MAP_APPFONT));
//STRIP001     }
//STRIP001 
//STRIP001     ColorLB::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorBox::ReleaseFocus_Impl()
//STRIP001 {
//STRIP001     if(!bRelease)
//STRIP001     {
//STRIP001         bRelease = TRUE;
//STRIP001         return;
//STRIP001     }
//STRIP001     Window* pShellWnd = SfxViewShell::Current()->GetWindow();
//STRIP001 
//STRIP001 	if ( pShellWnd )
//STRIP001 		pShellWnd->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // SvxMetricField
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SvxMetricField::SvxMetricField( Window* pParent, SfxBindings& rBind, WinBits nBits ) :
//STRIP001 
//STRIP001 	MetricField( pParent, nBits ),
//STRIP001 	aCurTxt		( String() ),
//STRIP001 	rBindings	( rBind )
//STRIP001 
//STRIP001 {
//STRIP001 	Size aSize = Size(GetTextWidth( String::CreateFromAscii("99,99mm") ),GetTextHeight());
//STRIP001 	aSize.Width() += 20;
//STRIP001 #ifndef MAC
//STRIP001 	aSize.Height() += 6;
//STRIP001 #else
//STRIP001 	aSize.Height() += 5;
//STRIP001 #endif
//STRIP001 	SetSizePixel( aSize );
//STRIP001     aLogicalSize = PixelToLogic(aSize, MAP_APPFONT);
//STRIP001 	SetUnit( FUNIT_MM );
//STRIP001 	SetDecimalDigits( 2 );
//STRIP001 	SetMax( 5000 );
//STRIP001 	SetMin( 0 );
//STRIP001 	SetLast( 5000 );
//STRIP001 	SetFirst( 0 );
//STRIP001 
//STRIP001 	eDlgUnit = GetModuleFieldUnit( NULL );
//STRIP001 	SetFieldUnit( *this, eDlgUnit, FALSE );
//STRIP001 	Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxMetricField::~SvxMetricField()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxMetricField::Update( const XLineWidthItem* pItem )
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		if ( pItem->GetValue() != GetCoreValue( *this, ePoolUnit ) )
//STRIP001 			SetMetricValue( *this, pItem->GetValue(), ePoolUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetText( String() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxMetricField::Modify()
//STRIP001 {
//STRIP001 	MetricField::Modify();
//STRIP001 	long nTmp = GetCoreValue( *this, ePoolUnit );
//STRIP001 	XLineWidthItem aLineWidthItem( nTmp );
//STRIP001 	rBindings.GetDispatcher()->Execute( SID_ATTR_LINE_WIDTH, SFX_CALLMODE_RECORD, &aLineWidthItem, 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxMetricField::ReleaseFocus_Impl()
//STRIP001 {
//STRIP001 	Window* pShellWnd = SfxViewShell::Current()->GetWindow();
//STRIP001 	if ( pShellWnd )
//STRIP001 		pShellWnd->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxMetricField::Down()
//STRIP001 {
//STRIP001 	long nValue = GetValue();
//STRIP001 	nValue -= GetSpinSize();
//STRIP001 
//STRIP001 	// Um unter OS/2 einen Sprung auf Max zu verhindern
//STRIP001 	if ( nValue >= GetMin() )
//STRIP001 		MetricField::Down();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxMetricField::Up()
//STRIP001 {
//STRIP001 	MetricField::Up();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxMetricField::SetCoreUnit( SfxMapUnit eUnit )
//STRIP001 {
//STRIP001 	ePoolUnit = eUnit;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxMetricField::RefreshDlgUnit()
//STRIP001 {
//STRIP001 	FieldUnit eTmpUnit = GetModuleFieldUnit( NULL );
//STRIP001 
//STRIP001 	if ( eDlgUnit != eTmpUnit )
//STRIP001 	{
//STRIP001 		eDlgUnit = eTmpUnit;
//STRIP001 		SetFieldUnit( *this, eDlgUnit, FALSE );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxMetricField::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 
//STRIP001 	if ( EVENT_MOUSEBUTTONDOWN == nType || EVENT_GETFOCUS == nType )
//STRIP001 		aCurTxt = GetText();
//STRIP001 
//STRIP001 	return MetricField::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxMetricField::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = MetricField::Notify( rNEvt );
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 		const KeyCode& rKey = pKEvt->GetKeyCode();
//STRIP001 		SfxViewShell* pSh = SfxViewShell::Current();
//STRIP001 
//STRIP001 		if ( rKey.GetModifier() && rKey.GetGroup() != KEYGROUP_CURSOR && pSh )
//STRIP001 			pSh->KeyInput( *pKEvt );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			FASTBOOL bHandled = FALSE;
//STRIP001 
//STRIP001 			switch ( rKey.GetCode() )
//STRIP001 			{
//STRIP001 				case KEY_RETURN:
//STRIP001 					Reformat();
//STRIP001 					bHandled = TRUE;
//STRIP001 					break;
//STRIP001 
//STRIP001 				case KEY_ESCAPE:
//STRIP001 					SetText( aCurTxt );
//STRIP001 					bHandled = TRUE;
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bHandled )
//STRIP001 			{
//STRIP001 				nHandled = 1;
//STRIP001 				Modify();
//STRIP001 				ReleaseFocus_Impl();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nHandled;
//STRIP001 }
//STRIP001 /* -----------------------------08.03.2002 15:32------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxMetricField::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         SetSizePixel(LogicToPixel(aLogicalSize, MAP_APPFONT));
//STRIP001     }
//STRIP001 
//STRIP001     MetricField::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // SvxFillTypeBox
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SvxFillTypeBox::SvxFillTypeBox( Window* pParent, WinBits nBits ) :
//STRIP001 
//STRIP001 	FillTypeLB( pParent, nBits | WB_TABSTOP ),
//STRIP001 
//STRIP001 	nCurPos	( 0 ),
//STRIP001     bSelect ( FALSE ),
//STRIP001     bRelease(TRUE)
//STRIP001 
//STRIP001 {
//STRIP001     SetSizePixel( LogicToPixel( Size(40, 40 ),MAP_APPFONT ));
//STRIP001     Fill();
//STRIP001 	SelectEntryPos( XFILL_SOLID );
//STRIP001 	Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxFillTypeBox::~SvxFillTypeBox()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxFillTypeBox::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 
//STRIP001 	if ( EVENT_MOUSEBUTTONDOWN == nType || EVENT_GETFOCUS == nType )
//STRIP001 		nCurPos = GetSelectEntryPos();
//STRIP001 	else if ( EVENT_LOSEFOCUS == nType
//STRIP001 		&& Application::GetFocusWindow()
//STRIP001 		&& !IsWindowOrChild( Application::GetFocusWindow(), TRUE ) )
//STRIP001 	{
//STRIP001 		if ( !bSelect )
//STRIP001 			SelectEntryPos( nCurPos );
//STRIP001 		else
//STRIP001 			bSelect = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FillTypeLB::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxFillTypeBox::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = FillTypeLB::Notify( rNEvt );
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 		switch ( pKEvt->GetKeyCode().GetCode() )
//STRIP001 		{
//STRIP001             case KEY_RETURN:
//STRIP001                 nHandled = 1;
//STRIP001                 ( (Link&)GetSelectHdl() ).Call( this );
//STRIP001             break;
//STRIP001             case KEY_TAB:
//STRIP001                 bRelease = FALSE;
//STRIP001                 ( (Link&)GetSelectHdl() ).Call( this );
//STRIP001                 bRelease = TRUE;
//STRIP001                 break;
//STRIP001 
//STRIP001 			case KEY_ESCAPE:
//STRIP001 				SelectEntryPos( nCurPos );
//STRIP001 				ReleaseFocus_Impl();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nHandled;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFillTypeBox::ReleaseFocus_Impl()
//STRIP001 {
//STRIP001 	Window* pShellWnd = SfxViewShell::Current()->GetWindow();
//STRIP001 
//STRIP001 	if ( pShellWnd )
//STRIP001 		pShellWnd->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // SvxFillAttrBox
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SvxFillAttrBox::SvxFillAttrBox( Window* pParent, WinBits nBits ) :
//STRIP001 
//STRIP001 	FillAttrLB( pParent, nBits | WB_TABSTOP ),
//STRIP001 
//STRIP001     nCurPos( 0 ),
//STRIP001     bRelease( TRUE )
//STRIP001 
//STRIP001 {
//STRIP001 	SetPosPixel( Point( 90, 0 ) );
//STRIP001     SetSizePixel( LogicToPixel( Size(50, 80 ), MAP_APPFONT ));
//STRIP001 	Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxFillAttrBox::~SvxFillAttrBox()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxFillAttrBox::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 
//STRIP001 	if ( EVENT_MOUSEBUTTONDOWN == nType || EVENT_GETFOCUS == nType )
//STRIP001 		nCurPos = GetSelectEntryPos();
//STRIP001 
//STRIP001 	return FillAttrLB::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SvxFillAttrBox::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = FillAttrLB::Notify( rNEvt );
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 
//STRIP001 		switch ( pKEvt->GetKeyCode().GetCode() )
//STRIP001 		{
//STRIP001 			case KEY_RETURN:
//STRIP001 				( (Link&)GetSelectHdl() ).Call( this );
//STRIP001 				nHandled = 1;
//STRIP001             break;
//STRIP001             case KEY_TAB:
//STRIP001                 bRelease = FALSE;
//STRIP001                 GetSelectHdl().Call( this );
//STRIP001                 bRelease = TRUE;
//STRIP001             break;
//STRIP001 			case KEY_ESCAPE:
//STRIP001 				SelectEntryPos( nCurPos );
//STRIP001 				ReleaseFocus_Impl();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nHandled;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFillAttrBox::Select()
//STRIP001 {
//STRIP001 	FillAttrLB::Select();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFillAttrBox::ReleaseFocus_Impl()
//STRIP001 {
//STRIP001 	Window* pShellWnd = SfxViewShell::Current()->GetWindow();
//STRIP001 
//STRIP001 	if ( pShellWnd )
//STRIP001 		pShellWnd->GrabFocus();
//STRIP001 }
//STRIP001 
}
