/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_SwXMLTextBlocks.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 10:08:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _URLOBJ_HXX
//STRIP001 #include <tools/urlobj.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _STG_HXX
//STRIP001 #include <sot/stg.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXDOCFILE_HXX
//STRIP001 #include <bf_sfx2/docfile.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
//STRIP001 #include <unotools/localfilehelper.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNTOOLS_UCBSTREAMHELPER_HXX
//STRIP001 #include <unotools/ucbstreamhelper.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _DOC_HXX
//STRIP001 #include <doc.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCSH_HXX
//STRIP001 #include <docsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _PAM_HXX
//STRIP001 #include <pam.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWBLOCKS_HXX
//STRIP001 #include <swblocks.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _NDTXT_HXX
//STRIP001 #include <ndtxt.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SHELLIO_HXX
//STRIP001 #include <shellio.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _POOLFMT_HXX
//STRIP001 #include <poolfmt.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SW_XMLTEXTBLOCKS_HXX
//STRIP001 #include <SwXMLTextBlocks.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _ERRHDL_HXX //autogen wg. ASSERT
//STRIP001 #include <errhdl.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SW_XMLBLOCKIMPORT_HXX
//STRIP001 #include <SwXMLBlockImport.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SW_XMLBLOCKEXPORT_HXX
//STRIP001 #include <SwXMLBlockExport.hxx>
//STRIP001 #endif

//STRIP001 #ifndef _SWSWERROR_H
//STRIP001 #include <swerror.h>
//STRIP001 #endif


//STRIP001 #define STREAM_STGREAD  ( STREAM_READ | STREAM_SHARE_DENYWRITE | STREAM_NOCREATE )
//STRIP001 #define STREAM_STGWRITE ( STREAM_READ | STREAM_WRITE | STREAM_SHARE_DENYWRITE )



//STRIP001 void SwXMLTextBlocks::InitBlockMode ( SvStorageRef & rStorage )
//STRIP001 {
//STRIP001 	xBlkRoot = rStorage;
//STRIP001 	xRoot.Clear();
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::ResetBlockMode ( )
//STRIP001 {
//STRIP001 	xBlkRoot.Clear();
//STRIP001 	xRoot.Clear();
//STRIP001 }

//STRIP001 SwXMLTextBlocks::SwXMLTextBlocks( const String& rFile )
//STRIP001 : SwImpBlocks( rFile ), bAutocorrBlock( FALSE ), nFlags ( 0 )
//STRIP001 {
//STRIP001 	SwDocShell* pDocSh = new SwDocShell ( SFX_CREATE_MODE_INTERNAL );
//STRIP001 	if( !pDocSh->DoInitNew( 0 ) )
//STRIP001 		return;
//STRIP001 	bReadOnly = FALSE;
//STRIP001 	pDoc = pDocSh->GetDoc();
//STRIP001 	xDocShellRef = pDocSh;
//STRIP001 	pDoc->SetOle2Link( Link() );
//STRIP001 	pDoc->DoUndo( FALSE );		// always FALSE
//STRIP001 	pDoc->AddLink();
//STRIP001 
//STRIP001 	if( !aDateModified.GetDate() || !aTimeModified.GetTime() )
//STRIP001 		Touch();		// falls neu angelegt -> neuen ZeitStempel besorgen
//STRIP001 	SvStorageRef refStg  = new SvStorage( TRUE, rFile, STREAM_STD_READWRITE | STREAM_SHARE_DENYNONE );
//STRIP001 	InitBlockMode ( refStg );
//STRIP001 	ReadInfo();
//STRIP001 	ResetBlockMode ();
//STRIP001 	bInfoChanged = FALSE;
//STRIP001 }

//STRIP001 SwXMLTextBlocks::SwXMLTextBlocks( SvStorage& rStg )
//STRIP001 : SwImpBlocks( rStg.GetName() )
//STRIP001 , bAutocorrBlock( TRUE )
//STRIP001 , nFlags ( 0 )
//STRIP001 {
//STRIP001 	SwDocShell* pDocSh = new SwDocShell ( SFX_CREATE_MODE_INTERNAL );
//STRIP001 	if( !pDocSh->DoInitNew( 0 ) )
//STRIP001 		return;
//STRIP001 	bReadOnly = FALSE;
//STRIP001 	pDoc = pDocSh->GetDoc();
//STRIP001 	xDocShellRef = pDocSh;
//STRIP001 	pDoc->SetOle2Link( Link() );
//STRIP001 	pDoc->DoUndo( FALSE );
//STRIP001 	pDoc->AddLink();
//STRIP001 
//STRIP001 	SvStorageRef refStg = &rStg;
//STRIP001 	InitBlockMode ( refStg );
//STRIP001 	ReadInfo();
//STRIP001 	bInfoChanged = FALSE;
//STRIP001 }

//STRIP001 SwXMLTextBlocks::~SwXMLTextBlocks()
//STRIP001 {
//STRIP001 	if ( bInfoChanged )
//STRIP001 		WriteInfo();
//STRIP001 	ResetBlockMode ();
//STRIP001 	if( pDoc && !pDoc->RemoveLink() )
//STRIP001 		delete pDoc;
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::ClearDoc()
//STRIP001 {
//STRIP001 	SwDocShell * pDocShell = pDoc->GetDocShell();
//STRIP001 	pDocShell->InvalidateModel();
//STRIP001 	pDocShell->ReactivateModel();
//STRIP001 	static_cast < SfxObjectShell * > (pDocShell)->Clear();
//STRIP001 	pDoc->ClearDoc();
//STRIP001 }
//STRIP001 void SwXMLTextBlocks::AddName( const String& rShort, const String& rLong, BOOL bOnlyTxt )
//STRIP001 {
//STRIP001 	USHORT nIdx = GetIndex( rShort );
//STRIP001 	SwBlockName* pNew = NULL;
//STRIP001 	if( nIdx != (USHORT) -1 )
//STRIP001 		aNames.DeleteAndDestroy( nIdx );
//STRIP001 
//STRIP001 	GeneratePackageName( rShort, aPackageName );
//STRIP001 	pNew = new SwBlockName( rShort, rLong, aPackageName );
//STRIP001 
//STRIP001 	pNew->bIsOnlyTxtFlagInit = TRUE;
//STRIP001 	pNew->bIsOnlyTxt = bOnlyTxt;
//STRIP001 	aNames.C40_PTR_INSERT( SwBlockName, pNew );
//STRIP001 	bInfoChanged = TRUE;
//STRIP001 }
//STRIP001 void SwXMLTextBlocks::AddName( const String& rShort, const String& rLong,
//STRIP001 						   const String& rPackageName, BOOL bOnlyTxt )
//STRIP001 {
//STRIP001 	USHORT nIdx = GetIndex( rShort );
//STRIP001 	if( nIdx != (USHORT) -1 )
//STRIP001 		aNames.DeleteAndDestroy( nIdx );
//STRIP001 	SwBlockName* pNew = new SwBlockName( rShort, rLong, rPackageName );
//STRIP001 	pNew->bIsOnlyTxtFlagInit = TRUE;
//STRIP001 	pNew->bIsOnlyTxt = bOnlyTxt;
//STRIP001 	aNames.C40_PTR_INSERT( SwBlockName, pNew );
//STRIP001 	bInfoChanged = TRUE;
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::Delete( USHORT n )
//STRIP001 {
//STRIP001 	String aName (aNames[ n ]->aPackageName);
//STRIP001 
//STRIP001 	if ( xBlkRoot->IsContained( aName ) )
//STRIP001 	{
//STRIP001 		xBlkRoot->Remove ( aName );
//STRIP001 		return xBlkRoot->Commit() ? 0 : ERR_SWG_WRITE_ERROR;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::Rename( USHORT nIdx, const String& rNewShort, const String& rNewLong )
//STRIP001 {
//STRIP001 	String aOldName (aNames[ nIdx ]->aPackageName);
//STRIP001 	aShort = rNewShort;
//STRIP001 	GeneratePackageName( aShort, aPackageName );
//STRIP001 	if (IsOnlyTextBlock ( nIdx ) )
//STRIP001 	{
//STRIP001 		String sExt( String::CreateFromAscii( ".xml" ));
//STRIP001         String aOldStreamName( aOldName ); aOldStreamName += sExt;
//STRIP001         String aNewStreamName( aPackageName ); aNewStreamName += sExt;
//STRIP001 
//STRIP001 		xRoot = xBlkRoot->OpenUCBStorage ( aOldName, STREAM_STGWRITE );
//STRIP001 		xRoot->Rename ( aOldStreamName, aNewStreamName );
//STRIP001 		xRoot->Commit();
//STRIP001 		xRoot.Clear();
//STRIP001 	}
//STRIP001 	xBlkRoot->Rename ( aOldName, aPackageName );
//STRIP001 	xBlkRoot->Commit();
//STRIP001 	// No need to commit xBlkRoot here as SwTextBlocks::Rename calls
//STRIP001 	// WriteInfo which does the commit
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::CopyBlock( SwImpBlocks& rDestImp, String& rShort,
//STRIP001 													const String& rLong)
//STRIP001 {
//STRIP001 	ULONG nError = 0;
//STRIP001 	OpenFile(TRUE);
//STRIP001 	rDestImp.OpenFile(FALSE);
//STRIP001 	String aGroup( rShort );
//STRIP001 	BOOL bTextOnly = IsOnlyTextBlock ( rShort ) ;//pImp->pBlkRoot->IsStream( aGroup );
//STRIP001 	USHORT nIndex = GetIndex ( rShort );
//STRIP001 	String sDestShortName( GetPackageName (nIndex) );
//STRIP001 	USHORT nIdx = 0;
//STRIP001 
//STRIP001 	while(((SwXMLTextBlocks&)rDestImp).xBlkRoot->IsContained( sDestShortName ))
//STRIP001 	{
//STRIP001 		++nIdx;
//STRIP001 		//falls wirklich mal einer so verrueckt ist
//STRIP001 		if(USHRT_MAX == nIdx)
//STRIP001 		{
//STRIP001 			CloseFile();
//STRIP001 			rDestImp.CloseFile();
//STRIP001 			return ERR_SWG_WRITE_ERROR;
//STRIP001 		}
//STRIP001 		sDestShortName += String::CreateFromInt32( nIdx );
//STRIP001 	}
//STRIP001 
//STRIP001 	/*if(!bTextOnly)*/
//STRIP001 	{
//STRIP001 		SvStorageRef rSourceRoot = xBlkRoot->OpenUCBStorage( aGroup, STREAM_STGREAD );
//STRIP001 		DBG_ASSERT(rSourceRoot.Is(), "Block existiert nicht!")
//STRIP001 		if(!rSourceRoot.Is())
//STRIP001 			nError = ERR_SWG_READ_ERROR;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//jetzt muss der Storage kopiert werden
//STRIP001 			if(!xBlkRoot->CopyTo( aGroup, ((SwXMLTextBlocks&)rDestImp).xBlkRoot, sDestShortName ))
//STRIP001 			{
//STRIP001 				//nError = rSourceRoot->GetError();
//STRIP001 				nError = ERR_SWG_WRITE_ERROR;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001     /* I think this should work now that text only blocks are in sub-storages as well
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SvStorageStreamRef rSourceStream = xBlkRoot->OpenStream( aGroup, STREAM_STGREAD );
//STRIP001 		SvStorageStreamRef rDestStream = ((SwXMLTextBlocks&)rDestImp).xBlkRoot-> OpenStream( sDestShortName, STREAM_STGWRITE );
//STRIP001 		if(!rDestStream.Is())
//STRIP001 			nError = ERR_SWG_WRITE_ERROR;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if(!rSourceStream->CopyTo(&rDestStream))
//STRIP001 				nError = ERR_SWG_WRITE_ERROR;
//STRIP001 			else
//STRIP001 				rDestStream->Commit();
//STRIP001 		}
//STRIP001 	}
//STRIP001     */
//STRIP001 	if(!nError)
//STRIP001 	{
//STRIP001 		rShort = sDestShortName;
//STRIP001 		((SwXMLTextBlocks&)rDestImp).xBlkRoot->Commit();
//STRIP001 		((SwXMLTextBlocks&)rDestImp).AddName( rShort, rLong, bTextOnly );
//STRIP001 		((SwXMLTextBlocks&)rDestImp).MakeBlockList();
//STRIP001 	}
//STRIP001 	CloseFile();
//STRIP001 	rDestImp.CloseFile();
//STRIP001 	return nError;
//STRIP001 }


//STRIP001 ULONG SwXMLTextBlocks::StartPutBlock( const String& rShort, const String& rPackageName )
//STRIP001 {
//STRIP001 	USHORT nIndex = GetIndex ( rShort );
//STRIP001 	/*
//STRIP001 	if( xBlkRoot->IsContained( rPackageName ) )
//STRIP001 	{
//STRIP001 		xBlkRoot->Remove( rPackageName );
//STRIP001 		xBlkRoot->Commit();
//STRIP001 	}
//STRIP001 	*/
//STRIP001 	xRoot = xBlkRoot->OpenUCBStorage( rPackageName, STREAM_STGWRITE );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 ULONG SwXMLTextBlocks::BeginPutDoc( const String& rShort, const String& rLong )
//STRIP001 {
//STRIP001 	// In der Basisklasse ablegen!
//STRIP001 	aShort = rShort;
//STRIP001 	aLong = rLong;
//STRIP001 	GeneratePackageName( rShort, aPackageName );
//STRIP001     SetIsTextOnly( rShort, FALSE);
//STRIP001 	return StartPutBlock (rShort, aPackageName);
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::PutBlock( SwPaM& rPam, const String& rLong )
//STRIP001 {
//STRIP001 	ULONG nRes = 0;
//STRIP001 	USHORT nCommitFlags = nFlags & (SWXML_CONVBLOCK|SWXML_NOROOTCOMMIT);
//STRIP001 
//STRIP001 	nFlags |= nCommitFlags;
//STRIP001 
//STRIP001 	WriterRef xWrt;
//STRIP001 	//::GetXMLWriter ( String::CreateFromAscii(FILTER_XML), xWrt);
//STRIP001 	::GetXMLWriter ( aEmptyStr, xWrt);
//STRIP001 	SwWriter aWriter (*xRoot, *pDoc );
//STRIP001 
//STRIP001 	xWrt->bBlock = sal_True;
//STRIP001 	nRes = aWriter.Write ( xWrt );
//STRIP001 	xWrt->bBlock = sal_False;
//STRIP001 	// Save OLE objects if there are some
//STRIP001 	SwDocShell *pDocSh = pDoc->GetDocShell();
//STRIP001 
//STRIP001 	sal_Bool bHasChilds = pDocSh && pDocSh->GetObjectList() &&
//STRIP001 						  pDocSh->GetObjectList()->Count() > 0;
//STRIP001 	if( !nRes && bHasChilds )
//STRIP001 	{
//STRIP001 		sal_Bool bOK = pDocSh->SaveAsChilds( xRoot );
//STRIP001 		if( bOK )
//STRIP001 			bOK = pDocSh->SaveCompletedChilds( xRoot );
//STRIP001 		if( !bOK )
//STRIP001 			nRes = ERR_SWG_WRITE_ERROR;
//STRIP001 	}
//STRIP001 
//STRIP001 	xRoot->Commit();
//STRIP001 	xRoot.Clear();
//STRIP001 	if ( !nCommitFlags )
//STRIP001 		xBlkRoot->Commit();
//STRIP001 	ULONG nErr = xBlkRoot->GetError();
//STRIP001 	if( nErr == SVSTREAM_DISK_FULL )
//STRIP001 		nRes = ERR_W4W_WRITE_FULL;
//STRIP001 	else if( nErr != SVSTREAM_OK )
//STRIP001 		nRes = ERR_SWG_WRITE_ERROR;
//STRIP001 	nFlags |= nCommitFlags;
//STRIP001 	return nErr;
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::PutDoc()
//STRIP001 {
//STRIP001 	SwPaM* pPaM = MakePaM();
//STRIP001 	ULONG nErr = PutBlock(*pPaM, aLong);
//STRIP001 	delete pPaM;
//STRIP001 	return nErr;
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::GetText( USHORT nIdx, String& rText )
//STRIP001 {
//STRIP001 	return GetBlockText( aNames[ nIdx ]->aShort, rText );
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::GetText( const String& rShort, String& rText )
//STRIP001 {
//STRIP001 	return GetBlockText( rShort, rText );
//STRIP001 }


//STRIP001 ULONG SwXMLTextBlocks::MakeBlockList()
//STRIP001 {
//STRIP001 	WriteInfo();
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::SetConvertMode( BOOL bOn )
//STRIP001 {
//STRIP001 	if (bOn)
//STRIP001 		nFlags |= SWXML_CONVBLOCK;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nFlags &= SWXML_CONVBLOCK;
//STRIP001 		if ( xBlkRoot.Is() )
//STRIP001 		{
//STRIP001 			xBlkRoot->Commit();
//STRIP001 			if ( xBlkRoot->GetError() != SVSTREAM_OK )
//STRIP001 				return ERR_SWG_WRITE_ERROR;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 BOOL SwXMLTextBlocks::PutMuchEntries( BOOL bOn )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if( bOn )
//STRIP001 	{
//STRIP001 		if( bInPutMuchBlocks )
//STRIP001 		{
//STRIP001 			ASSERT( !this, "verschachtelte Aufrufe sind nicht erlaubt" );
//STRIP001 		}
//STRIP001 		else if( !IsFileChanged() )
//STRIP001 		{
//STRIP001 			bRet = 0 == OpenFile( FALSE );
//STRIP001 			if( bRet )
//STRIP001 			{
//STRIP001 				nFlags |= SWXML_NOROOTCOMMIT;
//STRIP001 				bInPutMuchBlocks = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( bInPutMuchBlocks )
//STRIP001 	{
//STRIP001 		nFlags &= ~SWXML_NOROOTCOMMIT;
//STRIP001 		if( xBlkRoot.Is() )
//STRIP001 		{
//STRIP001 			xBlkRoot->Commit();
//STRIP001 			if( SVSTREAM_OK == xBlkRoot->GetError() )
//STRIP001 			{
//STRIP001 				MakeBlockList();
//STRIP001 				CloseFile();
//STRIP001 				Touch();
//STRIP001 				bInPutMuchBlocks = FALSE;
//STRIP001 				bRet = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 ULONG SwXMLTextBlocks::OpenFile( BOOL bReadOnly )
//STRIP001 {
//STRIP001 	if( bAutocorrBlock )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	SvStorageRef refStg = new SvStorage( TRUE, aFile,
//STRIP001 							bReadOnly ? (STREAM_READ | STREAM_SHARE_DENYNONE)
//STRIP001 									  : STREAM_STD_READWRITE);
//STRIP001 	InitBlockMode ( refStg );
//STRIP001 	return xBlkRoot->GetError();
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::CloseFile()
//STRIP001 {
//STRIP001 	if ( !bAutocorrBlock )
//STRIP001 	{
//STRIP001 		if (bInfoChanged)
//STRIP001 			WriteInfo();
//STRIP001 		ResetBlockMode();
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::SetIsTextOnly( const String& rShort, BOOL bNewValue )
//STRIP001 {
//STRIP001 	USHORT nIdx = GetIndex ( rShort );
//STRIP001 	if (nIdx != (USHORT) -1  && nIdx != USHRT_MAX)
//STRIP001 		aNames[nIdx]->bIsOnlyTxt = bNewValue;
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::SetIsTextOnly( USHORT nIdx, BOOL bNewValue )
//STRIP001 {
//STRIP001 	aNames[nIdx]->bIsOnlyTxt = bNewValue;
//STRIP001 }

//STRIP001 BOOL SwXMLTextBlocks::IsOnlyTextBlock( const String& rShort ) const
//STRIP001 {
//STRIP001 	USHORT nIdx = GetIndex ( rShort );
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if (nIdx != (USHORT) -1  && nIdx != USHRT_MAX)
//STRIP001 	{
//STRIP001 		bRet = aNames[nIdx]->bIsOnlyTxt;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 BOOL SwXMLTextBlocks::IsOnlyTextBlock( USHORT nIdx ) const
//STRIP001 {
//STRIP001 	return aNames[nIdx]->bIsOnlyTxt;
//STRIP001 }

//STRIP001 BOOL SwXMLTextBlocks::IsFileUCBStorage( const String & rFileName)
//STRIP001 {
//STRIP001 	String aName( rFileName );
//STRIP001     INetURLObject aObj( aName );
//STRIP001     if ( aObj.GetProtocol() == INET_PROT_NOT_VALID )
//STRIP001     {
//STRIP001         String aURL;
//STRIP001         ::utl::LocalFileHelper::ConvertPhysicalNameToURL( aName, aURL );
//STRIP001         aObj.SetURL( aURL );
//STRIP001 		aName = aObj.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001     }
//STRIP001 
//STRIP001 	SvStream * pStm = ::utl::UcbStreamHelper::CreateStream( aName, STREAM_STD_READ );
//STRIP001     BOOL bRet = UCBStorage::IsStorageFile( pStm );
//STRIP001 	delete pStm;
//STRIP001 	return bRet;
//STRIP001 }



//STRIP001 short SwXMLTextBlocks::GetFileType ( void ) const
//STRIP001 {
//STRIP001 	return SWBLK_XML;
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::GeneratePackageName ( const String& rShort, String& rPackageName )
//STRIP001 {
//STRIP001 	rPackageName = rShort;
//STRIP001 	xub_StrLen nPos = 0;
//STRIP001 	sal_Unicode pDelims[] = { '!', '/', ':', '.', '\\', 0 };
//STRIP001 	ByteString sByte ( rPackageName, RTL_TEXTENCODING_UTF7);
//STRIP001 	rPackageName = String (sByte, RTL_TEXTENCODING_ASCII_US);
//STRIP001 	while( STRING_NOTFOUND != ( nPos = rPackageName.SearchChar( pDelims, nPos )))
//STRIP001 	{
//STRIP001 		rPackageName.SetChar( nPos, '_' );
//STRIP001 		++nPos;
//STRIP001 	}
//STRIP001 #if 0
//STRIP001     /*
//STRIP001      * We can assume that if the package name we generate is already in the storage,
//STRIP001      * then we are over-writing it...*/
//STRIP001 	if (xBlkRoot.Is() || 0 == OpenFile ( FALSE ) )
//STRIP001 	{
//STRIP001 		if ( xBlkRoot->IsContained( rPackageName ) )
//STRIP001 		{
//STRIP001 			xBlkRoot->Remove ( rPackageName  );
//STRIP001 			xBlkRoot->Commit();
//STRIP001 		}
//STRIP001 
//STRIP001 		/*
//STRIP001 		ULONG nIdx=0;
//STRIP001         while ( xBlkRoot->IsContained( rPackageName ))
//STRIP001 		{
//STRIP001 			++nIdx;
//STRIP001 			rPackageName += String::CreateFromInt32( nIdx );
//STRIP001 		}
//STRIP001         */
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 }
//STRIP001 ULONG SwXMLTextBlocks::PutText( const String& rShort, const String& rName,
//STRIP001 								const String& rText )
//STRIP001 {
//STRIP001 	ULONG nRes = 0;
//STRIP001 	aShort = rShort;
//STRIP001 	aLong = rName;
//STRIP001 	aCur = rText;
//STRIP001     SetIsTextOnly( aShort, TRUE );
//STRIP001 	GeneratePackageName( rShort, aPackageName );
//STRIP001 	ClearDoc();
//STRIP001 	nRes = PutBlockText( rShort, rName, rText, aPackageName );
//STRIP001 	return nRes;
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::SetCurrentText( const String& rText )
//STRIP001 {
//STRIP001 	if (!aCur.Len())
//STRIP001 		aCur = rText;
//STRIP001 	else
//STRIP001 		aCur += rText;
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::MakeBlockText( const String& rText )
//STRIP001 {
//STRIP001 	SwTxtNode* pTxtNode = pDoc->GetNodes()[ pDoc->GetNodes().GetEndOfContent().
//STRIP001 										GetIndex() - 1 ]->GetTxtNode();
//STRIP001 	//JP 18.09.98: Bug 56706 - Standard sollte zumindest gesetzt sein!
//STRIP001 	if( pTxtNode->GetTxtColl() == pDoc->GetDfltTxtFmtColl() )
//STRIP001 		pTxtNode->ChgFmtColl( pDoc->GetTxtCollFromPool( RES_POOLCOLL_STANDARD ));
//STRIP001 
//STRIP001 	xub_StrLen nPos = 0;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		if ( nPos )
//STRIP001 		{
//STRIP001 			pTxtNode = (SwTxtNode*)pTxtNode->AppendNode( SwPosition( *pTxtNode ) );
//STRIP001 		}
//STRIP001 		SwIndex aIdx( pTxtNode );
//STRIP001 		String sTemp(rText.GetToken( 0, '\015', nPos ) );
//STRIP001 		pTxtNode->Insert( sTemp, aIdx );
//STRIP001 	} while ( STRING_NOTFOUND != nPos );
//STRIP001 }

//STRIP001 void SwXMLTextBlocks::AddTextNode ( const String & rText )
//STRIP001 {
//STRIP001 	SwTxtNode* pTxtNode = pDoc->GetNodes()[ pDoc->GetNodes().GetEndOfContent().
//STRIP001 										GetIndex() - 1 ]->GetTxtNode();
//STRIP001 	//JP 18.09.98: Bug 56706 - Standard sollte zumindest gesetzt sein!
//STRIP001 	if( pTxtNode->GetTxtColl() == pDoc->GetDfltTxtFmtColl() )
//STRIP001 		pTxtNode->ChgFmtColl( pDoc->GetTxtCollFromPool( RES_POOLCOLL_STANDARD ));
//STRIP001 	SwIndex aIdx ( pTxtNode );
//STRIP001 	pTxtNode->Insert( rText, aIdx );
//STRIP001 }


}
