/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wrt_db.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:02:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _WRT_DB_HXX
#define _WRT_DB_HXX

#include "shellio.hxx"
#include "wrt_fn.hxx"
namespace binfilter {

// einige Forward Deklarationen
class SwFmt;
class SwTableNode;
class SwPaM;
class SwNodes;
class SwNumRule;

extern SwAttrFnTab aDBAttrFnTab;
extern SwNodeFnTab aDBNodeFnTab;


// der DB-Writer

class SwDBWriter : public Writer
{
protected:
	virtual ULONG WriteStream();

public:
	BOOL bOutTable : 1;
	BOOL bTxtAttr : 1;				// werden TextAttribute ausgegeben ?

	const SwFmt* pNdFmt, *pNdCondColl;	// akt. Format/Collection vom Node
									// fuer den Zugriff auf einige Attribute
									// z.B. Font-Size, LR-Space,..

#if defined(MAC) || defined(UNX)
	static const sal_Char sNewLine;		// nur \012 oder \015
#else
	static const sal_Char __FAR_DATA sNewLine[];	// \015\012
#endif

	SwDBWriter();
	virtual ~SwDBWriter();
	void Out_SwDoc( SwPaM*, const SwNodes& rNds );

	SwPaM* GetEndPaM() 				{ return pOrigPam; }
	void SetEndPaM( SwPaM* pPam )	{ pOrigPam = pPam; }
};

Writer& OutDB_SwTableNode( Writer&, SwTableNode & rNode );
Writer& OutDB_SwSectionNode( Writer&, SwSectionNode & rNode );
Writer& OutDB_SwPageDescs( Writer&, const SwDoc& rDoc);
Writer& OutDB_SwFmt( Writer&, const SwFmt& rFmt );
Writer& OutDB_SwNumRule( Writer& rWrt, const SwNumRule& rRule );



} //namespace binfilter
#endif	//  _WRT_DB_HXX
