/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wrt_undo.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:02:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _WRT_UNDO_HXX
#define _WRT_UNDO_HXX

#include "shellio.hxx"
#include "swundo.hxx"
#include "rolbck.hxx"
namespace binfilter {

class SwUndos;
class SwNodes;
class SwUndo;

// der Undo-Writer
typedef Writer& (*FnUndoOut)( Writer&, const SwUndo& );
typedef FnUndoOut SwUndoFnTab[ UNDO_STD_END - UNDO_STD_BEGIN ];
extern SwUndoFnTab aUndoFnTab;

typedef Writer& (*FnRolbckOut)( Writer&, const SwHstryHint& );
typedef FnRolbckOut SwRolbckFnTab[ HSTRY_END ];
extern SwRolbckFnTab aRolbckFnTab;

class SwUndoWriter : public Writer
{
protected:
	virtual ULONG WriteStream();

public:
/*
	// die Undo-Daten werden aus dem SwDoc geholt
	BOOL bGroupUndo;
	SwUndos* pUndos;            // Undo/Redo History
	SwNodes* pUndoNodes;        // Inhalt fuer das Undo
	SwHistory *pAttrHstry;		// History fuer die Attribute
	USHORT nUndoPos;			// akt. Undo-InsertPosition (fuers Redo!)
	USHORT nUndoSavePos;		// Position im Undo-Array, ab der das Doc
								// nicht als modifiziert gilt
*/

	SwUndoWriter();
	virtual ~SwUndoWriter();
};


} //namespace binfilter
#endif  //  _WRT_UNDO_HXX
