/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dbtabobj.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:47:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_DBTABOBJ_HXX
#define _SBA_DBTABOBJ_HXX

#ifndef _SBA_DBDATDEF_HXX
#include "dbdatdef.hxx"
#endif

#ifndef _SBA_DBEXCH_HXX
#include "dbexch.hxx"
#endif

#ifndef _SDB_SDBTAB_HXX //autogen
#include <sdb/sdbtab.hxx>
#endif

#ifndef _SDB_SDBIDX_HXX
#include <sdb/sdbidx.hxx>
#endif
namespace binfilter {

//==================================================================
// SbaIndexDef
//==================================================================
class SbaIndexDef : public SvRefBase		// Entspricht einer Spalte im Index
{
	friend class SbaTableDef;
	friend class SbaTableIndexCtrl;

protected:
	String			aName, aQualifierName;
	SdbColumnsRef	aColumns;

	BOOL			bUnique			: 1,
					bCase			: 1,
					bSystemReadOnly : 1;

	SbaIndexDef(const SbaTableDef& _rTable);
	SbaIndexDef(const SbaTableDef& _rTable, const SbaIndexDef& _rIndex);
	SbaIndexDef(const SbaTableDef& _rTable, const SdbIndex& _rIndex);
	SbaIndexDef(const SbaTableDef& _rTable, const String& rQualifier, const String& rName, BOOL bUniq,BOOL bReadOnly=FALSE);
	~SbaIndexDef();

public:
	SdbColumnsRef GetColumns() const {return aColumns;}

	// Der Name des Index etc.
	const String& GetName() const {return aName;}
	const String& GetQualifier() const {return aQualifierName;}
	inline String GetFullName() const;
	BOOL IsUnique() const {return bUnique;}
	BOOL IsSystemReadOnly() const { return bSystemReadOnly;}

	virtual SbaIndexDef* Clone(const SbaTableDef& _rTable) const;
	virtual BOOL operator== (const SbaIndexDef& _rDef) const;
	BOOL operator !=(const SbaIndexDef& _rDef) const
		{return !operator ==(_rDef);}
};

SV_DECL_IMPL_REF(SbaIndexDef);

DECL_SDBKEYREFCONT_VIRT(SbaIndexMap,SbaIndexDef*);

//==================================================================
// SbaIndexList
//==================================================================
class SbaIndexList : public SbaIndexMap
{
public:
	SbaIndexList(BOOL _bCaseSensitive = FALSE,
				  USHORT _nInitSize = 16,
				  USHORT _nReSize = 16 )
				 :SbaIndexMap(_bCaseSensitive, _nInitSize, _nReSize ){}

	SbaIndexList( USHORT _nBlockSize, USHORT _nInitSize,
				   USHORT _nReSize, BOOL _bCaseSensitive = FALSE)
				  :SbaIndexMap(_nBlockSize,_nInitSize,_nReSize,_bCaseSensitive){}

	virtual SbaIndexDef* Lookup(const String& _rIndexName, const String& _rQualifierName = String()) const;
	virtual SbaIndexList& Copy(const SbaTableDef& _rTable, const SbaIndexList&);
	virtual SbaIndexList& Append(const SbaTableDef& _rTable, const SbaIndexList&);
	virtual BOOL operator ==(const SbaIndexList &) const;
	BOOL operator !=(const SbaIndexList & _rList) const
		{return !operator ==(_rList);}
};

//==================================================================
// SbaTableDef
//==================================================================
class SbaTableDef : public SbaDBDataDef
{
	friend class SbaQueryDef;
	friend class SbaDatabase;

protected:
	SdbTable*	 pTable;				// aktuelle Tabellendefinition
	SbaIndexList aOriginalIndexDefs,
				 aIndexDefs;
	BOOL		 bNotNullAllowed;		// kann die Datenbank NOT NULL Felder

public:
	TYPEINFO();

	// Zugriff auf SdbTable
	SdbTable* GetTable() const {return pTable;}
	UINT16 GetTablePrivileges() const
		{return pTable ? pTable->GetTablePrivileges() : SDB_PR_NONE;}

	// speichern der Tabellendefinition
	virtual BOOL Update();

	// Anlegen einer Tabellensicht
	virtual BOOL Update(const String& rSQL,BOOL bNative);

	// speichern der IndexDefinitionen
	BOOL IsIndexModified() const {return aIndexDefs != aOriginalIndexDefs;}
	virtual BOOL UpdateIndex();
	BOOL UpdateIndex(BOOL bIgnorError);
	void RestoreIndex();

	SbaIndexList&			GetIndexDefs() {return aIndexDefs;}
	const SbaIndexList&		GetOriginalIndexDefs() const {return aOriginalIndexDefs;}
	virtual SbaIndexDef*	CreateIndexDef() const;
	virtual SbaIndexDef*	CreateIndexDef(const SbaIndexDef&) const;
	SbaIndexDef*			CreateIndexDef(const String& rName,const String& rQualifier,BOOL bUnique) const;

	// default Werte fuer Langen und Required
	UINT32 GetDefaultLength(SbaFieldType eFieldType) const;
	BOOL   GetDefaultNull(SbaFieldType eFieldType, SbaNumericSize eSizeType) const;

	BOOL CopyStructure( SbaTableDef* pSourceTableDef );
	BOOL CopyStructure( const SbaColumnList& rSourceList,const SbaDatabase* pSourceDatabase,void* _pColumnsPos=NULL);
	BOOL CopyIndexes(SbaTableDef* pSourceTableDef );

	BOOL ConvertTypeTo( SbaFieldType eType, SbaColumn* pDestColumn);
	BOOL ConvertNumericTypeTo( SbaNumericSize eSize, SbaColumn* pDestColumn);
	BOOL AdjustType( SbaColumn* pSourceColumn, SbaColumn* pDestColumn);

protected:
	SbaTableDef(SbaDatabase* pDB,
				const String& rName,
				BOOL bView,				// flag um eine View anzulegen
				BOOL bNew,
				BOOL bShow);

	virtual	~SbaTableDef();
	virtual BOOL Open();
	virtual BOOL DropImpl();
	virtual BOOL RenameImpl(const String& rNewName);
	virtual BOOL DoRefresh();
	virtual BOOL IsDataUpdateAllowed() const;
	virtual SbaDataObj* CreateDataObjImpl();

private:
	void FillIndexes();
};

SV_DECL_IMPL_REF(SbaTableDef);

//------------------------------------------------------------------
inline String SbaIndexDef::GetFullName() const
{
	String sReturn(aQualifierName);
	if (sReturn.Len() != 0)
		sReturn += '.';
	sReturn += aName;
	return sReturn;
}


} //namespace binfilter
#endif


